/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class TabNavigationActionBase
extends AnAction
implements DumbAware,
ActionRemoteBehaviorSpecification.Frontend {
    private static final Logger LOG = Logger.getInstance(TabNavigationActionBase.class);
    private final NavigationType myNavigationType;

    TabNavigationActionBase(@NotNull NavigationType navigationType) {
        if (navigationType == null) {
            TabNavigationActionBase.$$$reportNull$$$0(0);
        }
        this.myNavigationType = navigationType;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext2;
        Project project2;
        if (e == null) {
            TabNavigationActionBase.$$$reportNull$$$0(1);
        }
        if ((project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2 = e.getDataContext())) == null || project2.isDisposed()) {
            return;
        }
        if (LightEdit.owns((Project)project2)) {
            LightEditService.getInstance().navigateToTab((AnAction)this);
            return;
        }
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)project2);
        if (windowManager.isEditorComponentActive()) {
            this.doNavigate(dataContext2, project2);
            return;
        }
        this.doNavigate((ContentManager)PlatformDataKeys.NONEMPTY_CONTENT_MANAGER.getData(dataContext2));
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            TabNavigationActionBase.$$$reportNull$$$0(2);
        }
        Presentation presentation2 = event.getPresentation();
        DataContext dataContext2 = event.getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        if (LightEdit.owns((Project)project2)) {
            presentation2.setEnabled(LightEditService.getInstance().isTabNavigationAvailable((AnAction)this));
            return;
        }
        presentation2.setEnabled(false);
        if (project2 == null || project2.isDisposed()) {
            return;
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project2);
        if (toolWindowManager.isEditorComponentActive()) {
            FileEditorManagerEx editorManager = FileEditorManagerEx.getInstanceEx(project2);
            EditorWindow currentWindow = (EditorWindow)EditorWindow.DATA_KEY.getData(dataContext2);
            if (currentWindow == null) {
                editorManager.getCurrentWindow();
            }
            if (currentWindow != null) {
                List<EditorComposite> composites2 = currentWindow.getAllComposites();
                switch (this.myNavigationType.ordinal()) {
                    case 9: 
                    case 10: {
                        presentation2.setEnabled(composites2.size() > 1);
                        break;
                    }
                    case 11: {
                        int index = composites2.indexOf(currentWindow.getSelectedComposite());
                        presentation2.setEnabled(index < composites2.size());
                        break;
                    }
                    default: {
                        int targetIndex = this.myNavigationType.ordinal();
                        presentation2.setEnabled(targetIndex < composites2.size());
                    }
                }
            }
            return;
        }
        ContentManager contentManager = (ContentManager)PlatformDataKeys.NONEMPTY_CONTENT_MANAGER.getData(dataContext2);
        presentation2.setEnabled(contentManager != null && contentManager.getContentCount() > 1 && contentManager.isSingleSelection());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            TabNavigationActionBase.$$$reportNull$$$0(3);
        }
        return actionUpdateThread;
    }

    private void doNavigate(@Nullable ContentManager contentManager) {
        if (contentManager == null) {
            return;
        }
        Content targetContent = null;
        switch (this.myNavigationType.ordinal()) {
            case 9: {
                contentManager.selectPreviousContent();
                return;
            }
            case 10: {
                contentManager.selectNextContent();
                return;
            }
            case 11: {
                targetContent = contentManager.getContent(contentManager.getContentCount() - 1);
                break;
            }
            default: {
                int targetIndex = this.myNavigationType.ordinal();
                if (contentManager.getContentCount() < targetIndex + 1) break;
                targetContent = contentManager.getContent(targetIndex);
            }
        }
        if (targetContent != null) {
            contentManager.setSelectedContent(targetContent, true);
        }
    }

    private void doNavigate(DataContext dataContext2, Project project2) {
        int targetIndex;
        List<VirtualFile> files2;
        int index;
        VirtualFile selectedFile;
        FileEditorManagerEx editorManager = FileEditorManagerEx.getInstanceEx(project2);
        EditorWindow currentWindow = (EditorWindow)EditorWindow.DATA_KEY.getData(dataContext2);
        if (currentWindow == null) {
            currentWindow = editorManager.getCurrentWindow();
        }
        if ((selectedFile = Objects.requireNonNull(currentWindow).getSelectedFile()) == null) {
            selectedFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext2);
        }
        LOG.assertTrue((index = (files2 = currentWindow.getFileList()).indexOf(selectedFile)) != -1);
        switch (this.myNavigationType.ordinal()) {
            case 9: {
                int n = (index + files2.size() - 1) % files2.size();
                break;
            }
            case 10: {
                int n = (index + files2.size() + 1) % files2.size();
                break;
            }
            case 11: {
                int n = files2.size() - 1;
                break;
            }
            default: {
                int n = targetIndex = this.myNavigationType.ordinal();
            }
        }
        if (targetIndex < files2.size()) {
            editorManager.openFile(files2.get(targetIndex), true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigationType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/TabNavigationActionBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/TabNavigationActionBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    static enum NavigationType {
        NUM1,
        NUM2,
        NUM3,
        NUM4,
        NUM5,
        NUM6,
        NUM7,
        NUM8,
        NUM9,
        PREV,
        NEXT,
        LAST;

    }

    static final class GoToLastTabAction
    extends GoToTabAction {
        GoToLastTabAction() {
            super(NavigationType.LAST);
        }
    }

    static final class GoToTab9Action
    extends GoToTabAction {
        private GoToTab9Action() {
            super(NavigationType.NUM9);
        }
    }

    static final class GoToTab8Action
    extends GoToTabAction {
        private GoToTab8Action() {
            super(NavigationType.NUM8);
        }
    }

    static final class GoToTab7Action
    extends GoToTabAction {
        private GoToTab7Action() {
            super(NavigationType.NUM7);
        }
    }

    static final class GoToTab6Action
    extends GoToTabAction {
        private GoToTab6Action() {
            super(NavigationType.NUM6);
        }
    }

    static final class GoToTab5Action
    extends GoToTabAction {
        private GoToTab5Action() {
            super(NavigationType.NUM5);
        }
    }

    static final class GoToTab4Action
    extends GoToTabAction {
        private GoToTab4Action() {
            super(NavigationType.NUM4);
        }
    }

    static final class GoToTab3Action
    extends GoToTabAction {
        private GoToTab3Action() {
            super(NavigationType.NUM3);
        }
    }

    static final class GoToTab2Action
    extends GoToTabAction {
        private GoToTab2Action() {
            super(NavigationType.NUM2);
        }
    }

    static final class GoToTab1Action
    extends GoToTabAction {
        private GoToTab1Action() {
            super(NavigationType.NUM1);
        }
    }

    private static abstract class GoToTabAction
    extends TabNavigationActionBase {
        protected GoToTabAction(@NotNull NavigationType navigationType) {
            if (navigationType == null) {
                GoToTabAction.$$$reportNull$$$0(0);
            }
            super(navigationType);
            if (navigationType == NavigationType.LAST) {
                this.getTemplatePresentation().setText(ActionsBundle.messagePointer((String)"action.GoToLastTab.text", (Object[])new Object[0]));
                this.getTemplatePresentation().setDescription(ActionsBundle.messagePointer((String)"action.GoToLastTab.description", (Object[])new Object[0]));
            } else {
                this.getTemplatePresentation().setText(ActionsBundle.messagePointer((String)"action.GoToTab.text", (Object[])new Object[]{navigationType.ordinal() + 1}));
                this.getTemplatePresentation().setDescription(ActionsBundle.messagePointer((String)"action.GoToTab.description", (Object[])new Object[]{navigationType.ordinal() + 1}));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigationType", "com/intellij/ide/actions/TabNavigationActionBase$GoToTabAction", "<init>"));
        }
    }
}

