/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.ide.browsers.WebBrowserXmlService;
import com.intellij.ide.browsers.actions.BaseOpenInBrowserAction;
import com.intellij.ide.browsers.actions.OpenFileInDefaultBrowserAction;
import com.intellij.ide.browsers.actions.OpenHtmlInEmbeddedBrowserAction;
import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.toolbar.floating.AbstractFloatingToolbarProvider;
import com.intellij.openapi.editor.toolbar.floating.FloatingToolbarProvider;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OpenInBrowserBaseGroupAction
extends ActionGroup
implements DumbAware {
    private CachedValue<AnAction[]> myChildren;

    protected OpenInBrowserBaseGroupAction(boolean popup2) {
        Presentation p = this.getTemplatePresentation();
        p.setPopupGroup(popup2);
        p.setHideGroupIfEmpty(true);
        p.setText(IdeBundle.messagePointer((String)"open.in.browser", (Object[])new Object[0]));
        p.setDescription(IdeBundle.messagePointer((String)"open.selected.file.in.browser", (Object[])new Object[0]));
        p.setIconSupplier(() -> AllIcons.Nodes.PpWeb);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenInBrowserBaseGroupAction.$$$reportNull$$$0(0);
        }
        Project project2 = e.getProject();
        e.getPresentation().setEnabledAndVisible(project2 != null && TrustedProjects.isProjectTrusted(project2));
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        CachedValueImpl children2 = this.myChildren;
        if (children2 == null) {
            this.myChildren = children2 = new CachedValueImpl(() -> {
                AnAction[] actions = this.computeChildren();
                return CachedValueProvider.Result.create((Object)actions, (Object[])new Object[]{WebBrowserManager.getInstance()});
            });
        }
        AnAction[] anActionArray = (AnAction[])children2.getValue();
        if (anActionArray == null) {
            OpenInBrowserBaseGroupAction.$$$reportNull$$$0(1);
        }
        return anActionArray;
    }

    private AnAction @NotNull [] computeChildren() {
        List<WebBrowser> browsers = WebBrowserManager.getInstance().getBrowsers();
        boolean addDefaultBrowser = this.isPopup();
        boolean hasLocalBrowser = OpenInBrowserBaseGroupAction.hasLocalBrowser();
        int offset = 0;
        if (addDefaultBrowser) {
            ++offset;
        }
        if (hasLocalBrowser) {
            ++offset;
        }
        AnAction[] actions = new AnAction[browsers.size() + offset];
        if (hasLocalBrowser) {
            actions[0] = new OpenHtmlInEmbeddedBrowserAction();
        }
        if (addDefaultBrowser) {
            OpenFileInDefaultBrowserAction defaultBrowserAction = new OpenFileInDefaultBrowserAction();
            defaultBrowserAction.getTemplatePresentation().setText(IdeBundle.messagePointer((String)"default", (Object[])new Object[0]));
            defaultBrowserAction.getTemplatePresentation().setIconSupplier(() -> AllIcons.Nodes.PpWeb);
            actions[hasLocalBrowser ? 1 : 0] = defaultBrowserAction;
        }
        int size2 = browsers.size();
        for (int i2 = 0; i2 < size2; ++i2) {
            actions[i2 + offset] = new BaseOpenInBrowserAction(browsers.get(i2));
        }
        if (actions == null) {
            OpenInBrowserBaseGroupAction.$$$reportNull$$$0(2);
        }
        return actions;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            OpenInBrowserBaseGroupAction.$$$reportNull$$$0(3);
        }
        return actionUpdateThread;
    }

    public static boolean hasLocalBrowser() {
        return JBCefApp.isSupported() && Registry.is((String)"ide.web.preview.enabled", (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/browsers/actions/OpenInBrowserBaseGroupAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/browsers/actions/OpenInBrowserBaseGroupAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "computeChildren";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }

    public static class OpenInBrowserEditorContextBarGroupAction
    extends OpenInBrowserBaseGroupAction {
        public OpenInBrowserEditorContextBarGroupAction() {
            super(false);
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            FileType fileType2;
            VirtualFile virtualFile;
            Language language;
            if (e == null) {
                OpenInBrowserEditorContextBarGroupAction.$$$reportNull$$$0(0);
            }
            Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
            WebBrowserManager browserManager = WebBrowserManager.getInstance();
            PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
            Language language2 = language = psiFile != null ? psiFile.getViewProvider().getBaseLanguage() : null;
            if ((language == null || language == Language.ANY || language == PlainTextLanguage.INSTANCE) && (virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)) != null && (fileType2 = virtualFile.getFileType()) instanceof LanguageFileType) {
                LanguageFileType fileType3 = (LanguageFileType)fileType2;
                language = fileType3.getLanguage();
            }
            boolean needShowOnHover = language != null && WebBrowserXmlService.getInstance().isXmlLanguage(language) ? browserManager.isShowBrowserHoverXml() : browserManager.isShowBrowserHover();
            boolean enabled2 = needShowOnHover && (!browserManager.getActiveBrowsers().isEmpty() || OpenInBrowserEditorContextBarGroupAction.hasLocalBrowser()) && editor2 != null && !DiffUtil.isDiffEditor(editor2);
            e.getPresentation().setEnabledAndVisible(enabled2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/browsers/actions/OpenInBrowserBaseGroupAction$OpenInBrowserEditorContextBarGroupAction", "update"));
        }
    }

    public static interface OpenInBrowserFloatingToolbarSuppressor {
        public static final ExtensionPointName<OpenInBrowserFloatingToolbarSuppressor> EP_NAME = ExtensionPointName.create((String)"com.intellij.openInBrowserFloatingToolbarSuppressor");

        public boolean isSuppressed(FloatingToolbarProvider var1, DataContext var2);
    }

    public static class OpenInBrowserFloatingToolbarProvider
    extends AbstractFloatingToolbarProvider {
        private static final String ACTION_GROUP = "OpenInBrowserEditorContextBarGroup";

        public OpenInBrowserFloatingToolbarProvider() {
            super(ACTION_GROUP);
        }

        @Override
        public boolean isApplicable(@NotNull DataContext dataContext2) {
            boolean suppressed;
            if (dataContext2 == null) {
                OpenInBrowserFloatingToolbarProvider.$$$reportNull$$$0(0);
            }
            return !(suppressed = ContainerUtil.exists((Iterable)OpenInBrowserFloatingToolbarSuppressor.EP_NAME.getExtensionList(), suppressor -> suppressor.isSuppressed(this, dataContext2))) && super.isApplicable(dataContext2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/browsers/actions/OpenInBrowserBaseGroupAction$OpenInBrowserFloatingToolbarProvider", "isApplicable"));
        }
    }

    public static final class OpenInBrowserGroupAction
    extends OpenInBrowserBaseGroupAction {
        public OpenInBrowserGroupAction() {
            super(true);
        }
    }
}

