/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.ClassLoaderTreeCheckerKt;
import com.intellij.ide.plugins.DependsSubDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginMainDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginSet;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.util.containers.WeakList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/plugins/ClassLoaderTreeChecker;", "", "unloadedMainDescriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "classLoaders", "Lcom/intellij/util/containers/WeakList;", "Lcom/intellij/ide/plugins/cl/PluginClassLoader;", "<init>", "(Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;Lcom/intellij/util/containers/WeakList;)V", "checkThatClassLoaderNotReferencedByPluginClassLoader", "", "descriptor", "checkThatClassloaderNotReferenced", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nClassLoaderTreeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassLoaderTreeChecker.kt\ncom/intellij/ide/plugins/ClassLoaderTreeChecker\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,64:1\n12970#2,2:65\n*S KotlinDebug\n*F\n+ 1 ClassLoaderTreeChecker.kt\ncom/intellij/ide/plugins/ClassLoaderTreeChecker\n*L\n52#1:65,2\n*E\n"})
public final class ClassLoaderTreeChecker {
    @NotNull
    private final IdeaPluginDescriptorImpl unloadedMainDescriptor;
    @NotNull
    private final WeakList<PluginClassLoader> classLoaders;

    public ClassLoaderTreeChecker(@NotNull IdeaPluginDescriptorImpl unloadedMainDescriptor, @NotNull WeakList<PluginClassLoader> classLoaders) {
        Intrinsics.checkNotNullParameter((Object)unloadedMainDescriptor, (String)"unloadedMainDescriptor");
        Intrinsics.checkNotNullParameter(classLoaders, (String)"classLoaders");
        this.unloadedMainDescriptor = unloadedMainDescriptor;
        this.classLoaders = classLoaders;
    }

    public final void checkThatClassLoaderNotReferencedByPluginClassLoader() {
        if (!(this.unloadedMainDescriptor.getPluginClassLoader() instanceof PluginClassLoader)) {
            return;
        }
        PluginSet pluginSet = PluginManagerCore.getPluginSet();
        for (PluginMainDescriptor it : pluginSet.enabledPlugins) {
            this.checkThatClassLoaderNotReferencedByPluginClassLoader((IdeaPluginDescriptorImpl)it);
        }
        for (PluginMainDescriptor it : pluginSet.getUnsortedEnabledModules()) {
            this.checkThatClassloaderNotReferenced((IdeaPluginDescriptorImpl)it);
        }
    }

    private final void checkThatClassLoaderNotReferencedByPluginClassLoader(IdeaPluginDescriptorImpl descriptor) {
        this.checkThatClassloaderNotReferenced(descriptor);
        for (PluginDependency dependency : descriptor.getDependencies()) {
            DependsSubDescriptor dependsSubDescriptor = dependency.getSubDescriptor();
            if (dependsSubDescriptor == null) continue;
            this.checkThatClassLoaderNotReferencedByPluginClassLoader((IdeaPluginDescriptorImpl)dependsSubDescriptor);
        }
    }

    private final void checkThatClassloaderNotReferenced(IdeaPluginDescriptorImpl descriptor) {
        Object object = descriptor.getPluginClassLoader();
        PluginClassLoader pluginClassLoader = object instanceof PluginClassLoader ? (PluginClassLoader)object : null;
        if (pluginClassLoader == null) {
            return;
        }
        PluginClassLoader classLoader = pluginClassLoader;
        if (descriptor != this.unloadedMainDescriptor) {
            if (this.classLoaders.contains((Object)classLoader)) {
                ClassLoaderTreeCheckerKt.access$getLOG$p().error(classLoader + " must be unloaded but still referenced");
            }
            if (classLoader.getPluginDescriptor() == descriptor && Intrinsics.areEqual((Object)classLoader.getPluginId(), (Object)this.unloadedMainDescriptor.getPluginId())) {
                ClassLoaderTreeCheckerKt.access$getLOG$p().error("Classloader of " + descriptor + " must be nullified");
            }
        }
        ClassLoader[] parents = classLoader.getAllParentsClassLoaders();
        Iterator iterator = this.classLoaders.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        object = iterator;
        while (object.hasNext()) {
            boolean bl;
            PluginClassLoader unloadedClassLoader;
            block7: {
                Object e = object.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                unloadedClassLoader = (PluginClassLoader)e;
                ClassLoader[] $this$any$iv = parents;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int j = 0; j < n; ++j) {
                    ClassLoader element$iv;
                    ClassLoader it = element$iv = $this$any$iv[j];
                    boolean bl2 = false;
                    if (!(it == unloadedClassLoader)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
            if (!bl) continue;
            ClassLoaderTreeCheckerKt.access$getLOG$p().error(classLoader + " references via parents " + unloadedClassLoader + " that must be unloaded");
        }
        for (IdeaPluginDescriptor parent : classLoader._getParents()) {
            if (!Intrinsics.areEqual((Object)parent.getPluginId(), (Object)this.unloadedMainDescriptor.getPluginId())) continue;
            ClassLoaderTreeCheckerKt.access$getLOG$p().error(classLoader + " references via parents " + parent + " that must be unloaded");
        }
    }
}

