/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.InProductNotificationKt;
import com.intellij.ide.ui.LicenseExpirationDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.components.JBHtmlPane;
import com.intellij.ui.components.JBHtmlPaneConfiguration;
import com.intellij.ui.components.JBHtmlPaneStyleConfiguration;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0014J\r\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012H\u0014J\r\u0010\u0013\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ide/ui/InProductNotificationDialog;", "Lcom/intellij/ide/ui/LicenseExpirationDialog;", "project", "Lcom/intellij/openapi/project/Project;", "days", "", "time", "", "<init>", "(Lcom/intellij/openapi/project/Project;IJ)V", "getDays", "()I", "getTime", "()J", "createPanel", "Ljavax/swing/JComponent;", "getOKActionText", "", "Lorg/jetbrains/annotations/Nls;", "getCancelActionText", "show", "", "handleAction", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class InProductNotificationDialog
extends LicenseExpirationDialog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int days;
    private final long time;
    private static long showTime;

    public InProductNotificationDialog(@Nullable Project project2, int days, long time) {
        super(project2, "/images/Expiration.png");
        this.days = days;
        this.time = time;
        String string = IdeBundle.message((String)"in.product.notification.action.default.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.initDialog(string);
    }

    public final int getDays() {
        return this.days;
    }

    public final long getTime() {
        return this.time;
    }

    @Override
    @NotNull
    protected JComponent createPanel() {
        JBHtmlPaneConfiguration configuration = JBHtmlPaneConfiguration.Companion.builder().customStyleSheet("h1 { margin: 0px; padding: 0px; }").build();
        JBHtmlPane message = new JBHtmlPane(new JBHtmlPaneStyleConfiguration(), configuration);
        Object[] objectArray = new Object[]{this.days};
        message.setText(IdeBundle.message((String)"in.product.notification.dialog.text", (Object[])objectArray));
        message.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        return (JComponent)message;
    }

    @Override
    @NotNull
    protected String getOKActionText() {
        String string = IdeBundle.message((String)"in.product.notification.action.renew.button", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    protected String getCancelActionText() {
        String string = IdeBundle.message((String)"in.product.notification.action.dismiss.button", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void show() {
        if (this.time > 0L) {
            if (showTime > 0L && this.time - showTime < 360000L) {
                return;
            }
            showTime = this.time;
        }
        super.show();
        if (this.time > 0L) {
            showTime = System.currentTimeMillis();
        }
    }

    public final void handleAction() {
        if (this.getExitCode() == 0) {
            InProductNotificationKt.access$renewLicense();
        }
    }

    @JvmStatic
    public static final boolean enabled() {
        return Companion.enabled();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007R\u0018\u0010\u0006\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0003\u00a8\u0006\t"}, d2={"Lcom/intellij/ide/ui/InProductNotificationDialog$Companion;", "", "<init>", "()V", "enabled", "", "showTime", "", "getShowTime$annotations", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean enabled() {
            return Registry.Companion.is("edu.pack.in.product.notification.enabled", true);
        }

        @JvmStatic
        private static /* synthetic */ void getShowTime$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

