/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.ActionCallback;
import java.awt.Component;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ide/ui/OpenEditorSchemeConfigurableAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "component", "Ljavax/swing/JComponent;", "selectedSchemeProvider", "Lkotlin/Function0;", "", "<init>", "(Ljavax/swing/JComponent;Lkotlin/jvm/functions/Function0;)V", "getComponent", "()Ljavax/swing/JComponent;", "getSelectedSchemeProvider", "()Lkotlin/jvm/functions/Function0;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.ide.impl"})
final class OpenEditorSchemeConfigurableAction
extends DumbAwareAction {
    @NotNull
    private final JComponent component;
    @NotNull
    private final Function0<String> selectedSchemeProvider;

    public OpenEditorSchemeConfigurableAction(@NotNull JComponent component2, @NotNull Function0<String> selectedSchemeProvider) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter(selectedSchemeProvider, (String)"selectedSchemeProvider");
        super(IdeBundle.message((String)"combobox.editor.color.scheme.edit", (Object[])new Object[0]));
        this.component = component2;
        this.selectedSchemeProvider = selectedSchemeProvider;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    @NotNull
    public final Function0<String> getSelectedSchemeProvider() {
        return this.selectedSchemeProvider;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext2 = DataManager.getInstance().getDataContext((Component)this.component);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        Settings settings = (Settings)Settings.KEY.getData(dataContext2);
        if (settings == null) {
            ShowSettingsUtil.getInstance().showSettingsDialog(ProjectManager.getInstance().getDefaultProject(), ColorAndFontOptions.class);
        } else {
            Configurable configurable = settings.find("reference.settingsdialog.IDE.editor.colors");
            ColorAndFontOptions colorAndFontOptions = configurable instanceof ColorAndFontOptions ? (ColorAndFontOptions)configurable : null;
            if (colorAndFontOptions == null) {
                return;
            }
            ColorAndFontOptions configurable2 = colorAndFontOptions;
            String string = (String)this.selectedSchemeProvider.invoke();
            if (string != null) {
                String it = string;
                boolean bl = false;
                configurable2.preselectScheme(it);
            }
            ActionCallback actionCallback = settings.select((Configurable)configurable2);
            Intrinsics.checkNotNull((Object)actionCallback);
        }
    }
}

