/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.customization;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.customization.ActionGroupCustomizationService;
import com.intellij.ide.ui.customization.ActionIconInfo;
import com.intellij.ide.ui.customization.ActionUrl;
import com.intellij.ide.ui.customization.AddActionDialog;
import com.intellij.ide.ui.customization.BrowseIconsComboBox;
import com.intellij.ide.ui.customization.CustomActionsListener;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.ui.customization.CustomActionsSchemaKt;
import com.intellij.ide.ui.customization.CustomizationActionPanelLayoutUtilsKt;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.toolbarLayout.ToolbarLayoutStrategy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ui.ActionsTreeUtil;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.packageDependencies.ui.TreeExpansionMonitor;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.RowsDnDSupport;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.dsl.gridLayout.GridLayout;
import com.intellij.ui.mac.touchbar.TouchbarSupport;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public class CustomizableActionsPanel {
    private static final DataKey<TreePath[]> SELECTION = DataKey.create((String)"CUSTOMIZABLE_ACTIONS_PANEL_SELECTION");
    private static final DataKey<TreePath> LEAD_SELECTION = DataKey.create((String)"CUSTOMIZABLE_ACTIONS_PANEL_LEAD_SELECTION");
    private final JPanel myPanel = new MyPanel();
    protected JTree myActionsTree;
    protected CustomActionsSchema mySelectedSchema;
    private final Computable<Integer> myPreferredHeightProvider;

    public CustomizableActionsPanel() {
        Group rootGroup = new Group("root");
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(rootGroup);
        MyActionsTreeModel model2 = new MyActionsTreeModel(root);
        this.myActionsTree = new Tree((TreeModel)model2);
        this.myActionsTree.setRootVisible(false);
        this.myActionsTree.setShowsRootHandles(true);
        this.myActionsTree.setCellRenderer(CustomizableActionsPanel.createDefaultRenderer());
        RowsDnDSupport.install((JTree)this.myActionsTree, (EditableModel)model2);
        PopupHandler.installPopupMenu((JComponent)this.myActionsTree, (ActionGroup)this.createPopupActionGroup(), (String)"CustomizeActionsPanel");
        TreeExpansionMonitor.install(this.myActionsTree);
        FilterComponent filter2 = CustomizableActionsPanel.setupFilterComponent(this.myActionsTree);
        this.myPreferredHeightProvider = new Computable<Integer>(this, (JComponent)filter2){
            final /* synthetic */ JComponent val$filter;
            {
                this.val$filter = jComponent;
            }

            public Integer compute() {
                return this.val$filter.getPreferredSize().height;
            }
        };
        JPanel topPanel = new JPanel((LayoutManager)new GridLayout());
        CustomizationActionPanelLayoutUtilsKt.setupTopPanelLayout(topPanel, this.createToolbar(), (JComponent)filter2);
        this.myPanel.add((Component)topPanel, "North");
        this.myPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myActionsTree), "Center");
    }

    private ActionGroup createPopupActionGroup() {
        return new DefaultActionGroup(new AnAction[]{new EditIconAction(), new RemoveAction(), new Separator(), new AddActionBelowSelectionAction(this), new AddSeparatorAction()});
    }

    private JComponent createToolbar() {
        JPanel container = new JPanel(new BorderLayout());
        ActionToolbarImpl addGroupToolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)new DefaultActionGroup(new AnAction[]{new AddActionActionTreeSelectionAction()}), true);
        addGroupToolbar.setTargetComponent(this.myPanel);
        addGroupToolbar.setActionButtonBorder((Border)new JBEmptyBorder(0));
        addGroupToolbar.setBorder((Border)new JBEmptyBorder(0));
        container.add((Component)addGroupToolbar, "West");
        ActionToolbarImpl toolbar2 = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)new DefaultActionGroup(new AnAction[]{new EditIconAction(), new MoveUpAction(), new MoveDownAction(), new Separator(), new RemoveAction(), this.getRestoreGroup()}), true);
        toolbar2.setForceMinimumSize(true);
        toolbar2.setLayoutStrategy(ToolbarLayoutStrategy.NOWRAP_STRATEGY);
        toolbar2.setTargetComponent(this.myPanel);
        container.add((Component)toolbar2, "Center");
        return container;
    }

    @NotNull
    protected ActionGroup getRestoreGroup() {
        DefaultActionGroup restoreGroup = new DefaultActionGroup(new AnAction[]{new RestoreSelectionAction(), new RestoreAllAction()});
        restoreGroup.setPopup(true);
        restoreGroup.getTemplatePresentation().setText(IdeBundle.message((String)"group.customizations.restore.action.group", (Object[])new Object[0]));
        restoreGroup.getTemplatePresentation().setIcon(AllIcons.Actions.Rollback);
        DefaultActionGroup defaultActionGroup = restoreGroup;
        if (defaultActionGroup == null) {
            CustomizableActionsPanel.$$$reportNull$$$0(0);
        }
        return defaultActionGroup;
    }

    static FilterComponent setupFilterComponent(JTree tree2) {
        int[] keyCodes;
        final TreeSpeedSearch mySpeedSearch = new TreeSpeedSearch(tree2, true, null, (Function)new TreePathStringFunction()){

            @Override
            public boolean isPopupActive() {
                return true;
            }

            @Override
            public void showPopup(String searchText) {
            }

            @Override
            protected boolean isSpeedSearchEnabled() {
                return false;
            }

            @Override
            public void showPopup() {
            }
        };
        mySpeedSearch.setupListeners();
        final FilterComponent filterComponent2 = new FilterComponent("CUSTOMIZE_ACTIONS", 5){

            public void filter() {
                mySpeedSearch.findAndSelectElement(this.getFilter());
                ((JTree)mySpeedSearch.getComponent()).repaint();
            }
        };
        filterComponent2.setMaximumSize(new Dimension(300, 300));
        JTextField textField2 = filterComponent2.getTextEditor();
        for (final int keyCode : keyCodes = new int[]{36, 35, 38, 40}) {
            new DumbAwareAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    String filter2;
                    if (e == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (!StringUtil.isEmpty((String)(filter2 = filterComponent2.getFilter()))) {
                        mySpeedSearch.adjustSelection(keyCode, filter2);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/ui/customization/CustomizableActionsPanel$4", "actionPerformed"));
                }
            }.registerCustomShortcutSet(keyCode, 0, (JComponent)textField2);
        }
        return filterComponent2;
    }

    private void addCustomizedAction(ActionUrl url) {
        this.mySelectedSchema.addAction(url);
        this.onModified();
    }

    private static boolean isMoveSupported(@NotNull AnActionEvent e, int dir) {
        TreePath[] selectionPaths;
        if (e == null) {
            CustomizableActionsPanel.$$$reportNull$$$0(1);
        }
        if ((selectionPaths = (TreePath[])e.getData(SELECTION)) != null) {
            DefaultMutableTreeNode parent = null;
            for (TreePath treePath : selectionPaths) {
                if (treePath.getLastPathComponent() == null) continue;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                if (parent == null) {
                    parent = (DefaultMutableTreeNode)node.getParent();
                }
                if (parent == null || parent != node.getParent()) {
                    return false;
                }
                if (!(dir > 0 ? parent.getIndex(node) == parent.getChildCount() - 1 : parent.getIndex(node) == 0)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @RequiresBackgroundThread
    private static CustomizationRoots getCustomizationRoots() {
        ThreadingAssertions.assertBackgroundThread();
        return new CustomizationRoots(ActionGroupCustomizationService.getInstance().getReadOnlyActionGroupIds());
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    public void apply() throws ConfigurationException {
        List treePaths = TreeUtil.collectExpandedPaths((JTree)this.myActionsTree);
        if (this.mySelectedSchema != null) {
            CustomizationUtil.optimizeSchema(this.myActionsTree, this.mySelectedSchema);
        }
        this.restorePathsAfterTreeOptimization(treePaths);
        this.updateGlobalSchema();
        CustomActionsSchema customActionsSchema = CustomActionsSchema.getInstance();
        customActionsSchema.initActionIcons();
        customActionsSchema.setCustomizationSchemaForCurrentProjects();
        if (SystemInfo.isMac) {
            TouchbarSupport.reloadAllActions();
        }
        CustomActionsListener.fireSchemaChanged();
    }

    protected void updateGlobalSchema() {
        CustomActionsSchema.getInstance().copyFrom(this.mySelectedSchema);
    }

    protected void updateLocalSchema(CustomActionsSchema localSchema) {
    }

    private void restorePathsAfterTreeOptimization(List<? extends TreePath> treePaths) {
        for (TreePath treePath : treePaths) {
            this.myActionsTree.expandPath(CustomizationUtil.getPathByUserObjects(this.myActionsTree, treePath));
        }
    }

    public void reset() {
        this.reset(true);
    }

    public void resetToDefaults() {
        this.reset(false);
    }

    private void reset(boolean restoreLastState) {
        CustomActionsSchema source;
        List<String> expandedIds = CustomizableActionsPanel.toActionIDs(TreeUtil.collectExpandedPaths((JTree)this.myActionsTree));
        List<String> selectedIds = CustomizableActionsPanel.toActionIDs(TreeUtil.collectSelectedPaths((JTree)this.myActionsTree));
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myActionsTree.getModel().getRoot();
        TreeUtil.treeNodeTraverser((TreeNode)root).traverse().filter(node -> node instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)node).getUserObject() instanceof Pair).forEach(node -> CustomizableActionsPanel.doSetIcon(this.mySelectedSchema, (DefaultMutableTreeNode)node, null));
        CustomActionsSchema customActionsSchema = source = restoreLastState ? CustomActionsSchema.getInstance() : new CustomActionsSchema(null);
        if (this.mySelectedSchema == null) {
            this.mySelectedSchema = new CustomActionsSchema(null);
        }
        this.mySelectedSchema.copyFrom(source);
        this.updateLocalSchema(this.mySelectedSchema);
        this.mySelectedSchema.initActionIcons();
        this.patchActionsTreeCorrespondingToSchema(root);
        if (this.needExpandAll()) {
            new DefaultTreeExpander(this.myActionsTree).expandAll();
        } else {
            TreeUtil.restoreExpandedPaths((JTree)this.myActionsTree, CustomizableActionsPanel.toTreePaths(root, expandedIds));
        }
        TreeUtil.selectPaths((JTree)this.myActionsTree, CustomizableActionsPanel.toTreePaths(root, selectedIds));
        TreeUtil.ensureSelection((JTree)this.myActionsTree);
        this.onModified();
    }

    protected void onModified() {
    }

    private static @Unmodifiable List<String> toActionIDs(List<? extends TreePath> paths) {
        return ContainerUtil.map(paths, path -> CustomizableActionsPanel.getActionId((DefaultMutableTreeNode)path.getLastPathComponent()));
    }

    private static List<TreePath> toTreePaths(DefaultMutableTreeNode root, List<String> actionIDs) {
        ArrayList<TreePath> result2 = new ArrayList<TreePath>();
        for (String actionId : actionIDs) {
            DefaultMutableTreeNode treeNode = TreeUtil.findNode((DefaultMutableTreeNode)root, node -> Objects.equals(actionId, CustomizableActionsPanel.getActionId(node)));
            if (treeNode == null) continue;
            result2.add(TreeUtil.getPath((TreeNode)root, (TreeNode)treeNode));
        }
        return result2;
    }

    protected boolean needExpandAll() {
        return false;
    }

    public boolean isModified() {
        return this.isModified(true);
    }

    boolean isModified(boolean optimized) {
        if (CustomActionsSchema.getInstance().isModified(this.mySelectedSchema)) {
            if (optimized) {
                CustomizationUtil.optimizeSchema(this.myActionsTree, this.mySelectedSchema);
                return CustomActionsSchema.getInstance().isModified(this.mySelectedSchema);
            }
            return true;
        }
        return false;
    }

    protected void patchActionsTreeCorrespondingToSchema(DefaultMutableTreeNode root) {
        root.removeAllChildren();
        if (this.mySelectedSchema != null) {
            this.mySelectedSchema.fillCorrectedActionGroups(root);
        }
        ((DefaultTreeModel)this.myActionsTree.getModel()).reload();
        this.onModified();
    }

    static TreeCellRenderer createDefaultRenderer() {
        return CustomizableActionsPanel.createDefaultRenderer(false);
    }

    static TreeCellRenderer createDefaultRenderer(boolean showSeparatorAsAction) {
        return new MyTreeCellRenderer(showSeparatorAsAction);
    }

    @Nullable
    static String getActionId(DefaultMutableTreeNode node) {
        Object obj = node.getUserObject();
        if (obj instanceof String) {
            String actionId = (String)obj;
            return actionId;
        }
        if (obj instanceof Group) {
            Group group2 = (Group)obj;
            return group2.getId();
        }
        if (obj instanceof Pair) {
            String string;
            Pair pair = (Pair)obj;
            Object first = pair.first;
            if (first instanceof Group) {
                Group group3 = (Group)first;
                string = group3.getId();
            } else {
                string = (String)first;
            }
            return string;
        }
        return null;
    }

    static @NotNull Pair<@Nullable String, @Nullable Icon> getActionIdAndIcon(@NotNull DefaultMutableTreeNode node) {
        Object userObj;
        if (node == null) {
            CustomizableActionsPanel.$$$reportNull$$$0(2);
        }
        if ((userObj = node.getUserObject()) instanceof String) {
            String actionId = (String)userObj;
            AnAction action2 = ActionManager.getInstance().getAction(actionId);
            if (action2 != null) {
                return new Pair((Object)actionId, (Object)action2.getTemplatePresentation().getIcon());
            }
        } else {
            if (userObj instanceof Group) {
                Group group2 = (Group)userObj;
                return new Pair((Object)group2.getId(), (Object)group2.getIcon());
            }
            if (userObj instanceof Pair) {
                String string;
                Pair pair = (Pair)userObj;
                Object first = pair.first;
                if (first instanceof Group) {
                    Group group3 = (Group)first;
                    string = group3.getId();
                } else {
                    string = (String)first;
                }
                String actionId = string;
                return new Pair((Object)actionId, (Object)((Icon)pair.second));
            }
        }
        Pair pair = Pair.empty();
        if (pair == null) {
            CustomizableActionsPanel.$$$reportNull$$$0(3);
        }
        return pair;
    }

    static boolean setCustomIcon(@NotNull CustomActionsSchema schema, @NotNull DefaultMutableTreeNode node, @NotNull ActionIconInfo selectedInfo, @Nullable Component component2) {
        if (schema == null) {
            CustomizableActionsPanel.$$$reportNull$$$0(4);
        }
        if (node == null) {
            CustomizableActionsPanel.$$$reportNull$$$0(5);
        }
        if (selectedInfo == null) {
            CustomizableActionsPanel.$$$reportNull$$$0(6);
        }
        Pair<String, Icon> pair = CustomizableActionsPanel.getActionIdAndIcon(node);
        String actionId = (String)pair.first;
        if (actionId != null) {
            Icon originalIcon = (Icon)pair.second;
            Icon selectedIcon = selectedInfo.getIcon();
            if (selectedIcon != originalIcon) {
                String iconReference = selectedIcon != null ? selectedInfo.getIconReference() : null;
                return CustomizableActionsPanel.doSetIcon(schema, node, iconReference);
            }
        }
        return false;
    }

    private static boolean doSetIcon(@NotNull CustomActionsSchema schema, @NotNull DefaultMutableTreeNode node, @Nullable String path) {
        String actionId;
        Object value;
        Object userObj;
        if (schema == null) {
            CustomizableActionsPanel.$$$reportNull$$$0(7);
        }
        if (node == null) {
            CustomizableActionsPanel.$$$reportNull$$$0(8);
        }
        if ((userObj = node.getUserObject()) instanceof Pair) {
            Pair pair = (Pair)userObj;
            v0 = pair.first;
        } else {
            v0 = value = userObj;
        }
        if (value instanceof Group) {
            Group group2 = (Group)value;
            v1 = group2.getId();
        } else {
            v1 = actionId = value instanceof String ? (String)value : null;
        }
        if (actionId == null) {
            return false;
        }
        if (StringUtil.isEmpty((String)path)) {
            node.setUserObject(Pair.create((Object)value, null));
            schema.removeIconCustomization(actionId);
            return true;
        }
        ActionManager actionManager = ActionManager.getInstance();
        AnAction action2 = actionManager.getAction(actionId);
        if (action2 == null) {
            return false;
        }
        AnAction reuseFrom = actionManager.getAction(path);
        if (reuseFrom != null) {
            Icon toSet = CustomActionsSchemaKt.getOriginalIconFrom(reuseFrom);
            Icon defaultIcon = CustomActionsSchemaKt.getOriginalIconFrom(action2);
            node.setUserObject(Pair.create((Object)value, (Object)toSet));
            schema.addIconCustomization(actionId, toSet != defaultIcon ? path : null);
        } else {
            Icon icon2;
            try {
                icon2 = CustomActionsSchemaKt.loadCustomIcon(path);
            }
            catch (Throwable t) {
                Logger.getInstance(CustomizableActionsPanel.class).warn(String.format("Failed to load icon with path '%s' and set it to action '%s'", path, actionId), t);
                return false;
            }
            node.setUserObject(Pair.create((Object)value, (Object)icon2));
            schema.addIconCustomization(actionId, path);
        }
        return true;
    }

    private static void changePathInActionsTree(@NotNull JTree tree2, @NotNull ActionUrl url) {
        int actionType;
        if (tree2 == null) {
            CustomizableActionsPanel.$$$reportNull$$$0(9);
        }
        if (url == null) {
            CustomizableActionsPanel.$$$reportNull$$$0(10);
        }
        if ((actionType = url.getActionType()) == 1) {
            CustomizableActionsPanel.addPathToActionsTree(tree2, url);
        } else if (actionType == -1) {
            CustomizableActionsPanel.removePathFromActionsTree(tree2, url);
        } else if (actionType == 2) {
            CustomizableActionsPanel.movePathInActionsTree(tree2, url);
        }
    }

    @Nullable
    private static DefaultMutableTreeNode addPathToActionsTree(@NotNull JTree tree2, @NotNull ActionUrl url) {
        TreePath treePath;
        if (tree2 == null) {
            CustomizableActionsPanel.$$$reportNull$$$0(11);
        }
        if (url == null) {
            CustomizableActionsPanel.$$$reportNull$$$0(12);
        }
        if ((treePath = CustomizationUtil.getTreePath(tree2, url)) == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        int absolutePosition = url.getAbsolutePosition();
        if (node.getChildCount() >= absolutePosition && absolutePosition >= 0) {
            DefaultMutableTreeNode newNode;
            Object object = url.getComponent();
            if (object instanceof Group) {
                Group o = (Group)object;
                newNode = ActionsTreeUtil.createNode(o);
            } else {
                newNode = new DefaultMutableTreeNode(url.getComponent());
            }
            node.insert(newNode, absolutePosition);
            return newNode;
        }
        return null;
    }

    private static void removePathFromActionsTree(@NotNull JTree tree2, @NotNull ActionUrl url) {
        Object component2;
        if (tree2 == null) {
            CustomizableActionsPanel.$$$reportNull$$$0(13);
        }
        if (url == null) {
            CustomizableActionsPanel.$$$reportNull$$$0(14);
        }
        if ((component2 = url.getComponent()) == null) {
            return;
        }
        TreePath treePath = CustomizationUtil.getTreePath(tree2, url);
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        int absolutePosition = url.getAbsolutePosition();
        if (node.getChildCount() > absolutePosition && absolutePosition >= 0) {
            Object object;
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(absolutePosition);
            Object userObj = child.getUserObject();
            if (userObj instanceof Pair) {
                Pair pair = (Pair)userObj;
                object = pair.first;
            } else {
                object = userObj;
            }
            if (component2.equals(object)) {
                node.remove(child);
            }
        }
    }

    private static void movePathInActionsTree(@NotNull JTree tree2, @NotNull ActionUrl url) {
        DefaultMutableTreeNode o;
        DefaultMutableTreeNode parent;
        TreePath treePath;
        if (tree2 == null) {
            CustomizableActionsPanel.$$$reportNull$$$0(15);
        }
        if (url == null) {
            CustomizableActionsPanel.$$$reportNull$$$0(16);
        }
        Object pathComponent = (treePath = CustomizationUtil.getTreePath(tree2, url)) == null ? null : treePath.getLastPathComponent();
        DefaultMutableTreeNode defaultMutableTreeNode = parent = pathComponent instanceof DefaultMutableTreeNode ? (o = (DefaultMutableTreeNode)pathComponent) : null;
        if (parent == null) {
            return;
        }
        int absolutePosition = url.getAbsolutePosition();
        int initialPosition = url.getInitialPosition();
        Object component2 = url.getComponent();
        if (parent.getChildCount() > absolutePosition && absolutePosition >= 0 && parent.getChildCount() > initialPosition && initialPosition >= 0) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)parent.getChildAt(initialPosition);
            Object userObj = child.getUserObject();
            if (component2 != null) {
                Object object;
                if (userObj instanceof Pair) {
                    Pair pair = (Pair)userObj;
                    object = pair.first;
                } else {
                    object = userObj;
                }
                if (component2.equals(object)) {
                    parent.remove(child);
                    parent.insert(child, absolutePosition);
                }
            }
        }
    }

    @NotNull
    private static ArrayList<String> getGroupPath(TreePath treePath, boolean includeSelf) {
        ArrayList<String> result2 = new ArrayList<String>();
        int length = treePath.getPath().length - (includeSelf ? 0 : 1);
        for (int i2 = 0; i2 < length; ++i2) {
            Object o = ((DefaultMutableTreeNode)treePath.getPath()[i2]).getUserObject();
            if (!(o instanceof Group)) continue;
            result2.add(((Group)o).getName());
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            CustomizableActionsPanel.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    private static boolean isInsideMenu(TreePath path) {
        if (path.getPathCount() < 2) {
            return false;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getPathComponent(1);
        Group group2 = CustomizationUtil.getGroupForNode(node);
        if (group2 != null) {
            String groupId = group2.getId();
            return groupId != null && groupId.contains("Menu");
        }
        return false;
    }

    private void removePaths(TreePath ... paths) {
        if (paths == null) {
            return;
        }
        for (TreePath treePath : paths) {
            ActionUrl url = CustomizationUtil.getActionUrl(treePath, -1);
            CustomizableActionsPanel.changePathInActionsTree(this.myActionsTree, url);
            this.addCustomizedAction(url);
        }
        ((DefaultTreeModel)this.myActionsTree.getModel()).reload();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/customization/CustomizableActionsPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedInfo";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRestoreGroup";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/customization/CustomizableActionsPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionIdAndIcon";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupPath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isMoveSupported";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getActionIdAndIcon";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setCustomIcon";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doSetIcon";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "changePathInActionsTree";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addPathToActionsTree";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removePathFromActionsTree";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "movePathInActionsTree";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16 -> new IllegalArgumentException(string);
        };
    }

    private class MyPanel
    extends BorderLayoutPanel
    implements UiDataProvider {
        private MyPanel() {
            super(5, 5);
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                MyPanel.$$$reportNull$$$0(0);
            }
            sink.set(SELECTION, (Object)CustomizableActionsPanel.this.myActionsTree.getSelectionPaths());
            sink.set(LEAD_SELECTION, (Object)CustomizableActionsPanel.this.myActionsTree.getLeadSelectionPath());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/ide/ui/customization/CustomizableActionsPanel$MyPanel", "uiDataSnapshot"));
        }
    }

    private final class MyActionsTreeModel
    extends DefaultTreeModel
    implements EditableModel,
    RowsDnDSupport.RefinedDropSupport {
        private MyActionsTreeModel(TreeNode root) {
            super(root);
        }

        public void addRow() {
        }

        public void exchangeRows(int oldIndex, int newIndex) {
        }

        public boolean canExchangeRows(int oldIndex, int newIndex) {
            return CustomizableActionsPanel.this.myActionsTree.getPathForRow(oldIndex).getPath().length > 2 && CustomizableActionsPanel.this.myActionsTree.getPathForRow(newIndex).getPath().length > 2;
        }

        public void removeRow(int idx) {
        }

        public boolean isDropInto(JComponent component2, int oldIndex, int newIndex) {
            TreePath path = CustomizableActionsPanel.this.myActionsTree.getPathForRow(newIndex);
            return path.getPath().length > 1 && MyActionsTreeModel.isGroupPath(path);
        }

        public boolean canDrop(int oldIndex, int newIndex, @NotNull RowsDnDSupport.RefinedDropSupport.Position position) {
            if (position == null) {
                MyActionsTreeModel.$$$reportNull$$$0(0);
            }
            TreePath target = CustomizableActionsPanel.this.myActionsTree.getPathForRow(newIndex);
            TreePath sourcePath = CustomizableActionsPanel.this.myActionsTree.getPathForRow(oldIndex);
            if (sourcePath.getParentPath().equals(target.getParentPath())) {
                if (oldIndex == newIndex - 1 && position == RowsDnDSupport.RefinedDropSupport.Position.ABOVE) {
                    return false;
                }
                if (oldIndex == newIndex + 1 && position == RowsDnDSupport.RefinedDropSupport.Position.BELOW) {
                    return false;
                }
            }
            if (sourcePath.getParentPath().equals(target) && position == RowsDnDSupport.RefinedDropSupport.Position.INTO) {
                return false;
            }
            return sourcePath.getPath().length > 2 && (target.getPath().length > 2 || target.getPath().length > 1 && MyActionsTreeModel.isGroupPath(target));
        }

        public void drop(int oldIndex, int newIndex, @NotNull RowsDnDSupport.RefinedDropSupport.Position position) {
            if (position == null) {
                MyActionsTreeModel.$$$reportNull$$$0(1);
            }
            List expandedPaths = TreeUtil.collectExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree);
            TreePath path = CustomizableActionsPanel.this.myActionsTree.getPathForRow(oldIndex);
            TreePath targetPath = CustomizableActionsPanel.this.myActionsTree.getPathForRow(newIndex);
            if (Objects.equals(path.getParentPath(), targetPath.getParentPath()) && position != RowsDnDSupport.RefinedDropSupport.Position.INTO) {
                ActionUrl url = CustomizationUtil.getActionUrl(path, 2);
                url.setInitialPosition(url.getAbsolutePosition());
                int shift = position == RowsDnDSupport.RefinedDropSupport.Position.ABOVE && oldIndex < newIndex ? -1 : (position == RowsDnDSupport.RefinedDropSupport.Position.BELOW && oldIndex > newIndex ? 1 : 0);
                url.setAbsolutePosition(url.getInitialPosition() + newIndex - oldIndex + shift);
                CustomizableActionsPanel.changePathInActionsTree(CustomizableActionsPanel.this.myActionsTree, url);
                CustomizableActionsPanel.this.addCustomizedAction(url);
            } else {
                ActionUrl removeUrl = CustomizationUtil.getActionUrl(path, -1);
                CustomizableActionsPanel.changePathInActionsTree(CustomizableActionsPanel.this.myActionsTree, removeUrl);
                CustomizableActionsPanel.this.addCustomizedAction(removeUrl);
                ActionUrl addUrl = CustomizationUtil.getActionUrl(targetPath, 1);
                if (position == RowsDnDSupport.RefinedDropSupport.Position.INTO) {
                    addUrl.setAbsolutePosition(((DefaultMutableTreeNode)targetPath.getLastPathComponent()).getChildCount());
                    Object object = TreeUtil.getUserObject((Object)targetPath.getLastPathComponent());
                    if (object instanceof Group) {
                        Group group2 = (Group)object;
                        addUrl.getGroupPath().add(group2.getName());
                    }
                }
                addUrl.setComponent(removeUrl.getComponent());
                CustomizableActionsPanel.changePathInActionsTree(CustomizableActionsPanel.this.myActionsTree, addUrl);
                CustomizableActionsPanel.this.addCustomizedAction(addUrl);
            }
            ((DefaultTreeModel)CustomizableActionsPanel.this.myActionsTree.getModel()).reload();
            TreeUtil.restoreExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree, (List)expandedPaths);
            Object[] arr = Arrays.copyOf(targetPath.getParentPath().getPath(), targetPath.getPathCount());
            arr[arr.length - 1] = path.getLastPathComponent();
            TreePath pathToSelect = new TreePath(arr);
            TreeUtil.selectPath((JTree)CustomizableActionsPanel.this.myActionsTree, (TreePath)pathToSelect);
            TreeUtil.scrollToVisible((JTree)CustomizableActionsPanel.this.myActionsTree, (TreePath)path, (boolean)false);
        }

        private static boolean isGroupPath(TreePath path) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            return CustomizationUtil.getGroupForNode(node) != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "position";
            objectArray2[1] = "com/intellij/ide/ui/customization/CustomizableActionsPanel$MyActionsTreeModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canDrop";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "drop";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class EditIconAction
    extends TreeSelectionAction {
        private EditIconAction() {
            super(IdeBundle.messagePointer((String)"button.edit.action.icon", (Object[])new Object[0]), Presentation.NULL_STRING, AllIcons.Actions.Edit);
            this.registerCustomShortcutSet(CommonShortcuts.getEditSource(), CustomizableActionsPanel.this.myPanel);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            EditIconDialog dlg;
            if (e == null) {
                EditIconAction.$$$reportNull$$$0(0);
            }
            List expandedPaths = TreeUtil.collectExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree);
            TreePath selectionPath = (TreePath)e.getData(LEAD_SELECTION);
            if (selectionPath != null && (dlg = new EditIconDialog(selectionPath)).showAndGet()) {
                CustomizableActionsPanel.this.myActionsTree.repaint();
            }
            TreeUtil.restoreExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree, (List)expandedPaths);
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                EditIconAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            if (e.getPresentation().isEnabled()) {
                ActionManager actionManager = ActionManager.getInstance();
                TreePath leadSelection = (TreePath)e.getData(LEAD_SELECTION);
                if (leadSelection == null) {
                    e.getPresentation().setEnabled(false);
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)leadSelection.getLastPathComponent();
                String actionId = CustomizableActionsPanel.getActionId(node);
                if (actionId != null) {
                    AnAction action2 = actionManager.getAction(actionId);
                    e.getPresentation().setEnabled(action2 != null);
                } else {
                    e.getPresentation().setEnabled(false);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/ui/customization/CustomizableActionsPanel$EditIconAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class RemoveAction
    extends TreeSelectionAction {
        private RemoveAction() {
            super(IdeBundle.messagePointer((String)"button.remove", (Object[])new Object[0]), Presentation.NULL_STRING, AllIcons.Actions.GC);
            ShortcutSet shortcutSet = KeymapUtil.filterKeyStrokes((ShortcutSet)CommonShortcuts.getDelete(), (KeyStroke[])new KeyStroke[]{KeyStroke.getKeyStroke(127, 0), KeyStroke.getKeyStroke(8, 0)});
            if (shortcutSet != null) {
                this.registerCustomShortcutSet(shortcutSet, CustomizableActionsPanel.this.myPanel);
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveAction.$$$reportNull$$$0(0);
            }
            List expandedPaths = TreeUtil.collectExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree);
            CustomizableActionsPanel.this.removePaths((TreePath[])e.getData(SELECTION));
            TreeUtil.restoreExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree, (List)expandedPaths);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/ui/customization/CustomizableActionsPanel$RemoveAction", "actionPerformed"));
        }
    }

    private final class AddActionBelowSelectionAction
    extends AddActionActionBase {
        private AddActionBelowSelectionAction(CustomizableActionsPanel customizableActionsPanel) {
            super(IdeBundle.messagePointer((String)"group.customizations.add.action.below", (Object[])new Object[0]), AllIcons.General.Add);
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            boolean isGroup;
            if (e == null) {
                AddActionBelowSelectionAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            TreePath leadSelection = (TreePath)e.getData(LEAD_SELECTION);
            if (leadSelection == null) {
                e.getPresentation().setEnabled(false);
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)leadSelection.getLastPathComponent();
            boolean bl = isGroup = CustomizationUtil.getGroupForNode(node) != null;
            if (isGroup) {
                e.getPresentation().setText(IdeBundle.messagePointer((String)"group.customizations.add.action.group", (Object[])new Object[0]));
            } else {
                e.getPresentation().setText(IdeBundle.messagePointer((String)"group.customizations.add.action.below", (Object[])new Object[0]));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/ui/customization/CustomizableActionsPanel$AddActionBelowSelectionAction", "update"));
        }
    }

    private final class AddSeparatorAction
    extends TreeSelectionAction {
        private AddSeparatorAction() {
            super(IdeBundle.messagePointer((String)"button.add.separator", (Object[])new Object[0]), AllIcons.General.SeparatorH);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddSeparatorAction.$$$reportNull$$$0(0);
            }
            List expandedPaths = TreeUtil.collectExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree);
            TreePath selectionPath = (TreePath)e.getData(LEAD_SELECTION);
            if (selectionPath != null) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
                ActionUrl url = new ActionUrl(CustomizableActionsPanel.getGroupPath(selectionPath, false), Separator.getInstance(), 1, node.getParent().getIndex(node) + 1);
                CustomizableActionsPanel.changePathInActionsTree(CustomizableActionsPanel.this.myActionsTree, url);
                CustomizableActionsPanel.this.addCustomizedAction(url);
                ((DefaultTreeModel)CustomizableActionsPanel.this.myActionsTree.getModel()).reload();
            }
            TreeUtil.restoreExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree, (List)expandedPaths);
            CustomizableActionsPanel.this.myActionsTree.setSelectionRow(CustomizableActionsPanel.this.myActionsTree.getRowForPath(selectionPath) + 1);
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AddSeparatorAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            if (e.getPresentation().isEnabled()) {
                e.getPresentation().setEnabled(AddSeparatorAction.isSingleSelection(e));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/ui/customization/CustomizableActionsPanel$AddSeparatorAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class AddActionActionTreeSelectionAction
    extends AddActionActionBase
    implements CustomComponentAction {
        private AddActionActionTreeSelectionAction() {
            super(IdeBundle.messagePointer((String)"group.customizations.add.action.button", (Object[])new Object[0]));
        }

        @NotNull
        public JComponent createCustomComponent(final @NotNull Presentation presentation2, final @NotNull String place) {
            if (presentation2 == null) {
                AddActionActionTreeSelectionAction.$$$reportNull$$$0(0);
            }
            if (place == null) {
                AddActionActionTreeSelectionAction.$$$reportNull$$$0(1);
            }
            final JButton button2 = new JButton(presentation2.getText()){

                @Override
                public Dimension getPreferredSize() {
                    Dimension size2 = super.getPreferredSize();
                    if (CustomizableActionsPanel.this.myPreferredHeightProvider != null) {
                        size2.height = (Integer)CustomizableActionsPanel.this.myPreferredHeightProvider.compute();
                    }
                    return size2;
                }
            };
            button2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddActionActionTreeSelectionAction.this.performAction(button2, place, presentation2);
                }
            });
            JButton jButton = button2;
            if (jButton == null) {
                AddActionActionTreeSelectionAction.$$$reportNull$$$0(2);
            }
            return jButton;
        }

        public void updateCustomComponent(@NotNull JComponent component2, @NotNull Presentation presentation2) {
            if (component2 == null) {
                AddActionActionTreeSelectionAction.$$$reportNull$$$0(3);
            }
            if (presentation2 == null) {
                AddActionActionTreeSelectionAction.$$$reportNull$$$0(4);
            }
            component2.setEnabled(presentation2.isEnabled());
        }

        void performAction(JComponent component2, String place, Presentation presentation2) {
            DataContext dataContext2 = ActionToolbar.getDataContextFor((Component)component2);
            AnActionEvent event = AnActionEvent.createFromInputEvent(null, (String)place, (Presentation)presentation2, (DataContext)dataContext2);
            ActionUtil.performAction((AnAction)this, (AnActionEvent)event);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/ui/customization/CustomizableActionsPanel$AddActionActionTreeSelectionAction";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/ui/customization/CustomizableActionsPanel$AddActionActionTreeSelectionAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCustomComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createCustomComponent";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "updateCustomComponent";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private final class MoveUpAction
    extends TreeSelectionAction {
        private MoveUpAction() {
            super(IdeBundle.messagePointer((String)"button.move.up", (Object[])new Object[0]), Presentation.NULL_STRING, AllIcons.Actions.MoveUp);
            this.registerCustomShortcutSet(CommonShortcuts.MOVE_UP, CustomizableActionsPanel.this.myPanel);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MoveUpAction.$$$reportNull$$$0(0);
            }
            List expandedPaths = TreeUtil.collectExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree);
            TreePath[] selectionPath = (TreePath[])e.getData(SELECTION);
            if (selectionPath != null) {
                for (TreePath treePath : selectionPath) {
                    ActionUrl url = CustomizationUtil.getActionUrl(treePath, 2);
                    int absolutePosition = url.getAbsolutePosition();
                    url.setInitialPosition(absolutePosition);
                    url.setAbsolutePosition(absolutePosition - 1);
                    CustomizableActionsPanel.changePathInActionsTree(CustomizableActionsPanel.this.myActionsTree, url);
                    CustomizableActionsPanel.this.addCustomizedAction(url);
                }
                ((DefaultTreeModel)CustomizableActionsPanel.this.myActionsTree.getModel()).reload();
                TreeUtil.restoreExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree, (List)expandedPaths);
                for (TreePath path : selectionPath) {
                    CustomizableActionsPanel.this.myActionsTree.addSelectionPath(path);
                }
            }
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MoveUpAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            e.getPresentation().setEnabled(e.getPresentation().isEnabled() && CustomizableActionsPanel.isMoveSupported(e, -1));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/ui/customization/CustomizableActionsPanel$MoveUpAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MoveDownAction
    extends TreeSelectionAction {
        private MoveDownAction() {
            super(IdeBundle.messagePointer((String)"button.move.down", (Object[])new Object[0]), Presentation.NULL_STRING, AllIcons.Actions.MoveDown);
            this.registerCustomShortcutSet(CommonShortcuts.MOVE_DOWN, CustomizableActionsPanel.this.myPanel);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MoveDownAction.$$$reportNull$$$0(0);
            }
            List expandedPaths = TreeUtil.collectExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree);
            TreePath[] selectionPath = (TreePath[])e.getData(SELECTION);
            if (selectionPath != null) {
                for (int i2 = selectionPath.length - 1; i2 >= 0; --i2) {
                    TreePath treePath = selectionPath[i2];
                    ActionUrl url = CustomizationUtil.getActionUrl(treePath, 2);
                    int absolutePosition = url.getAbsolutePosition();
                    url.setInitialPosition(absolutePosition);
                    url.setAbsolutePosition(absolutePosition + 1);
                    CustomizableActionsPanel.changePathInActionsTree(CustomizableActionsPanel.this.myActionsTree, url);
                    CustomizableActionsPanel.this.addCustomizedAction(url);
                }
                ((DefaultTreeModel)CustomizableActionsPanel.this.myActionsTree.getModel()).reload();
                TreeUtil.restoreExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree, (List)expandedPaths);
                for (TreePath path : selectionPath) {
                    CustomizableActionsPanel.this.myActionsTree.addSelectionPath(path);
                }
            }
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MoveDownAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            e.getPresentation().setEnabled(e.getPresentation().isEnabled() && CustomizableActionsPanel.isMoveSupported(e, 1));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/ui/customization/CustomizableActionsPanel$MoveDownAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class RestoreSelectionAction
    extends DumbAwareAction {
        private RestoreSelectionAction() {
            super(IdeBundle.messagePointer((String)"button.restore.selected.groups", (Object[])new Object[0]));
        }

        private Pair<TreeSet<String>, List<ActionUrl>> findActionsUnderSelection(@NotNull AnActionEvent e) {
            if (e == null) {
                RestoreSelectionAction.$$$reportNull$$$0(0);
            }
            ArrayList<ActionUrl> actions = new ArrayList<ActionUrl>();
            TreeSet<String> selectedNames = new TreeSet<String>();
            TreePath[] selectionPaths = (TreePath[])e.getData(SELECTION);
            if (selectionPaths != null) {
                for (TreePath path : selectionPaths) {
                    ActionUrl selectedUrl = CustomizationUtil.getActionUrl(path, 2);
                    ArrayList<String> selectedGroupPath = new ArrayList<String>(selectedUrl.getGroupPath());
                    Object component2 = selectedUrl.getComponent();
                    if (!(component2 instanceof Group)) continue;
                    selectedGroupPath.add(((Group)component2).getName());
                    selectedNames.add(((Group)component2).getName());
                    for (ActionUrl action2 : CustomizableActionsPanel.this.mySelectedSchema.getActions()) {
                        ArrayList<String> groupPath = action2.getGroupPath();
                        int idx = Collections.indexOfSubList(groupPath, selectedGroupPath);
                        if (idx <= -1) continue;
                        actions.add(action2);
                    }
                }
            }
            return Pair.create(selectedNames, actions);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RestoreSelectionAction.$$$reportNull$$$0(1);
            }
            ArrayList<ActionUrl> otherActions = new ArrayList<ActionUrl>(CustomizableActionsPanel.this.mySelectedSchema.getActions());
            otherActions.removeAll((Collection)this.findActionsUnderSelection((AnActionEvent)e).second);
            CustomizableActionsPanel.this.mySelectedSchema.copyFrom(new CustomActionsSchema(null));
            for (ActionUrl otherAction : otherActions) {
                CustomizableActionsPanel.this.mySelectedSchema.addAction(otherAction);
            }
            List treePaths = TreeUtil.collectExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree);
            CustomizableActionsPanel.this.patchActionsTreeCorrespondingToSchema((DefaultMutableTreeNode)CustomizableActionsPanel.this.myActionsTree.getModel().getRoot());
            CustomizableActionsPanel.this.restorePathsAfterTreeOptimization(treePaths);
            CustomizableActionsPanel.this.onModified();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RestoreSelectionAction.$$$reportNull$$$0(2);
            }
            Pair<TreeSet<String>, List<ActionUrl>> selection = this.findActionsUnderSelection(e);
            e.getPresentation().setEnabled(!((List)selection.second).isEmpty());
            if (((TreeSet)selection.first).size() != 1) {
                e.getPresentation().setText(IdeBundle.messagePointer((String)"button.restore.selected.groups", (Object[])new Object[0]));
            } else {
                e.getPresentation().setText(IdeBundle.messagePointer((String)"button.restore.selection", (Object[])new Object[]{((TreeSet)selection.first).iterator().next()}));
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                RestoreSelectionAction.$$$reportNull$$$0(3);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/ui/customization/CustomizableActionsPanel$RestoreSelectionAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/ui/customization/CustomizableActionsPanel$RestoreSelectionAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "findActionsUnderSelection";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private final class RestoreAllAction
    extends DumbAwareAction {
        private RestoreAllAction() {
            super(IdeBundle.messagePointer((String)"button.restore.all", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RestoreAllAction.$$$reportNull$$$0(0);
            }
            CustomizableActionsPanel.this.mySelectedSchema.copyFrom(new CustomActionsSchema(null));
            CustomizableActionsPanel.this.patchActionsTreeCorrespondingToSchema((DefaultMutableTreeNode)CustomizableActionsPanel.this.myActionsTree.getModel().getRoot());
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RestoreAllAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(CustomizableActionsPanel.this.mySelectedSchema.isModified(new CustomActionsSchema(null)));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                RestoreAllAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/ui/customization/CustomizableActionsPanel$RestoreAllAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/ui/customization/CustomizableActionsPanel$RestoreAllAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static final class TreePathStringFunction
    implements Function<TreePath, String> {
        private TreePathStringFunction() {
        }

        @Override
        public String apply(TreePath o) {
            Object node = o.getLastPathComponent();
            if (node instanceof DefaultMutableTreeNode) {
                String actionId;
                Object object = ((DefaultMutableTreeNode)node).getUserObject();
                if (object instanceof Group) {
                    return ((Group)object).getName();
                }
                if (object instanceof QuickList) {
                    return ((QuickList)((Object)object)).getName();
                }
                if (object instanceof String) {
                    actionId = (String)object;
                } else if (object instanceof Pair) {
                    Object obj = ((Pair)object).first;
                    if (obj instanceof Group) {
                        Group group2 = (Group)obj;
                        return group2.getName();
                    }
                    actionId = (String)obj;
                } else {
                    return "";
                }
                if (Strings.isEmpty((String)actionId)) {
                    return "";
                }
                AnAction action2 = ActionManager.getInstance().getAction(actionId);
                if (action2 != null) {
                    return action2.getTemplatePresentation().getText();
                }
            }
            return "";
        }
    }

    private static class CustomizationRoots {
        @NotNull
        private final Set<String> myReadOnlyActionGroupIds;

        CustomizationRoots(@NotNull Set<String> readOnlyActionGroupIds) {
            if (readOnlyActionGroupIds == null) {
                CustomizationRoots.$$$reportNull$$$0(0);
            }
            this.myReadOnlyActionGroupIds = readOnlyActionGroupIds;
        }

        private boolean isUnderCustomizationRoot(@Nullable TreePath path) {
            if (path == null) {
                return false;
            }
            TreePath parent = path.getParentPath();
            return this.isCustomizationRoot(parent) || this.isUnderCustomizationRoot(parent);
        }

        private boolean isCustomizationRoot(@Nullable TreePath path) {
            if (path == null) {
                return false;
            }
            if (this.isReadOnlyGroup(path)) {
                return false;
            }
            TreePath parent = path.getParentPath();
            if (parent == null) {
                return false;
            }
            return this.isReadOnlyGroup(parent);
        }

        private boolean isReadOnlyGroup(@Nullable TreePath path) {
            if (path == null) {
                return false;
            }
            Group group2 = CustomizationUtil.getGroupForNode((DefaultMutableTreeNode)path.getLastPathComponent());
            if (group2 == null) {
                return false;
            }
            if (this.myReadOnlyActionGroupIds.contains(group2.getId())) {
                return true;
            }
            return path.getPathCount() == 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readOnlyActionGroupIds", "com/intellij/ide/ui/customization/CustomizableActionsPanel$CustomizationRoots", "<init>"));
        }
    }

    private static final class MyTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final boolean myShowSeparatorAsAction;

        private MyTreeCellRenderer(boolean showSeparatorAsAction) {
            this.myShowSeparatorAsAction = showSeparatorAsAction;
        }

        public void customizeCellRenderer(@NotNull JTree tree2, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            if (tree2 == null) {
                MyTreeCellRenderer.$$$reportNull$$$0(0);
            }
            if (value instanceof DefaultMutableTreeNode) {
                Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                if (this.myShowSeparatorAsAction && userObject instanceof Separator) {
                    this.setIcon(AllIcons.General.SeparatorH);
                    this.append(ActionsBundle.message((String)"action.separator", (Object[])new Object[0]));
                } else {
                    CustomizationUtil.acceptObjectIconAndText(userObject, (text2, description, icon2) -> {
                        this.append(text2);
                        if (description != null) {
                            this.append("   ", SimpleTextAttributes.REGULAR_ATTRIBUTES, false);
                            this.append(description, SimpleTextAttributes.GRAY_ATTRIBUTES);
                        }
                        if (((DefaultMutableTreeNode)value).getLevel() > 1) {
                            this.setIcon(icon2);
                        }
                    });
                }
                this.setForeground(UIUtil.getTreeForeground((boolean)selected, (boolean)hasFocus));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ide/ui/customization/CustomizableActionsPanel$MyTreeCellRenderer", "customizeCellRenderer"));
        }
    }

    private abstract class AddActionActionBase
    extends TreeSelectionAction {
        private AddActionActionBase(Supplier<String> text2) {
            if (text2 == null) {
                AddActionActionBase.$$$reportNull$$$0(0);
            }
            super(text2);
        }

        private AddActionActionBase(@Nullable Supplier<String> text2, Icon icon2) {
            if (text2 == null) {
                AddActionActionBase.$$$reportNull$$$0(1);
            }
            super(text2, icon2);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddActionActionBase.$$$reportNull$$$0(2);
            }
            List expandedPaths = TreeUtil.collectExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree);
            TreePath selectionPath = (TreePath)e.getData(LEAD_SELECTION);
            int row2 = CustomizableActionsPanel.this.myActionsTree.getRowForPath(selectionPath);
            if (selectionPath != null) {
                List<Object> addedActions;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
                AddActionDialog dlg = new AddActionDialog(CustomizableActionsPanel.this.mySelectedSchema, CustomizableActionsPanel.isInsideMenu(selectionPath));
                if (dlg.showAndGet() && !(addedActions = dlg.getAddedActions()).isEmpty()) {
                    boolean isGroupSelected = CustomizationUtil.getGroupForNode(node) != null;
                    for (int ind = 0; ind < addedActions.size(); ++ind) {
                        Object action2 = addedActions.get(ind);
                        if (action2 instanceof Group) {
                            Group group2 = (Group)action2;
                            group2.setForceShowAsPopup(true);
                        }
                        int newActionPosition = isGroupSelected ? node.getChildCount() : node.getParent().getIndex(node) + ind + 1;
                        ActionUrl url = new ActionUrl(CustomizableActionsPanel.getGroupPath(new TreePath(node.getPath()), true), action2, 1, newActionPosition);
                        CustomizableActionsPanel.this.addCustomizedAction(url);
                        DefaultMutableTreeNode newNode = CustomizableActionsPanel.addPathToActionsTree(CustomizableActionsPanel.this.myActionsTree, url);
                        if (newNode == null || !(action2 instanceof String)) continue;
                        String actionId = (String)action2;
                        String path = CustomizableActionsPanel.this.mySelectedSchema.getIconPath(actionId);
                        if (path.isEmpty()) {
                            path = actionId;
                        }
                        Icon icon2 = CustomActionsSchemaKt.getIconForPath((Function1<? super String, ? extends AnAction>)((Function1)s -> ActionManager.getInstance().getAction(s)), path);
                        newNode.setUserObject(new Pair((Object)actionId, (Object)icon2));
                    }
                    ((DefaultTreeModel)CustomizableActionsPanel.this.myActionsTree.getModel()).reload();
                    TreeUtil.restoreExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree, (List)expandedPaths);
                    if (isGroupSelected) {
                        CustomizableActionsPanel.this.myActionsTree.expandPath(selectionPath);
                    }
                    int newSelectedRow = row2 + (isGroupSelected ? node.getChildCount() : addedActions.size());
                    CustomizableActionsPanel.this.myActionsTree.setSelectionRow(newSelectedRow);
                }
            }
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AddActionActionBase.$$$reportNull$$$0(3);
            }
            super.update(e);
            if (e.getPresentation().isEnabled()) {
                e.getPresentation().setEnabled(AddActionActionBase.isSingleSelection(e));
            }
        }

        @Override
        protected boolean isNotApplicableForPath(@NotNull TreePath path) {
            if (path == null) {
                AddActionActionBase.$$$reportNull$$$0(4);
            }
            return CustomizableActionsPanel.getCustomizationRoots().isReadOnlyGroup(path);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/ui/customization/CustomizableActionsPanel$AddActionActionBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isNotApplicableForPath";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class TreeSelectionAction
    extends DumbAwareAction {
        private TreeSelectionAction(@NotNull Supplier<String> text2) {
            if (text2 == null) {
                TreeSelectionAction.$$$reportNull$$$0(0);
            }
            super(text2);
        }

        private TreeSelectionAction(@NotNull Supplier<String> text2, @Nullable Icon icon2) {
            if (text2 == null) {
                TreeSelectionAction.$$$reportNull$$$0(1);
            }
            super(text2, icon2);
        }

        private TreeSelectionAction(@NotNull Supplier<String> text2, @NotNull Supplier<String> description, @Nullable Icon icon2) {
            if (text2 == null) {
                TreeSelectionAction.$$$reportNull$$$0(2);
            }
            if (description == null) {
                TreeSelectionAction.$$$reportNull$$$0(3);
            }
            super(text2, description, icon2);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                TreeSelectionAction.$$$reportNull$$$0(4);
            }
            e.getPresentation().setEnabled(true);
            TreePath[] selectionPaths = (TreePath[])e.getData(SELECTION);
            if (selectionPaths == null) {
                e.getPresentation().setEnabled(false);
                return;
            }
            for (TreePath path : selectionPaths) {
                if (!this.isNotApplicableForPath(path)) continue;
                e.getPresentation().setEnabled(false);
                return;
            }
        }

        protected boolean isNotApplicableForPath(@NotNull TreePath path) {
            if (path == null) {
                TreeSelectionAction.$$$reportNull$$$0(5);
            }
            return !CustomizableActionsPanel.getCustomizationRoots().isUnderCustomizationRoot(path);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                TreeSelectionAction.$$$reportNull$$$0(6);
            }
            return actionUpdateThread;
        }

        protected static boolean isSingleSelection(@NotNull AnActionEvent e) {
            TreePath[] selectionPaths;
            if (e == null) {
                TreeSelectionAction.$$$reportNull$$$0(7);
            }
            return (selectionPaths = (TreePath[])e.getData(SELECTION)) != null && selectionPaths.length == 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/ui/customization/CustomizableActionsPanel$TreeSelectionAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/ui/customization/CustomizableActionsPanel$TreeSelectionAction";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isNotApplicableForPath";
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isSingleSelection";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6 -> new IllegalStateException(string);
            };
        }
    }

    private final class EditIconDialog
    extends DialogWrapper {
        private final DefaultMutableTreeNode myNode;
        private final boolean isNodeInsideMenu;
        private BrowseIconsComboBox myComboBox;

        private EditIconDialog(TreePath path) {
            super(false);
            this.setTitle(IdeBundle.message((String)"title.choose.action.icon", (Object[])new Object[0]));
            this.isNodeInsideMenu = CustomizableActionsPanel.isInsideMenu(path);
            this.init();
            this.myNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            this.myComboBox.selectIconForNode(this.myNode);
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myComboBox;
        }

        protected String getDimensionServiceKey() {
            return ((Object)((Object)this)).getClass().getName();
        }

        protected JComponent createCenterPanel() {
            this.myComboBox = new BrowseIconsComboBox(CustomizableActionsPanel.this.mySelectedSchema, this.getDisposable(), this.isNodeInsideMenu);
            JPanel northPanel2 = new JPanel(new BorderLayout());
            northPanel2.add((Component)((Object)this.myComboBox), "North");
            return northPanel2;
        }

        protected void doOKAction() {
            ActionIconInfo selectedInfo;
            Object selectedItem = this.myComboBox.getSelectedItem();
            if (selectedItem instanceof ActionIconInfo && CustomizableActionsPanel.setCustomIcon(CustomizableActionsPanel.this.mySelectedSchema, this.myNode, selectedInfo = (ActionIconInfo)selectedItem, this.getContentPane())) {
                CustomizableActionsPanel.this.myActionsTree.repaint();
                CustomActionsSchema.getInstance().setCustomizationSchemaForCurrentProjects();
            }
            super.doOKAction();
        }
    }
}

