/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.experimental.toolbar;

import com.intellij.ide.ui.ExperimentalToolbarSettingsState;
import com.intellij.ide.ui.ToolbarSettings;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.ide.ui.experimental.toolbar.ExperimentalToolbarSettingsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@State(name="ToolbarSettingsService", storages={@Storage(value="other.xml", roamingType=RoamingType.DISABLED)}, category=SettingsCategory.UI, exportable=true)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\nH\u0016J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\nH\u0002J\b\u0010\u001a\u001a\u00020\nH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR$\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u000f\"\u0004\b\u0012\u0010\u0013R$\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u000f\"\u0004\b\u0015\u0010\u0013\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ide/ui/experimental/toolbar/ExperimentalToolbarSettings;", "Lcom/intellij/ide/ui/ToolbarSettings;", "Lcom/intellij/ide/ui/UISettingsListener;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "toolbarState", "Lcom/intellij/ide/ui/ExperimentalToolbarSettingsState;", "getState", "loadState", "", "state", "dispose", "isAvailable", "", "()Z", "value", "isEnabled", "setEnabled", "(Z)V", "isVisible", "setVisible", "uiSettingsChanged", "uiSettings", "Lcom/intellij/ide/ui/UISettings;", "hideClassicMainToolbarIfVisible", "hideClassicMainToolbarAndNavbarIfVisible", "ToolbarRegistryListener", "intellij.platform.ide.impl"})
@ApiStatus.Experimental
public final class ExperimentalToolbarSettings
implements ToolbarSettings,
UISettingsListener,
Disposable {
    @NotNull
    private ExperimentalToolbarSettingsState toolbarState = new ExperimentalToolbarSettingsState();

    private ExperimentalToolbarSettings() {
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        Topic topic = UISettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)this);
    }

    @NotNull
    public ExperimentalToolbarSettingsState getState() {
        return this.toolbarState;
    }

    public void loadState(@NotNull ExperimentalToolbarSettingsState state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        this.toolbarState = state2;
    }

    public void dispose() {
    }

    public boolean isAvailable() {
        return this.isEnabled() && !ExperimentalUI.Companion.isNewUI();
    }

    public boolean isEnabled() {
        return RegistryManager.Companion.getInstance().is("ide.widget.toolbar");
    }

    public void setEnabled(boolean value) {
        RegistryManager.Companion.getInstance().get("ide.widget.toolbar").setValue(value);
    }

    public boolean isVisible() {
        return this.toolbarState.getShowNewMainToolbar();
    }

    public void setVisible(boolean value) {
        this.toolbarState.setShowNewMainToolbar(value);
        this.hideClassicMainToolbarAndNavbarIfVisible();
    }

    public void uiSettingsChanged(@NotNull UISettings uiSettings) {
        Intrinsics.checkNotNullParameter((Object)uiSettings, (String)"uiSettings");
        ExperimentalToolbarSettingsKt.access$getLogger$p().info("Dispatching UI settings change.");
        this.hideClassicMainToolbarIfVisible();
    }

    private final void hideClassicMainToolbarIfVisible() {
        if (this.isVisible()) {
            ExperimentalToolbarSettingsKt.access$getLogger$p().info("Hiding Main Toolbar (Classic) because the new toolbar is visible.");
            UISettings.Companion.getInstance().setShowMainToolbar(false);
        }
    }

    private final void hideClassicMainToolbarAndNavbarIfVisible() {
        if (this.isVisible()) {
            this.hideClassicMainToolbarIfVisible();
            ExperimentalToolbarSettingsKt.access$getLogger$p().info("Hiding NavBar because the new toolbar is visible.");
            UISettings.Companion.getInstance().setShowNavigationBar(false);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/ui/experimental/toolbar/ExperimentalToolbarSettings$ToolbarRegistryListener;", "Lcom/intellij/openapi/util/registry/RegistryValueListener;", "<init>", "()V", "afterValueChanged", "", "value", "Lcom/intellij/openapi/util/registry/RegistryValue;", "intellij.platform.ide.impl"})
    private static final class ToolbarRegistryListener
    implements RegistryValueListener {
        public void afterValueChanged(@NotNull RegistryValue value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (!Intrinsics.areEqual((Object)value.getKey(), (Object)"ide.widget.toolbar")) {
                return;
            }
            boolean booleanValue = value.asBoolean();
            ExperimentalToolbarSettingsKt.access$getLogger$p().info("New registry value: " + booleanValue);
            ToolbarSettings.Companion.getInstance().setVisible(booleanValue);
            UISettings uiSettings = UISettings.Companion.getInstance();
            uiSettings.setShowNavigationBar(!booleanValue && uiSettings.getShowNavigationBar());
            uiSettings.fireUISettingsChanged();
        }
    }
}

