/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsCollectorImpl;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsEventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.ObjectEventData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.NotificationsEventLogGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@ApiStatus.Internal
public final class NotificationCollector {
    public static final String UNKNOWN = "unknown";

    private NotificationCollector() {
    }

    public void logBalloonShown(@Nullable Project project2, @NotNull NotificationDisplayType displayType, @NotNull Notification notification2, boolean isExpandable) {
        if (displayType == null) {
            NotificationCollector.$$$reportNull$$$0(0);
        }
        if (notification2 == null) {
            NotificationCollector.$$$reportNull$$$0(1);
        }
        List<EventPair<?>> data2 = NotificationCollector.createNotificationData(notification2.getGroupId(), notification2.id, notification2.getDisplayId());
        data2.add(NotificationsEventLogGroup.DISPLAY_TYPE.with((Object)displayType));
        NotificationSeverity severity = NotificationCollector.getType(notification2);
        data2.add(NotificationsEventLogGroup.SEVERITY.with((Object)severity));
        data2.add(NotificationsEventLogGroup.IS_EXPANDABLE.with((Object)isExpandable));
        NotificationsEventLogGroup.SHOWN.log(project2, data2);
    }

    public void logToolWindowNotificationShown(@Nullable Project project2, @NotNull Notification notification2) {
        if (notification2 == null) {
            NotificationCollector.$$$reportNull$$$0(2);
        }
        List<EventPair<?>> data2 = NotificationCollector.createNotificationData(notification2.getGroupId(), notification2.id, notification2.getDisplayId());
        data2.add(NotificationsEventLogGroup.DISPLAY_TYPE.with((Object)NotificationDisplayType.TOOL_WINDOW));
        NotificationSeverity severity = NotificationCollector.getType(notification2);
        data2.add(NotificationsEventLogGroup.SEVERITY.with((Object)severity));
        NotificationsEventLogGroup.SHOWN.log(project2, data2);
    }

    public void logNotificationLoggedInEventLog(@NotNull Project project2, @NotNull Notification notification2) {
        if (project2 == null) {
            NotificationCollector.$$$reportNull$$$0(3);
        }
        if (notification2 == null) {
            NotificationCollector.$$$reportNull$$$0(4);
        }
        List<EventPair<?>> data2 = NotificationCollector.createNotificationData(notification2.getGroupId(), notification2.id, notification2.getDisplayId());
        NotificationSeverity severity = NotificationCollector.getType(notification2);
        data2.add(NotificationsEventLogGroup.SEVERITY.with((Object)severity));
        NotificationsEventLogGroup.LOGGED.log(project2, data2);
    }

    @NotNull
    private static NotificationSeverity getType(@NotNull Notification notification2) {
        if (notification2 == null) {
            NotificationCollector.$$$reportNull$$$0(5);
        }
        NotificationType type = notification2.getType();
        NotificationSeverity notificationSeverity = switch (type) {
            default -> throw new MatchException(null, null);
            case NotificationType.ERROR -> NotificationSeverity.ERROR;
            case NotificationType.WARNING -> NotificationSeverity.WARNING;
            case NotificationType.INFORMATION, NotificationType.IDE_UPDATE -> NotificationSeverity.INFORMATION;
        };
        if (notificationSeverity == null) {
            NotificationCollector.$$$reportNull$$$0(6);
        }
        return notificationSeverity;
    }

    public void logNotificationBalloonClosedByUser(@Nullable Project project2, @Nullable String notificationId, @Nullable String notificationDisplayId, @Nullable String groupId) {
        if (notificationId == null) {
            return;
        }
        NotificationsEventLogGroup.CLOSED_BY_USER.log(project2, NotificationCollector.createNotificationData(groupId, notificationId, notificationDisplayId));
    }

    public void logNotificationActionInvoked(@Nullable Project project2, @NotNull Notification notification2, @NotNull AnAction action2, @NotNull NotificationPlace notificationPlace) {
        if (notification2 == null) {
            NotificationCollector.$$$reportNull$$$0(7);
        }
        if (action2 == null) {
            NotificationCollector.$$$reportNull$$$0(8);
        }
        if (notificationPlace == null) {
            NotificationCollector.$$$reportNull$$$0(9);
        }
        List<EventPair<?>> data2 = NotificationCollector.createNotificationData(notification2.getGroupId(), notification2.id, notification2.getDisplayId());
        data2.add(NotificationsEventLogGroup.NOTIFICATION_PLACE.with((Object)notificationPlace));
        if (action2 instanceof NotificationAction.Simple) {
            NotificationAction.Simple simpleAction = (NotificationAction.Simple)action2;
            Object actionInstance = simpleAction.getDelegate();
            PluginInfo info = PluginInfoDetectorKt.getPluginInfo(actionInstance.getClass());
            String actionId = info.isSafeToReport() ? simpleAction.getId() : "third.party";
            data2.add(ActionsEventLogGroup.ACTION_ID.with((Object)actionId));
        } else {
            ActionsCollectorImpl.addActionClass(data2, action2, PluginInfoDetectorKt.getPluginInfo(action2.getClass()));
        }
        NotificationsEventLogGroup.ACTION_INVOKED.log(project2, data2);
    }

    public void logHyperlinkClicked(@NotNull Notification notification2) {
        if (notification2 == null) {
            NotificationCollector.$$$reportNull$$$0(10);
        }
        NotificationsEventLogGroup.HYPERLINK_CLICKED.log(NotificationCollector.createNotificationData(notification2.getGroupId(), notification2.id, notification2.getDisplayId()));
    }

    public void logBalloonShownFromEventLog(@Nullable Project project2, @NotNull Notification notification2) {
        if (notification2 == null) {
            NotificationCollector.$$$reportNull$$$0(11);
        }
        NotificationsEventLogGroup.EVENT_LOG_BALLOON_SHOWN.log(project2, NotificationCollector.createNotificationData(notification2.getGroupId(), notification2.id, notification2.getDisplayId()));
    }

    public void logNotificationSettingsClicked(@NotNull String notificationId, @Nullable String notificationDisplayId, @Nullable String groupId) {
        if (notificationId == null) {
            NotificationCollector.$$$reportNull$$$0(12);
        }
        NotificationsEventLogGroup.SETTINGS_CLICKED.log(NotificationCollector.createNotificationData(groupId, notificationId, notificationDisplayId));
    }

    public void logNotificationBalloonExpanded(@Nullable Project project2, @NotNull Notification notification2) {
        if (notification2 == null) {
            NotificationCollector.$$$reportNull$$$0(13);
        }
        NotificationsEventLogGroup.BALLOON_EXPANDED.log(project2, NotificationCollector.createNotificationData(notification2.getGroupId(), notification2.id, notification2.getDisplayId()));
    }

    public void logNotificationBalloonCollapsed(@Nullable Project project2, @NotNull Notification notification2) {
        if (notification2 == null) {
            NotificationCollector.$$$reportNull$$$0(14);
        }
        NotificationsEventLogGroup.BALLOON_COLLAPSED.log(project2, NotificationCollector.createNotificationData(notification2.getGroupId(), notification2.id, notification2.getDisplayId()));
    }

    @NotNull
    public static List<EventPair<?>> createNotificationData(@Nullable String groupId, @NotNull String id2, @Nullable String displayId) {
        if (id2 == null) {
            NotificationCollector.$$$reportNull$$$0(15);
        }
        ArrayList data2 = new ArrayList();
        data2.add(NotificationsEventLogGroup.ID.with((Object)id2));
        if (Strings.isNotEmpty((String)displayId)) {
            data2.add(NotificationsEventLogGroup.ADDITIONAL.with((Object)new ObjectEventData(new EventPair[]{NotificationsEventLogGroup.NOTIFICATION_ID.with(displayId)})));
        }
        data2.add(NotificationsEventLogGroup.NOTIFICATION_GROUP_ID.with((Object)(Strings.isNotEmpty((String)groupId) ? groupId : UNKNOWN)));
        PluginInfo pluginInfo = NotificationCollector.getPluginInfo(groupId);
        if (pluginInfo != null) {
            data2.add(EventFields.PluginInfo.with((Object)pluginInfo));
        }
        ArrayList arrayList = data2;
        if (arrayList == null) {
            NotificationCollector.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    public static NotificationCollector getInstance() {
        return (NotificationCollector)ApplicationManager.getApplication().getService(NotificationCollector.class);
    }

    @Nullable
    private static PluginInfo getPluginInfo(@Nullable String groupId) {
        if (groupId == null) {
            return null;
        }
        NotificationGroup group2 = NotificationGroup.findRegisteredGroup((String)groupId);
        if (group2 == null) {
            return null;
        }
        return PluginInfoDetectorKt.getPluginInfoById((PluginId)group2.getPluginId());
    }

    @NotNull
    public static List<String> parseIds(@Nullable String entry) {
        String[] values;
        if (entry == null) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                NotificationCollector.$$$reportNull$$$0(17);
            }
            return list2;
        }
        ArrayList<String> list3 = new ArrayList<String>();
        for (String value : values = StringUtil.convertLineSeparators((String)entry, (String)"").split(";")) {
            if (Strings.isEmptyOrSpaces((CharSequence)value)) continue;
            list3.add(value.trim());
        }
        ArrayList<String> arrayList = list3;
        if (arrayList == null) {
            NotificationCollector.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 16, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayType";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/notification/impl/NotificationCollector";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationPlace";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationId";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/notification/impl/NotificationCollector";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotificationData";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "parseIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "logBalloonShown";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "logToolWindowNotificationShown";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "logNotificationLoggedInEventLog";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 6: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "logNotificationActionInvoked";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "logHyperlinkClicked";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "logBalloonShownFromEventLog";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "logNotificationSettingsClicked";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "logNotificationBalloonExpanded";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "logNotificationBalloonCollapsed";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 16, 17, 18 -> new IllegalStateException(string);
        };
    }

    public static enum NotificationSeverity {
        INFORMATION,
        WARNING,
        ERROR;

    }

    public static enum NotificationPlace {
        BALLOON,
        ACTION_CENTER,
        EVENT_LOG,
        TOOL_WINDOW;

    }

    static final class NotificationIdValidator
    extends CustomValidationRule {
        NotificationIdValidator() {
        }

        @NotNull
        public String getRuleId() {
            return "notification_display_id";
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            if (data2 == null) {
                NotificationIdValidator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                NotificationIdValidator.$$$reportNull$$$0(1);
            }
            if (NotificationCollector.UNKNOWN.equals(data2)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    NotificationIdValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            if (NotificationGroupManager.getInstance().isRegisteredNotificationId(data2)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    NotificationIdValidator.$$$reportNull$$$0(3);
                }
                return validationResultType;
            }
            ValidationResultType validationResultType = ValidationResultType.REJECTED;
            if (validationResultType == null) {
                NotificationIdValidator.$$$reportNull$$$0(4);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/notification/impl/NotificationCollector$NotificationIdValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/notification/impl/NotificationCollector$NotificationIdValidator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    static final class NotificationGroupValidator
    extends CustomValidationRule {
        NotificationGroupValidator() {
        }

        @NotNull
        public String getRuleId() {
            return "notification_group";
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            if (data2 == null) {
                NotificationGroupValidator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                NotificationGroupValidator.$$$reportNull$$$0(1);
            }
            if (NotificationCollector.UNKNOWN.equals(data2)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    NotificationGroupValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            NotificationGroup group2 = NotificationGroupManager.getInstance().getNotificationGroup(data2);
            if (group2 != null && PluginInfoDetectorKt.getPluginInfoById((PluginId)group2.getPluginId()).isDevelopedByJetBrains()) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    NotificationGroupValidator.$$$reportNull$$$0(3);
                }
                return validationResultType;
            }
            ValidationResultType validationResultType = ValidationResultType.REJECTED;
            if (validationResultType == null) {
                NotificationGroupValidator.$$$reportNull$$$0(4);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/notification/impl/NotificationCollector$NotificationGroupValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/notification/impl/NotificationCollector$NotificationGroupValidator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

