/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.diagnostic.Dumpable;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.EditorAndState;
import com.intellij.openapi.command.impl.EditorChangeAction;
import com.intellij.openapi.command.impl.FinishMarkAction;
import com.intellij.openapi.command.impl.NonUndoableAction;
import com.intellij.openapi.command.impl.SharedAdjustableUndoableActionsHolder;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.command.impl.UndoCommandFlushReason;
import com.intellij.openapi.command.impl.UndoDumpUnit;
import com.intellij.openapi.command.impl.UndoRedoList;
import com.intellij.openapi.command.impl.UndoRedoStacksHolder;
import com.intellij.openapi.command.impl.UndoableGroupOriginalContext;
import com.intellij.openapi.command.undo.AdjustableUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class UndoableGroup
implements Dumpable {
    private static final Logger LOG = Logger.getInstance(UndoableGroup.class);
    private static final int BULK_MODE_ACTION_THRESHOLD = 50;
    private final @NlsContexts.Command @Nullable String commandName;
    @NotNull
    private final List<? extends UndoableAction> actions;
    @NotNull
    private final UndoConfirmationPolicy confirmationPolicy;
    @Nullable
    private final UndoCommandFlushReason flushReason;
    private final int commandTimestamp;
    private final boolean isLocalHistoryActivity;
    private final boolean isTransparent;
    private final boolean isGlobal;
    private final boolean isUndoable;
    @Nullable
    private UndoableGroupOriginalContext originalContext;
    @Nullable
    private EditorAndState stateBefore;
    @Nullable
    private EditorAndState stateAfter;
    private boolean isTemporary;
    private boolean isValid;

    UndoableGroup(@NlsContexts.Command @Nullable String commandName, @NotNull List<? extends UndoableAction> actions, @NotNull UndoConfirmationPolicy confirmationPolicy, @NotNull UndoRedoStacksHolder stacksHolder, @Nullable EditorAndState stateBefore, @Nullable EditorAndState stateAfter, @Nullable UndoCommandFlushReason flushReason, int commandTimestamp, boolean isLocalHistoryActivity, boolean isTransparent, boolean isGlobal, boolean isValid) {
        if (actions == null) {
            UndoableGroup.$$$reportNull$$$0(0);
        }
        if (confirmationPolicy == null) {
            UndoableGroup.$$$reportNull$$$0(1);
        }
        if (stacksHolder == null) {
            UndoableGroup.$$$reportNull$$$0(2);
        }
        this.commandName = commandName;
        this.actions = actions;
        this.confirmationPolicy = confirmationPolicy;
        this.originalContext = null;
        this.stateBefore = stateBefore;
        this.stateAfter = stateAfter;
        this.flushReason = flushReason;
        this.commandTimestamp = commandTimestamp;
        this.isLocalHistoryActivity = isLocalHistoryActivity;
        this.isTransparent = isTransparent;
        this.isTemporary = isTransparent;
        this.isGlobal = isGlobal;
        this.isValid = isValid;
        this.composeStartFinishGroup(stacksHolder);
        this.isUndoable = ContainerUtil.all(actions, action2 -> !(action2 instanceof NonUndoableAction));
    }

    boolean isUndoable() {
        return this.isUndoable;
    }

    void undo() throws UnexpectedUndoException {
        this.undoOrRedo(true);
    }

    void redo() throws UnexpectedUndoException {
        this.undoOrRedo(false);
    }

    boolean isInsideStartFinishGroup(boolean isUndo, boolean isInsideStartFinishGroup) {
        int startNmb = 0;
        int finishNmb = 0;
        for (UndoableAction undoableAction : this.actions) {
            if (undoableAction instanceof StartMarkAction) {
                ++startNmb;
                continue;
            }
            if (!(undoableAction instanceof FinishMarkAction)) continue;
            ++finishNmb;
        }
        if (startNmb != finishNmb) {
            if (isUndo) {
                return finishNmb > startNmb;
            }
            return startNmb > finishNmb;
        }
        return isInsideStartFinishGroup;
    }

    boolean shouldAskConfirmation(boolean redo) {
        if (this.shouldAskConfirmationForStartFinishGroup(redo)) {
            return true;
        }
        return this.confirmationPolicy == UndoConfirmationPolicy.REQUEST_CONFIRMATION || this.confirmationPolicy != UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION && this.isGlobal;
    }

    @NlsContexts.Command
    String getCommandName() {
        for (UndoableAction undoableAction : this.actions) {
            FinishMarkAction finishMark;
            StartMarkAction startMark;
            String commandName;
            if (!(undoableAction instanceof StartMarkAction ? (commandName = (startMark = (StartMarkAction)undoableAction).getCommandName()) != null : undoableAction instanceof FinishMarkAction && (commandName = (finishMark = (FinishMarkAction)undoableAction).getCommandName()) != null)) continue;
            return commandName;
        }
        return this.commandName;
    }

    @NotNull
    UndoConfirmationPolicy getConfirmationPolicy() {
        UndoConfirmationPolicy undoConfirmationPolicy = this.confirmationPolicy;
        if (undoConfirmationPolicy == null) {
            UndoableGroup.$$$reportNull$$$0(3);
        }
        return undoConfirmationPolicy;
    }

    @NotNull
    List<? extends UndoableAction> getActions() {
        List<? extends UndoableAction> list2 = this.actions;
        if (list2 == null) {
            UndoableGroup.$$$reportNull$$$0(4);
        }
        return list2;
    }

    boolean isGlobal() {
        return this.isGlobal;
    }

    boolean isTransparent() {
        return this.isTransparent;
    }

    boolean isLocalHistoryActivity() {
        return this.isLocalHistoryActivity;
    }

    int getCommandTimestamp() {
        return this.commandTimestamp;
    }

    boolean isTemporary() {
        return this.isTemporary;
    }

    void makePermanent() {
        this.isTemporary = false;
    }

    boolean isValid() {
        return this.isValid;
    }

    long getGroupStartPerformedTimestamp() {
        if (this.actions.isEmpty()) {
            return -1L;
        }
        return Math.min(this.actions.getFirst().getPerformedNanoTime(), this.actions.getLast().getPerformedNanoTime());
    }

    void invalidateChangeRanges(@NotNull SharedAdjustableUndoableActionsHolder adjustableUndoableActionsHolder) {
        if (adjustableUndoableActionsHolder == null) {
            UndoableGroup.$$$reportNull$$$0(5);
        }
        for (UndoableAction undoableAction : this.actions) {
            if (!(undoableAction instanceof AdjustableUndoableAction)) continue;
            AdjustableUndoableAction adjustableAction = (AdjustableUndoableAction)undoableAction;
            adjustableUndoableActionsHolder.remove(adjustableAction);
        }
    }

    void invalidateActionsFor(@NotNull DocumentReference ref2) {
        if (ref2 == null) {
            UndoableGroup.$$$reportNull$$$0(6);
        }
        if (this.getAffectedDocuments().contains(ref2)) {
            this.isValid = false;
        }
    }

    @NotNull
    Collection<DocumentReference> getAffectedDocuments() {
        HashSet<DocumentReference> result2 = new HashSet<DocumentReference>();
        for (UndoableAction undoableAction : this.actions) {
            DocumentReference[] refs = undoableAction.getAffectedDocuments();
            if (refs == null) continue;
            Collections.addAll(result2, refs);
        }
        HashSet<DocumentReference> hashSet = result2;
        if (hashSet == null) {
            UndoableGroup.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    void setOriginalContext(@NotNull UndoableGroupOriginalContext originalContext) {
        if (originalContext == null) {
            UndoableGroup.$$$reportNull$$$0(8);
        }
        this.originalContext = originalContext;
    }

    @Nullable
    UndoableGroupOriginalContext getOriginalContext() {
        return this.originalContext;
    }

    void setStateBefore(@NotNull EditorAndState stateBefore) {
        if (stateBefore == null) {
            UndoableGroup.$$$reportNull$$$0(9);
        }
        this.stateBefore = stateBefore;
    }

    void setStateAfter(@NotNull EditorAndState stateAfter) {
        if (stateAfter == null) {
            UndoableGroup.$$$reportNull$$$0(10);
        }
        this.stateAfter = stateAfter;
    }

    @Nullable
    EditorAndState getStateBefore() {
        return this.stateBefore;
    }

    @Nullable
    EditorAndState getStateAfter() {
        return this.stateAfter;
    }

    @Nullable
    UndoCommandFlushReason getFlushReason() {
        return this.flushReason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undoOrRedo(boolean isUndo) throws UnexpectedUndoException {
        LocalHistoryAction action2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Performing " + (isUndo ? "undo" : "redo") + " for " + this.dumpState());
        }
        if (this.isLocalHistoryActivity && this.isGlobal()) {
            String actionName = IdeBundle.message((String)(isUndo ? "undo.command" : "redo.command"), (Object[])new Object[]{this.commandName});
            action2 = LocalHistory.getInstance().startAction(actionName);
        } else {
            action2 = LocalHistoryAction.NULL;
        }
        try {
            this.doUndoOrRedo(isUndo);
        }
        finally {
            action2.finish();
        }
    }

    private void doUndoOrRedo(boolean isUndo) throws UnexpectedUndoException {
        UnexpectedUndoException[] exception = new UnexpectedUndoException[]{null};
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                List actionsList = isUndo ? ContainerUtil.reverse(this.actions) : this.actions;
                int toProcess = 0;
                int toProcessInBulk = 0;
                int actionCount = actionsList.size();
                for (int i2 = 0; i2 < actionCount; ++i2) {
                    UndoableAction action2 = (UndoableAction)actionsList.get(i2);
                    DocumentEx newDocument = UndoableGroup.getDocumentToSetBulkMode(action2);
                    if (newDocument != null) continue;
                    if (i2 - toProcessInBulk > 50) {
                        UndoableGroup.performActions(actionsList.subList(toProcess, toProcessInBulk), isUndo, false);
                        UndoableGroup.performActions(actionsList.subList(toProcessInBulk, i2), isUndo, true);
                        toProcess = i2;
                    }
                    toProcessInBulk = i2 + 1;
                }
                if (actionCount - toProcessInBulk > 50) {
                    UndoableGroup.performActions(actionsList.subList(toProcess, toProcessInBulk), isUndo, false);
                    UndoableGroup.performActions(actionsList.subList(toProcessInBulk, actionCount), isUndo, true);
                } else {
                    UndoableGroup.performActions(actionsList.subList(toProcess, actionCount), isUndo, false);
                }
            }
            catch (UnexpectedUndoException e) {
                exception[0] = e;
            }
        });
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    private void composeStartFinishGroup(@NotNull UndoRedoStacksHolder holder) {
        FinishMarkAction finishMark;
        if (holder == null) {
            UndoableGroup.$$$reportNull$$$0(11);
        }
        if ((finishMark = this.getFinishMark()) != null) {
            boolean global = false;
            String commandName = null;
            UndoRedoList stack = (UndoRedoList)holder.getStack(finishMark.getAffectedDocument());
            Iterator iterator = stack.descendingIterator();
            while (iterator.hasNext()) {
                UndoableGroup group2 = (UndoableGroup)iterator.next();
                if (group2.isGlobal()) {
                    global = true;
                    commandName = group2.getCommandName();
                    break;
                }
                if (group2.getStartMark() == null) continue;
                break;
            }
            if (global) {
                finishMark.setGlobal(true);
                finishMark.setCommandName(commandName);
            }
        }
    }

    private boolean shouldAskConfirmationForStartFinishGroup(boolean redo) {
        if (redo) {
            StartMarkAction mark = this.getStartMark();
            if (mark != null) {
                return mark.isGlobal();
            }
        } else {
            FinishMarkAction finishMark = this.getFinishMark();
            if (finishMark != null) {
                return finishMark.isGlobal();
            }
        }
        return false;
    }

    @Nullable
    private StartMarkAction getStartMark() {
        for (UndoableAction undoableAction : this.actions) {
            if (!(undoableAction instanceof StartMarkAction)) continue;
            StartMarkAction startMark = (StartMarkAction)undoableAction;
            return startMark;
        }
        return null;
    }

    @Nullable
    private FinishMarkAction getFinishMark() {
        for (UndoableAction undoableAction : this.actions) {
            if (!(undoableAction instanceof FinishMarkAction)) continue;
            FinishMarkAction finishMark = (FinishMarkAction)undoableAction;
            return finishMark;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performActions(@NotNull List<? extends UndoableAction> actions, boolean isUndo, boolean useBulkMode) throws UnexpectedUndoException {
        if (actions == null) {
            UndoableGroup.$$$reportNull$$$0(12);
        }
        HashSet<DocumentEx> bulkDocuments = new HashSet<DocumentEx>();
        try {
            for (UndoableAction undoableAction : actions) {
                if (useBulkMode) {
                    DocumentEx newDocument = UndoableGroup.getDocumentToSetBulkMode(undoableAction);
                    if (newDocument == null) {
                        for (DocumentEx document2 : bulkDocuments) {
                            document2.setInBulkUpdate(false);
                        }
                        bulkDocuments.clear();
                    } else if (bulkDocuments.add(newDocument)) {
                        newDocument.setInBulkUpdate(true);
                    }
                }
                if (isUndo) {
                    undoableAction.undo();
                    continue;
                }
                undoableAction.redo();
            }
        }
        finally {
            for (DocumentEx documentEx : bulkDocuments) {
                documentEx.setInBulkUpdate(false);
            }
        }
    }

    @Nullable
    private static DocumentEx getDocumentToSetBulkMode(@NotNull UndoableAction action2) {
        if (action2 == null) {
            UndoableGroup.$$$reportNull$$$0(13);
        }
        if (!(action2 instanceof EditorChangeAction)) {
            return null;
        }
        DocumentReference newDocumentRef = action2.getAffectedDocuments()[0];
        if (newDocumentRef == null) {
            return null;
        }
        VirtualFile file2 = newDocumentRef.getFile();
        if (file2 != null && !file2.isValid()) {
            return null;
        }
        return (DocumentEx)newDocumentRef.getDocument();
    }

    @NotNull
    String dumpState0() {
        String string = UndoDumpUnit.fromGroup(this).toString();
        if (string == null) {
            UndoableGroup.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public String dumpState() {
        String string = "UndoableGroup[name=%s, global=%s, transparent=%s, stamp=%s, localHistory=%s, policy=%s, temporary=%s, valid=%s, actions=%s, documents=%s]".formatted(this.commandName, this.isGlobal, this.isTransparent, this.commandTimestamp, this.isLocalHistoryActivity, this.confirmationPolicy, this.isTemporary, this.isValid, this.actions, this.getAffectedDocuments());
        if (string == null) {
            UndoableGroup.$$$reportNull$$$0(15);
        }
        return string;
    }

    public String toString() {
        boolean multiline;
        StringBuilder result2 = new StringBuilder("UndoableGroup[");
        boolean bl = multiline = this.actions.size() > 1;
        if (multiline) {
            result2.append("\n");
        }
        result2.append(StringUtil.join(this.actions, each -> (multiline ? "  " : "") + each.toString(), (String)",\n"));
        if (multiline) {
            result2.append("\n");
        }
        result2.append("]");
        return result2.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 7, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "confirmationPolicy";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stacksHolder";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/UndoableGroup";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adjustableUndoableActionsHolder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalContext";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stateBefore";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stateAfter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/UndoableGroup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfirmationPolicy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedDocuments";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpState0";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 14: 
            case 15: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invalidateChangeRanges";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invalidateActionsFor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setOriginalContext";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setStateBefore";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setStateAfter";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "composeStartFinishGroup";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "performActions";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentToSetBulkMode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 7, 14, 15 -> new IllegalStateException(string);
        };
    }
}

