/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.ui.ExperimentalUI;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public final class EditorColorSchemesComparator
implements Comparator<EditorColorsScheme> {
    public static final EditorColorSchemesComparator INSTANCE = new EditorColorSchemesComparator();
    public static final int DEFAULT_SCHEME = 0;
    public static final int ONE_OF_DEFAULT_SCHEMES = 1;
    public static final int BUNDLED_NEW_UI_SCHEME = 2;
    public static final int BUNDLED_CLASSIC_SCHEME = 3;
    public static final int CUSTOM_SCHEME = 4;

    private EditorColorSchemesComparator() {
    }

    @Override
    public int compare(EditorColorsScheme s1, EditorColorsScheme s2) {
        int order2;
        int order1 = EditorColorSchemesComparator.getOrder(s1, false);
        if (order1 != (order2 = EditorColorSchemesComparator.getOrder(s2, false))) {
            return order1 - order2;
        }
        return s1.getName().compareToIgnoreCase(s2.getName());
    }

    public static int getGroupNumber(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            EditorColorSchemesComparator.$$$reportNull$$$0(0);
        }
        return EditorColorSchemesComparator.getOrder(scheme, true);
    }

    private static int getOrder(@NotNull EditorColorsScheme scheme, boolean groupNumberOnly) {
        if (scheme == null) {
            EditorColorSchemesComparator.$$$reportNull$$$0(1);
        }
        if (scheme instanceof AbstractColorsScheme) {
            AbstractColorsScheme original = ((AbstractColorsScheme)scheme).getOriginal();
            if (!groupNumberOnly && original instanceof DefaultColorsScheme) {
                return EditorColorsScheme.getDefaultSchemeName().equals(original.getName()) ? 0 : 1;
            }
            if (original != null && original.isReadOnly()) {
                int i2;
                if (ExperimentalUI.isNewUI() && (i2 = Arrays.asList("High contrast", "Dark", "Light").indexOf(original.getName())) >= 0) {
                    return groupNumberOnly ? 2 : -(i2 + 1);
                }
                return 3;
            }
        }
        return 4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "scheme";
        objectArray2[1] = "com/intellij/openapi/editor/colors/impl/EditorColorSchemesComparator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getGroupNumber";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

