/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class BidiContentNotificationProvider
implements EditorNotificationProvider {
    private static final Key<Boolean> DISABLE_NOTIFICATION = Key.create((String)"bidi.content.notification.disable");

    BidiContentNotificationProvider() {
    }

    @Nullable
    public @Nullable Function<? super @NotNull FileEditor, ? extends @Nullable JComponent> collectNotificationData(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            BidiContentNotificationProvider.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            BidiContentNotificationProvider.$$$reportNull$$$0(1);
        }
        if (PropertiesComponent.getInstance().isTrueValue(DISABLE_NOTIFICATION.toString())) {
            return null;
        }
        return fileEditor -> {
            if (!(fileEditor instanceof TextEditor)) {
                return null;
            }
            Editor editor2 = ((TextEditor)fileEditor).getEditor();
            if (!Boolean.TRUE.equals(editor2.getUserData(EditorImpl.CONTAINS_BIDI_TEXT)) || Boolean.TRUE.equals(editor2.getUserData(DISABLE_NOTIFICATION))) {
                return null;
            }
            EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Info);
            panel2.setText(EditorBundle.message((String)"bidi.content.message", (Object[])new Object[0]));
            panel2.createActionLabel(EditorBundle.message((String)"bidi.content.choose.message", (Object[])new Object[0]), () -> BidiContentNotificationProvider.showChooserPopup(editor2));
            panel2.createActionLabel(EditorBundle.message((String)"notification.hide.message", (Object[])new Object[0]), () -> {
                editor2.putUserData(DISABLE_NOTIFICATION, (Object)Boolean.TRUE);
                EditorNotifications.getInstance((Project)project2).updateNotifications(file2);
            });
            panel2.createActionLabel(EditorBundle.message((String)"notification.dont.show.again.message", (Object[])new Object[0]), () -> {
                PropertiesComponent.getInstance().setValue(DISABLE_NOTIFICATION.toString(), "true");
                EditorNotifications.getInstance((Project)project2).updateAllNotifications();
            });
            return panel2;
        };
    }

    private static void showChooserPopup(@NotNull Editor editor2) {
        ActionManager actionManager;
        AnAction group2;
        if (editor2 == null) {
            BidiContentNotificationProvider.$$$reportNull$$$0(2);
        }
        if (!((group2 = (actionManager = ActionManager.getInstance()).getAction("EditorBidiTextDirection")) instanceof ActionGroup)) {
            return;
        }
        JPopupMenu popupMenu = actionManager.createActionPopupMenu("EDITOR_NOTIFICATION_POPUP", (ActionGroup)group2).getComponent();
        AWTEvent event = IdeEventQueue.getInstance().getTrueCurrentEvent();
        if (event instanceof MouseEvent && ((MouseEvent)event).getComponent().isShowing()) {
            JBPopupMenu.showByEvent((MouseEvent)((MouseEvent)event), (JPopupMenu)popupMenu);
        } else {
            JBPopupMenu.showByEditor((Editor)editor2, (JPopupMenu)popupMenu);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/BidiContentNotificationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectNotificationData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showChooserPopup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

