/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.view.EditorView;
import java.awt.Point;
import java.awt.Rectangle;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ClipDetector {
    private final EditorView myView;
    private final Document myDocument;
    private final FoldingModel myFoldingModel;
    private final Rectangle myClipRectangle;
    private final boolean myDisabled;
    private int myVisualLineStartOffset = -1;
    private int myVisualLineEndOffset = -1;
    private int myVisualLineClipStartOffset;
    private int myVisualLineClipEndOffset;

    public static boolean isDisabled(@NotNull EditorImpl editor2) {
        if (editor2 == null) {
            ClipDetector.$$$reportNull$$$0(0);
        }
        return editor2.getContentComponent().getWidth() < 10 * editor2.getScrollingModel().getVisibleArea().width;
    }

    public ClipDetector(EditorView view2, Document document2, FoldingModel foldingModel, Rectangle clipRectangle, boolean isDisabled) {
        this.myView = view2;
        this.myDocument = document2;
        this.myFoldingModel = foldingModel;
        this.myClipRectangle = clipRectangle;
        this.myDisabled = isDisabled;
    }

    public boolean rangeCanBeVisible(int startOffset, int endOffset) {
        assert (startOffset >= 0);
        assert (startOffset <= endOffset);
        assert (endOffset <= this.myDocument.getTextLength());
        if (this.myDisabled) {
            return true;
        }
        if (startOffset < this.myVisualLineStartOffset || startOffset > this.myVisualLineEndOffset) {
            this.myVisualLineStartOffset = EditorUtil.getNotFoldedLineStartOffset(this.myDocument, this.myFoldingModel, startOffset, false);
            this.myVisualLineEndOffset = EditorUtil.getNotFoldedLineEndOffset(this.myDocument, this.myFoldingModel, startOffset, false);
            int visualLine = this.myView.offsetToVisualLine(startOffset, false);
            int y = this.myView.visualLineToY(visualLine);
            this.myVisualLineClipStartOffset = this.myView.logicalPositionToOffset(this.myView.xyToLogicalPosition(new Point(this.myClipRectangle.x, y)));
            this.myVisualLineClipEndOffset = this.myView.logicalPositionToOffset(this.myView.xyToLogicalPosition(new Point(this.myClipRectangle.x + this.myClipRectangle.width, y)));
        }
        return endOffset > this.myVisualLineEndOffset || startOffset <= this.myVisualLineClipEndOffset && endOffset >= this.myVisualLineClipStartOffset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/ClipDetector", "isDisabled"));
    }
}

