/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.stickyLines.ui;

import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.stickyLines.VisualStickyLine;
import com.intellij.openapi.editor.impl.stickyLines.VisualStickyLines;
import com.intellij.openapi.editor.impl.stickyLines.ui.StickyLineComponent;
import com.intellij.openapi.editor.impl.stickyLines.ui.StickyLineComponents;
import com.intellij.openapi.editor.impl.stickyLines.ui.StickyLineShadowBorder;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.components.JBPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0015\u001a\u00020\u0012J\b\u0010\u0016\u001a\u00020\u0012H\u0002J\b\u0010\u0017\u001a\u00020\u000fH\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000fH\u0002J\b\u0010\u001c\u001a\u00020\u000fH\u0002J\b\u0010\u001d\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/editor/impl/stickyLines/ui/StickyLinesPanel;", "Lcom/intellij/ui/components/JBPanel;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "visualStickyLines", "Lcom/intellij/openapi/editor/impl/stickyLines/VisualStickyLines;", "shadowedBorder", "Lcom/intellij/openapi/editor/impl/stickyLines/ui/StickyLineShadowBorder;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/openapi/editor/impl/stickyLines/VisualStickyLines;Lcom/intellij/openapi/editor/impl/stickyLines/ui/StickyLineShadowBorder;)V", "layeredPane", "Lcom/intellij/ui/components/JBLayeredPane;", "stickyComponents", "Lcom/intellij/openapi/editor/impl/stickyLines/ui/StickyLineComponents;", "panelW", "", "panelH", "repaintLines", "", "startVisualLine", "endVisualLine", "startDumb", "repaintLinesImpl", "shadowedBorderHeight", "isPanelSizeChanged", "", "panelWidth", "panelHeight", "stickyLinesPanelWidth", "isPanelEnabled", "intellij.platform.ide.impl"})
public final class StickyLinesPanel
extends JBPanel<StickyLinesPanel> {
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final VisualStickyLines visualStickyLines;
    @NotNull
    private final JBLayeredPane layeredPane;
    @NotNull
    private final StickyLineComponents stickyComponents;
    private int panelW;
    private int panelH;

    public StickyLinesPanel(@NotNull EditorEx editor2, @NotNull VisualStickyLines visualStickyLines, @NotNull StickyLineShadowBorder shadowedBorder) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)visualStickyLines, (String)"visualStickyLines");
        Intrinsics.checkNotNullParameter((Object)shadowedBorder, (String)"shadowedBorder");
        this.editor = editor2;
        this.visualStickyLines = visualStickyLines;
        this.layeredPane = new JBLayeredPane();
        this.stickyComponents = new StickyLineComponents(this.editor, this.layeredPane);
        this.setOpaque(false);
        this.setBorder(shadowedBorder);
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.layeredPane.setLayout(null);
        this.add((Component)this.layeredPane);
    }

    public final void repaintLines(int startVisualLine, int endVisualLine) {
        if (this.isPanelEnabled()) {
            for (StickyLineComponent lineComp : this.stickyComponents.components()) {
                lineComp.repaintIfInRange(startVisualLine, endVisualLine);
            }
        }
    }

    public final void repaintLines() {
        if (this.isPanelEnabled()) {
            this.repaintLinesImpl();
        }
    }

    public final void startDumb() {
        if (this.isPanelEnabled()) {
            for (StickyLineComponent lineComp : this.stickyComponents.components()) {
                lineComp.startDumb();
            }
        }
    }

    private final void repaintLinesImpl() {
        int panelWidth = this.stickyLinesPanelWidth();
        int lineHeight = this.editor.getLineHeight();
        int index = 0;
        Iterator components = this.stickyComponents.unboundComponents().iterator();
        Rectangle rectangle = this.editor.getScrollingModel().getVisibleArea();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
        List<VisualStickyLine> stickyLines = this.visualStickyLines.lines(rectangle);
        for (VisualStickyLine stickyLine : stickyLines) {
            StickyLineComponent component2 = (StickyLineComponent)components.next();
            component2.setLine(stickyLine.primaryLine(), stickyLine.scopeLine(), stickyLine.navigateOffset(), stickyLine.debugText());
            component2.setBounds(0, stickyLine.getYLocation(), panelWidth, lineHeight);
            component2.setVisible(true);
            ++index;
        }
        this.stickyComponents.resetAfterIndex(index);
        int panelHeight = this.visualStickyLines.height();
        if (this.isPanelSizeChanged(panelWidth, panelHeight)) {
            this.panelW = panelWidth;
            this.panelH = panelHeight;
            this.setSize(panelWidth, this.shadowedBorderHeight());
            this.layeredPane.setSize(panelWidth, panelHeight);
            this.revalidate();
        }
        this.repaint();
    }

    private final int shadowedBorderHeight() {
        int n;
        if (this.panelH == 0) {
            n = 0;
        } else {
            Border border = this.getBorder();
            Intrinsics.checkNotNull((Object)border, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.stickyLines.ui.StickyLineShadowBorder");
            n = this.panelH + ((StickyLineShadowBorder)border).borderHeight();
        }
        return n;
    }

    private final boolean isPanelSizeChanged(int panelWidth, int panelHeight) {
        return this.panelW != panelWidth || this.panelH != panelHeight;
    }

    private final int stickyLinesPanelWidth() {
        EditorEx editorEx = this.editor;
        Intrinsics.checkNotNull((Object)editorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        return ((EditorImpl)editorEx).getStickyLinesPanelWidth();
    }

    private final boolean isPanelEnabled() {
        boolean isEnabled = this.editor.getSettings().areStickyLinesShown();
        if (!isEnabled && this.stickyComponents.clear()) {
            this.panelW = 0;
            this.panelH = 0;
            this.layeredPane.setSize(0, 0);
            this.setSize(0, 0);
            this.revalidate();
            this.repaint();
        }
        return isEnabled;
    }
}

