/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.diagnostic.Dumpable;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.EditorThreading;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.BidiTextDirection;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorModel;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.InlayModelEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FocusModeModel;
import com.intellij.openapi.editor.impl.FoldingModelInternal;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.TextDrawingCallback;
import com.intellij.openapi.editor.impl.view.CharWidthCache;
import com.intellij.openapi.editor.impl.view.CharacterGrid;
import com.intellij.openapi.editor.impl.view.EditorCoordinateMapper;
import com.intellij.openapi.editor.impl.view.EditorPainter;
import com.intellij.openapi.editor.impl.view.EditorSizeManager;
import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.openapi.editor.impl.view.LineLayout;
import com.intellij.openapi.editor.impl.view.LogicalPositionCache;
import com.intellij.openapi.editor.impl.view.TabFragment;
import com.intellij.openapi.editor.impl.view.TextLayoutCache;
import com.intellij.openapi.editor.impl.view.VisualLinesIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class EditorView
implements TextDrawingCallback,
Disposable,
Dumpable,
HierarchyListener,
VisibleAreaListener {
    private static final Logger LOG = Logger.getInstance(EditorView.class);
    private static final Key<LineLayout> FOLD_REGION_TEXT_LAYOUT = Key.create((String)"text.layout");
    private final EditorImpl myEditor;
    private final EditorModel myEditorModel;
    private final DocumentEx myDocument;
    private final EditorPainter myPainter;
    private final EditorCoordinateMapper myMapper;
    private final EditorSizeManager mySizeManager;
    private final TextLayoutCache myTextLayoutCache;
    private final LogicalPositionCache myLogicalPositionCache;
    private final CharWidthCache myCharWidthCache;
    private final TabFragment myTabFragment;
    private FontRenderContext myFontRenderContext;
    private String myPrefixText;
    private LineLayout myPrefixLayout;
    private TextAttributes myPrefixAttributes;
    private int myBidiFlags;
    private float myPlainSpaceWidth;
    private int myLineHeight;
    private int myDescent;
    private int myCharHeight;
    private float myMaxCharWidth;
    private int myCapHeight;
    private int myTabSize;
    private int myTopOverhang;
    private int myBottomOverhang;
    private final Object myLock;
    @Nullable
    private Runnable myPaintCallback;

    public EditorView(@NotNull EditorImpl editor2) {
        if (editor2 == null) {
            EditorView.$$$reportNull$$$0(0);
        }
        this(editor2, editor2.getEditorModel());
    }

    public EditorView(@NotNull EditorImpl editor2, @NotNull EditorModel editorModel) {
        if (editor2 == null) {
            EditorView.$$$reportNull$$$0(1);
        }
        if (editorModel == null) {
            EditorView.$$$reportNull$$$0(2);
        }
        this.myLock = new Object();
        this.myEditor = editor2;
        this.myEditorModel = editorModel;
        this.myDocument = this.myEditorModel.getDocument();
        this.myPainter = new EditorPainter(this);
        this.myMapper = new EditorCoordinateMapper(this);
        this.mySizeManager = new EditorSizeManager(this);
        this.myTextLayoutCache = new TextLayoutCache(this);
        this.myLogicalPositionCache = new LogicalPositionCache(this);
        this.myCharWidthCache = new CharWidthCache(this);
        this.myTabFragment = new TabFragment(this);
        this.myEditor.getContentComponent().addHierarchyListener(this);
        this.getScrollingModel().addVisibleAreaListener((VisibleAreaListener)this);
        Disposer.register((Disposable)this, (Disposable)this.myLogicalPositionCache);
        Disposer.register((Disposable)this, (Disposable)this.myTextLayoutCache);
        Disposer.register((Disposable)this, (Disposable)this.mySizeManager);
    }

    @ApiStatus.Internal
    public void setPaintCallback(@Nullable Runnable paintCallback) {
        this.myPaintCallback = paintCallback;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public int yToVisualLine(int n) {
        void y;
        ThreadingAssertions.assertEventDispatchThread();
        this.assertNotInBulkMode();
        return this.myMapper.yToVisualLine((int)y);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public int visualLineToY(int n) {
        void line;
        ThreadingAssertions.assertEventDispatchThread();
        this.assertNotInBulkMode();
        return this.myMapper.visualLineToY((int)line);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public int[] visualLineToYRange(int n) {
        void line;
        ThreadingAssertions.assertEventDispatchThread();
        this.assertNotInBulkMode();
        return this.myMapper.visualLineToYRange((int)line);
    }

    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset) {
        this.assertEditorAccessible();
        LogicalPosition logicalPosition = this.myMapper.offsetToLogicalPosition(offset);
        if (logicalPosition == null) {
            EditorView.$$$reportNull$$$0(3);
        }
        return logicalPosition;
    }

    public int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        if (pos == null) {
            EditorView.$$$reportNull$$$0(4);
        }
        this.assertEditorAccessible();
        return this.myMapper.logicalPositionToOffset(pos);
    }

    @RequiresEdt
    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition pos, boolean beforeSoftWrap) {
        if (pos == null) {
            EditorView.$$$reportNull$$$0(5);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.assertNotInBulkMode();
        this.getSoftWrapModel().prepareToMapping();
        VisualPosition visualPosition = this.myMapper.logicalToVisualPosition(pos, beforeSoftWrap);
        if (visualPosition == null) {
            EditorView.$$$reportNull$$$0(6);
        }
        return visualPosition;
    }

    @RequiresEdt
    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition pos) {
        if (pos == null) {
            EditorView.$$$reportNull$$$0(7);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.assertNotInBulkMode();
        this.getSoftWrapModel().prepareToMapping();
        LogicalPosition logicalPosition = this.myMapper.visualToLogicalPosition(pos);
        if (logicalPosition == null) {
            EditorView.$$$reportNull$$$0(8);
        }
        return logicalPosition;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    @NotNull
    public VisualPosition offsetToVisualPosition(int n, boolean bl, boolean bl2) {
        void beforeSoftWrap;
        void leanTowardsLargerOffsets;
        void offset;
        ThreadingAssertions.assertEventDispatchThread();
        this.assertNotInBulkMode();
        this.getSoftWrapModel().prepareToMapping();
        VisualPosition visualPosition = this.myMapper.offsetToVisualPosition((int)offset, (boolean)leanTowardsLargerOffsets, (boolean)beforeSoftWrap);
        if (visualPosition == null) {
            EditorView.$$$reportNull$$$0(9);
        }
        return visualPosition;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public int visualPositionToOffset(VisualPosition visualPosition) {
        void visualPosition2;
        ThreadingAssertions.assertEventDispatchThread();
        this.assertNotInBulkMode();
        this.getSoftWrapModel().prepareToMapping();
        return this.myMapper.visualPositionToOffset((VisualPosition)visualPosition2);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public int offsetToVisualLine(int n, boolean bl) {
        void beforeSoftWrap;
        void offset;
        ThreadingAssertions.assertEventDispatchThread();
        this.assertNotInBulkMode();
        this.getSoftWrapModel().prepareToMapping();
        return this.myMapper.offsetToVisualLine((int)offset, (boolean)beforeSoftWrap);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public int visualLineToOffset(int n) {
        void visualLine;
        ThreadingAssertions.assertEventDispatchThread();
        this.assertNotInBulkMode();
        this.getSoftWrapModel().prepareToMapping();
        return this.myMapper.visualLineToOffset((int)visualLine);
    }

    @RequiresEdt
    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point2D p) {
        if (p == null) {
            EditorView.$$$reportNull$$$0(10);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.assertNotInBulkMode();
        this.getSoftWrapModel().prepareToMapping();
        VisualPosition visualPosition = this.myMapper.xyToVisualPosition(p);
        if (visualPosition == null) {
            EditorView.$$$reportNull$$$0(11);
        }
        return visualPosition;
    }

    @RequiresEdt
    @NotNull
    public Point2D visualPositionToXY(@NotNull VisualPosition pos) {
        if (pos == null) {
            EditorView.$$$reportNull$$$0(12);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.assertNotInBulkMode();
        this.getSoftWrapModel().prepareToMapping();
        Point2D point2D = this.myMapper.visualPositionToXY(pos);
        if (point2D == null) {
            EditorView.$$$reportNull$$$0(13);
        }
        return point2D;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    @NotNull
    public Point2D offsetToXY(int n, boolean bl, boolean bl2) {
        void beforeSoftWrap;
        void leanTowardsLargerOffsets;
        void offset;
        ThreadingAssertions.assertEventDispatchThread();
        this.assertNotInBulkMode();
        this.getSoftWrapModel().prepareToMapping();
        Point2D point2D = this.myMapper.offsetToXY((int)offset, (boolean)leanTowardsLargerOffsets, (boolean)beforeSoftWrap);
        if (point2D == null) {
            EditorView.$$$reportNull$$$0(14);
        }
        return point2D;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @RequiresEdt
    public void setPrefix(String string, TextAttributes textAttributes) {
        void attributes;
        void prefixText;
        ThreadingAssertions.assertEventDispatchThread();
        this.myPrefixText = prefixText;
        Object object = this.myLock;
        synchronized (object) {
            this.myPrefixLayout = prefixText == null || prefixText.isEmpty() ? null : LineLayout.create(this, (CharSequence)prefixText, attributes.getFontType());
        }
        this.myPrefixAttributes = attributes;
        this.mySizeManager.invalidateRange(0, 0);
    }

    public float getPrefixTextWidthInPixels() {
        LineLayout layout2 = this.getPrefixLayout();
        return layout2 == null ? 0.0f : layout2.getWidth();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void paint(Graphics2D graphics2D) {
        void g;
        ThreadingAssertions.assertEventDispatchThread();
        this.getSoftWrapModel().prepareToMapping();
        this.checkFontRenderContext(g.getFontRenderContext());
        this.myPainter.paint((Graphics2D)g);
        if (this.myPaintCallback != null) {
            this.myPaintCallback.run();
        }
    }

    @RequiresEdt
    public void repaintCarets() {
        ThreadingAssertions.assertEventDispatchThread();
        this.myPainter.repaintCarets();
    }

    @RequiresEdt
    @NotNull
    public Dimension getPreferredSize() {
        ThreadingAssertions.assertEventDispatchThread();
        assert (!this.myEditor.isPurePaintingMode());
        Dimension dimension = (Dimension)EditorThreading.compute(() -> {
            this.getSoftWrapModel().prepareToMapping();
            return this.mySizeManager.getPreferredSize();
        });
        if (dimension == null) {
            EditorView.$$$reportNull$$$0(15);
        }
        return dimension;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public int getPreferredWidth(int n, int n2) {
        void endLine;
        void beginLine;
        ThreadingAssertions.assertEventDispatchThread();
        assert (!this.myEditor.isPurePaintingMode());
        return (Integer)EditorThreading.compute(() -> this.lambda$getPreferredWidth$1((int)beginLine, (int)endLine));
    }

    @RequiresEdt
    public int getPreferredHeight() {
        ThreadingAssertions.assertEventDispatchThread();
        assert (!this.myEditor.isPurePaintingMode());
        return (Integer)EditorThreading.compute(() -> {
            this.getSoftWrapModel().prepareToMapping();
            return this.mySizeManager.getPreferredHeight();
        });
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public int getMaxWidthInRange(int n, int n2) {
        void endOffset;
        void startOffset;
        ThreadingAssertions.assertEventDispatchThread();
        int startVisualLine = this.offsetToVisualLine((int)startOffset, false);
        int endVisualLine = this.offsetToVisualLine((int)endOffset, true);
        return this.getMaxTextWidthInLineRange(startVisualLine, endVisualLine) + this.getInsets().left;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    public void reinitSettings() {
        ThreadingAssertions.assertEventDispatchThread();
        Object object = this.myLock;
        synchronized (object) {
            this.myPlainSpaceWidth = -1.0f;
            this.myTabSize = -1;
            this.setFontRenderContext(null);
        }
        this.myBidiFlags = switch (EditorSettingsExternalizable.getInstance().getBidiTextDirection()) {
            case BidiTextDirection.LTR -> 0;
            case BidiTextDirection.RTL -> 1;
            default -> -2;
        };
        this.myLogicalPositionCache.reset(false);
        this.myTextLayoutCache.resetToDocumentSize(false);
        this.invalidateFoldRegionLayouts();
        this.myCharWidthCache.clear();
        this.setPrefix(this.myPrefixText, this.myPrefixAttributes);
        this.mySizeManager.reset();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void invalidateRange(int n, int n2, boolean bl) {
        void invalidateSize;
        void endOffset;
        void startOffset;
        ThreadingAssertions.assertEventDispatchThread();
        int textLength = this.myDocument.getTextLength();
        if (startOffset > endOffset || startOffset >= textLength || endOffset < 0) {
            return;
        }
        int startLine = this.myDocument.getLineNumber(Math.max(0, (int)startOffset));
        int endLine = this.myDocument.getLineNumber(Math.min(textLength, (int)endOffset));
        this.myTextLayoutCache.invalidateLines(startLine, endLine);
        if (invalidateSize != false) {
            this.mySizeManager.invalidateRange((int)startOffset, (int)endOffset);
        }
    }

    @RequiresEdt
    public void reset() {
        ThreadingAssertions.assertEventDispatchThread();
        this.myLogicalPositionCache.reset(true);
        this.myTextLayoutCache.resetToDocumentSize(true);
        this.mySizeManager.reset();
    }

    @RequiresEdt
    public boolean isRtlLocation(@NotNull VisualPosition visualPosition) {
        int offset;
        if (visualPosition == null) {
            EditorView.$$$reportNull$$$0(16);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myDocument.getTextLength() == 0) {
            return false;
        }
        LogicalPosition logicalPosition = this.visualToLogicalPosition(visualPosition);
        if (!logicalPosition.equals((Object)this.offsetToLogicalPosition(offset = this.logicalPositionToOffset(logicalPosition)))) {
            return false;
        }
        if (this.getSoftWrapModel().getSoftWrap(offset) != null) {
            VisualPosition beforeWrapPosition = this.offsetToVisualPosition(offset, true, true);
            if (visualPosition.line == beforeWrapPosition.line && (visualPosition.column > beforeWrapPosition.column || visualPosition.column == beforeWrapPosition.column && visualPosition.leansRight)) {
                return false;
            }
            VisualPosition afterWrapPosition = this.offsetToVisualPosition(offset, false, false);
            if (visualPosition.line == afterWrapPosition.line && (visualPosition.column < afterWrapPosition.column || visualPosition.column == afterWrapPosition.column && !visualPosition.leansRight)) {
                return false;
            }
        }
        int line = this.myDocument.getLineNumber(offset);
        LineLayout layout2 = this.myTextLayoutCache.getLineLayout(line);
        return layout2.isRtlLocation(offset - this.myDocument.getLineStartOffset(line), logicalPosition.leansForward);
    }

    @RequiresEdt
    public boolean isAtBidiRunBoundary(@NotNull VisualPosition visualPosition) {
        if (visualPosition == null) {
            EditorView.$$$reportNull$$$0(17);
        }
        ThreadingAssertions.assertEventDispatchThread();
        int offset = this.visualPositionToOffset(visualPosition);
        int otherSideOffset = this.visualPositionToOffset(visualPosition.leanRight(!visualPosition.leansRight));
        return offset != otherSideOffset;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public int findNearestDirectionBoundary(int n, boolean bl) {
        void lookForward;
        int lineStartOffset;
        void offset;
        ThreadingAssertions.assertEventDispatchThread();
        int textLength = this.myDocument.getTextLength();
        if (textLength == 0 || offset < 0 || offset > textLength) {
            return -1;
        }
        int line = this.myDocument.getLineNumber((int)offset);
        LineLayout layout2 = this.myTextLayoutCache.getLineLayout(line);
        int relativeOffset = layout2.findNearestDirectionBoundary((int)(offset - (lineStartOffset = this.myDocument.getLineStartOffset(line))), (boolean)lookForward);
        return relativeOffset < 0 ? -1 : lineStartOffset + relativeOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getPlainSpaceWidth() {
        Object object = this.myLock;
        synchronized (object) {
            this.initMetricsIfNeeded();
            return this.myPlainSpaceWidth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCaretHeight() {
        Object object = this.myLock;
        synchronized (object) {
            this.initMetricsIfNeeded();
            return this.myEditor.getSettings().isFullLineHeightCursor() ? this.myLineHeight : this.myLineHeight + this.myTopOverhang + this.myBottomOverhang;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineHeight() {
        Object object = this.myLock;
        synchronized (object) {
            this.initMetricsIfNeeded();
            return this.myLineHeight;
        }
    }

    private float getVerticalScalingFactor() {
        if (this.myEditor.isOneLineMode()) {
            return 1.0f;
        }
        float lineSpacing = this.myEditor.getColorsScheme().getLineSpacing();
        return lineSpacing > 0.0f ? lineSpacing : 1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDescent() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myDescent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCharHeight() {
        Object object = this.myLock;
        synchronized (object) {
            this.initMetricsIfNeeded();
            return this.myCharHeight;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAscent() {
        Object object = this.myLock;
        synchronized (object) {
            this.initMetricsIfNeeded();
            return this.myLineHeight - this.myDescent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTopOverhang() {
        Object object = this.myLock;
        synchronized (object) {
            this.initMetricsIfNeeded();
            return this.myTopOverhang;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBottomOverhang() {
        Object object = this.myLock;
        synchronized (object) {
            this.initMetricsIfNeeded();
            return this.myBottomOverhang;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTabSize() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myTabSize < 0) {
                this.myTabSize = EditorUtil.getTabSize(this.myEditor);
            }
            return this.myTabSize;
        }
    }

    public int offsetToVisualColumnInFoldRegion(@NotNull FoldRegion region, int offset, boolean leanTowardsLargerOffsets) {
        if (region == null) {
            EditorView.$$$reportNull$$$0(18);
        }
        if (offset < 0 || offset == 0 && !leanTowardsLargerOffsets) {
            return 0;
        }
        String text2 = region.getPlaceholderText();
        if (offset > text2.length()) {
            offset = text2.length();
            leanTowardsLargerOffsets = true;
        }
        int logicalColumn = LogicalPositionCache.calcColumn(text2, 0, 0, offset, this.getTabSize());
        int maxColumn = 0;
        for (LineLayout.VisualFragment fragment : this.getFoldRegionLayout(region).getFragmentsInVisualOrder(0.0f)) {
            int startLC = fragment.getStartLogicalColumn();
            int endLC = fragment.getEndLogicalColumn();
            if (logicalColumn > startLC && logicalColumn < endLC || logicalColumn == startLC && leanTowardsLargerOffsets || logicalColumn == endLC && !leanTowardsLargerOffsets) {
                return fragment.logicalToVisualColumn(logicalColumn);
            }
            maxColumn = fragment.getEndVisualColumn();
        }
        return maxColumn;
    }

    public int visualColumnToOffsetInFoldRegion(@NotNull FoldRegion region, int visualColumn, boolean leansRight) {
        if (region == null) {
            EditorView.$$$reportNull$$$0(19);
        }
        if (visualColumn < 0 || visualColumn == 0 && !leansRight) {
            return 0;
        }
        String text2 = region.getPlaceholderText();
        for (LineLayout.VisualFragment fragment : this.getFoldRegionLayout(region).getFragmentsInVisualOrder(0.0f)) {
            int startVC = fragment.getStartVisualColumn();
            int endVC = fragment.getEndVisualColumn();
            if (!(visualColumn > startVC && visualColumn < endVC || visualColumn == startVC && leansRight) && (visualColumn != endVC || leansRight)) continue;
            int logicalColumn = fragment.visualToLogicalColumn(visualColumn);
            return LogicalPositionCache.calcOffset(text2, logicalColumn, 0, 0, text2.length(), this.getTabSize());
        }
        return text2.length();
    }

    public void invalidateFoldRegionLayout(FoldRegion region) {
        region.putUserData(FOLD_REGION_TEXT_LAYOUT, null);
    }

    public int getVisibleLineCount() {
        return Math.max(1, this.getVisibleLogicalLinesCount() + this.getSoftWrapModel().getSoftWrapsIntroducedLinesNumber());
    }

    @NotNull
    public LogicalPosition xyToLogicalPosition(@NotNull Point p) {
        if (p == null) {
            EditorView.$$$reportNull$$$0(20);
        }
        Point pp = p.x >= 0 && p.y >= 0 ? p : new Point(Math.max(p.x, 0), Math.max(p.y, 0));
        LogicalPosition logicalPosition = this.visualToLogicalPosition(this.xyToVisualPosition(pp));
        if (logicalPosition == null) {
            EditorView.$$$reportNull$$$0(21);
        }
        return logicalPosition;
    }

    @Override
    public void drawChars(@NotNull Graphics g, char @NotNull [] data2, int start2, int end, int x, int y, @NotNull Color color, @NotNull FontInfo fontInfo) {
        if (g == null) {
            EditorView.$$$reportNull$$$0(22);
        }
        if (color == null) {
            EditorView.$$$reportNull$$$0(23);
        }
        if (fontInfo == null) {
            EditorView.$$$reportNull$$$0(24);
        }
        if (data2 == null) {
            EditorView.$$$reportNull$$$0(25);
        }
        this.myPainter.drawChars(g, data2, start2, end, x, y, color, fontInfo);
    }

    public void dispose() {
        this.getScrollingModel().removeVisibleAreaListener((VisibleAreaListener)this);
        this.myEditor.getContentComponent().removeHierarchyListener(this);
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        if ((e.getChangeFlags() & 4L) != 0L && e.getComponent().isShowing()) {
            this.checkFontRenderContext(null);
        }
    }

    public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
        if (e == null) {
            EditorView.$$$reportNull$$$0(26);
        }
        this.checkFontRenderContext(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public String dumpState() {
        String prefixText = this.myPrefixText;
        TextAttributes prefixAttributes = this.myPrefixAttributes;
        Object object = this.myLock;
        // MONITORENTER : object
        String string = "[prefix text: " + prefixText + ", prefix attributes: " + String.valueOf(prefixAttributes) + ", space width: " + this.myPlainSpaceWidth + ", line height: " + this.myLineHeight + ", descent: " + this.myDescent + ", char height: " + this.myCharHeight + ", max char width: " + this.myMaxCharWidth + ", tab size: " + this.myTabSize + " ,size manager: " + this.mySizeManager.dumpState() + " ,logical position cache: " + this.myLogicalPositionCache.dumpState() + "]";
        // MONITOREXIT : object
        if (string != null) return string;
        EditorView.$$$reportNull$$$0(27);
        return string;
    }

    @TestOnly
    public void validateState() {
        this.myLogicalPositionCache.validateState();
        this.mySizeManager.validateState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    float getMaxCharWidth() {
        Object object = this.myLock;
        synchronized (object) {
            this.initMetricsIfNeeded();
            return this.myMaxCharWidth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getCapHeight() {
        Object object = this.myLock;
        synchronized (object) {
            this.initMetricsIfNeeded();
            return this.myCapHeight;
        }
    }

    int getMaxTextWidthInLineRange(int startVisualLine, int endVisualLine) {
        this.getSoftWrapModel().prepareToMapping();
        int maxWidth = 0;
        VisualLinesIterator iterator = new VisualLinesIterator(this, startVisualLine);
        while (!iterator.atEnd() && iterator.getVisualLine() <= endVisualLine) {
            int width = this.mySizeManager.getVisualLineWidth(iterator, false);
            maxWidth = Math.max(maxWidth, width);
            iterator.advance();
        }
        return maxWidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LineLayout getPrefixLayout() {
        Object object = this.myLock;
        synchronized (object) {
            FoldRegion firstRegion;
            FoldRegion[] topLevelRegions = this.getFoldingModel().fetchTopLevel();
            if (topLevelRegions != null && topLevelRegions.length > 0 && (firstRegion = topLevelRegions[0]) instanceof CustomFoldRegion && firstRegion.getStartOffset() == 0) {
                return null;
            }
            return this.myPrefixLayout;
        }
    }

    TextAttributes getPrefixAttributes() {
        return this.myPrefixAttributes;
    }

    boolean isAd() {
        return this.myEditorModel.isAd();
    }

    EditorImpl getEditor() {
        return this.myEditor;
    }

    DocumentEx getDocument() {
        return this.myDocument;
    }

    FoldingModelInternal getFoldingModel() {
        return this.myEditorModel.getFoldingModel();
    }

    InlayModelEx getInlayModel() {
        return this.myEditorModel.getInlayModel();
    }

    SoftWrapModelImpl getSoftWrapModel() {
        return (SoftWrapModelImpl)this.myEditorModel.getSoftWrapModel();
    }

    MarkupModelEx getFilteredDocumentMarkupModel() {
        return this.myEditorModel.getDocumentMarkupModel();
    }

    MarkupModelEx getMarkupModel() {
        return this.myEditorModel.getEditorMarkupModel();
    }

    CaretModelImpl getCaretModel() {
        return (CaretModelImpl)this.myEditorModel.getCaretModel();
    }

    SelectionModel getSelectionModel() {
        return this.myEditorModel.getSelectionModel();
    }

    EditorHighlighter getHighlighter() {
        return this.myEditorModel.getHighlighter();
    }

    FocusModeModel getFocusModel() {
        return this.myEditorModel.getFocusModel();
    }

    ScrollingModel getScrollingModel() {
        return this.myEditorModel.getScrollingModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FontRenderContext getFontRenderContext() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myFontRenderContext;
        }
    }

    EditorSizeManager getSizeManager() {
        return this.mySizeManager;
    }

    TextLayoutCache getTextLayoutCache() {
        return this.myTextLayoutCache;
    }

    TabFragment getTabFragment() {
        return this.myTabFragment;
    }

    @VisibleForTesting
    public LogicalPositionCache getLogicalPositionCache() {
        return this.myLogicalPositionCache;
    }

    float getRightAlignmentLineStartX(int visualLine) {
        return this.myMapper.getRightAlignmentLineStartX(visualLine);
    }

    int getRightAlignmentMarginX() {
        return this.myMapper.getRightAlignmentMarginX();
    }

    LineLayout getFoldRegionLayout(FoldRegion foldRegion) {
        LineLayout layout2 = (LineLayout)foldRegion.getUserData(FOLD_REGION_TEXT_LAYOUT);
        if (layout2 == null) {
            TextAttributes placeholderAttributes = this.getFoldingModel().getPlaceholderAttributes();
            layout2 = LineLayout.create(this, StringUtil.replace((String)foldRegion.getPlaceholderText(), (String)"\n", (String)" "), placeholderAttributes == null ? 0 : placeholderAttributes.getFontType());
            foldRegion.putUserData(FOLD_REGION_TEXT_LAYOUT, (Object)layout2);
        }
        return layout2;
    }

    float getCodePointWidth(int codePoint, @JdkConstants.FontStyle int fontStyle) {
        CharacterGrid grid = this.myEditor.getCharacterGrid();
        if (grid != null) {
            return grid.codePointWidth(codePoint);
        }
        return this.myCharWidthCache.getCodePointWidth(codePoint, fontStyle);
    }

    Insets getInsets() {
        return this.myEditor.getContentComponent().getInsets();
    }

    int getBidiFlags() {
        return this.myBidiFlags;
    }

    private void invalidateFoldRegionLayouts() {
        EditorThreading.run(() -> {
            for (FoldRegion region : this.getFoldingModel().getAllFoldRegions()) {
                this.invalidateFoldRegionLayout(region);
            }
        });
    }

    private int getVisibleLogicalLinesCount() {
        return this.getDocument().getLineCount() - this.getFoldingModel().getTotalNumberOfFoldedLines();
    }

    private void initMetricsIfNeeded() {
        int lineHeight;
        if (this.myPlainSpaceWidth >= 0.0f) {
            return;
        }
        Font font = this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN);
        FontMetrics fm = FontInfo.getFontMetrics(font, this.myFontRenderContext);
        float width = FontLayoutService.getInstance().charWidth2D(fm, 32);
        this.myPlainSpaceWidth = width > 0.0f ? width : 1.0f;
        this.myCharHeight = FontLayoutService.getInstance().charWidth(fm, 'a');
        float verticalScalingFactor = this.getVerticalScalingFactor();
        int fontMetricsHeight = FontLayoutService.getInstance().getHeight(fm);
        if (Registry.is((String)"editor.text.xcode.vertical.spacing")) {
            double delta;
            LineMetrics metrics = font.getLineMetrics("", this.myFontRenderContext);
            double height = Math.ceil(metrics.getHeight()) + (double)metrics.getLeading();
            int spacing = Math.round(height * (delta = (double)(verticalScalingFactor - 1.0f)) / 2.0) <= 1L ? (delta > 0.0 ? 2 : 0) : (int)Math.ceil(height * delta / 2.0) * 2;
            lineHeight = (int)Math.ceil(height) + spacing;
        } else if (Registry.is((String)"editor.text.vertical.spacing.correct.rounding")) {
            if (verticalScalingFactor == 1.0f) {
                lineHeight = fontMetricsHeight;
            } else {
                Font scaledFont = font.deriveFont((float)font.getSize() * verticalScalingFactor);
                FontMetrics scaledMetrics = FontInfo.getFontMetrics(scaledFont, this.myFontRenderContext);
                lineHeight = FontLayoutService.getInstance().getHeight(scaledMetrics);
            }
        } else {
            lineHeight = (int)Math.ceil((float)fontMetricsHeight * verticalScalingFactor);
        }
        this.myLineHeight = Math.max(1, lineHeight);
        int descent = FontLayoutService.getInstance().getDescent(fm);
        this.myDescent = descent + (this.myLineHeight - fontMetricsHeight) / 2;
        this.myTopOverhang = fontMetricsHeight - this.myLineHeight + this.myDescent - descent;
        this.myBottomOverhang = descent - this.myDescent;
        FontMetrics fmBI = FontInfo.getFontMetrics(this.myEditor.getColorsScheme().getFont(EditorFontType.BOLD_ITALIC), this.myFontRenderContext);
        this.myMaxCharWidth = FontLayoutService.getInstance().charWidth2D(fmBI, 87);
        this.myCapHeight = (int)font.createGlyphVector(this.myFontRenderContext, "H").getVisualBounds().getHeight();
    }

    private boolean setFontRenderContext(FontRenderContext context) {
        FontRenderContext contextToSet;
        FontRenderContext fontRenderContext = contextToSet = context == null ? FontInfo.getFontRenderContext(this.myEditor.getContentComponent()) : context;
        if (EditorView.areEqualContexts(this.myFontRenderContext, contextToSet)) {
            return false;
        }
        AffineTransform transform = contextToSet.getTransform();
        if (transform.getDeterminant() == 0.0) {
            LOG.error("Incorrect transform in FontRenderContext" + (context == null ? " obtained from component" : "") + ": " + String.valueOf(transform));
            contextToSet = new FontRenderContext(new AffineTransform(), contextToSet.getAntiAliasingHint(), contextToSet.getFractionalMetricsHint());
        }
        Object fmHint = UISettings.getEditorFractionalMetricsHint();
        this.myFontRenderContext = contextToSet.getFractionalMetricsHint() == fmHint ? contextToSet : new FontRenderContext(contextToSet.getTransform(), contextToSet.getAntiAliasingHint(), fmHint);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFontRenderContext(FontRenderContext context) {
        boolean contextUpdated = false;
        Object object = this.myLock;
        synchronized (object) {
            if (this.setFontRenderContext(context)) {
                this.myPlainSpaceWidth = -1.0f;
                contextUpdated = true;
            }
        }
        if (contextUpdated) {
            this.myTextLayoutCache.resetToDocumentSize(false);
            this.invalidateFoldRegionLayouts();
            this.myCharWidthCache.clear();
            this.getFoldingModel().updateCachedOffsets();
        }
    }

    private void assertEditorAccessible() {
        if (!this.myEditorModel.isAd()) {
            EditorThreading.assertInteractionAllowed();
        }
    }

    private void assertNotInBulkMode() {
        if (this.myDocument instanceof DocumentImpl) {
            ((DocumentImpl)this.myDocument).assertNotInBulkUpdate();
        } else if (this.myDocument.isInBulkUpdate()) {
            throw new IllegalStateException("Current operation is not permitted in bulk mode");
        }
        if (this.getInlayModel().isInBatchMode()) {
            throw new IllegalStateException("Current operation is not permitted during batch inlay update");
        }
    }

    private static boolean areEqualContexts(FontRenderContext c1, FontRenderContext c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.getTransform().equals(c2.getTransform()) && c1.getAntiAliasingHint().equals(c2.getAntiAliasingHint());
    }

    private /* synthetic */ Integer lambda$getPreferredWidth$1(int beginLine, int endLine) throws RuntimeException {
        this.getSoftWrapModel().prepareToMapping();
        return this.mySizeManager.getPreferredWidth(beginLine, endLine);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 8, 9, 11, 13, 14, 15, 21, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorModel";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/view/EditorView";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 10: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visualPosition";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontInfo";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/view/EditorView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "offsetToLogicalPosition";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "logicalToVisualPosition";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "visualToLogicalPosition";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "offsetToVisualPosition";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "xyToVisualPosition";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "visualPositionToXY";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "offsetToXY";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredSize";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "xyToLogicalPosition";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 27: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "logicalPositionToOffset";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "logicalToVisualPosition";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visualToLogicalPosition";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "xyToVisualPosition";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visualPositionToXY";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isRtlLocation";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isAtBidiRunBoundary";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "offsetToVisualColumnInFoldRegion";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "visualColumnToOffsetInFoldRegion";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "xyToLogicalPosition";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "drawChars";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "visibleAreaChanged";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 8, 9, 11, 13, 14, 15, 21, 27 -> new IllegalStateException(string);
        };
    }
}

