/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.toolbar.floating;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.toolbar.floating.TransparentComponent;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.animation.ShowHideAnimator;
import com.intellij.util.ui.TimerUtil;
import java.awt.event.ActionEvent;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020'H\u0002J\u0006\u0010)\u001a\u00020'J\u0006\u0010*\u001a\u00020'J\u0006\u0010+\u001a\u00020'R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00108F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017*\u0004\b\u0012\u0010\u0013R+\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00108F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b\u001a\u0010\u0015\"\u0004\b\u001b\u0010\u0017*\u0004\b\u0019\u0010\u0013R+\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00108F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b\u001e\u0010\u0015\"\u0004\b\u001f\u0010\u0017*\u0004\b\u001d\u0010\u0013R\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u0006-"}, d2={"Lcom/intellij/openapi/editor/toolbar/floating/TransparentComponentAnimator;", "", "component", "Lcom/intellij/openapi/editor/toolbar/floating/TransparentComponent;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/editor/toolbar/floating/TransparentComponent;Lcom/intellij/openapi/Disposable;)V", "disposable", "Lcom/intellij/openapi/util/CheckedDisposable;", "Lorg/jetbrains/annotations/NotNull;", "clk", "Ljavax/swing/Timer;", "animator", "Lcom/intellij/util/animation/ShowHideAnimator;", "<set-?>", "", "showingTime", "getShowingTime$delegate", "(Lcom/intellij/openapi/editor/toolbar/floating/TransparentComponentAnimator;)Ljava/lang/Object;", "getShowingTime", "()I", "setShowingTime", "(I)V", "hidingTime", "getHidingTime$delegate", "getHidingTime", "setHidingTime", "retentionTime", "getRetentionTime$delegate", "getRetentionTime", "setRetentionTime", "autoHideable", "", "getAutoHideable", "()Z", "setAutoHideable", "(Z)V", "startTimerIfNeeded", "", "stopTimerIfNeeded", "scheduleShow", "scheduleHide", "hideImmediately", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class TransparentComponentAnimator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TransparentComponent component;
    @NotNull
    private final CheckedDisposable disposable;
    @NotNull
    private final Timer clk;
    @NotNull
    private final ShowHideAnimator animator;
    private boolean autoHideable;
    public static final int SHOWING_TIME_MS = 500;
    public static final int HIDING_TIME_MS = 1000;
    public static final int RETENTION_TIME_MS = 1500;

    public TransparentComponentAnimator(@NotNull TransparentComponent component2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.component = component2;
        CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable((Disposable)parentDisposable);
        Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"newCheckedDisposable(...)");
        this.disposable = checkedDisposable;
        Timer timer = TimerUtil.createNamedTimer((String)"CLK", (int)1500);
        Intrinsics.checkNotNullExpressionValue((Object)timer, (String)"createNamedTimer(...)");
        this.clk = timer;
        this.animator = new ShowHideAnimator(arg_0 -> TransparentComponentAnimator.animator$lambda$0(this, arg_0));
        Disposer.register((Disposable)parentDisposable, (Disposable)this.animator.getDisposable());
        this.animator.setHidingDelay(0);
        this.animator.setShowingDelay(0);
        this.animator.setHidingDuration(1000);
        this.animator.setShowingDuration(500);
        this.clk.setRepeats(false);
        DisposerUtilKt.whenDisposed((Disposable)((Disposable)this.disposable), () -> TransparentComponentAnimator._init_$lambda$0(this));
        this.clk.addActionListener(arg_0 -> TransparentComponentAnimator._init_$lambda$1(this, arg_0));
        this.component.hideComponent();
    }

    public final int getShowingTime() {
        return this.animator.getShowingDuration();
    }

    public final void setShowingTime(int n) {
        this.animator.setShowingDuration(n);
    }

    private static Object getShowingTime$delegate(TransparentComponentAnimator transparentComponentAnimator) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)transparentComponentAnimator.animator, ShowHideAnimator.class, "showingDuration", "getShowingDuration()I", 0)));
    }

    public final int getHidingTime() {
        return this.animator.getHidingDuration();
    }

    public final void setHidingTime(int n) {
        this.animator.setHidingDuration(n);
    }

    private static Object getHidingTime$delegate(TransparentComponentAnimator transparentComponentAnimator) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)transparentComponentAnimator.animator, ShowHideAnimator.class, "hidingDuration", "getHidingDuration()I", 0)));
    }

    public final int getRetentionTime() {
        return this.clk.getInitialDelay();
    }

    public final void setRetentionTime(int n) {
        this.clk.setInitialDelay(n);
    }

    private static Object getRetentionTime$delegate(TransparentComponentAnimator transparentComponentAnimator) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)transparentComponentAnimator.clk, Timer.class, "initialDelay", "getInitialDelay()I", 2)));
    }

    public final boolean getAutoHideable() {
        return this.autoHideable;
    }

    public final void setAutoHideable(boolean bl) {
        this.autoHideable = bl;
    }

    private final void startTimerIfNeeded() {
        if (!this.disposable.isDisposed() && !this.clk.isRunning()) {
            this.clk.start();
        }
    }

    private final void stopTimerIfNeeded() {
        if (this.clk.isRunning()) {
            this.clk.stop();
        }
    }

    public final void scheduleShow() {
        this.stopTimerIfNeeded();
        KFunction onCompletion2 = this.autoHideable ? (KFunction)new Function0<Unit>((Object)this){

            public final void invoke() {
                TransparentComponentAnimator.access$startTimerIfNeeded((TransparentComponentAnimator)this.receiver);
            }
        } : null;
        this.animator.setVisible(true, (Function0<Unit>)((Function0)onCompletion2), (Function0<Unit>)((Function0)() -> TransparentComponentAnimator.scheduleShow$lambda$0(this)));
    }

    public final void scheduleHide() {
        this.stopTimerIfNeeded();
        ShowHideAnimator.setVisible$default(this.animator, false, null, () -> TransparentComponentAnimator.scheduleHide$lambda$0(this), 2, null);
    }

    public final void hideImmediately() {
        this.stopTimerIfNeeded();
        this.component.hideComponent();
        this.animator.setVisibleImmediately(false);
    }

    private static final void animator$lambda$0(TransparentComponentAnimator this$0, double progress) {
        this$0.component.setOpacity((float)progress);
        this$0.component.repaintComponent();
    }

    private static final Unit scheduleShow$lambda$0(TransparentComponentAnimator this$0) {
        this$0.component.showComponent();
        return Unit.INSTANCE;
    }

    private static final Unit scheduleHide$lambda$0(TransparentComponentAnimator this$0) {
        this$0.component.hideComponent();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$0(TransparentComponentAnimator this$0) {
        this$0.stopTimerIfNeeded();
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(TransparentComponentAnimator this$0, ActionEvent it) {
        if (!this$0.component.isComponentOnHold()) {
            this$0.scheduleHide();
        }
    }

    public static final /* synthetic */ void access$startTimerIfNeeded(TransparentComponentAnimator $this) {
        $this.startTimerIfNeeded();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/editor/toolbar/floating/TransparentComponentAnimator$Companion;", "", "<init>", "()V", "SHOWING_TIME_MS", "", "HIDING_TIME_MS", "RETENTION_TIME_MS", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

