/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.fileEditor.ConditionalActionGroup;
import com.intellij.openapi.fileEditor.DoublingEventListenerDelegate;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.LayoutActionsFloatingToolbar;
import com.intellij.openapi.fileEditor.MyEditorLayeredComponentWrapper;
import com.intellij.openapi.fileEditor.MyListenersMultimap;
import com.intellij.openapi.fileEditor.SplitEditorToolbar;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorWithPreviewKt;
import com.intellij.openapi.observable.util.RevertOnDisposeUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 p2\u00020\u00012\u00020\u0002:\u0005opqrsBH\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\r\b\u0002\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\n\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\n\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020$H\u0016J\b\u0010&\u001a\u00020$H\u0016J\b\u0010'\u001a\u00020(H\u0014J\b\u0010)\u001a\u00020*H\u0016J \u0010.\u001a\u00020$2\u0006\u0010/\u001a\u00020*2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u00104\u001a\u00020$2\u0006\u00105\u001a\u00020\fH\u0016J\u0010\u00106\u001a\u0002072\u0006\u00108\u001a\u00020*H\u0002J\u0010\u00109\u001a\u00020$2\u0006\u0010:\u001a\u00020;H\u0016J\u001c\u0010<\u001a\u00020$2\b\u0010=\u001a\u0004\u0018\u00010\n2\b\u0010>\u001a\u0004\u0018\u00010\nH\u0014J\u0010\u0010?\u001a\u00020$2\u0006\u0010\r\u001a\u00020\nH\u0002J\b\u0010@\u001a\u0004\u0018\u00010\nJ\u0010\u0010A\u001a\u00020$2\u0006\u0010\r\u001a\u00020\nH\u0016J\n\u0010E\u001a\u0004\u0018\u00010*H\u0016J\b\u0010F\u001a\u00020\u0007H\u0016J\u0010\u0010G\u001a\u00020;2\u0006\u0010H\u001a\u00020IH\u0016J\u0010\u0010J\u001a\u00020$2\u0006\u0010K\u001a\u00020LH\u0016J\u0010\u0010M\u001a\u00020$2\u0006\u0010K\u001a\u00020LH\u0016J\b\u0010N\u001a\u00020\fH\u0016J\b\u0010O\u001a\u00020\fH\u0016J\n\u0010P\u001a\u0004\u0018\u00010QH\u0014J\n\u0010R\u001a\u0004\u0018\u00010SH\u0014J\b\u0010T\u001a\u00020QH\u0014J\b\u0010U\u001a\u00020SH\u0014J\n\u0010V\u001a\u0004\u0018\u00010SH\u0014J\b\u0010W\u001a\u00020SH\u0016J\u0013\u0010X\u001a\b\u0012\u0004\u0012\u00020Z0YH\u0014\u00a2\u0006\u0002\u0010[J\n\u0010f\u001a\u0004\u0018\u00010gH\u0016J\b\u0010h\u001a\u00020iH\u0016J\u0010\u0010j\u001a\u00020\f2\u0006\u0010k\u001a\u00020lH\u0016J\u0010\u0010m\u001a\u00020$2\u0006\u0010k\u001a\u00020lH\u0016J\u0010\u0010n\u001a\u00020$2\u0006\u0010\u000b\u001a\u00020\fH\u0004R\u0010\u0010\u0003\u001a\u00020\u00028\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0012\u0010\u0013R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010+\u001a\u00020\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010,R\u0014\u0010B\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR\u0014\u0010\\\u001a\u00020]8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b^\u0010_R\u0014\u0010`\u001a\u00020]8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\ba\u0010_R\u0014\u0010b\u001a\u00020]8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\bc\u0010_R\u0014\u0010d\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\be\u0010D\u00a8\u0006t"}, d2={"Lcom/intellij/openapi/fileEditor/TextEditorWithPreview;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "Lcom/intellij/openapi/fileEditor/TextEditor;", "myEditor", "myPreview", "Lcom/intellij/openapi/fileEditor/FileEditor;", "name", "", "Lorg/jetbrains/annotations/Nls;", "defaultLayout", "Lcom/intellij/openapi/fileEditor/TextEditorWithPreview$Layout;", "isVerticalSplit", "", "layout", "<init>", "(Lcom/intellij/openapi/fileEditor/TextEditor;Lcom/intellij/openapi/fileEditor/FileEditor;Ljava/lang/String;Lcom/intellij/openapi/fileEditor/TextEditorWithPreview$Layout;ZLcom/intellij/openapi/fileEditor/TextEditorWithPreview$Layout;)V", "listenerGenerator", "Lcom/intellij/openapi/fileEditor/MyListenersMultimap;", "getListenerGenerator$annotations", "()V", "ui", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "Lcom/intellij/openapi/fileEditor/TextEditorWithPreview$TextEditorWithPreviewUi;", "textEditor", "getTextEditor", "()Lcom/intellij/openapi/fileEditor/TextEditor;", "previewEditor", "getPreviewEditor", "()Lcom/intellij/openapi/fileEditor/FileEditor;", "getBackgroundHighlighter", "Lcom/intellij/codeHighlighting/BackgroundEditorHighlighter;", "getCurrentLocation", "Lcom/intellij/openapi/fileEditor/FileEditorLocation;", "getStructureViewBuilder", "Lcom/intellij/ide/structureView/StructureViewBuilder;", "dispose", "", "selectNotify", "deselectNotify", "createSplitter", "Lcom/intellij/ui/JBSplitter;", "getComponent", "Ljavax/swing/JComponent;", "isShowFloatingToolbar", "()Z", "isShowActionsInTabs", "registerToolbarListeners", "actualComponent", "toolbar", "Lcom/intellij/openapi/fileEditor/LayoutActionsFloatingToolbar;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "setVerticalSplit", "verticalSplit", "createSplitEditorToolbar", "Lcom/intellij/openapi/fileEditor/SplitEditorToolbar;", "targetComponentForActions", "setState", "state", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "onLayoutChange", "oldValue", "newValue", "adjustEditorsVisibility", "getLayout", "setLayout", "splitterProportionKey", "getSplitterProportionKey", "()Ljava/lang/String;", "getPreferredFocusedComponent", "getName", "getState", "level", "Lcom/intellij/openapi/fileEditor/FileEditorStateLevel;", "addPropertyChangeListener", "listener", "Ljava/beans/PropertyChangeListener;", "removePropertyChangeListener", "isModified", "isValid", "createToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "createLeftToolbarActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "createRightToolbar", "createViewActionGroup", "createRightToolbarActionGroup", "getTabActions", "createTabActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "()[Lcom/intellij/openapi/actionSystem/AnAction;", "showEditorAction", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "getShowEditorAction", "()Lcom/intellij/openapi/actionSystem/ToggleAction;", "showEditorAndPreviewAction", "getShowEditorAndPreviewAction", "showPreviewAction", "getShowPreviewAction", "layoutPropertyName", "getLayoutPropertyName", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getEditor", "Lcom/intellij/openapi/editor/Editor;", "canNavigateTo", "navigatable", "Lcom/intellij/pom/Navigatable;", "navigateTo", "handleLayoutChange", "TextEditorWithPreviewUi", "Companion", "MyFileEditorState", "Layout", "MyMouseListener", "intellij.platform.ide.impl"})
public class TextEditorWithPreview
extends UserDataHolderBase
implements TextEditor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    protected final TextEditor myEditor;
    @JvmField
    @NotNull
    protected final FileEditor myPreview;
    @NotNull
    private final String name;
    private boolean isVerticalSplit;
    @Nullable
    private Layout layout;
    @NotNull
    private final MyListenersMultimap listenerGenerator;
    @NotNull
    private final Layout defaultLayout;
    @NotNull
    private final SynchronizedClearableLazy<TextEditorWithPreviewUi> ui;
    @JvmField
    @NotNull
    public static final Key<Layout> DEFAULT_LAYOUT_FOR_FILE;

    @JvmOverloads
    public TextEditorWithPreview(@NotNull TextEditor myEditor, @NotNull FileEditor myPreview, @NotNull String name2, @NotNull Layout defaultLayout, boolean isVerticalSplit, @Nullable Layout layout2) {
        Intrinsics.checkNotNullParameter((Object)myEditor, (String)"myEditor");
        Intrinsics.checkNotNullParameter((Object)myPreview, (String)"myPreview");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)defaultLayout), (String)"defaultLayout");
        this.myEditor = myEditor;
        this.myPreview = myPreview;
        this.name = name2;
        this.isVerticalSplit = isVerticalSplit;
        this.layout = layout2;
        this.listenerGenerator = new MyListenersMultimap(this);
        Object object = this.myEditor.getFile();
        if (object == null || (object = (Layout)((Object)object.getUserData(DEFAULT_LAYOUT_FOR_FILE))) == null) {
            object = defaultLayout;
        }
        this.defaultLayout = object;
        this.ui = new SynchronizedClearableLazy(() -> TextEditorWithPreview.ui$lambda$0(this));
        this.myEditor.putUserData(TextEditorWithPreviewKt.access$getPARENT_SPLIT_EDITOR_KEY$p(), (Object)this);
        this.myPreview.putUserData(TextEditorWithPreviewKt.access$getPARENT_SPLIT_EDITOR_KEY$p(), (Object)this);
        EventQueue.invokeLater(() -> TextEditorWithPreview._init_$lambda$0(this));
    }

    public /* synthetic */ TextEditorWithPreview(TextEditor textEditor, FileEditor fileEditor, String string, Layout layout2, boolean bl, Layout layout3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = "TextEditorWithPreview";
        }
        if ((n & 8) != 0) {
            layout2 = Layout.SHOW_EDITOR_AND_PREVIEW;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            layout3 = null;
        }
        this(textEditor, fileEditor, string, layout2, bl, layout3);
    }

    private static /* synthetic */ void getListenerGenerator$annotations() {
    }

    @NotNull
    public TextEditor getTextEditor() {
        return this.myEditor;
    }

    @NotNull
    public FileEditor getPreviewEditor() {
        return this.myPreview;
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return this.myEditor.getBackgroundHighlighter();
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return this.myEditor.getCurrentLocation();
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return this.myEditor.getStructureViewBuilder();
    }

    public void dispose() {
        Disposer.dispose((Disposable)((Disposable)this.myEditor));
        Disposer.dispose((Disposable)((Disposable)this.myPreview));
    }

    public void selectNotify() {
        this.myEditor.selectNotify();
        this.myPreview.selectNotify();
    }

    public void deselectNotify() {
        this.myEditor.deselectNotify();
        this.myPreview.deselectNotify();
    }

    @NotNull
    protected JBSplitter createSplitter() {
        return (JBSplitter)new OnePixelSplitter();
    }

    @NotNull
    public JComponent getComponent() {
        return ((TextEditorWithPreviewUi)this.ui.getValue()).component;
    }

    protected boolean isShowFloatingToolbar() {
        return Registry.Companion.is("ide.text.editor.with.preview.show.floating.toolbar");
    }

    protected boolean isShowActionsInTabs() {
        return ExperimentalUI.Companion.isNewUI() && UISettings.Companion.getInstance().getEditorTabPlacement() != 0;
    }

    private final void registerToolbarListeners(JComponent actualComponent, LayoutActionsFloatingToolbar toolbar2, Disposable parentDisposable) {
        StartupUiUtil.addAwtListener((long)32L, (Disposable)parentDisposable, (AWTEventListener)new MyMouseListener(toolbar2, parentDisposable));
        EditorComponentImpl editorComponentImpl = (EditorComponentImpl)UIUtil.findComponentOfType((JComponent)actualComponent, EditorComponentImpl.class);
        if (editorComponentImpl == null) {
            return;
        }
        EditorComponentImpl actualEditor = editorComponentImpl;
        KeyAdapter editorKeyListener2 = new KeyAdapter(toolbar2){
            final /* synthetic */ LayoutActionsFloatingToolbar $toolbar;
            {
                this.$toolbar = $toolbar;
            }

            public void keyPressed(KeyEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$toolbar.scheduleHide();
            }
        };
        EditorComponentImpl editorComponentImpl2 = actualEditor.getEditor().getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)editorComponentImpl2, (String)"getContentComponent(...)");
        RevertOnDisposeUtilKt.addKeyListener((Component)editorComponentImpl2, (Disposable)parentDisposable, (KeyListener)editorKeyListener2);
    }

    public boolean isVerticalSplit() {
        return this.isVerticalSplit;
    }

    public void setVerticalSplit(boolean verticalSplit) {
        this.isVerticalSplit = verticalSplit;
        ((TextEditorWithPreviewUi)this.ui.getValue()).splitter.setOrientation(verticalSplit);
    }

    private final SplitEditorToolbar createSplitEditorToolbar(JComponent targetComponentForActions) {
        ActionToolbar leftToolbar = this.createToolbar();
        if (leftToolbar != null) {
            leftToolbar.setTargetComponent(targetComponentForActions);
            leftToolbar.setReservePlaceAutoPopupIcon(false);
        }
        ActionToolbar rightToolbar = this.createRightToolbar();
        rightToolbar.setTargetComponent(targetComponentForActions);
        rightToolbar.setReservePlaceAutoPopupIcon(false);
        return new SplitEditorToolbar(leftToolbar, rightToolbar);
    }

    public void setState(@NotNull FileEditorState state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        if (state2 instanceof MyFileEditorState) {
            if (((MyFileEditorState)state2).getFirstState() != null) {
                this.myEditor.setState(((MyFileEditorState)state2).getFirstState());
            }
            if (((MyFileEditorState)state2).getSecondState() != null) {
                this.myPreview.setState(((MyFileEditorState)state2).getSecondState());
            }
            Layout layout2 = ((MyFileEditorState)state2).getSplitLayout();
            if (layout2 != null) {
                Layout splitLayout = layout2;
                boolean bl = false;
                this.layout = ((MyFileEditorState)state2).getSplitLayout();
                this.adjustEditorsVisibility(splitLayout);
                TextEditorWithPreviewUi ui = (TextEditorWithPreviewUi)this.ui.getValueIfInitialized();
                Object object = ui;
                if (object != null && (object = ((TextEditorWithPreviewUi)object).toolbarWrapper) != null) {
                    ((SplitEditorToolbar)object).refresh();
                }
                if (ui != null && EDT.isCurrentThreadEdt()) {
                    ui.component.repaint();
                    JComponent focusComponent2 = this.getPreferredFocusedComponent();
                    Component focusOwner = IdeFocusManager.findInstance().getFocusOwner();
                    if (focusComponent2 != null && focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, this.getComponent())) {
                        IdeFocusManager.findInstanceByComponent((Component)focusComponent2).requestFocus((Component)focusComponent2, true);
                    }
                }
            }
            this.setVerticalSplit(((MyFileEditorState)state2).isVerticalSplit());
        }
    }

    protected void onLayoutChange(@Nullable Layout oldValue, @Nullable Layout newValue) {
    }

    private final void adjustEditorsVisibility(Layout layout2) {
        this.myEditor.getComponent().setVisible(layout2 == Layout.SHOW_EDITOR || layout2 == Layout.SHOW_EDITOR_AND_PREVIEW);
        this.myPreview.getComponent().setVisible(layout2 == Layout.SHOW_PREVIEW || layout2 == Layout.SHOW_EDITOR_AND_PREVIEW);
    }

    @Nullable
    public final Layout getLayout() {
        return this.layout;
    }

    public void setLayout(@NotNull Layout layout2) {
        Intrinsics.checkNotNullParameter((Object)((Object)layout2), (String)"layout");
        Layout oldLayout = this.layout;
        this.layout = layout2;
        PropertiesComponent.getInstance().setValue(this.getLayoutPropertyName(), layout2.getId(), this.defaultLayout.getId());
        this.adjustEditorsVisibility(layout2);
        this.onLayoutChange(oldLayout, layout2);
    }

    @NotNull
    protected String getSplitterProportionKey() {
        return "TextEditorWithPreview.SplitterProportionKey";
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        Layout layout2 = this.layout;
        return switch (layout2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[layout2.ordinal()]) {
            case 1, 2 -> this.myEditor.getPreferredFocusedComponent();
            case 3 -> this.myPreview.getPreferredFocusedComponent();
            case -1 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return new MyFileEditorState(this.layout, this.myEditor.getState(level), this.myPreview.getState(level), this.isVerticalSplit());
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.myEditor.addPropertyChangeListener(listener2);
        this.myPreview.addPropertyChangeListener(listener2);
        DoublingEventListenerDelegate delegate = this.listenerGenerator.addListenerAndGetDelegate(listener2);
        this.myEditor.addPropertyChangeListener((PropertyChangeListener)delegate);
        this.myPreview.addPropertyChangeListener((PropertyChangeListener)delegate);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.myEditor.removePropertyChangeListener(listener2);
        this.myPreview.removePropertyChangeListener(listener2);
        DoublingEventListenerDelegate delegate = this.listenerGenerator.removeListenerAndGetDelegate(listener2);
        if (delegate != null) {
            this.myEditor.removePropertyChangeListener((PropertyChangeListener)delegate);
            this.myPreview.removePropertyChangeListener((PropertyChangeListener)delegate);
        }
    }

    public boolean isModified() {
        return this.myEditor.isModified() || this.myPreview.isModified();
    }

    public boolean isValid() {
        return this.myEditor.isValid() && this.myPreview.isValid();
    }

    @Nullable
    protected ActionToolbar createToolbar() {
        ActionGroup actionGroup = this.createLeftToolbarActionGroup();
        if (actionGroup == null) {
            return null;
        }
        ActionGroup actionGroup2 = actionGroup;
        return ActionManager.getInstance().createActionToolbar("TextEditorWithPreview", actionGroup2, true);
    }

    @Nullable
    protected ActionGroup createLeftToolbarActionGroup() {
        return null;
    }

    @NotNull
    protected ActionToolbar createRightToolbar() {
        ActionGroup actionGroup;
        ActionGroup $this$createRightToolbar_u24lambda_u240 = this.createViewActionGroup();
        boolean bl = false;
        AnAction[] anActionArray = $this$createRightToolbar_u24lambda_u240 instanceof DefaultActionGroup ? (AnAction[])$this$createRightToolbar_u24lambda_u240 : null;
        if (anActionArray == null || (anActionArray = anActionArray.getChildren(ActionManager.getInstance())) == null) {
            AnAction[] anActionArray2 = $this$createRightToolbar_u24lambda_u240.getChildren(null);
            anActionArray = anActionArray2;
            Intrinsics.checkNotNullExpressionValue((Object)anActionArray2, (String)"getChildren(...)");
        }
        AnAction[] viewActions = anActionArray;
        ConditionalActionGroup viewActionsGroup = new ConditionalActionGroup(viewActions, (Function0<Boolean>)((Function0)() -> TextEditorWithPreview.createRightToolbar$lambda$1(this)));
        ActionGroup group2 = this.createRightToolbarActionGroup();
        if (group2 == null) {
            actionGroup = viewActionsGroup;
        } else {
            AnAction[] anActionArray3 = new AnAction[]{group2, Separator.create(), viewActionsGroup};
            actionGroup = (ActionGroup)new DefaultActionGroup(anActionArray3);
        }
        ActionGroup rightToolbarActions = actionGroup;
        ActionToolbar actionToolbar2 = ActionManager.getInstance().createActionToolbar("TextEditorWithPreview", rightToolbarActions, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"createActionToolbar(...)");
        return actionToolbar2;
    }

    @NotNull
    protected ActionGroup createViewActionGroup() {
        Object[] objectArray = new ToggleAction[]{this.getShowEditorAction(), this.getShowEditorAndPreviewAction(), this.getShowPreviewAction()};
        return (ActionGroup)new DefaultActionGroup(CollectionsKt.listOf((Object[])objectArray));
    }

    @Nullable
    protected ActionGroup createRightToolbarActionGroup() {
        return null;
    }

    @NotNull
    public ActionGroup getTabActions() {
        return new ConditionalActionGroup(this.createTabActions(), (Function0<Boolean>)((Function0)() -> TextEditorWithPreview.getTabActions$lambda$0(this)));
    }

    @NotNull
    protected AnAction[] createTabActions() {
        ActionGroup $this$createTabActions_u24lambda_u240 = this.createViewActionGroup();
        boolean bl = false;
        AnAction[] anActionArray = $this$createTabActions_u24lambda_u240 instanceof DefaultActionGroup ? (AnAction[])$this$createTabActions_u24lambda_u240 : null;
        if (anActionArray == null || (anActionArray = anActionArray.getChildren(ActionManager.getInstance())) == null) {
            AnAction[] anActionArray2 = $this$createTabActions_u24lambda_u240.getChildren(null);
            anActionArray = anActionArray2;
            Intrinsics.checkNotNullExpressionValue((Object)anActionArray2, (String)"getChildren(...)");
        }
        return anActionArray;
    }

    @NotNull
    protected ToggleAction getShowEditorAction() {
        AnAction anAction = ActionUtil.getAction((String)"TextEditorWithPreview.Layout.EditorOnly");
        Intrinsics.checkNotNull((Object)anAction);
        return (ToggleAction)anAction;
    }

    @NotNull
    protected ToggleAction getShowEditorAndPreviewAction() {
        AnAction anAction = ActionUtil.getAction((String)"TextEditorWithPreview.Layout.EditorAndPreview");
        Intrinsics.checkNotNull((Object)anAction);
        return (ToggleAction)anAction;
    }

    @NotNull
    protected ToggleAction getShowPreviewAction() {
        AnAction anAction = ActionUtil.getAction((String)"TextEditorWithPreview.Layout.PreviewOnly");
        Intrinsics.checkNotNull((Object)anAction);
        return (ToggleAction)anAction;
    }

    private final String getLayoutPropertyName() {
        return this.name + "Layout";
    }

    @Nullable
    public VirtualFile getFile() {
        return this.myEditor.getFile();
    }

    @NotNull
    public Editor getEditor() {
        Editor editor2 = this.myEditor.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        return editor2;
    }

    public boolean canNavigateTo(@NotNull Navigatable navigatable) {
        Intrinsics.checkNotNullParameter((Object)navigatable, (String)"navigatable");
        return this.myEditor.canNavigateTo(navigatable);
    }

    public void navigateTo(@NotNull Navigatable navigatable) {
        Intrinsics.checkNotNullParameter((Object)navigatable, (String)"navigatable");
        this.myEditor.navigateTo(navigatable);
    }

    protected final void handleLayoutChange(boolean isVerticalSplit) {
        block1: {
            if (this.isVerticalSplit == isVerticalSplit) {
                return;
            }
            this.isVerticalSplit = isVerticalSplit;
            TextEditorWithPreviewUi textEditorWithPreviewUi = (TextEditorWithPreviewUi)this.ui.getValueIfInitialized();
            if (textEditorWithPreviewUi == null) break block1;
            textEditorWithPreviewUi.handleLayoutChange(isVerticalSplit);
        }
    }

    @JvmOverloads
    public TextEditorWithPreview(@NotNull TextEditor myEditor, @NotNull FileEditor myPreview, @NotNull String name2, @NotNull Layout defaultLayout, boolean isVerticalSplit) {
        Intrinsics.checkNotNullParameter((Object)myEditor, (String)"myEditor");
        Intrinsics.checkNotNullParameter((Object)myPreview, (String)"myPreview");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)defaultLayout), (String)"defaultLayout");
        this(myEditor, myPreview, name2, defaultLayout, isVerticalSplit, null, 32, null);
    }

    @JvmOverloads
    public TextEditorWithPreview(@NotNull TextEditor myEditor, @NotNull FileEditor myPreview, @NotNull String name2, @NotNull Layout defaultLayout) {
        Intrinsics.checkNotNullParameter((Object)myEditor, (String)"myEditor");
        Intrinsics.checkNotNullParameter((Object)myPreview, (String)"myPreview");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)defaultLayout), (String)"defaultLayout");
        this(myEditor, myPreview, name2, defaultLayout, false, null, 48, null);
    }

    @JvmOverloads
    public TextEditorWithPreview(@NotNull TextEditor myEditor, @NotNull FileEditor myPreview, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)myEditor, (String)"myEditor");
        Intrinsics.checkNotNullParameter((Object)myPreview, (String)"myPreview");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this(myEditor, myPreview, name2, null, false, null, 56, null);
    }

    @JvmOverloads
    public TextEditorWithPreview(@NotNull TextEditor myEditor, @NotNull FileEditor myPreview) {
        Intrinsics.checkNotNullParameter((Object)myEditor, (String)"myEditor");
        Intrinsics.checkNotNullParameter((Object)myPreview, (String)"myPreview");
        this(myEditor, myPreview, null, null, false, null, 60, null);
    }

    private static final TextEditorWithPreviewUi ui$lambda$0(TextEditorWithPreview this$0) {
        return new TextEditorWithPreviewUi(this$0);
    }

    private static final void _init_$lambda$0(TextEditorWithPreview this$0) {
        this$0.ui.getValue();
    }

    private static final boolean createRightToolbar$lambda$1(TextEditorWithPreview this$0) {
        return !this$0.isShowActionsInTabs();
    }

    private static final boolean getTabActions$lambda$0(TextEditorWithPreview this$0) {
        return this$0.isShowActionsInTabs();
    }

    static {
        Key key = Key.create((String)"TextEditorWithPreview.DefaultLayout");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        DEFAULT_LAYOUT_FOR_FILE = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\rR\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/fileEditor/TextEditorWithPreview$Companion;", "", "<init>", "()V", "DEFAULT_LAYOUT_FOR_FILE", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/fileEditor/TextEditorWithPreview$Layout;", "getEditorWithPreviewIcon", "Ljavax/swing/Icon;", "isVerticalSplit", "", "openPreviewForFile", "", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)[Lcom/intellij/openapi/fileEditor/FileEditor;", "getParentSplitEditor", "Lcom/intellij/openapi/fileEditor/TextEditorWithPreview;", "fileEditor", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Icon getEditorWithPreviewIcon(boolean isVerticalSplit) {
            Icon icon2;
            if (ExperimentalUI.Companion.isNewUI()) {
                if (isVerticalSplit) {
                    Icon icon3 = AllIcons.General.EditorPreviewVertical;
                    icon2 = icon3;
                    Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"EditorPreviewVertical");
                } else {
                    Icon icon4 = AllIcons.General.LayoutEditorPreview;
                    icon2 = icon4;
                    Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"LayoutEditorPreview");
                }
            } else if (isVerticalSplit) {
                Icon icon5 = AllIcons.Actions.PreviewDetailsVertically;
                icon2 = icon5;
                Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"PreviewDetailsVertically");
            } else {
                Icon icon6 = AllIcons.Actions.PreviewDetails;
                icon2 = icon6;
                Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"PreviewDetails");
            }
            return icon2;
        }

        @NotNull
        public final FileEditor[] openPreviewForFile(@NotNull Project project2, @NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            file2.putUserData(DEFAULT_LAYOUT_FOR_FILE, (Object)Layout.SHOW_PREVIEW);
            FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)project2).openFile(file2, true);
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"openFile(...)");
            return fileEditorArray;
        }

        @Nullable
        public final TextEditorWithPreview getParentSplitEditor(@Nullable FileEditor fileEditor) {
            return fileEditor instanceof TextEditorWithPreview ? (TextEditorWithPreview)fileEditor : (TextEditorWithPreview)((Object)TextEditorWithPreviewKt.access$getPARENT_SPLIT_EDITOR_KEY$p().get((UserDataHolder)fileEditor));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0081\u0002\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0013B$\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0011\u0010\u0004\u001a\r\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000b\u0010\u000e\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u0004\u001a\r\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/fileEditor/TextEditorWithPreview$Layout;", "", "id", "", "myName", "Ljava/util/function/Supplier;", "Lorg/jetbrains/annotations/Nls;", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/util/function/Supplier;)V", "getId", "()Ljava/lang/String;", "SHOW_EDITOR", "SHOW_PREVIEW", "SHOW_EDITOR_AND_PREVIEW", "getName", "getIcon", "Ljavax/swing/Icon;", "editor", "Lcom/intellij/openapi/fileEditor/TextEditorWithPreview;", "Companion", "intellij.platform.ide.impl"})
    public static final class Layout
    extends Enum<Layout> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String id;
        @NotNull
        private final Supplier<String> myName;
        public static final /* enum */ Layout SHOW_EDITOR;
        public static final /* enum */ Layout SHOW_PREVIEW;
        public static final /* enum */ Layout SHOW_EDITOR_AND_PREVIEW;
        private static final /* synthetic */ Layout[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Layout(String id2, Supplier<String> myName) {
            this.id = id2;
            this.myName = myName;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getName() {
            String string = this.myName.get();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
            return string;
        }

        @NotNull
        public final Icon getIcon(@Nullable TextEditorWithPreview editor2) {
            Icon icon2;
            if (this == SHOW_EDITOR) {
                Icon icon3 = AllIcons.General.LayoutEditorOnly;
                icon2 = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"LayoutEditorOnly");
            } else if (this == SHOW_PREVIEW) {
                Icon icon4 = AllIcons.General.LayoutPreviewOnly;
                icon2 = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"LayoutPreviewOnly");
            } else {
                icon2 = Companion.getEditorWithPreviewIcon(editor2 != null && editor2.isVerticalSplit);
            }
            return icon2;
        }

        public static Layout[] values() {
            return (Layout[])$VALUES.clone();
        }

        public static Layout valueOf(String value) {
            return Enum.valueOf(Layout.class, value);
        }

        @NotNull
        public static EnumEntries<Layout> getEntries() {
            return $ENTRIES;
        }

        @JvmStatic
        @NotNull
        public static final Layout fromId(@Nullable String id2, @NotNull Layout defaultValue) {
            return Companion.fromId(id2, defaultValue);
        }

        static {
            Supplier supplier = IdeBundle.messagePointer((String)"tab.title.editor.only", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"messagePointer(...)");
            SHOW_EDITOR = new Layout("Editor only", supplier);
            Supplier supplier2 = IdeBundle.messagePointer((String)"tab.title.preview.only", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)supplier2, (String)"messagePointer(...)");
            SHOW_PREVIEW = new Layout("Preview only", supplier2);
            Supplier supplier3 = IdeBundle.messagePointer((String)"tab.title.editor.and.preview", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)supplier3, (String)"messagePointer(...)");
            SHOW_EDITOR_AND_PREVIEW = new Layout("Editor and Preview", supplier3);
            $VALUES = layoutArray = new Layout[]{Layout.SHOW_EDITOR, Layout.SHOW_PREVIEW, Layout.SHOW_EDITOR_AND_PREVIEW};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/fileEditor/TextEditorWithPreview$Layout$Companion;", "", "<init>", "()V", "fromId", "Lcom/intellij/openapi/fileEditor/TextEditorWithPreview$Layout;", "id", "", "defaultValue", "intellij.platform.ide.impl"})
        @SourceDebugExtension(value={"SMAP\nTextEditorWithPreview.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextEditorWithPreview.kt\ncom/intellij/openapi/fileEditor/TextEditorWithPreview$Layout$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,539:1\n295#2,2:540\n*S KotlinDebug\n*F\n+ 1 TextEditorWithPreview.kt\ncom/intellij/openapi/fileEditor/TextEditorWithPreview$Layout$Companion\n*L\n418#1:540,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Layout fromId(@Nullable String id2, @NotNull Layout defaultValue) {
                Layout layout2;
                Object v0;
                block2: {
                    Intrinsics.checkNotNullParameter((Object)((Object)defaultValue), (String)"defaultValue");
                    Iterable $this$firstOrNull$iv = (Iterable)Layout.getEntries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Layout it = (Layout)((Object)element$iv);
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)id2)) continue;
                        v0 = element$iv;
                        break block2;
                    }
                    v0 = null;
                }
                if ((layout2 = (Layout)v0) == null) {
                    layout2 = defaultValue;
                }
                return layout2;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B-\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB'\b\u0017\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\b\u0010\u000bJ\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0013\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/fileEditor/TextEditorWithPreview$MyFileEditorState;", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "splitLayout", "Lcom/intellij/openapi/fileEditor/TextEditorWithPreview$Layout;", "firstState", "secondState", "isVerticalSplit", "", "<init>", "(Lcom/intellij/openapi/fileEditor/TextEditorWithPreview$Layout;Lcom/intellij/openapi/fileEditor/FileEditorState;Lcom/intellij/openapi/fileEditor/FileEditorState;Z)V", "layout", "(Lcom/intellij/openapi/fileEditor/TextEditorWithPreview$Layout;Lcom/intellij/openapi/fileEditor/FileEditorState;Lcom/intellij/openapi/fileEditor/FileEditorState;)V", "getSplitLayout", "()Lcom/intellij/openapi/fileEditor/TextEditorWithPreview$Layout;", "getFirstState", "()Lcom/intellij/openapi/fileEditor/FileEditorState;", "getSecondState", "()Z", "canBeMergedWith", "otherState", "level", "Lcom/intellij/openapi/fileEditor/FileEditorStateLevel;", "equals", "other", "", "hashCode", "", "intellij.platform.ide.impl"})
    public static final class MyFileEditorState
    implements FileEditorState {
        @Nullable
        private final Layout splitLayout;
        @Nullable
        private final FileEditorState firstState;
        @Nullable
        private final FileEditorState secondState;
        private final boolean isVerticalSplit;

        public MyFileEditorState(@Nullable Layout splitLayout, @Nullable FileEditorState firstState, @Nullable FileEditorState secondState, boolean isVerticalSplit) {
            this.splitLayout = splitLayout;
            this.firstState = firstState;
            this.secondState = secondState;
            this.isVerticalSplit = isVerticalSplit;
        }

        @Nullable
        public final Layout getSplitLayout() {
            return this.splitLayout;
        }

        @Nullable
        public final FileEditorState getFirstState() {
            return this.firstState;
        }

        @Nullable
        public final FileEditorState getSecondState() {
            return this.secondState;
        }

        public final boolean isVerticalSplit() {
            return this.isVerticalSplit;
        }

        @Deprecated(message="Use {@link #MyFileEditorState(Layout, FileEditorState, FileEditorState, boolean)}")
        public MyFileEditorState(@Nullable Layout layout2, @Nullable FileEditorState firstState, @Nullable FileEditorState secondState) {
            this(layout2, firstState, secondState, false);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean canBeMergedWith(@NotNull FileEditorState otherState, @NotNull FileEditorStateLevel level) {
            Intrinsics.checkNotNullParameter((Object)otherState, (String)"otherState");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            if (!(otherState instanceof MyFileEditorState)) return false;
            if (this.firstState != null) {
                FileEditorState fileEditorState = ((MyFileEditorState)otherState).firstState;
                Intrinsics.checkNotNull((Object)fileEditorState);
                if (!this.firstState.canBeMergedWith(fileEditorState, level)) return false;
            }
            if (this.secondState == null) return true;
            FileEditorState fileEditorState = ((MyFileEditorState)otherState).secondState;
            Intrinsics.checkNotNull((Object)fileEditorState);
            if (!this.secondState.canBeMergedWith(fileEditorState, level)) return false;
            return true;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
                return false;
            }
            MyFileEditorState state2 = (MyFileEditorState)other;
            return this.splitLayout == state2.splitLayout && Intrinsics.areEqual((Object)this.firstState, (Object)state2.firstState) && Intrinsics.areEqual((Object)this.secondState, (Object)state2.secondState);
        }

        public int hashCode() {
            Layout layout2 = this.splitLayout;
            int result2 = layout2 != null ? layout2.hashCode() : 0;
            FileEditorState fileEditorState = this.firstState;
            result2 = 31 * result2 + (fileEditorState != null ? fileEditorState.hashCode() : 0);
            FileEditorState fileEditorState2 = this.secondState;
            result2 = 31 * result2 + (fileEditorState2 != null ? fileEditorState2.hashCode() : 0);
            result2 = 31 * result2 + Boolean.hashCode(this.isVerticalSplit);
            return result2;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/fileEditor/TextEditorWithPreview$MyMouseListener;", "Ljava/awt/event/AWTEventListener;", "toolbar", "Lcom/intellij/openapi/fileEditor/LayoutActionsFloatingToolbar;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/fileEditor/TextEditorWithPreview;Lcom/intellij/openapi/fileEditor/LayoutActionsFloatingToolbar;Lcom/intellij/openapi/Disposable;)V", "alarm", "Lcom/intellij/util/Alarm;", "eventDispatched", "", "event", "Ljava/awt/AWTEvent;", "intellij.platform.ide.impl"})
    private final class MyMouseListener
    implements AWTEventListener {
        @NotNull
        private final LayoutActionsFloatingToolbar toolbar;
        @NotNull
        private final Alarm alarm;

        public MyMouseListener(@NotNull LayoutActionsFloatingToolbar toolbar2, Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter((Object)toolbar2, (String)"toolbar");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            this.toolbar = toolbar2;
            this.alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, parentDisposable);
        }

        @Override
        public void eventDispatched(@NotNull AWTEvent event) {
            boolean isMouseOutsideToolbar;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            boolean isMouseInsideComponent = TextEditorWithPreview.this.getComponent().getMousePosition() != null;
            boolean bl = isMouseOutsideToolbar = this.toolbar.getMousePosition() == null;
            if (isMouseInsideComponent) {
                this.alarm.cancelAllRequests();
                this.toolbar.scheduleShow();
                if (isMouseOutsideToolbar) {
                    this.alarm.addRequest(() -> MyMouseListener.eventDispatched$lambda$0(this), 1400);
                }
            } else if (isMouseOutsideToolbar) {
                this.toolbar.scheduleHide();
            }
        }

        private static final void eventDispatched$lambda$0(MyMouseListener this$0) {
            this$0.toolbar.scheduleHide();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/fileEditor/TextEditorWithPreview$TextEditorWithPreviewUi;", "", "host", "Lcom/intellij/openapi/fileEditor/TextEditorWithPreview;", "<init>", "(Lcom/intellij/openapi/fileEditor/TextEditorWithPreview;)V", "component", "Ljavax/swing/JComponent;", "splitter", "Lcom/intellij/ui/JBSplitter;", "toolbarWrapper", "Lcom/intellij/openapi/fileEditor/SplitEditorToolbar;", "handleLayoutChange", "", "isVerticalSplit", "", "intellij.platform.ide.impl"})
    private static final class TextEditorWithPreviewUi {
        @JvmField
        @NotNull
        public final JComponent component;
        @JvmField
        @NotNull
        public JBSplitter splitter;
        @JvmField
        @NotNull
        public final SplitEditorToolbar toolbarWrapper;

        public TextEditorWithPreviewUi(@NotNull TextEditorWithPreview host) {
            SplitEditorToolbar toolbarWrapper;
            Intrinsics.checkNotNullParameter((Object)((Object)host), (String)"host");
            this.splitter = host.createSplitter();
            this.splitter.setSplitterProportionKey(host.getSplitterProportionKey());
            this.splitter.setFirstComponent(host.myEditor.getComponent());
            this.splitter.setSecondComponent(host.myPreview.getComponent());
            this.splitter.setDividerWidth(ExperimentalUI.Companion.isNewUI() ? 1 : 2);
            this.splitter.getDivider().setBackground((Color)JBColor.lazy(TextEditorWithPreviewUi::_init_$lambda$0));
            this.toolbarWrapper = toolbarWrapper = host.createSplitEditorToolbar((JComponent)this.splitter);
            Layout layout2 = host.layout;
            if (layout2 == null) {
                String lastUsed = PropertiesComponent.getInstance().getValue(host.getLayoutPropertyName());
                layout2 = Layout.Companion.fromId(lastUsed, host.defaultLayout);
                host.layout = layout2;
            }
            host.adjustEditorsVisibility(layout2);
            if (host.isShowFloatingToolbar() && toolbarWrapper.isLeftToolbarEmpty()) {
                toolbarWrapper.setVisible(false);
                MyEditorLayeredComponentWrapper layeredPane2 = new MyEditorLayeredComponentWrapper((JComponent)this.splitter);
                this.component = (JComponent)((Object)layeredPane2);
                ActionGroup actionGroup = toolbarWrapper.getRightToolbar().getActionGroup();
                Intrinsics.checkNotNullExpressionValue((Object)actionGroup, (String)"getActionGroup(...)");
                ActionGroup toolbarGroup2 = actionGroup;
                LayoutActionsFloatingToolbar toolbar2 = new LayoutActionsFloatingToolbar((JComponent)((Object)layeredPane2), toolbarGroup2, (Disposable)host);
                Component component2 = (Component)this.splitter;
                Integer n = JLayeredPane.DEFAULT_LAYER;
                Intrinsics.checkNotNull((Object)n, (String)"null cannot be cast to non-null type kotlin.Any");
                layeredPane2.add(component2, n);
                Component component3 = toolbar2;
                Integer n2 = JLayeredPane.POPUP_LAYER;
                Intrinsics.checkNotNull((Object)n2, (String)"null cannot be cast to non-null type kotlin.Any");
                layeredPane2.add(component3, n2);
                host.registerToolbarListeners((JComponent)this.splitter, toolbar2, (Disposable)host);
            } else {
                JPanel panel2 = new JPanel(new BorderLayout());
                panel2.add((Component)this.splitter, "Center");
                panel2.add((Component)toolbarWrapper, "North");
                this.component = panel2;
            }
        }

        public final void handleLayoutChange(boolean isVerticalSplit) {
            this.toolbarWrapper.refresh();
            this.splitter.setOrientation(isVerticalSplit);
            this.component.repaint();
        }

        private static final Color _init_$lambda$0() {
            Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.PREVIEW_BORDER_COLOR);
            if (color == null) {
                Color color2 = UIUtil.getPanelBackground();
                color = color2;
                Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getPanelBackground(...)");
            }
            return color;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Layout.values().length];
            try {
                nArray[Layout.SHOW_EDITOR_AND_PREVIEW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Layout.SHOW_EDITOR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Layout.SHOW_PREVIEW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

