/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.impl.ActionShortcutRestrictions;
import com.intellij.openapi.keymap.impl.SystemShortcutsListener;
import com.intellij.openapi.keymap.impl.ui.ActionsTreeUtil;
import com.intellij.openapi.keymap.impl.ui.EditKeymapsDialog;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.messages.MessageBus;
import com.jetbrains.JBR;
import com.jetbrains.SystemShortcuts;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class SystemShortcuts {
    private static final Logger LOG = Logger.getInstance(SystemShortcuts.class);
    @NotNull
    private static final String ourUnknownSysAction = "Unknown action";
    @NotNull
    private final Map<KeyStroke, SystemShortcuts.Shortcut> myKeyStroke2SysShortcut = new HashMap<KeyStroke, SystemShortcuts.Shortcut>();
    @NotNull
    private final MuteConflictsSettings myMutedConflicts = new MuteConflictsSettings();
    @NotNull
    private final Set<String> myNotifiedActions = new HashSet<String>();
    private int myNotifyCount = 0;
    @Nullable
    private Keymap myKeymap;
    @NotNull
    private final Map<String, ConflictItem> myKeymapConflicts = new HashMap<String, ConflictItem>();
    private static final boolean DEBUG_SYSTEM_SHORTCUTS = Boolean.getBoolean("debug.system.shortcuts");

    private SystemShortcuts() {
        this.readSystem();
        this.setUpSystemShortcutsChangeListener();
    }

    @NotNull
    public static SystemShortcuts getInstance() {
        SystemShortcuts systemShortcuts = (SystemShortcuts)ApplicationManager.getApplication().getService(SystemShortcuts.class);
        if (systemShortcuts == null) {
            SystemShortcuts.$$$reportNull$$$0(0);
        }
        return systemShortcuts;
    }

    public void updateKeymapConflicts(@Nullable Keymap keymap2) {
        this.myKeymap = keymap2;
        this.myKeymapConflicts.clear();
        if (this.myKeyStroke2SysShortcut.isEmpty()) {
            return;
        }
        if (keymap2 == null) {
            return;
        }
        for (Map.Entry<KeyStroke, SystemShortcuts.Shortcut> entry : this.myKeyStroke2SysShortcut.entrySet()) {
            KeyStroke sysKS = entry.getKey();
            SystemShortcuts.Shortcut shk = entry.getValue();
            String[] actIds = SystemShortcuts.computeOnEdt(() -> keymap2.getActionIds(sysKS));
            if (actIds.length == 0) continue;
            this.myKeymapConflicts.put(shk.getId(), new ConflictItem(sysKS, SystemShortcuts.getDescription(shk), actIds));
        }
    }

    @NotNull
    public Collection<ConflictItem> getUnmutedKeymapConflicts() {
        ArrayList<ConflictItem> result2 = new ArrayList<ConflictItem>();
        this.myKeymapConflicts.forEach((ks, ci) -> {
            if (ci.getUnmutedActionId(this.myMutedConflicts) != null) {
                result2.add((ConflictItem)ci);
            }
        });
        ArrayList<ConflictItem> arrayList = result2;
        if (arrayList == null) {
            SystemShortcuts.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Nullable
    public Condition<AnAction> createKeymapConflictsActionFilter() {
        if (this.myKeyStroke2SysShortcut.isEmpty() || this.myKeymap == null) {
            return null;
        }
        Condition predicate = sc -> {
            if (sc == null) {
                return false;
            }
            for (Map.Entry<KeyStroke, SystemShortcuts.Shortcut> entry : this.myKeyStroke2SysShortcut.entrySet()) {
                ConflictItem ci;
                KeyStroke ks = entry.getKey();
                if (!sc.startsWith((Shortcut)new KeyboardShortcut(ks, null)) || (ci = this.myKeymapConflicts.get(entry.getValue().getId())) == null || ci.getUnmutedActionId(this.myMutedConflicts) == null) continue;
                return true;
            }
            return false;
        };
        return ActionsTreeUtil.isActionFiltered(ActionManager.getInstance(), this.myKeymap, (Condition<? super Shortcut>)predicate);
    }

    @Nullable
    public Map<KeyboardShortcut, String> calculateConflicts(@NotNull Keymap keymap2, @NotNull String actionId) {
        Shortcut[] actionShortcuts;
        if (keymap2 == null) {
            SystemShortcuts.$$$reportNull$$$0(2);
        }
        if (actionId == null) {
            SystemShortcuts.$$$reportNull$$$0(3);
        }
        if (this.myKeyStroke2SysShortcut.isEmpty()) {
            return null;
        }
        HashMap<KeyboardShortcut, String> result2 = null;
        for (Shortcut sc : actionShortcuts = SystemShortcuts.computeOnEdt(() -> keymap2.getShortcuts(actionId))) {
            if (!(sc instanceof KeyboardShortcut)) continue;
            KeyboardShortcut ksc = (KeyboardShortcut)sc;
            for (Map.Entry<KeyStroke, SystemShortcuts.Shortcut> entry : this.myKeyStroke2SysShortcut.entrySet()) {
                KeyStroke sks = entry.getKey();
                SystemShortcuts.Shortcut shk = entry.getValue();
                if (!ksc.getFirstKeyStroke().equals(sks) && !sks.equals(ksc.getSecondKeyStroke())) continue;
                if (result2 == null) {
                    result2 = new HashMap<KeyboardShortcut, String>();
                }
                result2.put(ksc, SystemShortcuts.getDescription(shk));
            }
        }
        return result2;
    }

    private static <T> T computeOnEdt(Supplier<? extends T> supplier) {
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            return supplier.get();
        }
        Ref result2 = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> result2.set(supplier.get()));
        return (T)result2.get();
    }

    @Nullable
    public Map<KeyStroke, String> createKeystroke2SysShortcutMap() {
        if (this.myKeyStroke2SysShortcut.isEmpty()) {
            return null;
        }
        HashMap<KeyStroke, String> result2 = new HashMap<KeyStroke, String>();
        this.myKeyStroke2SysShortcut.forEach((ks, sysks) -> result2.put((KeyStroke)ks, SystemShortcuts.getDescription(sysks)));
        return result2;
    }

    private int getUnmutedConflictsCount() {
        if (this.myKeymapConflicts.isEmpty()) {
            return 0;
        }
        int result2 = 0;
        for (ConflictItem ci : this.myKeymapConflicts.values()) {
            if (ci.getUnmutedActionId(this.myMutedConflicts) == null) continue;
            ++result2;
        }
        return result2;
    }

    public void onUserPressedShortcut(@NotNull Keymap keymap2, @NotNull List<String> actionIds, @NotNull KeyboardShortcut ksc) {
        if (keymap2 == null) {
            SystemShortcuts.$$$reportNull$$$0(4);
        }
        if (actionIds == null) {
            SystemShortcuts.$$$reportNull$$$0(5);
        }
        if (ksc == null) {
            SystemShortcuts.$$$reportNull$$$0(6);
        }
        if (this.myNotifyCount > 0 || actionIds.isEmpty()) {
            return;
        }
        KeyStroke ks = ksc.getFirstKeyStroke();
        SystemShortcuts.Shortcut sysKs = this.myKeyStroke2SysShortcut.get(ks);
        if (sysKs == null && ksc.getSecondKeyStroke() != null) {
            sysKs = this.myKeyStroke2SysShortcut.get(ksc.getSecondKeyStroke());
        }
        if (sysKs == null) {
            return;
        }
        String unmutedActId = null;
        for (String actId : actionIds) {
            if (this.myNotifiedActions.contains(actId) || this.myMutedConflicts.isMutedAction(actId)) continue;
            unmutedActId = actId;
            break;
        }
        if (unmutedActId == null) {
            return;
        }
        @Nullable String macOsShortcutAction = SystemShortcuts.getDescription(sysKs);
        if (Strings.areSameInstance((String)macOsShortcutAction, (String)ourUnknownSysAction)) {
            macOsShortcutAction = null;
        }
        this.doNotify(keymap2, unmutedActId, macOsShortcutAction, ksc);
    }

    private void doNotify(@NotNull Keymap keymap2, @NotNull String actionId, @Nullable String macOsShortcutAction, @NotNull KeyboardShortcut conflicted) {
        String actText;
        if (keymap2 == null) {
            SystemShortcuts.$$$reportNull$$$0(7);
        }
        if (actionId == null) {
            SystemShortcuts.$$$reportNull$$$0(8);
        }
        if (conflicted == null) {
            SystemShortcuts.$$$reportNull$$$0(9);
        }
        this.updateKeymapConflicts(keymap2);
        int unmutedConflicts = this.getUnmutedConflictsCount();
        boolean hasOtherConflicts = unmutedConflicts > 1;
        AnAction act = ActionManager.getInstance().getAction(actionId);
        String string = actText = act == null ? actionId : act.getTemplateText();
        String message = hasOtherConflicts ? IdeBundle.message((String)"notification.content.more.shortcut.conflict", (Object[])new Object[]{actText, unmutedConflicts - 1}) : IdeBundle.message((String)"notification.content.shortcut.conflicts.with.macos.shortcut.modify", (Object[])new Object[]{actText, macOsShortcutAction == null ? "" : " '" + macOsShortcutAction + "'"});
        Notification notification2 = NotificationGroupManager.getInstance().getNotificationGroup("System shortcuts conflicts").createNotification(IdeBundle.message((String)"notification.title.shortcuts.conflicts", (Object[])new Object[0]), message, NotificationType.WARNING);
        if (hasOtherConflicts) {
            DumbAwareAction showKeymapPanelAction = DumbAwareAction.create((String)IdeBundle.message((String)"action.text.modify.shortcuts", (Object[])new Object[0]), e -> {
                new EditKeymapsDialog(null, actionId, true).show();
                this.updateKeymapConflicts(this.myKeymap);
            });
            notification2.addAction((AnAction)showKeymapPanelAction);
        } else {
            DumbAwareAction configureShortcut = DumbAwareAction.create((String)IdeBundle.message((String)"action.text.modify.shortcut", (Object[])new Object[0]), e -> {
                Component component2 = (Component)e.getDataContext().getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
                if (component2 == null) {
                    Window[] frames = Window.getWindows();
                    Component component3 = component2 = frames == null || frames.length == 0 ? null : frames[0];
                    if (component2 == null) {
                        LOG.error("can't show KeyboardShortcutDialog (parent component wasn't found)");
                        return;
                    }
                }
                KeymapPanel.addKeyboardShortcut(actionId, ActionShortcutRestrictions.getInstance().getForActionId(actionId), keymap2, component2, conflicted, this, new QuickList[0]);
                notification2.expire();
            });
            notification2.addAction((AnAction)configureShortcut);
        }
        DumbAwareAction muteAction = DumbAwareAction.create((String)IdeBundle.message((String)"action.dont.show.again.text", (Object[])new Object[0]), e -> {
            this.myMutedConflicts.addMutedAction(actionId);
            notification2.expire();
        });
        notification2.addAction((AnAction)muteAction);
        if (SystemInfo.isMac && !hasOtherConflicts) {
            DumbAwareAction changeSystemSettings = DumbAwareAction.create((String)IdeBundle.message((String)"action.text.change.system.shortcuts", (Object[])new Object[0]), e -> ApplicationManager.getApplication().executeOnPooledThread(() -> {
                GeneralCommandLine cmdLine = new GeneralCommandLine(new String[]{"osascript", "-e", "tell application \"System Preferences\"", "-e", "set the current pane to pane id \"com.apple.preference.keyboard\"", "-e", "reveal anchor \"shortcutsTab\" of pane id \"com.apple.preference.keyboard\"", "-e", "activate", "-e", "end tell"});
                try {
                    ExecUtil.execAndGetOutput((GeneralCommandLine)cmdLine);
                }
                catch (ExecutionException ex) {
                    LOG.error((Throwable)ex);
                }
            }));
            notification2.addAction((AnAction)changeSystemSettings);
        }
        this.myNotifiedActions.add(actionId);
        ++this.myNotifyCount;
        notification2.notify(null);
    }

    @NotNull
    private static String getDescription(SystemShortcuts.Shortcut systemHotkey) {
        if (systemHotkey == null) {
            return ourUnknownSysAction;
        }
        String result2 = systemHotkey.getDescription();
        if (result2 == null) {
            return ourUnknownSysAction;
        }
        String delimiter = " - ";
        int pos0 = result2.indexOf(" - ");
        if (pos0 < 0) {
            String string = result2;
            if (string == null) {
                SystemShortcuts.$$$reportNull$$$0(10);
            }
            return string;
        }
        int pos1 = result2.indexOf(" - ", pos0 + " - ".length());
        if (pos1 < 0) {
            String string = result2;
            if (string == null) {
                SystemShortcuts.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = result2.substring(pos0 + " - ".length(), pos1).replace("%", "").replace("@", "");
        if (string == null) {
            SystemShortcuts.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    private static com.jetbrains.SystemShortcuts getJbrApi() {
        if (!(SystemInfo.isMac && SystemInfo.isJetBrainsJvm && Registry.is((String)"read.system.shortcuts"))) {
            return null;
        }
        return JBR.getSystemShortcuts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSystem() {
        this.myKeyStroke2SysShortcut.clear();
        com.jetbrains.SystemShortcuts systemShortcuts = SystemShortcuts.getJbrApi();
        if (systemShortcuts == null) {
            return;
        }
        try {
            SystemShortcuts.Shortcut[] all = systemShortcuts.querySystemShortcuts();
            if (all == null || all.length == 0) {
                return;
            }
            StringBuilder debugInfo = new StringBuilder();
            for (SystemShortcuts.Shortcut shk : all) {
                KeyStroke sysKS;
                if (shk.getModifiers() == 0 || shk.getKeyChar() == '\uffff' && shk.getKeyCode() == 0 || "FocusNextApplicationWindow".equals(shk.getId()) || "FocusPreviousApplicationWindow".equals(shk.getId())) continue;
                if (shk.getKeyChar() != '\uffff') {
                    int keyCode = KeyEvent.getExtendedKeyCodeForChar(shk.getKeyChar());
                    if (keyCode == 0) continue;
                    sysKS = KeyStroke.getKeyStroke(keyCode, shk.getModifiers());
                } else {
                    sysKS = KeyStroke.getKeyStroke(shk.getKeyCode(), shk.getModifiers());
                }
                this.myKeyStroke2SysShortcut.put(sysKS, shk);
                if (!DEBUG_SYSTEM_SHORTCUTS) continue;
                debugInfo.append(shk).append(";\n");
            }
            if (DEBUG_SYSTEM_SHORTCUTS) {
                Logger.getInstance(SystemShortcuts.class).info("system shortcuts:\n" + String.valueOf(debugInfo));
            }
        }
        catch (Throwable e) {
            Logger.getInstance(SystemShortcuts.class).debug(e);
        }
        finally {
            if (SystemInfo.isMacOSBigSur) {
                this.addCustomShortcut(91, 320, "Select Next Tab Window");
                this.addCustomShortcut(93, 320, "Select Previous Tab Window");
            }
        }
    }

    private void setUpSystemShortcutsChangeListener() {
        com.jetbrains.SystemShortcuts systemShortcuts = SystemShortcuts.getJbrApi();
        if (systemShortcuts == null) {
            return;
        }
        systemShortcuts.setChangeListener(new SystemShortcuts.ChangeEventListener(){

            public void handleSystemShortcutsChangeEvent() {
                SystemShortcuts.this.readSystem();
                SystemShortcuts.this.updateKeymapConflicts(SystemShortcuts.this.myKeymap);
                MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
                ((SystemShortcutsListener)messageBus.syncPublisher(SystemShortcutsListener.CHANGE_TOPIC)).processSystemShortcutsChanged();
            }
        });
    }

    private void addCustomShortcut(final int keycode, final int modifiers, final @NotNull String description) {
        if (description == null) {
            SystemShortcuts.$$$reportNull$$$0(13);
        }
        KeyStroke newStroke = KeyStroke.getKeyStroke(keycode, modifiers);
        for (KeyStroke keyStroke : this.myKeyStroke2SysShortcut.keySet()) {
            if (!newStroke.equals(keyStroke)) continue;
            return;
        }
        this.myKeyStroke2SysShortcut.put(newStroke, new SystemShortcuts.Shortcut(){

            public int getKeyCode() {
                return keycode;
            }

            public char getKeyChar() {
                return '\uffff';
            }

            public int getModifiers() {
                return modifiers;
            }

            public String getId() {
                return "CustomShortcut_" + description;
            }

            public String getDescription() {
                return description;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/keymap/impl/SystemShortcuts";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keymap";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionIds";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksc";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicted";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnmutedKeymapConflicts";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/keymap/impl/SystemShortcuts";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calculateConflicts";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onUserPressedShortcut";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doNotify";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addCustomShortcut";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 13 -> new IllegalArgumentException(string);
        };
    }

    private static final class MuteConflictsSettings {
        private static final String MUTED_ACTIONS_KEY = "muted.system.shortcut.conflicts.actions";
        private Set<String> myMutedActions;

        private MuteConflictsSettings() {
        }

        void init() {
            if (this.myMutedActions != null) {
                return;
            }
            this.myMutedActions = new HashSet<String>();
            List muted = PropertiesComponent.getInstance().getList(MUTED_ACTIONS_KEY);
            if (muted != null) {
                this.myMutedActions.addAll(muted);
            }
        }

        void addMutedAction(@NotNull String actId) {
            if (actId == null) {
                MuteConflictsSettings.$$$reportNull$$$0(0);
            }
            this.init();
            this.myMutedActions.add(actId);
            PropertiesComponent.getInstance().setList(MUTED_ACTIONS_KEY, this.myMutedActions);
        }

        void removeMutedAction(@NotNull String actId) {
            if (actId == null) {
                MuteConflictsSettings.$$$reportNull$$$0(1);
            }
            this.init();
            this.myMutedActions.remove(actId);
            PropertiesComponent.getInstance().setList(MUTED_ACTIONS_KEY, this.myMutedActions);
        }

        public boolean isMutedAction(@NotNull String actionId) {
            if (actionId == null) {
                MuteConflictsSettings.$$$reportNull$$$0(2);
            }
            this.init();
            return this.myMutedActions.contains(actionId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/keymap/impl/SystemShortcuts$MuteConflictsSettings";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addMutedAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeMutedAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isMutedAction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class ConflictItem {
        @NotNull
        final String mySysActionDesc;
        @NotNull
        final KeyStroke mySysKeyStroke;
        final String @NotNull [] myActionIds;

        public ConflictItem(@NotNull KeyStroke sysKeyStroke, @NotNull String sysActionDesc, String @NotNull [] actionIds) {
            if (sysKeyStroke == null) {
                ConflictItem.$$$reportNull$$$0(0);
            }
            if (sysActionDesc == null) {
                ConflictItem.$$$reportNull$$$0(1);
            }
            if (actionIds == null) {
                ConflictItem.$$$reportNull$$$0(2);
            }
            this.mySysKeyStroke = sysKeyStroke;
            this.mySysActionDesc = sysActionDesc;
            this.myActionIds = actionIds;
        }

        @NotNull
        public String getSysActionDesc() {
            String string = this.mySysActionDesc;
            if (string == null) {
                ConflictItem.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public KeyStroke getSysKeyStroke() {
            KeyStroke keyStroke = this.mySysKeyStroke;
            if (keyStroke == null) {
                ConflictItem.$$$reportNull$$$0(4);
            }
            return keyStroke;
        }

        public String @NotNull [] getActionIds() {
            if (this.myActionIds == null) {
                ConflictItem.$$$reportNull$$$0(5);
            }
            return this.myActionIds;
        }

        @Nullable
        String getUnmutedActionId(@NotNull MuteConflictsSettings settings) {
            if (settings == null) {
                ConflictItem.$$$reportNull$$$0(6);
            }
            for (String actId : this.myActionIds) {
                if (settings.isMutedAction(actId)) continue;
                return actId;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sysKeyStroke";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sysActionDesc";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionIds";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/keymap/impl/SystemShortcuts$ConflictItem";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/keymap/impl/SystemShortcuts$ConflictItem";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSysActionDesc";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSysKeyStroke";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionIds";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getUnmutedActionId";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

