/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SchemeImportUtil {
    @Nullable
    public static VirtualFile selectImportSource(@NotNull @NotNull String @NotNull [] sourceExtensions, @NotNull Component parent, @Nullable VirtualFile preselect, @NlsContexts.Label @Nullable String description) {
        VirtualFile[] virtualFileArray;
        if (parent == null) {
            SchemeImportUtil.$$$reportNull$$$0(0);
        }
        if (sourceExtensions == null) {
            SchemeImportUtil.$$$reportNull$$$0(1);
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, SchemeImportUtil.canSelectJarFile(sourceExtensions), false, false, false);
        if (sourceExtensions.length == 1) {
            descriptor.withExtensionFilter(sourceExtensions[0]);
        } else if (sourceExtensions.length > 1) {
            descriptor.withExtensionFilter(IdeCoreBundle.message((String)"file.chooser.files.label", (Object[])new Object[]{sourceExtensions[0].toUpperCase(Locale.ROOT)}), sourceExtensions);
        }
        if (description != null) {
            descriptor.setDescription(description);
        }
        FileChooserDialog fileChooser = FileChooserFactory.getInstance().createFileChooser(descriptor, null, parent);
        if (preselect != null) {
            VirtualFile[] virtualFileArray2 = new VirtualFile[1];
            virtualFileArray = virtualFileArray2;
            virtualFileArray2[0] = preselect;
        } else {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
        }
        VirtualFile[] preselectFiles = virtualFileArray;
        VirtualFile[] virtualFiles = fileChooser.choose(null, preselectFiles);
        if (virtualFiles.length != 1) {
            return null;
        }
        virtualFiles[0].refresh(false, false);
        return virtualFiles[0];
    }

    private static boolean canSelectJarFile(String[] sourceExtensions) {
        return ArrayUtil.contains((String)"jar", (String[])sourceExtensions);
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static Element loadSchemeDom(@NotNull VirtualFile file2) throws SchemeImportException {
        Element element;
        InputStream inputStream;
        block10: {
            if (file2 == null) {
                SchemeImportUtil.$$$reportNull$$$0(2);
            }
            inputStream = file2.getInputStream();
            element = JDOMUtil.load((InputStream)inputStream);
            if (inputStream == null) break block10;
            inputStream.close();
        }
        Element element2 = element;
        if (element2 == null) {
            SchemeImportUtil.$$$reportNull$$$0(3);
        }
        return element2;
        {
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | JDOMException e) {
                    throw new SchemeImportException();
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceExtensions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/SchemeImportUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/SchemeImportUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadSchemeDom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "selectImportSource";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadSchemeDom";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

