/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.newEditor.ConfigurableEditorBanner;
import com.intellij.openapi.options.newEditor.SimpleBanner;
import com.intellij.util.IJSwingUtilities;
import java.awt.Component;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ConfigurableController
implements Configurable.TopComponentController {
    private SimpleBanner myBanner;
    private Component myCenterComponent;
    private Component myLeftComponent;
    private boolean myProgress;
    private boolean myHasProject;

    ConfigurableController() {
    }

    void setBanner(SimpleBanner banner) {
        if (banner == null) {
            this.myBanner.setLeftComponent(null);
            this.myBanner.setCenterComponent(null);
            this.myBanner.showProgress(false);
            ConfigurableController.showProject(this.myBanner, true);
        } else {
            banner.setLeftComponent(this.myLeftComponent);
            banner.setCenterComponent(this.myCenterComponent);
            banner.showProgress(this.myProgress);
            ConfigurableController.showProject(banner, this.myHasProject);
            IJSwingUtilities.updateComponentTreeUI(banner);
        }
        this.myBanner = banner;
    }

    public void setLeftComponent(@Nullable Component component2) {
        this.myLeftComponent = component2;
        if (this.myBanner != null) {
            this.myBanner.setLeftComponent(component2);
        }
    }

    public void showProgress(boolean start2) {
        this.myProgress = start2;
        if (this.myBanner != null) {
            this.myBanner.showProgress(start2);
        }
    }

    public void showProject(boolean hasProject) {
        this.myHasProject = hasProject;
        ConfigurableController.showProject(this.myBanner, hasProject);
    }

    @Nullable
    static ConfigurableController getOrCreate(@Nullable Configurable configurable, @NotNull Map<Configurable, ConfigurableController> controllers) {
        ConfigurableController controller;
        if (controllers == null) {
            ConfigurableController.$$$reportNull$$$0(0);
        }
        if ((controller = controllers.get(configurable)) == null) {
            Configurable original = configurable instanceof ConfigurableWrapper ? ((ConfigurableWrapper)configurable).getConfigurable() : configurable;
            ConfigurableController configurableController = controller = original instanceof Configurable.TopComponentProvider ? ConfigurableController.createController((Configurable.TopComponentProvider)original) : null;
            if (controller != null) {
                controllers.put(configurable, controller);
            }
        }
        return controller;
    }

    @Nullable
    private static ConfigurableController createController(@NotNull Configurable.TopComponentProvider original) {
        if (original == null) {
            ConfigurableController.$$$reportNull$$$0(1);
        }
        if (!original.isAvailable()) {
            return null;
        }
        ConfigurableController controller = new ConfigurableController();
        controller.myCenterComponent = original.getCenterComponent((Configurable.TopComponentController)controller);
        return controller;
    }

    private static void showProject(@Nullable SimpleBanner banner, boolean hasProject) {
        if (banner instanceof ConfigurableEditorBanner) {
            ((ConfigurableEditorBanner)banner).showProject(hasProject);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controllers";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/options/newEditor/ConfigurableController";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrCreate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createController";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

