/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.ide.HelpTooltip;
import com.intellij.ide.actions.BackAction;
import com.intellij.ide.actions.ForwardAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.ex.MutableConfigurableGroup;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.options.newEditor.AbstractEditor;
import com.intellij.openapi.options.newEditor.ConfigurableController;
import com.intellij.openapi.options.newEditor.ConfigurableEditor;
import com.intellij.openapi.options.newEditor.ConfigurableEditorBanner;
import com.intellij.openapi.options.newEditor.CopySettingsPathAction;
import com.intellij.openapi.options.newEditor.ISettingsTreeViewFactory;
import com.intellij.openapi.options.newEditor.OptionsEditorColleague;
import com.intellij.openapi.options.newEditor.ResetConfigurableHandler;
import com.intellij.openapi.options.newEditor.SettingsDialogExtensionsKt;
import com.intellij.openapi.options.newEditor.SettingsDialogListener;
import com.intellij.openapi.options.newEditor.SettingsFilter;
import com.intellij.openapi.options.newEditor.SettingsSearch;
import com.intellij.openapi.options.newEditor.SettingsTreeView;
import com.intellij.openapi.options.newEditor.SpotlightPainter;
import com.intellij.openapi.options.newEditor.SpotlightPainterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.impl.IdeFrameDecorator;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.breadcrumbs.Breadcrumbs;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.concurrency.EdtScheduler;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@ApiStatus.Internal
public final class SettingsEditor
extends AbstractEditor
implements UiDataProvider,
Place.Navigator {
    static final String SELECTED_CONFIGURABLE = "settings.editor.selected.configurable";
    private static final String SPLITTER_PROPORTION = "settings.editor.splitter.proportion";
    private static final float SPLITTER_PROPORTION_DEFAULT_VALUE = 0.2f;
    private final PropertiesComponent properties;
    private final Settings settings;
    private final SettingsSearch search;
    private final SettingsFilter filter;
    private final SettingsTreeView treeView;
    public final ConfigurableEditor editor;
    private final OnePixelSplitter mySplitter;
    private final SpotlightPainter spotlightPainter;
    private final LoadingDecorator loadingDecorator;
    @NotNull
    private final ConfigurableEditorBanner myBanner;
    private final History myHistory;
    private volatile boolean myNavigatingNow;
    private final boolean myIsModal;
    @Nullable
    private final ResetConfigurableHandler myResetConfigurableHandler;
    private final Map<Configurable, Boolean> myLeaveState;
    private final Map<Configurable, ConfigurableController> controllers;
    private ConfigurableController lastController;
    private final Breadcrumbs myBreadcrumbs;
    private final JLabel myHeaderLabel;
    private final AbstractAction myResetAllAction;

    SettingsEditor(@NotNull Disposable parent, final @NotNull Project project2, final @NotNull List<? extends ConfigurableGroup> groups, @Nullable Configurable configurable, @Nullable String filter2, @Nullable Supplier<JButton> helpButtonSupplier, boolean isModal, @NotNull ISettingsTreeViewFactory factory, @NotNull SpotlightPainterFactory spotlightPainterFactory) {
        String id2;
        if (parent == null) {
            SettingsEditor.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            SettingsEditor.$$$reportNull$$$0(1);
        }
        if (groups == null) {
            SettingsEditor.$$$reportNull$$$0(2);
        }
        if (factory == null) {
            SettingsEditor.$$$reportNull$$$0(3);
        }
        if (spotlightPainterFactory == null) {
            SettingsEditor.$$$reportNull$$$0(4);
        }
        super(parent);
        this.myHistory = new History((Place.Navigator)this);
        this.myNavigatingNow = false;
        this.myLeaveState = new ConcurrentHashMap<Configurable, Boolean>();
        this.controllers = new HashMap<Configurable, ConfigurableController>();
        this.myBreadcrumbs = new Breadcrumbs(){

            protected int getFontStyle(Crumb crumb) {
                return 1;
            }
        };
        this.myHeaderLabel = new JLabel();
        this.myResetAllAction = new AbstractAction(UIBundle.message((String)"settings.reset.all.action.name", (Object[])new Object[0])){

            @Override
            public void actionPerformed(ActionEvent event) {
                SettingsEditor.this.reset();
            }
        };
        this.myIsModal = isModal;
        this.properties = PropertiesComponent.getInstance((Project)project2);
        this.settings = new Settings(groups){

            @Override
            @NotNull
            protected Promise<? super Object> selectImpl(Configurable configurable) {
                SettingsEditor.this.filter.update(null);
                Promise<? super Object> promise = SettingsEditor.this.treeView.select(configurable);
                if (promise == null) {
                    3.$$$reportNull$$$0(0);
                }
                return promise;
            }

            @Override
            @Nullable
            protected Configurable getConfigurableWithInitializedUiComponentImpl(@Nullable Configurable configurable, boolean initializeUiComponentIfNotYet) {
                JComponent content2 = SettingsEditor.this.editor.getContent(configurable);
                if (!initializeUiComponentIfNotYet || content2 != null) {
                    return content2 == null ? null : configurable;
                }
                SettingsEditor.this.editor.readContent(configurable);
                return configurable;
            }

            @Override
            protected void checkModifiedImpl(@NotNull Configurable configurable) {
                if (configurable == null) {
                    3.$$$reportNull$$$0(1);
                }
                SettingsEditor.this.checkModified(configurable);
            }

            @Override
            protected void setSearchText(String search) {
                SettingsEditor.this.filter.update(search);
            }

            @Override
            public void revalidate() {
                SettingsEditor.this.editor.requestUpdate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/options/newEditor/SettingsEditor$3";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "configurable";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "selectImpl";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/options/newEditor/SettingsEditor$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "checkModifiedImpl";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        };
        this.search = new SettingsSearch(){

            @Override
            void onTextKeyEvent(KeyEvent event) {
                SettingsEditor.this.treeView.getTree().processKeyEvent(event);
            }
        };
        JPanel searchPanel = new JPanel((LayoutManager)new VerticalLayout(0));
        if (this.myIsModal) {
            searchPanel.add("CENTER", (Component)((Object)this.search));
        }
        this.filter = new SettingsFilter(project2, groups, this.search, this.coroutineScope){

            @Override
            protected Configurable getConfigurable(SimpleNode node) {
                return SettingsTreeView.getConfigurable(node);
            }

            @Override
            protected SimpleNode findNode(Configurable configurable) {
                return SettingsEditor.this.treeView.findNode(configurable);
            }

            @Override
            protected void updateSpotlight(boolean now) {
                if (!SettingsEditor.this.isDisposed && SettingsEditor.this.spotlightPainter != null) {
                    if (!now) {
                        SettingsEditor.this.spotlightPainter.updateLater();
                    } else {
                        SettingsEditor.this.spotlightPainter.updateNow();
                    }
                }
            }
        };
        this.filter.context.addColleague(new OptionsEditorColleague(){

            @Override
            @NotNull
            public Promise<? super Object> onSelected(@Nullable Configurable configurable, Configurable oldConfigurable) {
                if (configurable != null) {
                    SettingsEditor.this.properties.setValue(SettingsEditor.SELECTED_CONFIGURABLE, ConfigurableVisitor.getId(configurable));
                    if (!SettingsEditor.this.myIsModal) {
                        if (!SettingsEditor.this.myNavigatingNow && oldConfigurable != null) {
                            IdeDocumentHistory documentHistory = IdeDocumentHistory.getInstance(project2);
                            if (SettingsEditor.this.myResetConfigurableHandler != null) {
                                SettingsEditor.this.myResetConfigurableHandler.scheduleConfigurableReset(oldConfigurable);
                            }
                            CommandProcessor.getInstance().executeCommand(project2, () -> documentHistory.onSelectionChanged(), "ConfigurableChange", null);
                        }
                    } else {
                        SettingsEditor.this.myHistory.pushQueryPlace();
                    }
                    SettingsEditor.this.loadingDecorator.startLoading(false);
                }
                if (oldConfigurable != null) {
                    SettingsEditor.this.checkModified(oldConfigurable);
                    if (!SettingsEditor.this.myIsModal) {
                        SettingsEditor.this.myLeaveState.put(oldConfigurable, oldConfigurable.isModified());
                    }
                }
                Promise<? super Object> result2 = SettingsEditor.this.editor.select(configurable);
                result2.onSuccess(it -> {
                    SettingsEditor.this.updateController(configurable);
                    SettingsEditor.this.loadingDecorator.stopLoading();
                    SettingsEditor.this.myNavigatingNow = false;
                });
                Promise<? super Object> promise = result2;
                if (promise == null) {
                    6.$$$reportNull$$$0(0);
                }
                return promise;
            }

            @Override
            @NotNull
            public Promise<? super Object> onModifiedAdded(Configurable configurable) {
                return this.updateIfCurrent(configurable);
            }

            @Override
            @NotNull
            public Promise<? super Object> onModifiedRemoved(Configurable configurable) {
                return this.updateIfCurrent(configurable);
            }

            @Override
            @NotNull
            public Promise<? super Object> onErrorsChanged() {
                return this.updateIfCurrent(SettingsEditor.this.filter.context.getCurrentConfigurable());
            }

            @NotNull
            private Promise<? super Object> updateIfCurrent(@Nullable Configurable configurable) {
                if (configurable != null && configurable == SettingsEditor.this.filter.context.getCurrentConfigurable()) {
                    SettingsEditor.this.updateStatus(configurable);
                    Promise promise = Promises.resolvedPromise();
                    if (promise == null) {
                        6.$$$reportNull$$$0(1);
                    }
                    return promise;
                }
                Promise promise = Promises.cancelledPromise();
                if (promise == null) {
                    6.$$$reportNull$$$0(2);
                }
                return promise;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/openapi/options/newEditor/SettingsEditor$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "onSelected";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "updateIfCurrent";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        });
        this.treeView = factory.createTreeView(this.filter, groups);
        this.treeView.getTree().addKeyListener((KeyListener)this.search);
        this.editor = new ConfigurableEditor(this, null){

            @Override
            protected boolean apply() {
                SettingsEditor.this.checkModified(SettingsEditor.this.filter.context.getCurrentConfigurable());
                if (SettingsEditor.this.filter.context.getModified().isEmpty()) {
                    return true;
                }
                HashSet<String> modifiedIds = new HashSet<String>();
                LinkedHashMap<Configurable, ConfigurationException> map2 = new LinkedHashMap<Configurable, ConfigurationException>();
                for (Configurable configurable : SettingsEditor.this.filter.context.getModified()) {
                    ConfigurationException exception = ConfigurableEditor.apply(configurable);
                    if (exception != null) {
                        map2.put(configurable, exception);
                        continue;
                    }
                    if (configurable.isModified()) continue;
                    SettingsEditor.this.filter.context.fireModifiedRemoved(configurable, null);
                    modifiedIds.add(ConfigurableVisitor.getId(configurable));
                }
                SettingsEditor.this.search.updateToolTipText();
                SettingsEditor.this.filter.context.fireErrorsChanged(map2, null);
                if (!map2.isEmpty()) {
                    Configurable targetConfigurable = (Configurable)map2.keySet().iterator().next();
                    ConfigurationException exception = (ConfigurationException)((Object)map2.get(targetConfigurable));
                    Configurable originator = exception.getOriginator();
                    if (originator != null) {
                        targetConfigurable = originator;
                    }
                    SettingsEditor.this.treeView.select(targetConfigurable);
                    return false;
                }
                SettingsEditor.this.updateStatus(SettingsEditor.this.filter.context.getCurrentConfigurable());
                ((SettingsDialogListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(SettingsDialogListener.TOPIC)).afterApply(SettingsEditor.this, modifiedIds);
                return true;
            }

            @Override
            void updateCurrent(Configurable configurable, boolean reset) {
                if (reset && configurable != null) {
                    SettingsEditor.this.filter.context.fireReset(configurable);
                }
                SettingsEditor.this.checkModified(configurable);
            }

            @Override
            void postUpdateCurrent(Configurable configurable) {
                Boolean leaveState;
                if (!SettingsEditor.this.myIsModal && configurable != null && (leaveState = SettingsEditor.this.myLeaveState.remove(configurable)) == Boolean.FALSE) {
                    configurable.reset();
                }
            }

            @Override
            void openLink(Configurable configurable) {
                SettingsEditor.this.settings.select(configurable);
            }
        };
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(SettingsDialogListener.TOPIC, (Object)new SettingsDialogListener(){

            @Override
            public void afterApply(@NotNull SettingsEditor settingsEditor, @NotNull @NotNull Set<@NotNull String> modifiedConfigurableIds) {
                if (settingsEditor == null) {
                    8.$$$reportNull$$$0(0);
                }
                if (modifiedConfigurableIds == null) {
                    8.$$$reportNull$$$0(1);
                }
                if (settingsEditor == SettingsEditor.this) {
                    return;
                }
                for (String id2 : modifiedConfigurableIds) {
                    Configurable conf = ConfigurableVisitor.findById(id2, groups);
                    if (conf == null) continue;
                    SettingsEditor.this.checkModified(conf);
                }
                for (Configurable modifiedConfigurable : SettingsEditor.this.filter.context.getModified()) {
                    String confId = ConfigurableVisitor.getId(modifiedConfigurable);
                    if (confId.equals(SettingsEditor.this.getSelectedConfigurableId()) || !modifiedConfigurableIds.contains(confId)) continue;
                    modifiedConfigurable.reset();
                    SettingsEditor.this.filter.context.fireModifiedRemoved(modifiedConfigurable, null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "settingsEditor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "modifiedConfigurableIds";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/options/newEditor/SettingsEditor$8";
                objectArray[2] = "afterApply";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.loadingDecorator = new LoadingDecorator((JComponent)this.editor, (Disposable)this, 10, true);
        this.loadingDecorator.setOverlayBackground(LoadingDecorator.OVERLAY_BACKGROUND);
        this.myBanner = new ConfigurableEditorBanner(this.editor.getResetAction(), (JComponent)(this.myIsModal ? this.myBreadcrumbs : this.myHeaderLabel));
        searchPanel.setBorder((Border)JBUI.Borders.empty((int)7, (int)5, (int)6, (int)5));
        this.myBanner.setBorder((Border)JBUI.Borders.empty((int)11, (int)6, (int)0, (int)10));
        this.search.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        searchPanel.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        JPanel left = new JPanel(new BorderLayout());
        left.add("Center", this.treeView);
        JPanel right = new JPanel(new BorderLayout());
        right.add("Center", this.loadingDecorator.getComponent());
        this.mySplitter = new OnePixelSplitter(false, this.properties.getFloat(SPLITTER_PROPORTION, 0.2f));
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.mySplitter.setLackOfSpaceStrategy(Splitter.LackOfSpaceStrategy.HONOR_THE_FIRST_MIN_SIZE);
        this.mySplitter.setFirstComponent((JComponent)left);
        if (!this.myIsModal) {
            if (IdeFrameDecorator.Companion.isCustomDecorationActive()) {
                this.mySplitter.getDivider().setOpaque(false);
            }
            if (helpButtonSupplier != null) {
                JButton helpButton = helpButtonSupplier.get();
                this.mySplitter.setSecondComponent(SettingsDialogExtensionsKt.paneWithCorner(this, right, helpButton));
            } else {
                this.mySplitter.setSecondComponent((JComponent)right);
            }
            RelativeFont.HUGE.install((Component)this.myHeaderLabel);
            RelativeFont.BOLD.install((Component)this.myHeaderLabel);
            this.myHeaderLabel.setAlignmentY(0.5f);
            this.myHeaderLabel.setBorder(JBUI.Borders.empty((int)8));
            right.add("North", this.myBanner);
            this.myBanner.setBorder((Border)JBUI.Borders.empty((int)8, (int)5));
            this.mySplitter.setDividerPositionStrategy(Splitter.DividerPositionStrategy.KEEP_FIRST_SIZE);
            this.add("Center", (Component)SettingsDialogExtensionsKt.createWrapperPanel(this, this.mySplitter));
        } else {
            this.mySplitter.setSecondComponent((JComponent)right);
            right.add("North", this.withHistoryToolbar(this.myBanner));
            left.add("North", searchPanel);
            this.editor.setPreferredSize((Dimension)JBUI.size((int)800, (int)600));
            this.add("Center", (Component)this.mySplitter);
        }
        this.myResetConfigurableHandler = this.myIsModal ? null : new ResetConfigurableHandler(project2, this.filter.context, this.editor.coroutineScope, parent);
        this.spotlightPainter = spotlightPainterFactory.createSpotlightPainter(project2, this.editor, this, (Function1<? super SpotlightPainter, Unit>)((Function1)painter -> {
            Configurable currentConfigurable = this.filter.context.getCurrentConfigurable();
            if (this.treeView.getTree().hasFocus() || this.search.getTextEditor().hasFocus()) {
                painter.update(this.filter, currentConfigurable, this.editor.getContent(currentConfigurable));
            }
            return Unit.INSTANCE;
        }));
        if (configurable == null && (configurable = ConfigurableVisitor.findById((id2 = this.properties.getValue(SELECTED_CONFIGURABLE)) != null ? id2 : "preferences.lookFeel", groups)) == null) {
            configurable = ConfigurableVisitor.find(ConfigurableVisitor.ALL, groups);
        }
        this.treeView.select(configurable).onProcessed(it -> this.filter.update(filter2));
        Disposer.register((Disposable)this, (Disposable)this.treeView);
        this.installSpotlightRemover();
        this.search.getTextEditor().addActionListener(event -> this.treeView.select(this.filter.context.getCurrentConfigurable()).onProcessed(o -> this.requestFocusToEditor()));
        for (ConfigurableGroup configurableGroup : groups) {
            if (!(configurableGroup instanceof MutableConfigurableGroup)) continue;
            MutableConfigurableGroup mutable = (MutableConfigurableGroup)configurableGroup;
            Disposer.register((Disposable)this, (Disposable)mutable);
            mutable.addListener(this.createReloadListener(groups));
        }
    }

    @ApiStatus.Internal
    public void select(Configurable configurable) {
        this.treeView.select(configurable);
        this.editor.select(configurable);
    }

    boolean isSidebarVisible() {
        return this.mySplitter.getFirstComponent().isVisible();
    }

    void setSidebarVisible(boolean visible) {
        this.mySplitter.getFirstComponent().setVisible(visible);
    }

    @ApiStatus.Internal
    @NotNull
    public SettingsTreeView getTreeView() {
        SettingsTreeView settingsTreeView = this.treeView;
        if (settingsTreeView == null) {
            SettingsEditor.$$$reportNull$$$0(5);
        }
        return settingsTreeView;
    }

    SettingsSearch getSearch() {
        return this.search;
    }

    @NotNull
    private MutableConfigurableGroup.Listener createReloadListener(final List<? extends ConfigurableGroup> groups) {
        return new MutableConfigurableGroup.Listener(){

            @Override
            public void handleUpdate() {
                Configurable candidate;
                Configurable selected = SettingsEditor.this.editor.getConfigurable();
                String id2 = selected instanceof SearchableConfigurable ? ((SearchableConfigurable)selected).getId() : null;
                SettingsEditor.this.editor.reload();
                SettingsEditor.this.filter.reload();
                SettingsEditor.this.controllers.clear();
                SettingsEditor.this.lastController = null;
                Configurable configurable = candidate = id2 == null ? null : ConfigurableVisitor.findById(id2, groups);
                if (candidate == null) {
                    candidate = ConfigurableVisitor.findById("preferences.pluginManager", groups);
                }
                SettingsEditor.this.editor.init(candidate, false);
                SettingsEditor.this.treeView.reloadWithSelection(candidate);
                SettingsEditor.this.settings.reload();
                SettingsEditor.this.invalidate();
                SettingsEditor.this.repaint();
            }
        };
    }

    private void requestFocusToEditor() {
        JComponent component2 = this.editor.getPreferredFocusedComponent();
        if (component2 != null) {
            IdeFocusManager.findInstanceByComponent((Component)component2).requestFocus((Component)component2, true);
        }
    }

    private void installSpotlightRemover() {
        FocusAdapter spotlightRemover = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Component comp = e.getOppositeComponent();
                if (comp == SettingsEditor.this.search.getTextEditor() || comp == SettingsEditor.this.treeView.getTree()) {
                    return;
                }
                SettingsEditor.this.spotlightPainter.update(null, null, null);
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (!StringUtil.isEmpty((String)SettingsEditor.this.search.getText())) {
                    SettingsEditor.this.spotlightPainter.updateNow();
                }
            }
        };
        this.treeView.getTree().addFocusListener((FocusListener)spotlightRemover);
        this.search.getTextEditor().addFocusListener((FocusListener)spotlightRemover);
    }

    private JComponent withHistoryToolbar(JComponent component2) {
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.add(ActionUtil.copyFrom((AnAction)new BackAction(), (String)"Back"));
        group2.add(ActionUtil.copyFrom((AnAction)new ForwardAction(), (String)"Forward"));
        JComponent toolbar2 = ActionUtil.createToolbarComponent((JComponent)this, (String)"SettingsHistory", (ActionGroup)group2, (boolean)true);
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        panel2.add((Component)component2, gbc);
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        gbc.insets = JBUI.insets((int)8, (int)2, (int)0, (int)0);
        panel2.add((Component)toolbar2, gbc);
        return panel2;
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            SettingsEditor.$$$reportNull$$$0(6);
        }
        place.putPath(SELECTED_CONFIGURABLE, (Object)this.properties.getValue(SELECTED_CONFIGURABLE));
    }

    @NotNull
    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        Object path = place == null ? null : place.getPath(SELECTED_CONFIGURABLE);
        String id2 = path instanceof String ? (String)path : null;
        ActionCallback actionCallback = this.settings.select(id2 == null ? null : this.settings.find(id2));
        if (actionCallback == null) {
            SettingsEditor.$$$reportNull$$$0(7);
        }
        return actionCallback;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            SettingsEditor.$$$reportNull$$$0(8);
        }
        if (this.myIsModal) {
            sink.set(History.KEY, (Object)this.myHistory);
        }
        sink.set(Settings.KEY, (Object)this.settings);
        sink.set(SearchTextField.KEY, (Object)this.search);
    }

    @Override
    protected void disposeOnce() {
        if (this.properties == null || this.mySplitter == null) {
            return;
        }
        this.properties.setValue(SPLITTER_PROPORTION, this.mySplitter.getProportion(), 0.2f);
    }

    @Override
    protected Action getApplyAction() {
        return this.editor.getApplyAction();
    }

    @Override
    protected Action getResetAction() {
        return this.myResetAllAction;
    }

    private void reset() {
        this.checkModified(this.filter.context.getCurrentConfigurable());
        for (Configurable configurable : this.filter.context.getModified()) {
            this.filter.context.fireReset(configurable);
            configurable.reset();
        }
    }

    @Override
    protected String getHelpTopic() {
        Configurable configurable = this.filter.context.getCurrentConfigurable();
        while (configurable != null) {
            String topic = configurable.getHelpTopic();
            if (topic != null) {
                return topic;
            }
            configurable = this.filter.context.getParentConfigurable(configurable);
        }
        return "preferences";
    }

    @Override
    protected boolean apply() {
        return this.editor.apply();
    }

    @Override
    protected boolean cancel(AWTEvent source) {
        if (source instanceof KeyEvent && this.filter.context.isHoldingFilter) {
            this.search.setText("");
            return false;
        }
        for (Configurable configurable : this.filter.context.getModified()) {
            configurable.cancel();
        }
        return super.cancel(source);
    }

    @Override
    protected JComponent getPreferredFocusedComponent() {
        return this.treeView != null ? this.treeView.getTree() : this.editor;
    }

    void setHelpTooltip(@NotNull JButton helpButton) {
        if (helpButton == null) {
            SettingsEditor.$$$reportNull$$$0(9);
        }
        if (UISettings.isIdeHelpTooltipEnabled()) {
            new HelpTooltip().setDescription(ActionsBundle.actionDescription((String)"HelpTopics")).installOn((JComponent)helpButton);
        }
    }

    @Nullable Collection<@NlsContexts.ConfigurableName String> getPathNames() {
        return this.treeView == null ? null : this.treeView.getPathNames(this.filter.context.getCurrentConfigurable());
    }

    public void addOptionsListener(OptionsEditorColleague colleague) {
        this.filter.context.addColleague(colleague);
    }

    void updateStatus(Configurable configurable) {
        this.filter.updateSpotlight(configurable == null);
        if (this.editor != null) {
            ConfigurationException exception = this.filter.context.getErrors().get(configurable);
            boolean isModified2 = this.isModified();
            this.editor.getApplyAction().setEnabled(isModified2);
            this.myResetAllAction.setEnabled(isModified2);
            this.editor.getResetAction().setEnabled(this.filter.context.isModified(configurable) || exception != null);
            this.editor.setError(exception);
            this.editor.revalidate();
        }
        if (configurable != null) {
            EdtScheduler.getInstance().schedule(300, () -> {
                if (!this.isDisposed && this.spotlightPainter != null) {
                    this.spotlightPainter.updateNow();
                }
            });
        }
    }

    public boolean isModified() {
        return !this.filter.context.getModified().isEmpty();
    }

    public void setNavigatingNow() {
        this.myNavigatingNow = true;
    }

    public String getSelectedConfigurableId() {
        Configurable configurable = this.editor.getConfigurable();
        if (configurable == null) {
            return null;
        }
        return ConfigurableVisitor.getId(configurable);
    }

    private void updateController(@Nullable Configurable configurable) {
        ConfigurableController controller;
        Project project2 = this.treeView.findConfigurableProject(configurable);
        this.myBanner.setProjectText(project2 != null ? SettingsEditor.getProjectText(project2) : null);
        Collection<@NlsContexts.ConfigurableName String> pathNames = this.treeView.getPathNames(configurable);
        ArrayList<Crumb.Impl> crumbs = new ArrayList<Crumb.Impl>();
        if (!pathNames.isEmpty()) {
            List<Action> actions = CopySettingsPathAction.createSwingActions(() -> pathNames);
            for (String name2 : pathNames) {
                crumbs.add(new Crumb.Impl(null, name2, null, actions));
            }
        }
        this.myBreadcrumbs.setCrumbs(crumbs);
        this.myHeaderLabel.setText(configurable == null ? "" : configurable.getDisplayName());
        if (this.lastController != null) {
            this.lastController.setBanner(null);
            this.lastController = null;
        }
        if ((controller = ConfigurableController.getOrCreate(configurable, this.controllers)) != null) {
            this.lastController = controller;
            controller.setBanner(this.myBanner);
        }
    }

    void checkModified(Configurable configurable) {
        Configurable parent = this.filter.context.getParentConfigurable(configurable);
        if (parent != null && ConfigurableWrapper.hasOwnContent((UnnamedConfigurable)parent)) {
            this.checkModifiedForItem(parent);
            for (Configurable child : this.filter.context.getChildren(parent)) {
                this.checkModifiedForItem(child);
            }
        } else if (configurable != null) {
            this.checkModifiedForItem(configurable);
        }
        this.updateStatus(configurable);
    }

    private void checkModifiedForItem(@NotNull Configurable configurable) {
        JComponent component2;
        if (configurable == null) {
            SettingsEditor.$$$reportNull$$$0(10);
        }
        if ((component2 = this.editor.getContent(configurable)) == null && ConfigurableWrapper.hasOwnContent((UnnamedConfigurable)configurable)) {
            component2 = this.editor.readContent(configurable);
        }
        if (component2 != null) {
            this.checkModifiedInternal(configurable);
        }
    }

    private void checkModifiedInternal(Configurable configurable) {
        if (configurable.isModified()) {
            this.filter.context.fireModifiedAdded(configurable, null);
        } else if (!this.filter.context.getErrors().containsKey(configurable)) {
            this.filter.context.fireModifiedRemoved(configurable, null);
        }
    }

    @NotNull
    @Nls
    private static String getProjectText(@NotNull Project project2) {
        if (project2 == null) {
            SettingsEditor.$$$reportNull$$$0(11);
        }
        IdeUICustomization customization = IdeUICustomization.getInstance();
        String string = project2.isDefault() ? customization.projectMessage("configurable.default.project.tooltip", new Object[0]) : customization.projectMessage("configurable.current.project.tooltip", new Object[0]);
        if (string == null) {
            SettingsEditor.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spotlightPainterFactory";
                break;
            }
            case 5: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/newEditor/SettingsEditor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpButton";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/newEditor/SettingsEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeView";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "navigateTo";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 7: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "queryPlace";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setHelpTooltip";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkModifiedForItem";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getProjectText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 12 -> new IllegalStateException(string);
        };
    }
}

