/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.concurrency.ContextAwareRunnable;
import com.intellij.ide.ui.laf.darcula.ui.DarculaProgressBarUI;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.util.PotemkinProgress;
import com.intellij.openapi.progress.util.ProgressDialogUI;
import com.intellij.openapi.progress.util.ProgressDialogWrapperKt;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.impl.GlassPaneDialogWrapperPeer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.PopupBorder;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ProgressBarUI;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 52\u00020\u0001:\u000256B0\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\r\u0010\u0006\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010 \u001a\u00020\u0011H\u0002J\b\u0010!\u001a\u00020\u0011H\u0016J\u0006\u0010&\u001a\u00020\u0018J\b\u0010'\u001a\u0004\u0018\u00010\u001bJ\u0006\u0010(\u001a\u00020\u0011J\u000e\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u0005J\u0006\u0010+\u001a\u00020\u0011J\u0006\u0010,\u001a\u00020\u0011J\u0006\u0010-\u001a\u00020\u0011J\u0006\u0010.\u001a\u00020\u0011J\u0006\u0010/\u001a\u00020\u0011J\b\u00100\u001a\u00020\u0005H\u0002J\u0010\u00101\u001a\u00020\u001b2\u0006\u00102\u001a\u00020\nH\u0002J\u0014\u00103\u001a\u000604R\u00020\u00002\u0006\u00102\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001e\u0010\u001fR\u0011\u0010\"\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u00067"}, d2={"Lcom/intellij/openapi/progress/util/ProgressDialog;", "Lcom/intellij/openapi/Disposable;", "progressWindow", "Lcom/intellij/openapi/progress/util/ProgressWindow;", "shouldShowBackground", "", "cancelText", "", "Lorg/jetbrains/annotations/Nls;", "parentWindow", "Ljava/awt/Window;", "<init>", "(Lcom/intellij/openapi/progress/util/ProgressWindow;ZLjava/lang/String;Ljava/awt/Window;)V", "lastTimeDrawn", "", "updateRequests", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "cancelButtonEnabledRequests", "wasShown", "startMillis", "ui", "Lcom/intellij/openapi/progress/util/ProgressDialogUI;", "repaintRunnable", "Ljava/lang/Runnable;", "repaintedFlag", "popup", "Lcom/intellij/openapi/ui/DialogWrapper;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "getCoroutineScope$annotations", "()V", "doRepaint", "dispose", "panel", "Ljavax/swing/JPanel;", "getPanel", "()Ljavax/swing/JPanel;", "getRepaintRunnable", "getPopup", "cancel", "enableCancelButtonIfNeeded", "enable", "scheduleUpdate", "background", "hide", "hideImmediately", "show", "isWriteActionProgress", "createDialog", "window", "createDialogPrevious", "Lcom/intellij/openapi/progress/util/ProgressDialog$MyDialogWrapper;", "Companion", "MyDialogWrapper", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class ProgressDialog
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProgressWindow progressWindow;
    private final boolean shouldShowBackground;
    @Nullable
    private final Window parentWindow;
    private long lastTimeDrawn;
    @NotNull
    private final MutableSharedFlow<Unit> updateRequests;
    @NotNull
    private final MutableSharedFlow<Boolean> cancelButtonEnabledRequests;
    private boolean wasShown;
    private final long startMillis;
    @NotNull
    private final ProgressDialogUI ui;
    @NotNull
    private final Runnable repaintRunnable;
    private boolean repaintedFlag;
    @Nullable
    private DialogWrapper popup;
    @NotNull
    private final CoroutineScope coroutineScope;
    public static final int UPDATE_INTERVAL = 50;

    public ProgressDialog(@NotNull ProgressWindow progressWindow, boolean shouldShowBackground, @Nullable String cancelText, @Nullable Window parentWindow) {
        Intrinsics.checkNotNullParameter((Object)((Object)progressWindow), (String)"progressWindow");
        this.progressWindow = progressWindow;
        this.shouldShowBackground = shouldShowBackground;
        this.parentWindow = parentWindow;
        this.lastTimeDrawn = -1L;
        this.updateRequests = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        this.cancelButtonEnabledRequests = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        this.startMillis = System.currentTimeMillis();
        this.ui = new ProgressDialogUI();
        this.repaintRunnable = this::doRepaint;
        this.repaintedFlag = true;
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)Dispatchers.getDefault()));
        this.ui.getProgressBar().setIndeterminate(this.progressWindow.isIndeterminate());
        JButton cancelButton = this.ui.getCancelButton();
        if (cancelText != null) {
            cancelButton.setText(cancelText);
        }
        if (this.progressWindow.myShouldShowCancel) {
            cancelButton.addActionListener(arg_0 -> ProgressDialog._init_$lambda$0(this, arg_0));
            ActionListener cancelFunction = arg_0 -> ProgressDialog._init_$lambda$1(cancelButton, this, arg_0);
            cancelButton.registerKeyboardAction(cancelFunction, KeyStroke.getKeyStroke(27, 0), 1);
        } else {
            cancelButton.setVisible(false);
        }
        JButton backgroundButton = this.ui.getBackgroundButton();
        if (this.shouldShowBackground) {
            backgroundButton.addActionListener(arg_0 -> ProgressDialog._init_$lambda$2(this, arg_0));
        } else {
            backgroundButton.setVisible(false);
        }
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ProgressDialog this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)com.intellij.platform.util.coroutines.flow.FlowKt.throttle((Flow)((Flow)this.this$0.updateRequests), (long)500L), (Function2)((Function2)new Function2<Unit, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ ProgressDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
                                        ModalityState modalityState = this.this$0.progressWindow.getModalityState();
                                        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"getModalityState(...)");
                                        this.label = 1;
                                        Object object2 = BuildersKt.withContext((CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                            int label;
                                            final /* synthetic */ ProgressDialog this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super(2, $completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        if (!this.this$0.repaintedFlag) {
                                                            return Unit.INSTANCE;
                                                        }
                                                        if (System.currentTimeMillis() > this.this$0.lastTimeDrawn + (long)50) {
                                                            this.this$0.repaintedFlag = false;
                                                            this.this$0.doRepaint();
                                                        } else {
                                                            this.this$0.scheduleUpdate();
                                                        }
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Unit p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ ProgressDialog this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
                        ModalityState modalityState = ModalityState.any();
                        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
                        CoroutineContext anyModalityContext = coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState));
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)anyModalityContext);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)FlowKt.debounce((Flow)((Flow)this.this$0.cancelButtonEnabledRequests), (long)500L), (Function2)((Function2)new Function2<Boolean, Continuation<? super Unit>, Object>(anyModalityContext, this.this$0, null){
                            int label;
                            /* synthetic */ boolean Z$0;
                            final /* synthetic */ CoroutineContext $anyModalityContext;
                            final /* synthetic */ ProgressDialog this$0;
                            {
                                this.$anyModalityContext = $anyModalityContext;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                boolean bl = this.Z$0;
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void isEnabled;
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.Z$0 = isEnabled;
                                        this.label = 1;
                                        Object object2 = BuildersKt.withContext((CoroutineContext)this.$anyModalityContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, isEnabled != false, null){
                                            int label;
                                            final /* synthetic */ ProgressDialog this$0;
                                            final /* synthetic */ boolean $isEnabled;
                                            {
                                                this.this$0 = $receiver;
                                                this.$isEnabled = $isEnabled;
                                                super(2, $completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        this.this$0.ui.getCancelButton().setEnabled(this.$isEnabled);
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.Z$0 = (Boolean)value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(boolean p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        CoroutineContext anyModalityContext = (CoroutineContext)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static /* synthetic */ void getCoroutineScope$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doRepaint() {
        ProgressBarUI progressBarUI;
        this.ui.updateTitle(this.progressWindow.getTitle());
        ProgressDialogUI progressDialogUI = this.ui;
        Object object = this.progressWindow.getText();
        String string = this.progressWindow.getText2();
        Double d = this.progressWindow.isIndeterminate() ? null : Double.valueOf(this.progressWindow.getFraction());
        progressDialogUI.updateProgress(d, (String)object, string);
        JProgressBar progressBar = this.ui.getProgressBar();
        if (progressBar.isShowing() && progressBar.isIndeterminate() && this.isWriteActionProgress() && (progressBarUI = progressBar.getUI()) instanceof DarculaProgressBarUI) {
            ((DarculaProgressBarUI)progressBarUI).updateIndeterminateAnimationIndex(this.startMillis);
        }
        this.lastTimeDrawn = System.currentTimeMillis();
        object = this;
        synchronized (object) {
            boolean bl = false;
            this.repaintedFlag = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    public void dispose() {
        CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
        Disposer.dispose((Disposable)this.ui);
    }

    @NotNull
    public final JPanel getPanel() {
        return this.ui.getPanel();
    }

    @NotNull
    public final Runnable getRepaintRunnable() {
        return this.repaintRunnable;
    }

    @Nullable
    public final DialogWrapper getPopup() {
        return this.popup;
    }

    public final void cancel() {
        this.enableCancelButtonIfNeeded(false);
    }

    public final void enableCancelButtonIfNeeded(boolean enable2) {
        if (this.progressWindow.myShouldShowCancel && !this.cancelButtonEnabledRequests.tryEmit((Object)enable2)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    public final void scheduleUpdate() {
        if (!this.updateRequests.tryEmit((Object)Unit.INSTANCE)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    public final synchronized void background() {
        if (this.shouldShowBackground) {
            this.ui.getBackgroundButton().setEnabled(false);
        }
        this.hide();
    }

    public final void hide() {
        ApplicationManager.getApplication().invokeLater((Runnable)((ContextAwareRunnable)this::hideImmediately), ModalityState.any());
    }

    public final void hideImmediately() {
        if (this.popup != null) {
            DialogWrapper dialogWrapper = this.popup;
            Intrinsics.checkNotNull((Object)dialogWrapper);
            dialogWrapper.close(1);
            this.popup = null;
        }
    }

    public final void show() {
        DialogWrapper popup2;
        if (this.wasShown) {
            return;
        }
        this.wasShown = true;
        if (ApplicationManager.getApplication().isHeadlessEnvironment() || this.parentWindow == null) {
            return;
        }
        if (this.popup != null) {
            DialogWrapper dialogWrapper = this.popup;
            Intrinsics.checkNotNull((Object)dialogWrapper);
            dialogWrapper.close(1);
        }
        this.popup = popup2 = this.createDialog(this.parentWindow);
        popup2.show();
        SwingUtilities.invokeLater(() -> ProgressDialog.show$lambda$0(this));
    }

    private final boolean isWriteActionProgress() {
        return this.progressWindow instanceof PotemkinProgress;
    }

    private final DialogWrapper createDialog(Window window) {
        MyDialogWrapper myDialogWrapper;
        if (Registry.Companion.is("ide.modal.progress.wrapper.refactoring")) {
            return ProgressDialogWrapperKt.createDialogWrapper(this.getPanel(), (Function0<Unit>)((Function0)() -> ProgressDialog.createDialog$lambda$0(this)), window, this.isWriteActionProgress(), this.progressWindow.myProject);
        }
        MyDialogWrapper it = myDialogWrapper = this.createDialogPrevious(window);
        boolean bl = false;
        ProgressDialogWrapperKt.setupProgressDialog(it, this.isWriteActionProgress());
        return myDialogWrapper;
    }

    private final MyDialogWrapper createDialogPrevious(Window window) {
        if (this.isWriteActionProgress()) {
            if (window.isShowing()) {
                return new MyDialogWrapper(this, window){

                    protected boolean useLightPopup() {
                        return false;
                    }

                    protected boolean canRecordDialogId() {
                        return false;
                    }
                };
            }
            Project project2 = this.progressWindow.myProject;
            return new MyDialogWrapper(this, project2){

                protected boolean useLightPopup() {
                    return false;
                }

                protected boolean canRecordDialogId() {
                    return false;
                }
            };
        }
        if (window.isShowing() || Intrinsics.areEqual((Object)window, (Object)JOptionPane.getRootFrame())) {
            return new MyDialogWrapper(window);
        }
        return new MyDialogWrapper(this.progressWindow.myProject);
    }

    private static final void _init_$lambda$0(ProgressDialog this$0, ActionEvent it) {
        this$0.progressWindow.cancel();
    }

    private static final void _init_$lambda$1(JButton $cancelButton, ProgressDialog this$0, ActionEvent it) {
        if ($cancelButton.isEnabled()) {
            this$0.progressWindow.cancel();
        }
    }

    private static final void _init_$lambda$2(ProgressDialog this$0, ActionEvent it) {
        this$0.progressWindow.background();
    }

    private static final void show$lambda$0(ProgressDialog this$0) {
        if (this$0.popup != null) {
            DialogWrapper dialogWrapper = this$0.popup;
            Intrinsics.checkNotNull((Object)dialogWrapper);
            if (!dialogWrapper.isDisposed()) {
                Component originalFocusOwner;
                Window window = SwingUtilities.getWindowAncestor(this$0.ui.getCancelButton());
                if (window != null && (originalFocusOwner = window.getMostRecentFocusOwner()) != null) {
                    DialogWrapper dialogWrapper2 = this$0.popup;
                    Intrinsics.checkNotNull((Object)dialogWrapper2);
                    Disposer.register((Disposable)dialogWrapper2.getDisposable(), () -> ProgressDialog.show$lambda$0$0(originalFocusOwner));
                }
                this$0.ui.getCancelButton().requestFocusInWindow();
                this$0.doRepaint();
            }
        }
    }

    private static final void show$lambda$0$0(Component $originalFocusOwner) {
        $originalFocusOwner.requestFocusInWindow();
    }

    private static final Unit createDialog$lambda$0(ProgressDialog this$0) {
        if (this$0.progressWindow.myShouldShowCancel) {
            this$0.progressWindow.cancel();
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/progress/util/ProgressDialog$Companion;", "", "<init>", "()V", "UPDATE_INTERVAL", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0092\u0004\u0018\u00002\u00020\u0001B\u0013\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0004J \u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0004J\b\u0010\u0012\u001a\u00020\u000eH\u0014J\u001a\u0010\u000b\u001a\u00020\f2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0004J\b\u0010\u0013\u001a\u00020\nH\u0004J\b\u0010\u0014\u001a\u00020\u000eH\u0004J\b\u0010\u0015\u001a\u00020\u0016H\u0004J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0004J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0004\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/progress/util/ProgressDialog$MyDialogWrapper;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/progress/util/ProgressDialog;Lcom/intellij/openapi/project/Project;)V", "parent", "Ljava/awt/Component;", "(Lcom/intellij/openapi/progress/util/ProgressDialog;Ljava/awt/Component;)V", "doCancelAction", "", "createPeer", "Lcom/intellij/openapi/ui/DialogWrapperPeer;", "canBeParent", "", "owner", "Ljava/awt/Window;", "applicationModalIfPossible", "useLightPopup", "init", "isProgressDialog", "createCenterPanel", "Ljavax/swing/JComponent;", "createSouthPanel", "createContentPaneBorder", "Ljavax/swing/border/Border;", "intellij.platform.ide.impl"})
    private class MyDialogWrapper
    extends DialogWrapper {
        public MyDialogWrapper(Project project2) {
            super(project2, false);
            this.init();
        }

        public MyDialogWrapper(Component parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            super(parent, false);
            this.init();
        }

        public final void doCancelAction() {
            if (((ProgressDialog)ProgressDialog.this).progressWindow.myShouldShowCancel) {
                ProgressDialog.this.progressWindow.cancel();
            }
        }

        @NotNull
        protected final DialogWrapperPeer createPeer(@NotNull Component parent, boolean canBeParent) {
            DialogWrapperPeer dialogWrapperPeer;
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            if (this.useLightPopup() && ProgressDialogWrapperKt.areLightPopupsEnabled()) {
                DialogWrapperPeer dialogWrapperPeer2;
                try {
                    dialogWrapperPeer2 = new GlassPaneDialogWrapperPeer((DialogWrapper)this, parent);
                }
                catch (GlassPaneDialogWrapperPeer.GlasspanePeerUnavailableException e) {
                    DialogWrapperPeer dialogWrapperPeer3 = super.createPeer(parent, canBeParent);
                    Intrinsics.checkNotNull((Object)dialogWrapperPeer3);
                    dialogWrapperPeer2 = dialogWrapperPeer3;
                }
                dialogWrapperPeer = dialogWrapperPeer2;
            } else {
                DialogWrapperPeer dialogWrapperPeer4 = super.createPeer(parent, canBeParent);
                Intrinsics.checkNotNull((Object)dialogWrapperPeer4);
                dialogWrapperPeer = dialogWrapperPeer4;
            }
            return dialogWrapperPeer;
        }

        @NotNull
        protected final DialogWrapperPeer createPeer(@NotNull Window owner, boolean canBeParent, boolean applicationModalIfPossible) {
            DialogWrapperPeer dialogWrapperPeer;
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            if (this.useLightPopup() && ProgressDialogWrapperKt.areLightPopupsEnabled()) {
                DialogWrapperPeer dialogWrapperPeer2;
                try {
                    dialogWrapperPeer2 = new GlassPaneDialogWrapperPeer(this);
                }
                catch (GlassPaneDialogWrapperPeer.GlasspanePeerUnavailableException e) {
                    DialogWrapperPeer dialogWrapperPeer3 = super.createPeer(WindowManager.getInstance().suggestParentWindow(((ProgressDialog)ProgressDialog.this).progressWindow.myProject), canBeParent, applicationModalIfPossible);
                    Intrinsics.checkNotNull((Object)dialogWrapperPeer3);
                    dialogWrapperPeer2 = dialogWrapperPeer3;
                }
                dialogWrapperPeer = dialogWrapperPeer2;
            } else {
                DialogWrapperPeer dialogWrapperPeer4 = super.createPeer(WindowManager.getInstance().suggestParentWindow(((ProgressDialog)ProgressDialog.this).progressWindow.myProject), canBeParent, applicationModalIfPossible);
                Intrinsics.checkNotNull((Object)dialogWrapperPeer4);
                dialogWrapperPeer = dialogWrapperPeer4;
            }
            return dialogWrapperPeer;
        }

        protected boolean useLightPopup() {
            return true;
        }

        @NotNull
        protected final DialogWrapperPeer createPeer(@Nullable Project project2, boolean canBeParent) {
            DialogWrapperPeer dialogWrapperPeer;
            try {
                dialogWrapperPeer = new GlassPaneDialogWrapperPeer(project2, this);
            }
            catch (GlassPaneDialogWrapperPeer.GlasspanePeerUnavailableException e) {
                DialogWrapperPeer dialogWrapperPeer2 = super.createPeer(project2, canBeParent);
                Intrinsics.checkNotNull((Object)dialogWrapperPeer2);
                dialogWrapperPeer = dialogWrapperPeer2;
            }
            return dialogWrapperPeer;
        }

        protected final void init() {
            super.init();
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(0);
            ProgressDialog.this.getPanel().setBorder((Border)PopupBorder.Factory.create((boolean)true, (boolean)true));
        }

        protected final boolean isProgressDialog() {
            return true;
        }

        @NotNull
        protected final JComponent createCenterPanel() {
            return ProgressDialog.this.getPanel();
        }

        @Nullable
        protected final JComponent createSouthPanel() {
            return null;
        }

        @Nullable
        protected final Border createContentPaneBorder() {
            return null;
        }
    }
}

