/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.indexing.IndexingBundle;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@ApiStatus.Internal
@ApiStatus.Experimental
public final class DumbModeProgressTitle {
    private final Set<ProgressWindow> myWindowSet;
    private final Collection<@NlsContexts.ProgressTitle @NotNull String> mySubProcessTitles;

    @NotNull
    public static DumbModeProgressTitle getInstance(@NotNull Project project2) {
        if (project2 == null) {
            DumbModeProgressTitle.$$$reportNull$$$0(0);
        }
        DumbModeProgressTitle dumbModeProgressTitle = (DumbModeProgressTitle)project2.getService(DumbModeProgressTitle.class);
        if (dumbModeProgressTitle == null) {
            DumbModeProgressTitle.$$$reportNull$$$0(1);
        }
        return dumbModeProgressTitle;
    }

    public DumbModeProgressTitle(@NotNull Project project2) {
        if (project2 == null) {
            DumbModeProgressTitle.$$$reportNull$$$0(2);
        }
        this.myWindowSet = ConcurrentCollectionFactory.createConcurrentSet();
        this.mySubProcessTitles = Collections.synchronizedSet(new LinkedHashSet());
    }

    @NlsContexts.ProgressTitle
    @NotNull
    public String getDumbModeProgressTitle() {
        String mainMessage = IndexingBundle.message((String)"progress.indexing", (Object[])new Object[0]);
        if (this.mySubProcessTitles.isEmpty()) {
            String string = mainMessage;
            if (string == null) {
                DumbModeProgressTitle.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = (String)this.mySubProcessTitles.stream().collect(NlsMessages.joiningNarrowAnd());
        if (string == null) {
            DumbModeProgressTitle.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    private static ProgressWindow castProgress(@NotNull ProgressIndicator indicator2) {
        if (indicator2 == null) {
            DumbModeProgressTitle.$$$reportNull$$$0(5);
        }
        if (indicator2 instanceof ProgressWindow) {
            return (ProgressWindow)indicator2;
        }
        return null;
    }

    public void attachDumbModeProgress(@NotNull ProgressIndicator indicator2) {
        ProgressWindow wnd;
        if (indicator2 == null) {
            DumbModeProgressTitle.$$$reportNull$$$0(6);
        }
        if ((wnd = DumbModeProgressTitle.castProgress(indicator2)) != null) {
            this.myWindowSet.add(wnd);
            wnd.setTitle(this.getDumbModeProgressTitle());
        }
    }

    public void removeDumbModeProgress(@NotNull ProgressIndicator indicator2) {
        ProgressWindow wnd;
        if (indicator2 == null) {
            DumbModeProgressTitle.$$$reportNull$$$0(7);
        }
        if ((wnd = DumbModeProgressTitle.castProgress(indicator2)) != null) {
            this.myWindowSet.remove((Object)wnd);
        }
    }

    public void attachProgressTitleText(@NotNull @Nls String textAddon, @NotNull Disposable lifetime) {
        if (textAddon == null) {
            DumbModeProgressTitle.$$$reportNull$$$0(8);
        }
        if (lifetime == null) {
            DumbModeProgressTitle.$$$reportNull$$$0(9);
        }
        this.mySubProcessTitles.add(textAddon);
        this.updateAllRegisteredProgressWindows();
        Disposer.register((Disposable)lifetime, () -> {
            if (this.mySubProcessTitles.remove(textAddon)) {
                this.updateAllRegisteredProgressWindows();
            }
        });
    }

    private void updateAllRegisteredProgressWindows() {
        for (ProgressWindow wnd : this.myWindowSet) {
            wnd.setTitle(this.getDumbModeProgressTitle());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/project/DumbModeProgressTitle";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAddon";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lifetime";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/project/DumbModeProgressTitle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDumbModeProgressTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "castProgress";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "attachDumbModeProgress";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeDumbModeProgress";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "attachProgressTitleText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4 -> new IllegalStateException(string);
        };
    }
}

