/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ChildInfoImpl
implements ChildInfo {
    public static final int UNKNOWN_ID_YET = -238;
    private static final FileAttributes UNKNOWN = new FileAttributes(false, false, false, false, 0L, 0L, false);
    private final FileAttributes attributes;
    private final int id;
    private final int nameId;
    private final String symLinkTarget;
    private final ChildInfo @Nullable(value="null means children are unknown") [] children;

    public ChildInfoImpl(int nameId, @Nullable FileAttributes attributes, ChildInfo @Nullable [] children2, @Nullable String symLinkTarget) {
        this(-238, nameId, attributes, children2, symLinkTarget);
    }

    public ChildInfoImpl(int fileId, int nameId, @Nullable FileAttributes attributes, ChildInfo @Nullable [] children2, @Nullable String symLinkTarget) {
        this.attributes = null == attributes ? UNKNOWN : attributes;
        this.id = fileId;
        this.nameId = nameId;
        this.symLinkTarget = symLinkTarget;
        this.children = children2;
        if (fileId <= 0 && fileId != -238) {
            int parentId = FSRecords.getInstance().getParent(fileId);
            throw new IllegalArgumentException("fileId is invalid: fileId=" + fileId + ", parentId=" + parentId + ", nameId=" + nameId);
        }
        if (nameId <= 0 && nameId != -238) {
            int parentId = FSRecords.getInstance().getParent(fileId);
            throw new IllegalArgumentException("nameId is invalid: fileId=" + fileId + ", parentId=" + parentId + ", nameId=" + nameId);
        }
    }

    public int getId() {
        return this.id;
    }

    @NotNull
    public CharSequence getName() {
        String string = ((PersistentFSImpl)PersistentFS.getInstance()).getNameByNameId(this.nameId);
        if (string == null) {
            ChildInfoImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    public int getNameId() {
        return this.nameId;
    }

    public String getSymlinkTarget() {
        return this.symLinkTarget;
    }

    public ChildInfo @Nullable [] getChildren() {
        return this.children;
    }

    @Nullable
    public FileAttributes getFileAttributes() {
        return this.attributes == UNKNOWN ? null : this.attributes;
    }

    public @PersistentFS.Attributes int getFileAttributeFlags() {
        if (this.attributes == UNKNOWN) {
            return -1;
        }
        boolean isDirectory = this.attributes.isDirectory();
        boolean isWritable = this.attributes.isWritable();
        boolean isSymLink = this.attributes.isSymLink();
        boolean isSpecial = this.attributes.isSpecial();
        boolean isHidden = this.attributes.isHidden();
        FileAttributes.CaseSensitivity sensitivity = this.attributes.areChildrenCaseSensitive();
        boolean isCaseSensitive = sensitivity.isSensitive();
        boolean isCaseSensitivityKnown = sensitivity.isKnown();
        return PersistentFSImpl.fileAttributesToFlags(isDirectory, isWritable, isSymLink, isSpecial, isHidden, isCaseSensitivityKnown, isCaseSensitive);
    }

    private ChildInfoImpl(FileAttributes attributes, int id2, int nameId, String symLinkTarget, ChildInfo @Nullable [] children2) {
        this.attributes = attributes;
        this.id = id2;
        this.nameId = nameId;
        this.symLinkTarget = symLinkTarget;
        this.children = children2;
    }

    @NotNull
    public ChildInfo withChildren(ChildInfo @Nullable [] children2) {
        return new ChildInfoImpl(this.attributes, this.id, this.nameId, this.symLinkTarget, children2);
    }

    @NotNull
    public ChildInfo withNameId(int nameId) {
        return new ChildInfoImpl(this.attributes, this.id, nameId, this.symLinkTarget, this.children);
    }

    @NotNull
    public ChildInfo withId(int id2) {
        return new ChildInfoImpl(this.attributes, id2, this.nameId, this.symLinkTarget, this.children);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ChildInfoImpl info = (ChildInfoImpl)o;
        return this.id == info.id && this.nameId == info.nameId && Objects.equals(this.symLinkTarget, info.symLinkTarget) && Arrays.equals(this.children, info.children);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.id, this.nameId, this.symLinkTarget, Arrays.hashCode(this.children));
    }

    public String toString() {
        return "\"" + String.valueOf(this.nameId > 0 ? this.getName() : "?") + "\"; nameId: " + this.nameId + "; id: " + this.id + " (" + (this.attributes == UNKNOWN ? "unknown" : this.attributes.toString()) + ")" + (String)(this.children == null ? "" : "\n  " + StringUtil.join((Object[])this.children, info -> info.toString().replaceAll("\n", "\n  "), (String)"\n  "));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/ChildInfoImpl", "getName"));
    }
}

