/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.vfs.newvfs.AttributeInputStream;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStreamImpl;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSConnection;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSRecordsStorage;
import com.intellij.openapi.vfs.newvfs.persistent.VFSAttributesStorage;
import com.intellij.platform.util.io.storages.blobstorage.RecordAlreadyDeletedException;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.CleanableStorage;
import com.intellij.util.io.CorruptedException;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.io.UnsyncByteArrayOutputStream;
import com.intellij.util.io.blobstorage.ByteBufferReader;
import com.intellij.util.io.blobstorage.StreamlinedBlobStorage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class AttributesStorageOverBlobStorage
implements VFSAttributesStorage,
CleanableStorage {
    public static final int MAX_SUPPORTED_ATTRIBUTE_ID = 16384;
    public static final boolean IGNORE_ALREADY_DELETED_ERRORS = SystemProperties.getBooleanProperty((String)"vfs.attributes.ignore-already-deleted-errors", (boolean)true);
    @NotNull
    private final StreamlinedBlobStorage storage;

    public AttributesStorageOverBlobStorage(@NotNull StreamlinedBlobStorage storage) {
        if (storage == null) {
            AttributesStorageOverBlobStorage.$$$reportNull$$$0(0);
        }
        this.storage = storage;
    }

    @Override
    public int getVersion() throws IOException {
        return this.storage.getDataFormatVersion();
    }

    @Override
    public void setVersion(int version) throws IOException {
        this.storage.setDataFormatVersion(version);
    }

    @Override
    @Nullable
    public AttributeInputStream readAttribute(@NotNull PersistentFSConnection connection, int fileId, @NotNull FileAttribute attribute) throws IOException {
        if (connection == null) {
            AttributesStorageOverBlobStorage.$$$reportNull$$$0(1);
        }
        if (attribute == null) {
            AttributesStorageOverBlobStorage.$$$reportNull$$$0(2);
        }
        PersistentFSConnection.ensureIdIsValid(fileId);
        int attributeRecordId = connection.records().getAttributeRecordId(fileId);
        if (attributeRecordId == 0) {
            return null;
        }
        if (attributeRecordId < 0) {
            throw new IllegalStateException("file[id: " + fileId + "]: attributeRecordId[=" + attributeRecordId + "] is negative, must be >=0");
        }
        int encodedAttributeId = connection.enumerateAttributeId(attribute.getId());
        byte[] attributeValueBytes = this.readAttributeValue(attributeRecordId, fileId, encodedAttributeId);
        if (attributeValueBytes == null) {
            return null;
        }
        return new AttributeInputStream((InputStream)new UnsyncByteArrayInputStream(attributeValueBytes), connection.attributesEnumerator());
    }

    public <R> R readAttributeRaw(@NotNull PersistentFSConnection connection, int fileId, @NotNull FileAttribute attribute, @NotNull ByteBufferReader<R> reader) throws IOException {
        if (connection == null) {
            AttributesStorageOverBlobStorage.$$$reportNull$$$0(3);
        }
        if (attribute == null) {
            AttributesStorageOverBlobStorage.$$$reportNull$$$0(4);
        }
        if (reader == null) {
            AttributesStorageOverBlobStorage.$$$reportNull$$$0(5);
        }
        PersistentFSConnection.ensureIdIsValid(fileId);
        int attributeRecordId = connection.records().getAttributeRecordId(fileId);
        if (attributeRecordId == 0) {
            return null;
        }
        if (attributeRecordId < 0) {
            throw new IllegalStateException("file[id: " + fileId + "]: attributeRecordId[=" + attributeRecordId + "] is negative, must be >=0");
        }
        int encodedAttributeId = connection.enumerateAttributeId(attribute.getId());
        return this.readAttributeValue(attributeRecordId, fileId, encodedAttributeId, reader);
    }

    @Override
    public boolean hasAttributePage(@NotNull PersistentFSConnection connection, int fileId, @NotNull FileAttribute attribute) throws IOException {
        if (connection == null) {
            AttributesStorageOverBlobStorage.$$$reportNull$$$0(6);
        }
        if (attribute == null) {
            AttributesStorageOverBlobStorage.$$$reportNull$$$0(7);
        }
        PersistentFSConnection.ensureIdIsValid(fileId);
        int attributeRecordId = connection.records().getAttributeRecordId(fileId);
        if (attributeRecordId == 0) {
            return false;
        }
        int encodedAttributeId = connection.enumerateAttributeId(attribute.getId());
        return this.hasAttribute(attributeRecordId, fileId, encodedAttributeId);
    }

    @Override
    @NotNull
    public AttributeOutputStream writeAttribute(@NotNull PersistentFSConnection connection, int fileId, @NotNull FileAttribute attribute) {
        if (connection == null) {
            AttributesStorageOverBlobStorage.$$$reportNull$$$0(8);
        }
        if (attribute == null) {
            AttributesStorageOverBlobStorage.$$$reportNull$$$0(9);
        }
        return new AttributeOutputStreamImpl((OutputStream)((Object)new WritesAccumulatingOutputStream(connection, fileId, attribute)), connection.attributesEnumerator());
    }

    @Override
    public void deleteAttributes(@NotNull PersistentFSConnection connection, int fileId) throws IOException {
        if (connection == null) {
            AttributesStorageOverBlobStorage.$$$reportNull$$$0(10);
        }
        PersistentFSConnection.ensureIdIsValid(fileId);
        PersistentFSRecordsStorage records = connection.records();
        int attributeRecordId = records.getAttributeRecordId(fileId);
        this.deleteAttributes(attributeRecordId, fileId);
        records.setAttributeRecordId(fileId, 0);
    }

    @Override
    public void checkAttributeRecordSanity(int fileId, int attributeRecordId) throws IOException {
        if (attributeRecordId == 0) {
            return;
        }
        this.storage.readRecord(attributeRecordId, buffer2 -> {
            AttributesRecord attributesRecord = new AttributesRecord(buffer2);
            if (!attributesRecord.isValid()) {
                throw new IllegalStateException("record(" + attributeRecordId + ") is invalid: " + String.valueOf(attributesRecord));
            }
            attributesRecord.checkBackrefFile(attributeRecordId, fileId);
            if (attributesRecord.hasDirectory()) {
                int entryNo = 0;
                AttributeEntry entry = attributesRecord.currentEntry();
                while (entry.isValid()) {
                    int attributeId = entry.attributeId();
                    if (entry.isValueInlined()) {
                        if (!AttributesStorageOverBlobStorage.validAttributeId(attributeId)) {
                            String valueAsHex = IOUtil.toHexString((ByteBuffer)entry.inlinedValueAsSlice());
                            throw new IllegalStateException("attributeRecord[id:" + attributeRecordId + "][#" + entryNo + "]{attributeId: " + attributeId + ", value: " + valueAsHex + "} attributeId must be in [1.." + MAX_ATTRIBUTE_ID + "]");
                        }
                    } else {
                        int dedicatedRecordId = entry.dedicatedValueRecordId();
                        if (!this.storage.hasRecord(dedicatedRecordId)) {
                            throw new IllegalStateException("attributeRecord[id:" + attributeRecordId + "][#" + entryNo + "]{attributeId: " + attributeId + ", dedicatedId: " + dedicatedRecordId + "} dedicatedId must be != 0");
                        }
                    }
                    entry.moveToNextEntry();
                    ++entryNo;
                }
            } else {
                if (attributesRecord.hasDedicatedAttribute()) {
                    int attributeId = attributesRecord.dedicatedRecordAttributeId();
                    throw new IllegalStateException("attributeRecord[id:" + attributeRecordId + "]{attributeId: " + attributeId + "} is dedicated record, but must be a directory record: " + String.valueOf(attributesRecord));
                }
                throw new AssertionError((Object)("attributeRecord[id:" + attributeRecordId + "] is of unknown type (!directory & !dedicated) record: " + String.valueOf(attributesRecord)));
            }
            return null;
        });
    }

    @Override
    public boolean isEmpty() throws IOException {
        return this.storage.liveRecordsCount() == 0;
    }

    public <E extends Exception> void forEachAttribute(Processor<E> processor2) throws IOException, E {
        this.storage.forEach((recordId, recordCapacity, recordLength, payload) -> {
            if (!this.storage.isRecordActual(recordLength)) {
                return true;
            }
            AttributesRecord attributesRecord = new AttributesRecord(payload);
            if (attributesRecord.hasDirectory()) {
                int fileId = attributesRecord.fileId();
                AttributeEntry attributeEntry = attributesRecord.currentEntry();
                while (attributeEntry.isValid()) {
                    int attributeId = attributeEntry.attributeId();
                    if (attributeEntry.isValueInlined()) {
                        byte[] valueBytes = attributeEntry.inlinedValueAsByteArray();
                        processor2.processAttribute(recordId, fileId, attributeId, valueBytes, true);
                    }
                    attributeEntry.moveToNextEntry();
                }
            } else if (attributesRecord.hasDedicatedAttribute()) {
                int fileId = attributesRecord.fileId();
                int attributeId = attributesRecord.dedicatedRecordAttributeId();
                byte[] valueBytes = attributesRecord.dedicatedValueAsByteArray();
                processor2.processAttribute(recordId, fileId, attributeId, valueBytes, false);
            }
            return true;
        });
    }

    public boolean isDirty() {
        return this.storage.isDirty();
    }

    public void force() throws IOException {
        this.storage.force();
    }

    @Override
    public void close() throws IOException {
        this.storage.close();
    }

    public void closeAndClean() throws IOException {
        this.storage.closeAndClean();
    }

    @VisibleForTesting
    public int updateAttribute(int attributesRecordId, int fileId, int attributeId, byte[] newValueBytes, int newValueSize) throws IOException {
        AttributesStorageOverBlobStorage.checkAttributeId(attributeId);
        int updatedAttributesRecordId = newValueSize < 64 ? this.writeAttributeInlineIntoDirectoryRecord(attributesRecordId, fileId, attributeId, newValueBytes, newValueSize) : this.writeAttributeIntoDedicatedRecord(attributesRecordId, fileId, attributeId, newValueBytes, newValueSize);
        return updatedAttributesRecordId;
    }

    private int writeAttributeInlineIntoDirectoryRecord(int attributesRecordId, int fileId, int attributeId, byte[] newValueBuffer, int newValueSize) throws IOException {
        assert (newValueSize < 64) : "Only small values could be stored in directory record";
        if (attributesRecordId == 0) {
            int directoryRecordSize = 4 + AttributeEntry.entrySizeForInlineValueSize(attributeId, newValueSize);
            return this.storage.writeToRecord(attributesRecordId, buffer2 -> {
                ByteBuffer writeTo = AttributesStorageOverBlobStorage.ensureLimit(buffer2, directoryRecordSize);
                AttributesRecord.putDirectoryRecordHeader(writeTo, fileId);
                AttributeEntry.putInlineEntry(writeTo, attributeId, newValueBuffer, newValueSize);
                return writeTo;
            }, directoryRecordSize);
        }
        IntRef recordToDelete = new IntRef(0);
        int updatedAttributeRecordId = this.storage.writeToRecord(attributesRecordId, buffer2 -> {
            AttributesRecord record = new AttributesRecord(buffer2);
            if (record.findAttributeInDirectoryRecord(attributeId)) {
                AttributeEntry entryToOverwrite = record.currentEntry();
                if (!entryToOverwrite.isValueInlined()) {
                    recordToDelete.set(entryToOverwrite.dedicatedValueRecordId());
                }
                int newEntrySize = AttributeEntry.entrySizeForInlineValueSize(attributeId, newValueSize);
                ByteBuffer writeTo = AttributesStorageOverBlobStorage.resizeGap(buffer2, entryToOverwrite.offset(), entryToOverwrite.entrySize(), newEntrySize);
                writeTo.position(entryToOverwrite.offset());
                AttributeEntry.putInlineEntry(writeTo, attributeId, newValueBuffer, newValueSize);
                return writeTo.position(writeTo.limit());
            }
            int entrySize = AttributeEntry.entrySizeForInlineValueSize(attributeId, newValueSize);
            ByteBuffer writeTo = AttributesStorageOverBlobStorage.ensureLimitAndData(buffer2, record.length + entrySize);
            writeTo.position(record.length);
            AttributeEntry.putInlineEntry(writeTo, attributeId, newValueBuffer, newValueSize);
            return writeTo;
        });
        if (recordToDelete.get() != 0) {
            this.deleteRecordInStorage(recordToDelete.get());
        }
        return updatedAttributeRecordId;
    }

    private int writeAttributeIntoDedicatedRecord(int attributesRecordId, int fileId, int attributeId, byte[] newValueBytes, int newValueSize) throws IOException {
        int updatedAttributeRecordId = this.storage.writeToRecord(attributesRecordId, buffer2 -> {
            AttributesRecord attributesRecord;
            if (buffer2.limit() == 0) {
                buffer2.limit(4);
                AttributesRecord.putDirectoryRecordHeader(buffer2, fileId).position(0);
            }
            if (!(attributesRecord = new AttributesRecord(buffer2)).findAttributeInDirectoryRecord(attributeId)) {
                int dedicatedValueRecordId = this.writeDedicatedAttributeRecord(0, fileId, attributeId, newValueBytes, newValueSize);
                ByteBuffer writeTo = AttributesStorageOverBlobStorage.ensureLimitAndData(buffer2, attributesRecord.length + AttributeEntry.headerSizeForRef(attributeId, dedicatedValueRecordId));
                writeTo.position(attributesRecord.length);
                AttributeEntry.putRefEntry(writeTo, attributeId, dedicatedValueRecordId);
                return writeTo;
            }
            AttributeEntry entry = attributesRecord.currentEntry();
            int dedicatedValueRecordId = entry.isValueInlined() ? 0 : entry.dedicatedValueRecordId();
            int updatedDedicatedValueRecordId = this.writeDedicatedAttributeRecord(dedicatedValueRecordId, fileId, attributeId, newValueBytes, newValueSize);
            int refEntrySize = AttributeEntry.headerSizeForRef(attributeId, updatedDedicatedValueRecordId);
            ByteBuffer writeTo = AttributesStorageOverBlobStorage.resizeGap(buffer2, entry.offset(), entry.entrySize(), refEntrySize);
            writeTo.position(entry.offset());
            AttributeEntry.putRefEntry(writeTo, attributeId, updatedDedicatedValueRecordId);
            return writeTo.position(writeTo.limit());
        });
        return updatedAttributeRecordId;
    }

    @VisibleForTesting
    public byte[] readAttributeValue(int attributesRecordId, int fileId, int attributeId) throws IOException {
        return (byte[])this.storage.readRecord(attributesRecordId, buffer2 -> {
            AttributesRecord attributesRecord = new AttributesRecord(buffer2);
            attributesRecord.checkBackrefFile(attributesRecordId, fileId);
            if (!attributesRecord.findAttributeInDirectoryRecord(attributeId)) {
                return null;
            }
            AttributeEntry attributeEntry = attributesRecord.currentEntry();
            if (attributeEntry.isValueInlined()) {
                return attributeEntry.inlinedValueAsByteArray();
            }
            int dedicatedRecordId = attributeEntry.dedicatedValueRecordId();
            return (byte[])this.storage.readRecord(dedicatedRecordId, dedicatedRecordBuffer -> AttributesStorageOverBlobStorage.readDedicatedRecordPayload(attributesRecordId, fileId, attributeEntry.attributeId, dedicatedRecordBuffer));
        });
    }

    @VisibleForTesting
    public <R> R readAttributeValue(int attributesRecordId, int fileId, int attributeId, ByteBufferReader<R> reader) throws IOException {
        return (R)this.storage.readRecord(attributesRecordId, buffer2 -> {
            AttributesRecord attributesRecord = new AttributesRecord(buffer2);
            attributesRecord.checkBackrefFile(attributesRecordId, fileId);
            if (!attributesRecord.findAttributeInDirectoryRecord(attributeId)) {
                return null;
            }
            AttributeEntry attributeEntry = attributesRecord.currentEntry();
            if (attributeEntry.isValueInlined()) {
                return reader.read(attributeEntry.inlinedValueAsSlice());
            }
            int dedicatedRecordId = attributeEntry.dedicatedValueRecordId();
            return this.storage.readRecord(dedicatedRecordId, dedicatedRecordBuffer -> reader.read(AttributesStorageOverBlobStorage.readDedicatedRecordPayloadAsSlice(attributesRecordId, fileId, attributeEntry.attributeId, dedicatedRecordBuffer)));
        });
    }

    @VisibleForTesting
    public boolean hasAttribute(int attributesRecordId, int fileId, int attributeId) throws IOException {
        if (!this.storage.hasRecord(attributesRecordId)) {
            return false;
        }
        return (Boolean)this.storage.readRecord(attributesRecordId, buffer2 -> {
            AttributesRecord attributesRecord = new AttributesRecord(buffer2);
            attributesRecord.checkBackrefFile(attributesRecordId, fileId);
            if (!attributesRecord.hasDirectory()) {
                throw new IllegalArgumentException("record(" + attributesRecordId + ") is not a directory record: (" + attributesRecord.backRefFileId + ", " + attributesRecord.dedicatedAttributeId + ")");
            }
            if (!attributesRecord.findAttributeInDirectoryRecord(attributeId)) {
                return false;
            }
            AttributeEntry attributeEntry = attributesRecord.currentEntry();
            if (attributeEntry.isValueInlined()) {
                return true;
            }
            int dedicatedRecordId = attributeEntry.dedicatedValueRecordId();
            return this.storage.hasRecord(dedicatedRecordId);
        });
    }

    @VisibleForTesting
    public boolean deleteAttributes(int attributesRecordId, int fileId) throws IOException {
        if (attributesRecordId == 0) {
            return false;
        }
        try {
            this.storage.writeToRecord(attributesRecordId, buffer2 -> {
                AttributesRecord attributesRecord = new AttributesRecord(buffer2);
                attributesRecord.checkBackrefFile(attributesRecordId, fileId);
                AttributeEntry entry = attributesRecord.currentEntry();
                while (entry.isValid()) {
                    if (!entry.isValueInlined()) {
                        this.deleteRecordInStorage(entry.dedicatedValueRecordId());
                    }
                    entry.moveToNextEntry();
                }
                return null;
            });
        }
        catch (RecordAlreadyDeletedException ex) {
            if (IGNORE_ALREADY_DELETED_ERRORS) {
                FSRecords.LOG.warn("Record [" + attributesRecordId + "] is already deleted -> likely improper app shutdown?");
            }
            throw ex;
        }
        return this.deleteRecordInStorage(attributesRecordId);
    }

    private boolean deleteRecordInStorage(int recordId) throws IOException {
        try {
            this.storage.deleteRecord(recordId);
            return true;
        }
        catch (RecordAlreadyDeletedException ex) {
            if (IGNORE_ALREADY_DELETED_ERRORS) {
                FSRecords.LOG.warn("Record [" + recordId + "] is already deleted -> likely improper app shutdown?");
                return false;
            }
            throw ex;
        }
    }

    private static byte[] readDedicatedRecordPayload(int dedicatedAttributeRecordId, int fileId, int attributeId, ByteBuffer dedicatedRecordBuffer) throws IOException {
        if (dedicatedRecordBuffer.remaining() < 8) {
            throw new CorruptedException("record(" + dedicatedAttributeRecordId + ", fileId: " + fileId + ", " + attributeId + ") is too short for dedicated record: " + dedicatedRecordBuffer.remaining() + " b in buffer < 8 b header");
        }
        int backRefFileId = -dedicatedRecordBuffer.getInt(0);
        int backRefAttributeId = dedicatedRecordBuffer.getInt(4);
        if (backRefFileId != fileId) {
            throw new CorruptedException("record(" + dedicatedAttributeRecordId + ").fileId(" + fileId + ") != backref fileId(" + backRefFileId + "), buffer remains: " + IOUtil.toHexString((ByteBuffer)dedicatedRecordBuffer));
        }
        if (backRefAttributeId != attributeId) {
            throw new CorruptedException("record(" + dedicatedAttributeRecordId + ").attributeId(" + attributeId + ") != backref attributeId(" + backRefAttributeId + "), buffer remains: " + IOUtil.toHexString((ByteBuffer)dedicatedRecordBuffer));
        }
        int valueLength = dedicatedRecordBuffer.remaining() - 8;
        byte[] entryValue = new byte[valueLength];
        dedicatedRecordBuffer.get(8, entryValue);
        return entryValue;
    }

    private static ByteBuffer readDedicatedRecordPayloadAsSlice(int dedicatedAttributeRecordId, int fileId, int attributeId, ByteBuffer dedicatedRecordBuffer) throws IOException {
        int backRefFileId = -dedicatedRecordBuffer.getInt(0);
        int backRefAttributeId = dedicatedRecordBuffer.getInt(4);
        if (backRefFileId != fileId) {
            throw new CorruptedException("record(" + dedicatedAttributeRecordId + ").fileId(" + fileId + ") != backref fileId(" + backRefFileId + "), buffer remains: " + IOUtil.toHexString((ByteBuffer)dedicatedRecordBuffer));
        }
        if (backRefAttributeId != attributeId) {
            throw new CorruptedException("record(" + attributeId + ").attributeId(" + attributeId + ") != backref attributeId(" + backRefAttributeId + "), buffer remains: " + IOUtil.toHexString((ByteBuffer)dedicatedRecordBuffer));
        }
        int valueLength = dedicatedRecordBuffer.remaining() - 8;
        return dedicatedRecordBuffer.slice(8, valueLength).order(dedicatedRecordBuffer.order());
    }

    private int writeDedicatedAttributeRecord(int dedicatedAttributeRecordId, int fileId, int attributeId, byte[] newValueBytes, int newValueSize) throws IOException {
        return this.storage.writeToRecord(dedicatedAttributeRecordId, buffer2 -> {
            ByteBuffer toWrite = AttributesStorageOverBlobStorage.ensureLimit(buffer2, AttributesRecord.dedicatedRecordSizeForValueSize(newValueSize));
            return AttributesRecord.putDedicatedValueRecordHeader(toWrite, fileId, attributeId).put(newValueBytes, 0, newValueSize);
        });
    }

    @NotNull
    private static ByteBuffer ensureLimit(ByteBuffer buffer2, int requiredLimit) {
        if (buffer2.capacity() >= requiredLimit) {
            ByteBuffer byteBuffer = buffer2.limit(Math.max(buffer2.limit(), requiredLimit));
            if (byteBuffer == null) {
                AttributesStorageOverBlobStorage.$$$reportNull$$$0(11);
            }
            return byteBuffer;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(requiredLimit).order(buffer2.order()).position(buffer2.position());
        if (byteBuffer == null) {
            AttributesStorageOverBlobStorage.$$$reportNull$$$0(12);
        }
        return byteBuffer;
    }

    private static ByteBuffer ensureLimitAndData(ByteBuffer buffer2, int requiredLimit) {
        if (buffer2.capacity() >= requiredLimit) {
            return buffer2.limit(Math.max(buffer2.limit(), requiredLimit));
        }
        return ByteBuffer.allocate(requiredLimit).order(buffer2.order()).put(0, buffer2, 0, buffer2.limit()).position(buffer2.position());
    }

    @VisibleForTesting
    public static ByteBuffer resizeGap(ByteBuffer buffer2, int offset, int oldGapSize, int newGapSize) {
        int oldGapEndOffset = offset + oldGapSize;
        int newGapEndOffset = offset + newGapSize;
        int limitBefore = buffer2.limit();
        if (newGapSize > oldGapSize) {
            ByteBuffer enlargedBuffer = AttributesStorageOverBlobStorage.ensureLimitAndData(buffer2, limitBefore + (newGapSize - oldGapSize));
            enlargedBuffer.put(newGapEndOffset, buffer2, oldGapEndOffset, limitBefore - oldGapEndOffset);
            enlargedBuffer.limit(limitBefore + newGapSize - oldGapSize);
            return enlargedBuffer;
        }
        if (newGapSize < oldGapSize) {
            buffer2.put(newGapEndOffset, buffer2, oldGapEndOffset, limitBefore - oldGapEndOffset);
            buffer2.limit(limitBefore + (newGapSize - oldGapSize));
            return buffer2;
        }
        return buffer2;
    }

    private static void checkAttributeId(int attributeId) {
        if (!AttributesStorageOverBlobStorage.validAttributeId(attributeId)) {
            throw new IllegalArgumentException("attributeId(=" + attributeId + ") must be in (0..16384]");
        }
    }

    private static boolean validAttributeId(int attributeId) {
        return 0 < attributeId && attributeId <= 16384;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/AttributesStorageOverBlobStorage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/AttributesStorageOverBlobStorage";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureLimit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readAttribute";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readAttributeRaw";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasAttributePage";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeAttribute";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deleteAttributes";
                break;
            }
            case 11: 
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12 -> new IllegalStateException(string);
        };
    }

    @VisibleForTesting
    public static final class AttributeEntry {
        private static final int SMALLEST_HEADER_SIZE = 1;
        private static final int MEDIUM_HEADER_SIZE = 2;
        private static final int BIG_HEADER_SIZE = 6;
        private static final byte TINY_ENTRY_MASK = -128;
        private static final int TINY_ENTRY_ATTR_ID_BITS = 3;
        private static final int TINY_ENTRY_ATTR_ID_MASK = 112;
        private static final int TINY_ENTRY_SIZE_MASK = 15;
        private static final int TINY_ENTRY_SIZE_BITS = 4;
        private static final int TINY_ENTRY_MAX_ATTRIBUTE_ID = 7;
        private static final int TINY_ENTRY_MAX_SIZE = 15;
        private static final byte MEDIUM_ENTRY_MASK = 64;
        private static final int MEDIUM_ENTRY_ATTR_ID_BITS = 6;
        private static final int MEDIUM_ENTRY_SIZE_BITS = 8;
        private static final int MEDIUM_ENTRY_MAX_ATTRIBUTE_ID = 63;
        private static final int MEDIUM_ENTRY_MAX_SIZE = 255;
        private static final byte BIG_ENTRY_MASK = -64;
        private static final int BIG_ENTRY_ATTR_ID_OF_FIRST_BYTE_MASK = 63;
        private static final int BIG_ENTRY_ATTR_ID_BITS = 14;
        private int entryStartOffset;
        private int attributeId;
        private int inlinedValueSizeOrDedicatedRecordId;
        private int headerSize = -1;
        private ByteBuffer buffer;

        public void reset(int entryStartOffset, ByteBuffer buffer2) {
            this.entryStartOffset = entryStartOffset;
            this.buffer = buffer2;
            if (this.isValid()) {
                byte firstByte = buffer2.get(entryStartOffset);
                if ((firstByte & 0xFFFFFF80) == 0) {
                    this.attributeId = (firstByte & 0x70) >> 4;
                    this.inlinedValueSizeOrDedicatedRecordId = firstByte & 0xF;
                    this.headerSize = 1;
                } else if ((firstByte & 0x40) == 0) {
                    AttributeEntry.assertMediumHeaderIsValid(buffer2, entryStartOffset, firstByte);
                    byte secondByte = buffer2.get(entryStartOffset + 1);
                    this.attributeId = firstByte & 0x3F;
                    this.inlinedValueSizeOrDedicatedRecordId = Byte.toUnsignedInt(secondByte);
                    this.headerSize = 2;
                } else {
                    AttributeEntry.assertBigHeaderIsValid(buffer2, entryStartOffset, firstByte);
                    byte secondByte = buffer2.get(entryStartOffset + 1);
                    this.attributeId = (firstByte & 0x3F) << 8 | Byte.toUnsignedInt(secondByte);
                    this.inlinedValueSizeOrDedicatedRecordId = buffer2.getInt(entryStartOffset + 2);
                    this.headerSize = 6;
                }
            } else {
                this.attributeId = -1;
                this.inlinedValueSizeOrDedicatedRecordId = -1;
                this.headerSize = -1;
            }
        }

        public boolean isValid() {
            return this.entryStartOffset + 1 <= this.buffer.limit();
        }

        public int attributeId() {
            return this.attributeId;
        }

        public boolean isValueInlined() {
            return 0 <= this.inlinedValueSizeOrDedicatedRecordId && this.inlinedValueSizeOrDedicatedRecordId < 64;
        }

        public int dedicatedValueRecordId() {
            return this.inlinedValueSizeOrDedicatedRecordId - 64;
        }

        public int inlinedValueStartOffset() {
            return this.entryStartOffset + this.headerSize;
        }

        public int inlinedValueLength() {
            return this.isValueInlined() ? this.inlinedValueSizeOrDedicatedRecordId : 0;
        }

        public int offset() {
            return this.entryStartOffset;
        }

        public int nextEntryOffset() {
            return this.entryStartOffset + this.entrySize();
        }

        public int entrySize() {
            return this.headerSize + (this.isValueInlined() ? this.inlinedValueLength() : 0);
        }

        public boolean moveToNextEntry() {
            int offset = this.nextEntryOffset();
            if (offset >= this.buffer.remaining()) {
                this.entryStartOffset = offset;
                return false;
            }
            this.reset(offset, this.buffer);
            return true;
        }

        public byte[] inlinedValueAsByteArray() {
            int valueLength = this.inlinedValueLength();
            byte[] entryValue = new byte[valueLength];
            this.buffer.get(this.inlinedValueStartOffset(), entryValue);
            return entryValue;
        }

        public ByteBuffer inlinedValueAsSlice() {
            int valueLength = this.inlinedValueLength();
            return this.buffer.slice(this.inlinedValueStartOffset(), valueLength).order(this.buffer.order());
        }

        public String toString() {
            return "AttributeEntry{startOffset: " + this.entryStartOffset + ", attributeId: " + this.attributeId + ", valid: " + this.isValid() + "}{inlinedValueSizeOrDedicatedRecordId=" + this.inlinedValueSizeOrDedicatedRecordId + ", buffer=" + String.valueOf(this.buffer) + "}";
        }

        public static ByteBuffer putInlineEntryHeader(ByteBuffer buffer2, int encodedAttributeId, int newValueSize) {
            assert (newValueSize < 64) : newValueSize + " >= 64";
            return AttributeEntry.putEntryHeader(buffer2, encodedAttributeId, newValueSize);
        }

        private static ByteBuffer putEntryHeader(ByteBuffer buffer2, int encodedAttributeId, int sizeOrRefId) {
            assert (encodedAttributeId <= 16384) : "attributeId: " + encodedAttributeId + " > max 16384";
            if (AttributeEntry.fitsTinyEntry(encodedAttributeId, sizeOrRefId)) {
                byte firstByte = (byte)(encodedAttributeId << 4 | sizeOrRefId);
                return buffer2.put(firstByte);
            }
            if (AttributeEntry.fitsMediumEntry(encodedAttributeId, sizeOrRefId)) {
                byte firstByte = (byte)(encodedAttributeId | 0xFFFFFF80);
                return buffer2.put(firstByte).put((byte)sizeOrRefId);
            }
            int attributeLow8Bits = encodedAttributeId & 0xFF;
            int attributeHigh6Bits = encodedAttributeId >> 8;
            assert ((attributeHigh6Bits & 0xFFFFFFC0) == 0) : "attributeId: " + encodedAttributeId + " is larger than possible";
            byte firstByte = (byte)(attributeHigh6Bits | 0xFFFFFFC0);
            return buffer2.put(firstByte).put((byte)attributeLow8Bits).putInt(sizeOrRefId);
        }

        public static ByteBuffer putInlineEntryValue(ByteBuffer buffer2, byte[] newValueBytes, int newValueSize) {
            return buffer2.put(newValueBytes, 0, newValueSize);
        }

        public static ByteBuffer putInlineEntry(ByteBuffer buffer2, int attributeId, byte[] newValueBytes, int newValueSize) {
            assert (buffer2.remaining() >= AttributeEntry.entrySizeForInlineValueSize(attributeId, newValueSize)) : "buffer(pos:" + buffer2.position() + ", lim:" + buffer2.limit() + ") is too small for inline attribute " + newValueSize + " (+8b header)";
            AttributeEntry.putInlineEntryHeader(buffer2, attributeId, newValueSize);
            return AttributeEntry.putInlineEntryValue(buffer2, newValueBytes, newValueSize);
        }

        public static ByteBuffer putRefEntry(ByteBuffer buffer2, int encodedAttributeId, int dedicatedRecordId) {
            return AttributeEntry.putEntryHeader(buffer2, encodedAttributeId, 64 + dedicatedRecordId);
        }

        public static int entrySizeForInlineValueSize(int encodedAttributeId, int size2) {
            return AttributeEntry.headerSizeForInline(encodedAttributeId, size2) + size2;
        }

        public static int headerSizeForInline(int encodedAttributeId, int size2) {
            return AttributeEntry.headerSizeFor(encodedAttributeId, size2);
        }

        public static int headerSizeForRef(int encodedAttributeId, int dedicatedRecordId) {
            return AttributeEntry.headerSizeFor(encodedAttributeId, 64 + dedicatedRecordId);
        }

        private static int headerSizeFor(int encodedAttributeId, int sizeOrRefId) {
            if (AttributeEntry.fitsTinyEntry(encodedAttributeId, sizeOrRefId)) {
                return 1;
            }
            if (AttributeEntry.fitsMediumEntry(encodedAttributeId, sizeOrRefId)) {
                return 2;
            }
            return 6;
        }

        private static boolean fitsTinyEntry(int encodedAttributeId, int sizeOrRefId) {
            return (encodedAttributeId & 7) == encodedAttributeId && (sizeOrRefId & 0xF) == sizeOrRefId;
        }

        private static boolean fitsMediumEntry(int encodedAttributeId, int sizeOrRefId) {
            return (encodedAttributeId & 0x3F) == encodedAttributeId && (sizeOrRefId & 0xFF) == sizeOrRefId;
        }

        private static void assertMediumHeaderIsValid(@NotNull ByteBuffer buffer2, int entryStartOffset, byte firstByte) {
            if (buffer2 == null) {
                AttributeEntry.$$$reportNull$$$0(0);
            }
            assert (buffer2.limit() >= entryStartOffset + 2) : "Invalid record(@" + entryStartOffset + ") format: header[0](=" + Integer.toBinaryString(Byte.toUnsignedInt(firstByte)) + " -> medium record) but there is no header[1] byte. buffer[pos: " + buffer2.position() + ", lim: " + buffer2.limit() + "]:  " + IOUtil.toHexString((ByteBuffer)buffer2);
        }

        private static void assertBigHeaderIsValid(@NotNull ByteBuffer buffer2, int entryStartOffset, byte firstByte) {
            if (buffer2 == null) {
                AttributeEntry.$$$reportNull$$$0(1);
            }
            assert (buffer2.limit() >= entryStartOffset + 6) : "Invalid record(@" + entryStartOffset + ") format: header[0](=" + Integer.toBinaryString(firstByte) + " -> big record) but there is no header[1..5] bytes. buffer[pos: " + buffer2.position() + ", lim: " + buffer2.limit() + "]:  " + IOUtil.toHexString((ByteBuffer)buffer2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "buffer";
            objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/AttributesStorageOverBlobStorage$AttributeEntry";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "assertMediumHeaderIsValid";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "assertBigHeaderIsValid";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class WritesAccumulatingOutputStream
    extends UnsyncByteArrayOutputStream {
        @NotNull
        private final PersistentFSConnection connection;
        @NotNull
        private final FileAttribute attribute;
        private final int fileId;

        private WritesAccumulatingOutputStream(PersistentFSConnection connection, @NotNull int fileId, FileAttribute attribute) {
            if (connection == null) {
                WritesAccumulatingOutputStream.$$$reportNull$$$0(0);
            }
            if (attribute == null) {
                WritesAccumulatingOutputStream.$$$reportNull$$$0(1);
            }
            this.connection = connection;
            this.fileId = fileId;
            this.attribute = attribute;
        }

        public void close() throws IOException {
            super.close();
            int attributeValueSize = this.size();
            VFSAttributesStorage.checkAttributeValueSize(this.attribute, attributeValueSize);
            PersistentFSRecordsStorage records = this.connection.records();
            int encodedAttributeId = this.connection.enumerateAttributeId(this.attribute.getId());
            int attributesRecordId = records.getAttributeRecordId(this.fileId);
            int updatedAttributesRecordId = AttributesStorageOverBlobStorage.this.updateAttribute(attributesRecordId, this.fileId, encodedAttributeId, this.myBuffer, attributeValueSize);
            records.setAttributeRecordId(this.fileId, updatedAttributesRecordId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "attribute";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vfs/newvfs/persistent/AttributesStorageOverBlobStorage$WritesAccumulatingOutputStream";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Processor<E extends Exception> {
        public void processAttribute(int var1, int var2, int var3, byte[] var4, boolean var5) throws E;
    }

    @VisibleForTesting
    public static final class AttributesRecord {
        public static final int RECORD_FILE_ID_OFFSET = 0;
        public static final int RECORD_HEADER_SIZE = 4;
        public static final int DEDICATED_RECORD_ATTRIBUTE_ID_OFFSET = 4;
        public static final int DEDICATED_RECORD_HEADER_SIZE = 8;
        private final ByteBuffer buffer;
        private final int length;
        private final int backRefFileId;
        private final int dedicatedAttributeId;
        private final AttributeEntry entry = new AttributeEntry();

        public AttributesRecord(ByteBuffer buffer2) throws IOException {
            this.buffer = buffer2;
            this.length = buffer2.remaining();
            if (this.length >= 4) {
                int fileId = buffer2.getInt(0);
                if (fileId < 0) {
                    if (this.length < 8) {
                        throw new CorruptedException("record length(=" + this.length + ") must be > 8, buffer: " + IOUtil.toHexString((ByteBuffer)buffer2));
                    }
                    this.backRefFileId = -fileId;
                    this.dedicatedAttributeId = buffer2.getInt(4);
                } else {
                    this.backRefFileId = fileId;
                    this.dedicatedAttributeId = -1;
                    this.entry.reset(4, buffer2);
                }
            } else {
                this.backRefFileId = -1;
                this.dedicatedAttributeId = -1;
            }
        }

        public boolean isValid() {
            return this.hasDirectory() || this.hasDedicatedAttribute();
        }

        public void checkBackrefFile(int attributesRecordId, int fileId) throws CorruptedException {
            if (this.backRefFileId != fileId) {
                throw new CorruptedException("record(" + attributesRecordId + "): fileId(" + fileId + ") != backref fileId(" + this.backRefFileId + "), " + String.valueOf(this));
            }
        }

        public int fileId() {
            return this.backRefFileId;
        }

        public boolean findAttributeInDirectoryRecord(int lookupAttributeId) {
            this.entry.reset(4, this.buffer);
            while (this.entry.isValid()) {
                int attributeId = this.entry.attributeId();
                if (lookupAttributeId == attributeId) {
                    return true;
                }
                this.entry.moveToNextEntry();
            }
            return false;
        }

        public AttributeEntry currentEntry() {
            return this.entry;
        }

        public boolean hasDirectory() {
            return this.length >= 4 && this.dedicatedAttributeId < 0;
        }

        public boolean hasDedicatedAttribute() {
            return this.length >= 8 && this.dedicatedAttributeId > 0;
        }

        private int dedicatedRecordAttributeId() {
            return this.dedicatedAttributeId;
        }

        public byte[] dedicatedValueAsByteArray() {
            byte[] recordValue = new byte[this.length - 8];
            this.buffer.get(8, recordValue);
            return recordValue;
        }

        public String toString() {
            return "AttributesRecord[" + (this.hasDirectory() ? "directory" : "dedicated") + "][" + this.buffer.position() + ".." + this.buffer.limit() + ", length: " + this.length + "][backRefFileId: " + this.backRefFileId + ", dedicatedAttributeId: " + this.dedicatedAttributeId + "]";
        }

        public static ByteBuffer putDirectoryRecordHeader(ByteBuffer buffer2, int fileId) {
            return buffer2.putInt(fileId);
        }

        public static ByteBuffer putDedicatedValueRecordHeader(ByteBuffer buffer2, int fileId, int attributeId) {
            return buffer2.putInt(-fileId).putInt(attributeId);
        }

        public static int dedicatedRecordSizeForValueSize(int valueSize) {
            return 8 + valueSize;
        }
    }
}

