/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.wm.impl.content.SelectContentTabStep;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.TabbedContent;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0017\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u00a2\u0006\u0004\b\u0005\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u001e\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00142\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\nH\u0016J\u000e\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u0002H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/wm/impl/content/SelectContentStep;", "Lcom/intellij/openapi/ui/popup/util/BaseListPopupStep;", "Lcom/intellij/ui/content/Content;", "contents", "", "<init>", "([Lcom/intellij/ui/content/Content;)V", "", "(Ljava/util/List;)V", "isSpeedSearchEnabled", "", "getIconFor", "Ljavax/swing/Icon;", "value", "getTextFor", "", "getBackgroundFor", "Ljava/awt/Color;", "hasSubstep", "onChosen", "Lcom/intellij/openapi/ui/popup/PopupStep;", "finalChoice", "asMultiTabbed", "Lcom/intellij/ui/content/TabbedContent;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public class SelectContentStep
extends BaseListPopupStep<Content> {
    public SelectContentStep(@NotNull Content[] contents) {
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        super(null, (Object[])Arrays.copyOf(contents, contents.length));
    }

    public SelectContentStep(@NotNull List<? extends Content> contents) {
        Intrinsics.checkNotNullParameter(contents, (String)"contents");
        super(null, contents);
    }

    public boolean isSpeedSearchEnabled() {
        return true;
    }

    @Nullable
    public Icon getIconFor(@NotNull Content value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return value.getIcon();
    }

    @NotNull
    public String getTextFor(@NotNull Content value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = this.asMultiTabbed(value);
        if ((object == null || (object = object.getTitlePrefix()) == null) && (object = value.getDisplayName()) == null) {
            String string = super.getTextFor((Object)value);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTextFor(...)");
        }
        return object;
    }

    @Nullable
    public Color getBackgroundFor(@NotNull Content value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return value.getTabColor();
    }

    public boolean hasSubstep(@NotNull Content value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.asMultiTabbed(value) != null;
    }

    @Nullable
    public PopupStep<?> onChosen(@NotNull Content value, boolean finalChoice) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        TabbedContent tabbed = this.asMultiTabbed(value);
        if (tabbed == null) {
            ContentManager contentManager = value.getManager();
            if (contentManager != null) {
                contentManager.setSelectedContentCB(value, true, true);
            }
            return PopupStep.FINAL_CHOICE;
        }
        return (PopupStep)new SelectContentTabStep(tabbed);
    }

    private final TabbedContent asMultiTabbed(Content $this$asMultiTabbed) {
        return $this$asMultiTabbed instanceof TabbedContent && ((TabbedContent)$this$asMultiTabbed).hasMultipleTabs() ? (TabbedContent)$this$asMultiTabbed : null;
    }
}

