/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.encoding.ChangeFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingManagerListener;
import com.intellij.openapi.vfs.encoding.EncodingUtil;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedStatusBarPopup;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.MessageBusConnection;
import java.nio.charset.Charset;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EncodingPanel
extends EditorBasedStatusBarPopup {
    public EncodingPanel(@NotNull Project project2, @NotNull CoroutineScope scope) {
        if (project2 == null) {
            EncodingPanel.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            EncodingPanel.$$$reportNull$$$0(1);
        }
        super(project2, false, scope);
    }

    @Override
    @NotNull
    protected EditorBasedStatusBarPopup.WidgetState getWidgetState(@Nullable VirtualFile file2) {
        if (file2 == null || file2.isDirectory()) {
            EditorBasedStatusBarPopup.WidgetState widgetState = EditorBasedStatusBarPopup.WidgetState.HIDDEN;
            if (widgetState == null) {
                EncodingPanel.$$$reportNull$$$0(2);
            }
            return widgetState;
        }
        Pair<Charset, String> check2 = EncodingUtil.getCharsetAndTheReasonTooltip(file2);
        String failReason = (String)Pair.getSecond(check2);
        Charset charset = (Charset)ObjectUtils.notNull((Object)((Charset)Pair.getFirst(check2)), (Object)file2.getCharset());
        String charsetName = (String)ObjectUtils.notNull((Object)charset.displayName(), (Object)IdeBundle.message((String)"encoding.not.available", (Object[])new Object[0]));
        String toolTipText = IdeBundle.message((String)"status.bar.text.file.encoding", (Object[])new Object[]{charsetName}) + (String)(failReason == null ? "" : " (" + failReason + ")");
        return new EditorBasedStatusBarPopup.WidgetState(toolTipText, charsetName, failReason == null);
    }

    @Override
    @Nullable
    protected ListPopup createPopup(@NotNull DataContext context) {
        if (context == null) {
            EncodingPanel.$$$reportNull$$$0(3);
        }
        ChangeFileEncodingAction action2 = new ChangeFileEncodingAction();
        action2.getTemplatePresentation().setText(IdeBundle.messagePointer((String)"action.presentation.EncodingPanel.text", (Object[])new Object[0]));
        return action2.createPopup(context, (ActionGroup)ActionManager.getInstance().getAction("EncodingPanelActions"));
    }

    @Override
    protected void registerCustomListeners(@NotNull MessageBusConnection connection) {
        if (connection == null) {
            EncodingPanel.$$$reportNull$$$0(4);
        }
        connection.subscribe(EncodingManagerListener.ENCODING_MANAGER_CHANGES, (document2, propertyName, oldValue, newValue) -> {
            if (propertyName.equals("cachedEncoding")) {
                this.updateForDocument(document2);
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter(new VirtualFileListener(){

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ("encoding".equals(event.getPropertyName())) {
                    EncodingPanel.this.updateForFile(event.getFile());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/status/EncodingPanel$1", "propertyChanged"));
            }
        }));
    }

    @Override
    @NotNull
    protected StatusBarWidget createInstance(@NotNull Project project2) {
        if (project2 == null) {
            EncodingPanel.$$$reportNull$$$0(5);
        }
        return new EncodingPanel(project2, this.getScope());
    }

    @NotNull
    public String ID() {
        return "Encoding";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/status/EncodingPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/status/EncodingPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWidgetState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPopup";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerCustomListeners";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

