/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen.collapsedActionGroup;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListModel;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class CollapsibleGroupedListSelectionModel
extends DefaultListSelectionModel {
    private final ListModel<? extends AnAction> model;

    public CollapsibleGroupedListSelectionModel(ListModel<? extends AnAction> model2) {
        this.setSelectionMode(0);
        this.model = model2;
    }

    private int getNotGroupIndexInDirection(int startIndex, int direction) {
        for (int i2 = startIndex + direction; i2 >= 0 && i2 < this.model.getSize(); i2 += direction) {
            if (this.model.getElementAt(i2) instanceof ActionGroup) continue;
            return i2;
        }
        return startIndex;
    }

    @Override
    public void setSelectionInterval(int index0, int index1) {
        if (this.model.getElementAt(index0) instanceof ActionGroup) {
            int candidate = this.getNotGroupIndexInDirection(this.getMaxSelectionIndex(), index0 - this.getMaxSelectionIndex());
            if (candidate != this.getMaxSelectionIndex()) {
                super.setSelectionInterval(candidate, candidate);
            }
            return;
        }
        super.setSelectionInterval(index0, index1);
    }

    @Override
    public boolean isSelectedIndex(int index) {
        if (this.model.getElementAt(index) instanceof ActionGroup) {
            return false;
        }
        return super.isSelectedIndex(index);
    }
}

