/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.impl.toolkit;

import java.awt.Component;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.peer.MouseInfoPeer;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/impl/toolkit/IdeMouseInfoPeer;", "Ljava/awt/peer/MouseInfoPeer;", "<init>", "()V", "lastMouseCoords", "Ljava/awt/Point;", "lastWindowUnderMouse", "Ljava/awt/Component;", "lastComponentUnderCursor", "fillPointWithCoords", "", "point", "isWindowUnderMouse", "", "w", "Ljava/awt/Window;", "getComponentUnderCursor", "processMouseEvent", "", "event", "Ljava/awt/event/MouseEvent;", "window", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nIdeMouseInfoPeer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeMouseInfoPeer.kt\ncom/intellij/platform/impl/toolkit/IdeMouseInfoPeer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,40:1\n1772#2,6:41\n*S KotlinDebug\n*F\n+ 1 IdeMouseInfoPeer.kt\ncom/intellij/platform/impl/toolkit/IdeMouseInfoPeer\n*L\n20#1:41,6\n*E\n"})
public final class IdeMouseInfoPeer
implements MouseInfoPeer {
    @NotNull
    public static final IdeMouseInfoPeer INSTANCE = new IdeMouseInfoPeer();
    @NotNull
    private static final Point lastMouseCoords = new Point();
    @Nullable
    private static Component lastWindowUnderMouse;
    @Nullable
    private static Component lastComponentUnderCursor;

    private IdeMouseInfoPeer() {
    }

    @Override
    public int fillPointWithCoords(@NotNull Point point) {
        int n;
        block1: {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            point.setLocation(lastMouseCoords);
            GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            Intrinsics.checkNotNullExpressionValue((Object)graphicsDeviceArray, (String)"getScreenDevices(...)");
            Object[] $this$indexOfFirst$iv = graphicsDeviceArray;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length;
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                GraphicsDevice it = (GraphicsDevice)$this$indexOfFirst$iv[index$iv];
                boolean bl = false;
                if (!it.getDefaultConfiguration().getBounds().contains(point)) continue;
                n = index$iv;
                break block1;
            }
            n = -1;
        }
        return n;
    }

    @Override
    public boolean isWindowUnderMouse(@NotNull Window w) {
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        return Intrinsics.areEqual((Object)w, (Object)lastWindowUnderMouse);
    }

    @Nullable
    public final Component getComponentUnderCursor() {
        return lastComponentUnderCursor;
    }

    public final void processMouseEvent(@NotNull MouseEvent event, @NotNull Window window) {
        Component component2;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        lastMouseCoords.setLocation(event.getXOnScreen(), event.getYOnScreen());
        lastWindowUnderMouse = window;
        lastComponentUnderCursor = component2 = SwingUtilities.getDeepestComponentAt(window, event.getX(), event.getY());
        if (event.getID() == 505 && Intrinsics.areEqual((Object)component2, (Object)window)) {
            lastComponentUnderCursor = null;
        }
    }
}

