/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.LibNotifyWrapper;
import com.intellij.ui.MacOsNotifications;
import com.intellij.ui.SystemNotifications;
import com.intellij.ui.SystemTrayNotifications;
import com.intellij.util.ui.GraphicsUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SystemNotificationsImpl
extends SystemNotifications {
    private final NullableLazyValue<Notifier> myNotifier = NullableLazyValue.atomicLazyNullable(SystemNotificationsImpl::getPlatformNotifier);

    @Override
    public void notify(@NotNull String notificationName, @NotNull String title2, @NotNull String text2) {
        Notifier notifier;
        if (notificationName == null) {
            SystemNotificationsImpl.$$$reportNull$$$0(0);
        }
        if (title2 == null) {
            SystemNotificationsImpl.$$$reportNull$$$0(1);
        }
        if (text2 == null) {
            SystemNotificationsImpl.$$$reportNull$$$0(2);
        }
        if (NotificationsConfigurationImpl.getInstanceImpl().SYSTEM_NOTIFICATIONS && !ApplicationManager.getApplication().isActive() && (notifier = (Notifier)this.myNotifier.getValue()) != null) {
            notifier.notify(notificationName, title2, text2);
        }
    }

    @Nullable
    private static Notifier getPlatformNotifier() {
        if (!GraphicsUtil.isRemoteEnvironment()) {
            try {
                if (SystemInfo.isMac) {
                    return MacOsNotifications.getInstance();
                }
                if (SystemInfo.isUnix) {
                    return LibNotifyWrapper.getInstance();
                }
                if (SystemInfo.isWin10OrNewer) {
                    return SystemTrayNotifications.getWin10Instance();
                }
            }
            catch (Throwable t) {
                Logger.getInstance(SystemNotificationsImpl.class).infoWithDebug(t);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "notificationName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "title";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
        }
        objectArray[1] = "com/intellij/ui/SystemNotificationsImpl";
        objectArray[2] = "notify";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static interface Notifier {
        public void notify(@NotNull String var1, @NotNull String var2, @NotNull String var3);
    }
}

