/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.colorpicker;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.colorpicker.ColorPickerModelKt;
import com.intellij.ui.colorpicker.ColorPipette;
import com.intellij.ui.picker.ColorListener;
import java.awt.Color;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0012\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0001J\u0006\u0010\u0016\u001a\u00020\u0013J\u0006\u0010\u0017\u001a\u00020\u0013J\u001a\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0001J\u000e\u00101\u001a\u00020\u00132\u0006\u00102\u001a\u00020\bJ\u0016\u00101\u001a\u00020\u00132\u0006\u00102\u001a\u00020\b2\u0006\u00103\u001a\u00020\rJ\u000e\u00104\u001a\u00020\u00132\u0006\u00102\u001a\u00020\bJ\u000e\u00105\u001a\u00020\r2\u0006\u00102\u001a\u00020\nJ\u000e\u00106\u001a\u00020\r2\u0006\u00102\u001a\u00020\nJ\u000e\u00107\u001a\u00020\u00132\u0006\u00108\u001a\u00020\u0003J\u000e\u00109\u001a\u00020\u00132\u0006\u0010:\u001a\u00020\u0003J\u0006\u0010;\u001a\u00020\u0013R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001eR\u0011\u0010!\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001eR\u0011\u0010#\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001eR\u0011\u0010%\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010,R\u0011\u0010/\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b0\u0010,\u00a8\u0006<"}, d2={"Lcom/intellij/ui/colorpicker/ColorPickerModel;", "", "originalColor", "Ljava/awt/Color;", "<init>", "(Ljava/awt/Color;)V", "listeners", "", "Lcom/intellij/ui/picker/ColorListener;", "pipetteListeners", "Lcom/intellij/ui/colorpicker/ColorPipette$Callback;", "instantListeners", "changedByUser", "", "value", "color", "getColor", "()Ljava/awt/Color;", "setColor", "", "newColor", "source", "onClose", "onCancel", "applyColorToSource", "hsb", "", "red", "", "getRed", "()I", "green", "getGreen", "blue", "getBlue", "alpha", "getAlpha", "hex", "", "getHex", "()Ljava/lang/String;", "hue", "", "getHue", "()F", "saturation", "getSaturation", "brightness", "getBrightness", "addListener", "listener", "invokeOnEveryColorChange", "removeListener", "addPipetteListener", "removePipetteListener", "firePipettePicked", "pickedColor", "firePipetteUpdated", "updatedColor", "firePipetteCancelled", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nColorPickerModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorPickerModel.kt\ncom/intellij/ui/colorpicker/ColorPickerModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1869#2,2:106\n1869#2,2:108\n1869#2,2:110\n1869#2,2:112\n1869#2,2:114\n1869#2,2:116\n*S KotlinDebug\n*F\n+ 1 ColorPickerModel.kt\ncom/intellij/ui/colorpicker/ColorPickerModel\n*L\n44#1:106,2\n60#1:108,2\n99#1:110,2\n101#1:112,2\n103#1:114,2\n50#1:116,2\n*E\n"})
public final class ColorPickerModel {
    @NotNull
    private final Set<ColorListener> listeners;
    @NotNull
    private final Set<ColorPipette.Callback> pipetteListeners;
    @NotNull
    private final Set<ColorListener> instantListeners;
    private boolean changedByUser;
    @NotNull
    private Color color;
    @NotNull
    private final float[] hsb;

    public ColorPickerModel(@NotNull Color originalColor) {
        Intrinsics.checkNotNullParameter((Object)originalColor, (String)"originalColor");
        this.listeners = new LinkedHashSet();
        this.pipetteListeners = new LinkedHashSet();
        this.instantListeners = new LinkedHashSet();
        this.color = originalColor;
        float[] fArray = Color.RGBtoHSB(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), null);
        Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"RGBtoHSB(...)");
        this.hsb = fArray;
    }

    public /* synthetic */ ColorPickerModel(Color color, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            color = ColorPickerModelKt.getDEFAULT_PICKER_COLOR();
        }
        this(color);
    }

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    public final void setColor(@NotNull Color newColor, @Nullable Object source) {
        Intrinsics.checkNotNullParameter((Object)newColor, (String)"newColor");
        this.color = newColor;
        Color.RGBtoHSB(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.hsb);
        if (source != null) {
            this.changedByUser = true;
        }
        Iterable $this$forEach$iv = this.instantListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ColorListener it = (ColorListener)element$iv;
            boolean bl = false;
            it.colorChanged(this.color, source);
        }
    }

    public static /* synthetic */ void setColor$default(ColorPickerModel colorPickerModel, Color color, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        colorPickerModel.setColor(color, object);
    }

    public final void onClose() {
        if (this.changedByUser) {
            ApplicationManager.getApplication().invokeLater(() -> ColorPickerModel.onClose$lambda$0(this));
        }
    }

    public final void onCancel() {
    }

    public final void applyColorToSource(@NotNull Color newColor, @Nullable Object source) {
        Intrinsics.checkNotNullParameter((Object)newColor, (String)"newColor");
        this.setColor(newColor, source);
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ColorListener it = (ColorListener)element$iv;
            boolean bl = false;
            it.colorChanged(this.color, source);
        }
    }

    public static /* synthetic */ void applyColorToSource$default(ColorPickerModel colorPickerModel, Color color, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        colorPickerModel.applyColorToSource(color, object);
    }

    public final int getRed() {
        return this.color.getRed();
    }

    public final int getGreen() {
        return this.color.getGreen();
    }

    public final int getBlue() {
        return this.color.getBlue();
    }

    public final int getAlpha() {
        return this.color.getAlpha();
    }

    @NotNull
    public final String getHex() {
        String string = Integer.toHexString(this.color.getRGB());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHexString(...)");
        return string;
    }

    public final float getHue() {
        return this.hsb[0];
    }

    public final float getSaturation() {
        return this.hsb[1];
    }

    public final float getBrightness() {
        return this.hsb[2];
    }

    public final void addListener(@NotNull ColorListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.addListener(listener2, true);
    }

    public final void addListener(@NotNull ColorListener listener2, boolean invokeOnEveryColorChange) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
        if (invokeOnEveryColorChange) {
            this.instantListeners.add(listener2);
        }
    }

    public final void removeListener(@NotNull ColorListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
        this.instantListeners.remove(listener2);
    }

    public final boolean addPipetteListener(@NotNull ColorPipette.Callback listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        return this.pipetteListeners.add(listener2);
    }

    public final boolean removePipetteListener(@NotNull ColorPipette.Callback listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        return this.pipetteListeners.remove(listener2);
    }

    public final void firePipettePicked(@NotNull Color pickedColor) {
        Intrinsics.checkNotNullParameter((Object)pickedColor, (String)"pickedColor");
        Iterable $this$forEach$iv = this.pipetteListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ColorPipette.Callback it = (ColorPipette.Callback)element$iv;
            boolean bl = false;
            it.picked(pickedColor);
        }
    }

    public final void firePipetteUpdated(@NotNull Color updatedColor) {
        Intrinsics.checkNotNullParameter((Object)updatedColor, (String)"updatedColor");
        Iterable $this$forEach$iv = this.pipetteListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ColorPipette.Callback it = (ColorPipette.Callback)element$iv;
            boolean bl = false;
            it.update(updatedColor);
        }
    }

    public final void firePipetteCancelled() {
        Iterable $this$forEach$iv = this.pipetteListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ColorPipette.Callback it = (ColorPipette.Callback)element$iv;
            boolean bl = false;
            it.cancel();
        }
    }

    private static final void onClose$lambda$0(ColorPickerModel this$0) {
        Iterable $this$forEach$iv = this$0.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ColorListener it = (ColorListener)element$iv;
            boolean bl = false;
            it.colorChanged(this$0.color, (Object)this$0);
        }
    }

    public ColorPickerModel() {
        this(null, 1, null);
    }
}

