/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dsl.builder.impl;

import com.intellij.BundleBase;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBIntSpinner;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.BrowserLink;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.DropDownLink;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPasswordField;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.ui.dsl.UiDslException;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.HyperlinkEventAction;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.ui.dsl.builder.SegmentedButton;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import com.intellij.ui.dsl.builder.TopGap;
import com.intellij.ui.dsl.builder.components.DslLabel;
import com.intellij.ui.dsl.builder.components.DslLabelType;
import com.intellij.ui.dsl.builder.impl.ButtonsGroupImpl;
import com.intellij.ui.dsl.builder.impl.CellBaseImpl;
import com.intellij.ui.dsl.builder.impl.CellImpl;
import com.intellij.ui.dsl.builder.impl.DialogPanelConfig;
import com.intellij.ui.dsl.builder.impl.DslComponentPropertyInternal;
import com.intellij.ui.dsl.builder.impl.PanelContext;
import com.intellij.ui.dsl.builder.impl.PanelImpl;
import com.intellij.ui.dsl.builder.impl.PlaceholderImpl;
import com.intellij.ui.dsl.builder.impl.SegmentedButtonImpl;
import com.intellij.ui.dsl.builder.impl.UtilsKt;
import com.intellij.ui.dsl.gridLayout.UnscaledGaps;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsY;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.MathUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0096\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0011\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010/\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u0010\u001a\u00020\u0000H\u0016J\"\u0010\u0014\u001a\u00020\u00002\b\b\u0001\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J%\u00106\u001a\b\u0012\u0004\u0012\u0002H807\"\b\b\u0000\u00108*\u0002092\u0006\u0010:\u001a\u0002H8H\u0016\u00a2\u0006\u0002\u0010;J\b\u00106\u001a\u00020<H\u0016J%\u0010=\u001a\b\u0012\u0004\u0012\u0002H807\"\b\b\u0000\u00108*\u0002092\u0006\u0010:\u001a\u0002H8H\u0016\u00a2\u0006\u0002\u0010;J\b\u0010>\u001a\u00020?H\u0016J\u0010\u0010.\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u000fH\u0016J\u000e\u0010A\u001a\u00020\u00002\u0006\u0010B\u001a\u00020\u000fJ\u0006\u0010@\u001a\u00020\u000fJ\u0010\u0010C\u001a\u00020\u00002\u0006\u0010D\u001a\u00020EH\u0016J\u0016\u0010C\u001a\u00020\u00002\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u000f0GH\u0016J\u0010\u0010-\u001a\u00020\u00002\u0006\u0010H\u001a\u00020\u000fH\u0016J\u0010\u0010I\u001a\u00020\u00002\u0006\u0010D\u001a\u00020EH\u0016J\u0016\u0010I\u001a\u00020\u00002\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u000f0GH\u0016J\u000e\u0010J\u001a\u00020\u00002\u0006\u0010K\u001a\u00020\u000fJ\u0006\u0010H\u001a\u00020\u000fJ\u0010\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J\u0010\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J!\u0010L\u001a\u00020\u00072\u0017\u0010M\u001a\u0013\u0012\u0004\u0012\u00020O\u0012\u0004\u0012\u00020<0N\u00a2\u0006\u0002\bPH\u0016J\u0018\u0010Q\u001a\b\u0012\u0004\u0012\u00020R072\b\b\u0001\u0010S\u001a\u000201H\u0016J\u0018\u0010T\u001a\b\u0012\u0004\u0012\u00020V0U2\b\b\u0001\u0010S\u001a\u000201H\u0016J \u0010W\u001a\b\u0012\u0004\u0012\u00020X0U2\u0006\u0010S\u001a\u0002012\b\u0010\f\u001a\u0004\u0018\u00010YH\u0016J;\u0010Z\u001a\b\u0012\u0004\u0012\u00020[072\b\b\u0001\u0010S\u001a\u0002012!\u0010\\\u001a\u001d\u0012\u0013\u0012\u00110]\u00a2\u0006\f\b^\u0012\b\b_\u0012\u0004\b\b(`\u0012\u0004\u0012\u00020<0NH\u0016J&\u0010Z\u001a\b\u0012\u0004\u0012\u00020[0U2\u0006\u0010S\u001a\u0002012\u0006\u00104\u001a\u00020a2\u0006\u0010b\u001a\u000201H\u0016JA\u0010c\u001a\b\u0012\u0004\u0012\u0002H80d\"\u0004\b\u0000\u001082\f\u0010e\u001a\b\u0012\u0004\u0012\u0002H80f2\u001d\u0010g\u001a\u0019\u0012\u0004\u0012\u00020i\u0012\u0004\u0012\u0002H8\u0012\u0004\u0012\u00020<0h\u00a2\u0006\u0002\bPH\u0016J.\u0010j\u001a\b\u0012\u0004\u0012\u00020k0U2\u0006\u0010l\u001a\u0002032\u0006\u0010m\u001a\u0002032\u0006\u0010n\u001a\u0002032\u0006\u0010o\u001a\u000203H\u0016J\u0016\u0010p\u001a\b\u0012\u0004\u0012\u00020q072\u0006\u0010S\u001a\u000201H\u0016J(\u0010S\u001a\b\u0012\u0004\u0012\u00020r0U2\b\b\u0001\u0010S\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J&\u00100\u001a\b\u0012\u0004\u0012\u00020r072\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J*\u0010s\u001a\b\u0012\u0004\u0012\u00020t072\u0006\u0010S\u001a\u0002012\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020]\u0012\u0004\u0012\u00020<0NH\u0016J\u001e\u0010u\u001a\b\u0012\u0004\u0012\u00020v072\u0006\u0010S\u001a\u0002012\u0006\u0010w\u001a\u000201H\u0016J5\u0010x\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H80y0U\"\u0004\b\u0000\u001082\u0006\u0010z\u001a\u0002H82\f\u0010e\u001a\b\u0012\u0004\u0012\u0002H80{H\u0016\u00a2\u0006\u0002\u0010|J\u0016\u0010}\u001a\b\u0012\u0004\u0012\u00020q072\u0006\u0010}\u001a\u00020~H\u0016J\"\u0010\u007f\u001a\b\u0012\u0004\u0012\u00020q072\u0007\u0010\u0080\u0001\u001a\u0002012\t\u0010\u0081\u0001\u001a\u0004\u0018\u000101H\u0016J\u0010\u0010\u0082\u0001\u001a\t\u0012\u0005\u0012\u00030\u0083\u000107H\u0016JN\u0010\u0084\u0001\u001a\t\u0012\u0005\u0012\u00030\u0085\u00010U2\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\n\u0010\u0088\u0001\u001a\u0005\u0018\u00010\u0089\u00012&\u0010\u008a\u0001\u001a!\u0012\u0015\u0012\u00130\u008b\u0001\u00a2\u0006\r\b^\u0012\t\b_\u0012\u0005\b\b(\u008c\u0001\u0012\u0004\u0012\u000201\u0018\u00010NH\u0016J\u0010\u0010\u008d\u0001\u001a\t\u0012\u0005\u0012\u00030\u008e\u000107H\u0016JN\u0010\u008f\u0001\u001a\t\u0012\u0005\u0012\u00030\u0090\u00010U2\u001e\u0010\u0091\u0001\u001a\u0019\u0012\u0006\b\u0000\u0012\u000201\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002010)0\u0092\u00012\u001c\u0010\u0093\u0001\u001a\u0017\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u0002010)\u0012\u0004\u0012\u0002010\u0092\u0001H\u0016J-\u0010\u0094\u0001\u001a\t\u0012\u0005\u0012\u00030\u0083\u0001072\n\u0010\u0095\u0001\u001a\u0005\u0018\u00010\u0096\u00012\t\u0010\u0097\u0001\u001a\u0004\u0018\u000103H\u0016\u00a2\u0006\u0003\u0010\u0098\u0001J#\u0010\u0099\u0001\u001a\t\u0012\u0005\u0012\u00030\u009a\u0001072\b\u0010\u0095\u0001\u001a\u00030\u0096\u00012\u0007\u0010\u009b\u0001\u001a\u000203H\u0016J+\u0010\u0099\u0001\u001a\t\u0012\u0005\u0012\u00030\u009c\u00010U2\u000f\u0010\u0095\u0001\u001a\n\u0012\u0005\u0012\u00030\u009e\u00010\u009d\u00012\b\u0010\u009b\u0001\u001a\u00030\u009e\u0001H\u0016J\u0010\u0010\u009f\u0001\u001a\t\u0012\u0005\u0012\u00030\u00a0\u00010UH\u0016JA\u0010\u00a1\u0001\u001a\u000f\u0012\u000b\u0012\t\u0012\u0004\u0012\u0002H80\u00a2\u00010U\"\u0004\b\u0000\u001082\u000e\u0010\u00a3\u0001\u001a\t\u0012\u0004\u0012\u0002H80\u00a4\u00012\u0013\u0010g\u001a\u000f\u0012\b\b\u0000\u0012\u0004\u0018\u0001H8\u0018\u00010\u00a5\u0001H\u0016J?\u0010\u00a1\u0001\u001a\u000f\u0012\u000b\u0012\t\u0012\u0004\u0012\u0002H80\u00a2\u00010U\"\u0004\b\u0000\u001082\f\u0010e\u001a\b\u0012\u0004\u0012\u0002H80f2\u0013\u0010g\u001a\u000f\u0012\b\b\u0000\u0012\u0004\u0018\u0001H8\u0018\u00010\u00a5\u0001H\u0016J\u0012\u0010\u00a6\u0001\u001a\u00020\u00012\u0007\u0010\u00a7\u0001\u001a\u00020 H\u0016J\u0007\u0010\u00a8\u0001\u001a\u000203J\u0011\u0010\u00a9\u0001\u001a\u00020<2\u0006\u0010H\u001a\u00020\u000fH\u0002J\u0011\u0010\u00aa\u0001\u001a\u00020<2\u0006\u0010@\u001a\u00020\u000fH\u0002J$\u0010\u00ab\u0001\u001a\u00020<2\u000f\u00106\u001a\u000b\u0012\u0007\b\u0001\u0012\u00030\u00ac\u0001072\b\u0010\f\u001a\u0004\u0018\u00010YH\u0002J0\u0010\u00ad\u0001\u001a\b\u0012\u0004\u0012\u0002H807\"\b\b\u0000\u00108*\u0002092\u0006\u0010:\u001a\u0002H82\u0007\u0010\u00ae\u0001\u001a\u000209H\u0002\u00a2\u0006\u0003\u0010\u00af\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\"\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\f\u001a\u0004\u0018\u00010\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\"\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\u0010\f\u001a\u0004\u0018\u00010\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\"\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\u0010\f\u001a\u0004\u0018\u00010\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001c\u0010%\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\"\"\u0004\b'\u0010$R\u001d\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010*0)\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00b0\u0001"}, d2={"Lcom/intellij/ui/dsl/builder/impl/RowImpl;", "Lcom/intellij/ui/dsl/builder/Row;", "dialogPanelConfig", "Lcom/intellij/ui/dsl/builder/impl/DialogPanelConfig;", "panelContext", "Lcom/intellij/ui/dsl/builder/impl/PanelContext;", "parent", "Lcom/intellij/ui/dsl/builder/impl/PanelImpl;", "rowLayout", "Lcom/intellij/ui/dsl/builder/RowLayout;", "<init>", "(Lcom/intellij/ui/dsl/builder/impl/DialogPanelConfig;Lcom/intellij/ui/dsl/builder/impl/PanelContext;Lcom/intellij/ui/dsl/builder/impl/PanelImpl;Lcom/intellij/ui/dsl/builder/RowLayout;)V", "value", "getRowLayout", "()Lcom/intellij/ui/dsl/builder/RowLayout;", "", "resizableRow", "getResizableRow", "()Z", "Lcom/intellij/ui/dsl/builder/components/DslLabel;", "rowComment", "getRowComment", "()Lcom/intellij/ui/dsl/builder/components/DslLabel;", "Lcom/intellij/ui/dsl/builder/TopGap;", "topGap", "getTopGap", "()Lcom/intellij/ui/dsl/builder/TopGap;", "Lcom/intellij/ui/dsl/builder/BottomGap;", "bottomGap", "getBottomGap", "()Lcom/intellij/ui/dsl/builder/BottomGap;", "internalGaps", "Lcom/intellij/ui/dsl/gridLayout/UnscaledGapsY;", "getInternalGaps", "()Lcom/intellij/ui/dsl/gridLayout/UnscaledGapsY;", "setInternalGaps", "(Lcom/intellij/ui/dsl/gridLayout/UnscaledGapsY;)V", "customGaps", "getCustomGaps", "setCustomGaps", "cells", "", "Lcom/intellij/ui/dsl/builder/impl/CellBaseImpl;", "getCells", "()Ljava/util/List;", "visible", "enabled", "layout", "comment", "", "maxLineLength", "", "action", "Lcom/intellij/ui/dsl/builder/HyperlinkEventAction;", "cell", "Lcom/intellij/ui/dsl/builder/impl/CellImpl;", "T", "Ljavax/swing/JComponent;", "component", "(Ljavax/swing/JComponent;)Lcom/intellij/ui/dsl/builder/impl/CellImpl;", "", "scrollCell", "placeholder", "Lcom/intellij/ui/dsl/builder/impl/PlaceholderImpl;", "isEnabled", "enabledFromParent", "parentEnabled", "enabledIf", "predicate", "Lcom/intellij/ui/layout/ComponentPredicate;", "property", "Lcom/intellij/openapi/observable/properties/ObservableProperty;", "isVisible", "visibleIf", "visibleFromParent", "parentVisible", "panel", "init", "Lkotlin/Function1;", "Lcom/intellij/ui/dsl/builder/Panel;", "Lkotlin/ExtensionFunctionType;", "checkBox", "Lcom/intellij/ui/components/JBCheckBox;", "text", "threeStateCheckBox", "Lcom/intellij/ui/dsl/builder/Cell;", "Lcom/intellij/util/ui/ThreeStateCheckBox;", "radioButton", "Lcom/intellij/ui/components/JBRadioButton;", "", "button", "Ljavax/swing/JButton;", "actionListener", "Ljava/awt/event/ActionEvent;", "Lkotlin/ParameterName;", "name", "event", "Lcom/intellij/openapi/actionSystem/AnAction;", "actionPlace", "segmentedButton", "Lcom/intellij/ui/dsl/builder/SegmentedButton;", "items", "", "renderer", "Lkotlin/Function2;", "Lcom/intellij/ui/dsl/builder/SegmentedButton$ItemPresentation;", "slider", "Ljavax/swing/JSlider;", "min", "max", "minorTickSpacing", "majorTickSpacing", "label", "Ljavax/swing/JLabel;", "Ljavax/swing/JEditorPane;", "link", "Lcom/intellij/ui/components/ActionLink;", "browserLink", "Lcom/intellij/ui/components/BrowserLink;", "url", "dropDownLink", "Lcom/intellij/ui/components/DropDownLink;", "item", "", "(Ljava/lang/Object;Ljava/util/List;)Lcom/intellij/ui/dsl/builder/Cell;", "icon", "Ljavax/swing/Icon;", "contextHelp", "description", "title", "textField", "Lcom/intellij/ui/components/JBTextField;", "textFieldWithBrowseButton", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "fileChooserDescriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "fileChosen", "Lcom/intellij/openapi/vfs/VirtualFile;", "chosenFile", "passwordField", "Lcom/intellij/ui/components/JBPasswordField;", "expandableTextField", "Lcom/intellij/ui/components/fields/ExpandableTextField;", "parser", "Lcom/intellij/util/Function;", "joiner", "intTextField", "range", "Lkotlin/ranges/IntRange;", "keyboardStep", "(Lkotlin/ranges/IntRange;Ljava/lang/Integer;)Lcom/intellij/ui/dsl/builder/impl/CellImpl;", "spinner", "Lcom/intellij/ui/JBIntSpinner;", "step", "Ljavax/swing/JSpinner;", "Lkotlin/ranges/ClosedRange;", "", "textArea", "Lcom/intellij/ui/components/JBTextArea;", "comboBox", "Lcom/intellij/openapi/ui/ComboBox;", "model", "Ljavax/swing/ComboBoxModel;", "Ljavax/swing/ListCellRenderer;", "customize", "customRowGaps", "getIndent", "doVisible", "doEnabled", "registerRadioButton", "Ljavax/swing/JRadioButton;", "cellImpl", "viewComponent", "(Ljavax/swing/JComponent;Ljavax/swing/JComponent;)Lcom/intellij/ui/dsl/builder/impl/CellImpl;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nRowImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RowImpl.kt\ncom/intellij/ui/dsl/builder/impl/RowImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,440:1\n1#2:441\n*E\n"})
public class RowImpl
implements Row {
    @NotNull
    private final DialogPanelConfig dialogPanelConfig;
    @NotNull
    private final PanelContext panelContext;
    @NotNull
    private final PanelImpl parent;
    @NotNull
    private RowLayout rowLayout;
    private boolean resizableRow;
    @Nullable
    private DslLabel rowComment;
    @Nullable
    private TopGap topGap;
    @Nullable
    private BottomGap bottomGap;
    @NotNull
    private UnscaledGapsY internalGaps;
    @Nullable
    private UnscaledGapsY customGaps;
    @NotNull
    private final List<CellBaseImpl<?>> cells;
    private boolean visible;
    private boolean enabled;

    public RowImpl(@NotNull DialogPanelConfig dialogPanelConfig, @NotNull PanelContext panelContext, @NotNull PanelImpl parent, @NotNull RowLayout rowLayout) {
        Intrinsics.checkNotNullParameter((Object)dialogPanelConfig, (String)"dialogPanelConfig");
        Intrinsics.checkNotNullParameter((Object)panelContext, (String)"panelContext");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)((Object)rowLayout), (String)"rowLayout");
        this.dialogPanelConfig = dialogPanelConfig;
        this.panelContext = panelContext;
        this.parent = parent;
        this.rowLayout = rowLayout;
        this.internalGaps = UnscaledGapsY.EMPTY;
        this.cells = new ArrayList();
        this.visible = true;
        this.enabled = true;
    }

    @NotNull
    public final RowLayout getRowLayout() {
        return this.rowLayout;
    }

    public final boolean getResizableRow() {
        return this.resizableRow;
    }

    @Nullable
    public final DslLabel getRowComment() {
        return this.rowComment;
    }

    @Nullable
    public final TopGap getTopGap() {
        return this.topGap;
    }

    @Nullable
    public final BottomGap getBottomGap() {
        return this.bottomGap;
    }

    @NotNull
    public final UnscaledGapsY getInternalGaps() {
        return this.internalGaps;
    }

    public final void setInternalGaps(@NotNull UnscaledGapsY unscaledGapsY) {
        Intrinsics.checkNotNullParameter((Object)unscaledGapsY, (String)"<set-?>");
        this.internalGaps = unscaledGapsY;
    }

    @Nullable
    public final UnscaledGapsY getCustomGaps() {
        return this.customGaps;
    }

    public final void setCustomGaps(@Nullable UnscaledGapsY unscaledGapsY) {
        this.customGaps = unscaledGapsY;
    }

    @NotNull
    public final List<CellBaseImpl<?>> getCells() {
        return this.cells;
    }

    @Override
    @NotNull
    public RowImpl layout(@NotNull RowLayout rowLayout) {
        Intrinsics.checkNotNullParameter((Object)((Object)rowLayout), (String)"rowLayout");
        this.rowLayout = rowLayout;
        return this;
    }

    @Override
    @NotNull
    public RowImpl resizableRow() {
        this.resizableRow = true;
        return this;
    }

    @Override
    @NotNull
    public RowImpl rowComment(@NlsContexts.DetailedDescription @NotNull String comment2, int maxLineLength, @NotNull HyperlinkEventAction action2) {
        Intrinsics.checkNotNullParameter((Object)comment2, (String)"comment");
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        this.rowComment = UtilsKt.createComment(comment2, maxLineLength, action2);
        return this;
    }

    @NotNull
    public <T extends JComponent> CellImpl<T> cell(@NotNull T component2) {
        Intrinsics.checkNotNullParameter(component2, (String)"component");
        return this.cellImpl(component2, component2);
    }

    @Override
    public void cell() {
        this.cells.add(null);
    }

    @NotNull
    public <T extends JComponent> CellImpl<T> scrollCell(@NotNull T component2) {
        Intrinsics.checkNotNullParameter(component2, (String)"component");
        return this.cellImpl(component2, (JComponent)new JBScrollPane((Component)component2));
    }

    @Override
    @NotNull
    public PlaceholderImpl placeholder() {
        PlaceholderImpl result2 = new PlaceholderImpl(this);
        this.cells.add(result2);
        return result2;
    }

    @Override
    @NotNull
    public RowImpl enabled(boolean isEnabled) {
        this.enabled = isEnabled;
        if (this.parent.isEnabled(this)) {
            this.doEnabled(this.enabled);
        }
        return this;
    }

    @NotNull
    public final RowImpl enabledFromParent(boolean parentEnabled) {
        this.doEnabled(parentEnabled && this.enabled);
        return this;
    }

    public final boolean isEnabled() {
        return this.enabled && this.parent.isEnabled(this);
    }

    @Override
    @NotNull
    public RowImpl enabledIf(@NotNull ComponentPredicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        this.enabled((Boolean)predicate.invoke());
        predicate.addListener(arg_0 -> RowImpl.enabledIf$lambda$0(this, arg_0));
        return this;
    }

    @Override
    @NotNull
    public RowImpl enabledIf(@NotNull ObservableProperty<Boolean> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        return this.enabledIf(ComponentPredicate.Companion.fromObservableProperty$default((ComponentPredicate.Companion)ComponentPredicate.Companion, property, null, (int)2, null));
    }

    @Override
    @NotNull
    public RowImpl visible(boolean isVisible) {
        this.visible = isVisible;
        if (this.parent.isVisible(this)) {
            this.doVisible(this.visible);
        }
        return this;
    }

    @Override
    @NotNull
    public RowImpl visibleIf(@NotNull ComponentPredicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        this.visible((Boolean)predicate.invoke());
        predicate.addListener(arg_0 -> RowImpl.visibleIf$lambda$0(this, arg_0));
        return this;
    }

    @Override
    @NotNull
    public RowImpl visibleIf(@NotNull ObservableProperty<Boolean> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        return this.visibleIf(ComponentPredicate.Companion.fromObservableProperty$default((ComponentPredicate.Companion)ComponentPredicate.Companion, property, null, (int)2, null));
    }

    @NotNull
    public final RowImpl visibleFromParent(boolean parentVisible) {
        this.doVisible(parentVisible && this.visible);
        return this;
    }

    public final boolean isVisible() {
        return this.visible && this.parent.isVisible(this);
    }

    @Override
    @NotNull
    public RowImpl topGap(@NotNull TopGap topGap) {
        Intrinsics.checkNotNullParameter((Object)((Object)topGap), (String)"topGap");
        this.topGap = topGap;
        return this;
    }

    @Override
    @NotNull
    public RowImpl bottomGap(@NotNull BottomGap bottomGap) {
        Intrinsics.checkNotNullParameter((Object)((Object)bottomGap), (String)"bottomGap");
        this.bottomGap = bottomGap;
        return this;
    }

    @Override
    @NotNull
    public PanelImpl panel(@NotNull Function1<? super Panel, Unit> init2) {
        Intrinsics.checkNotNullParameter(init2, (String)"init");
        PanelImpl result2 = new PanelImpl(this.dialogPanelConfig, this.parent.getSpacingConfiguration(), this);
        init2.invoke((Object)result2);
        this.cells.add(result2);
        return result2;
    }

    @NotNull
    public CellImpl<JBCheckBox> checkBox(@NlsContexts.Checkbox @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return ((CellImpl)this.cell((JComponent)new JBCheckBox(text2))).applyToComponent(RowImpl::checkBox$lambda$0);
    }

    @Override
    @NotNull
    public Cell<ThreeStateCheckBox> threeStateCheckBox(@NlsContexts.Checkbox @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return ((CellImpl)this.cell((JComponent)new ThreeStateCheckBox(text2))).applyToComponent(RowImpl::threeStateCheckBox$lambda$0);
    }

    @Override
    @NotNull
    public Cell<JBRadioButton> radioButton(@NotNull String text2, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Cell result2 = ((CellImpl)this.cell((JComponent)new JBRadioButton(text2))).applyToComponent(RowImpl::radioButton$lambda$0);
        this.registerRadioButton((CellImpl<? extends JRadioButton>)result2, value);
        return result2;
    }

    @NotNull
    public CellImpl<JButton> button(@NlsContexts.Button @NotNull String text2, @NotNull Function1<? super ActionEvent, Unit> actionListener) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        JButton button2 = new JButton(BundleBase.replaceMnemonicAmpersand((String)text2));
        button2.addActionListener(arg_0 -> RowImpl.button$lambda$0(actionListener, arg_0));
        button2.setOpaque(false);
        return this.cell(button2);
    }

    @Override
    @NotNull
    public Cell<JButton> button(@NotNull String text2, @NotNull AnAction action2, @NotNull String actionPlace) {
        CellImpl cellImpl;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Intrinsics.checkNotNullParameter((Object)actionPlace, (String)"actionPlace");
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        result2.element = this.button(text2, arg_0 -> RowImpl.button$lambda$1(action2, result2, actionPlace, arg_0));
        if (result2.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"result");
            cellImpl = null;
        } else {
            cellImpl = (CellImpl)result2.element;
        }
        return cellImpl;
    }

    @Override
    @NotNull
    public <T> SegmentedButton<T> segmentedButton(@NotNull Collection<? extends T> items2, @NotNull Function2<? super SegmentedButton.ItemPresentation, ? super T, Unit> renderer2) {
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        Intrinsics.checkNotNullParameter(renderer2, (String)"renderer");
        SegmentedButtonImpl<? extends T> result2 = new SegmentedButtonImpl<T>(this.dialogPanelConfig, this, renderer2);
        result2.setItems(items2);
        this.cells.add(result2);
        return result2;
    }

    @Override
    @NotNull
    public Cell<JSlider> slider(int min, int max, int minorTickSpacing, int majorTickSpacing) {
        JSlider slider = new JSlider();
        UIUtil.setSliderIsFilled((JSlider)slider, (boolean)true);
        slider.setPaintLabels(true);
        slider.setPaintTicks(true);
        slider.setPaintTrack(true);
        slider.setMinimum(min);
        slider.setMaximum(max);
        slider.setMinorTickSpacing(minorTickSpacing);
        slider.setMajorTickSpacing(majorTickSpacing);
        return this.cell(slider);
    }

    @NotNull
    public CellImpl<JLabel> label(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return this.cell(new JLabel(text2));
    }

    @Override
    @NotNull
    public Cell<JEditorPane> text(@NlsContexts.Label @NotNull String text2, int maxLineLength, @NotNull HyperlinkEventAction action2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        DslLabel dslLabel = new DslLabel(DslLabelType.LABEL);
        dslLabel.setAction(action2);
        dslLabel.setMaxLineLength(maxLineLength);
        dslLabel.setText(text2);
        Cell result2 = this.cell(dslLabel);
        if (maxLineLength == -1) {
            ((CellImpl)result2).align(AlignX.FILL.INSTANCE);
        }
        return result2;
    }

    @NotNull
    public CellImpl<JEditorPane> comment(@NotNull String comment2, int maxLineLength, @NotNull HyperlinkEventAction action2) {
        Intrinsics.checkNotNullParameter((Object)comment2, (String)"comment");
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Cell result2 = this.cell(UtilsKt.createComment(comment2, maxLineLength, action2));
        if (maxLineLength == -1) {
            ((CellImpl)result2).align(AlignX.FILL.INSTANCE);
        }
        return result2;
    }

    @NotNull
    public CellImpl<ActionLink> link(@NotNull String text2, @NotNull Function1<? super ActionEvent, Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        return this.cell((JComponent)new ActionLink(text2, action2));
    }

    @NotNull
    public CellImpl<BrowserLink> browserLink(@NotNull String text2, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.cell((JComponent)new BrowserLink(text2, url));
    }

    @Override
    @NotNull
    public <T> Cell<DropDownLink<T>> dropDownLink(T item, @NotNull List<? extends T> items2) {
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        return this.cell((JComponent)new DropDownLink(item, items2, RowImpl::dropDownLink$lambda$0, true));
    }

    @NotNull
    public CellImpl<JLabel> icon(@NotNull Icon icon2) {
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        JBLabel label2 = new JBLabel(icon2);
        label2.setDisabledIcon(IconUtil.desaturate((Icon)icon2));
        return this.cell((JComponent)label2);
    }

    @NotNull
    public CellImpl<JLabel> contextHelp(@NotNull String description, @Nullable String title2) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        ContextHelpLabel contextHelpLabel = title2 == null ? ContextHelpLabel.create((String)description) : ContextHelpLabel.create((String)title2, (String)description);
        Intrinsics.checkNotNull((Object)contextHelpLabel);
        ContextHelpLabel result2 = contextHelpLabel;
        return this.cell((JComponent)result2);
    }

    @NotNull
    public CellImpl<JBTextField> textField() {
        Cell result2 = this.cell((JComponent)new JBTextField());
        TextFieldKt.columns(result2, 18);
        return result2;
    }

    @Override
    @NotNull
    public Cell<TextFieldWithBrowseButton> textFieldWithBrowseButton(@NotNull FileChooserDescriptor fileChooserDescriptor2, @Nullable Project project2, @Nullable Function1<? super VirtualFile, String> fileChosen) {
        Intrinsics.checkNotNullParameter((Object)fileChooserDescriptor2, (String)"fileChooserDescriptor");
        Cell result2 = ((CellImpl)this.cell((JComponent)ComponentsKt.textFieldWithBrowseButton(project2, fileChooserDescriptor2, fileChosen))).applyToComponent(RowImpl::textFieldWithBrowseButton$lambda$0);
        TextFieldWithBrowseButtonKt.columns(result2, 18);
        return result2;
    }

    @NotNull
    public CellImpl<JBPasswordField> passwordField() {
        Cell result2 = this.cell((JComponent)new JBPasswordField());
        TextFieldKt.columns(result2, 18);
        return result2;
    }

    @Override
    @NotNull
    public Cell<ExpandableTextField> expandableTextField(@NotNull Function<? super String, ? extends List<String>> parser, @NotNull Function<? super List<String>, String> joiner) {
        Intrinsics.checkNotNullParameter(parser, (String)"parser");
        Intrinsics.checkNotNullParameter(joiner, (String)"joiner");
        Cell result2 = this.cell((JComponent)new ExpandableTextField(parser, joiner));
        TextFieldKt.columns(result2, 18);
        return result2;
    }

    @NotNull
    public CellImpl<JBTextField> intTextField(@Nullable IntRange range, @Nullable Integer keyboardStep) {
        Cell result2;
        block0: {
            result2 = ((CellImpl)this.cell((JComponent)new JBTextField())).validationOnInput((arg_0, arg_1) -> RowImpl.intTextField$lambda$0(range, arg_0, arg_1));
            TextFieldKt.columns(result2, 6);
            ((JBTextField)((CellImpl)result2).getComponent()).putClientProperty((Object)DslComponentPropertyInternal.INT_TEXT_RANGE, (Object)range);
            Integer n = keyboardStep;
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl = false;
            ((JBTextField)((CellImpl)result2).getComponent()).addKeyListener((KeyListener)new KeyAdapter(keyboardStep, (CellImpl<JBTextField>)result2, range){
                final /* synthetic */ Integer $keyboardStep;
                final /* synthetic */ CellImpl<JBTextField> $result;
                final /* synthetic */ IntRange $range;
                {
                    this.$keyboardStep = $keyboardStep;
                    this.$result = $result;
                    this.$range = $range;
                }

                public void keyPressed(KeyEvent e) {
                    int n;
                    Integer n2;
                    KeyEvent keyEvent = e;
                    Integer n3 = n2 = keyEvent != null ? Integer.valueOf(keyEvent.getKeyCode()) : null;
                    int n4 = 38;
                    if (n3 != null && n3 == n4) {
                        n = this.$keyboardStep;
                    } else {
                        Integer n5 = n2;
                        n4 = 40;
                        if (n5 != null && n5 == n4) {
                            n = -this.$keyboardStep.intValue();
                        } else {
                            return;
                        }
                    }
                    int increment = n;
                    String string = this.$result.getComponent().getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    Integer value = StringsKt.toIntOrNull((String)string);
                    if (value != null) {
                        value = value + increment;
                        if (this.$range != null) {
                            value = MathUtil.clamp((int)value, (int)this.$range.getFirst(), (int)this.$range.getLast());
                        }
                        this.$result.getComponent().setText(String.valueOf(value));
                        e.consume();
                    }
                }
            });
        }
        return result2;
    }

    @NotNull
    public CellImpl<JBIntSpinner> spinner(@NotNull IntRange range, int step2) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return ((CellImpl)this.cell((JComponent)new JBIntSpinner(range.getFirst(), range.getFirst(), range.getLast(), step2))).applyToComponent(RowImpl::spinner$lambda$0);
    }

    @Override
    @NotNull
    public Cell<JSpinner> spinner(@NotNull ClosedRange<Double> range, double step2) {
        Intrinsics.checkNotNullParameter(range, (String)"range");
        return ((CellImpl)this.cell(new JSpinner(new SpinnerNumberModel(((Number)((Object)range.getStart())).doubleValue(), ((Number)((Object)range.getStart())).doubleValue(), ((Number)((Object)range.getEndInclusive())).doubleValue(), step2)))).applyToComponent(RowImpl::spinner$lambda$1);
    }

    @Override
    @NotNull
    public Cell<JBTextArea> textArea() {
        JBTextArea textArea = new JBTextArea();
        textArea.setBorder((Border)new JBEmptyBorder(3, 5, 3, 5));
        textArea.setColumns(18);
        textArea.setFont((Font)JBFont.regular());
        textArea.getEmptyText().setFont((Font)JBFont.regular());
        textArea.putClientProperty((Object)DslComponentProperty.VISUAL_PADDINGS, (Object)UnscaledGaps.EMPTY);
        return this.scrollCell((JComponent)textArea);
    }

    @Override
    @NotNull
    public <T> Cell<ComboBox<T>> comboBox(@NotNull ComboBoxModel<T> model2, @Nullable ListCellRenderer<? super T> renderer2) {
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        ComboBox component2 = new ComboBox(model2);
        if (renderer2 == null) {
            if (!ExperimentalUI.Companion.isNewUI()) {
                component2.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", arg_0 -> RowImpl.comboBox$lambda$1(RowImpl::comboBox$lambda$0, arg_0)));
            }
        } else {
            component2.setRenderer(renderer2);
        }
        return this.cell((JComponent)component2);
    }

    @Override
    @NotNull
    public <T> Cell<ComboBox<T>> comboBox(@NotNull Collection<? extends T> items2, @Nullable ListCellRenderer<? super T> renderer2) {
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        return this.comboBox((ComboBoxModel)new DefaultComboBoxModel<T>(new Vector<T>(items2)), renderer2);
    }

    @Override
    @NotNull
    public Row customize(@NotNull UnscaledGapsY customRowGaps) {
        Intrinsics.checkNotNullParameter((Object)customRowGaps, (String)"customRowGaps");
        this.customGaps = customRowGaps;
        return this;
    }

    public final int getIndent() {
        return this.panelContext.getIndentCount() * this.parent.getSpacingConfiguration().getHorizontalIndent();
    }

    private final void doVisible(boolean isVisible) {
        block1: {
            Iterator<CellBaseImpl<?>> iterator = this.cells.iterator();
            while (iterator.hasNext()) {
                CellBaseImpl<?> cell;
                CellBaseImpl<?> cellBaseImpl = cell = iterator.next();
                if (cellBaseImpl == null) continue;
                cellBaseImpl.visibleFromParent(isVisible);
            }
            DslLabel dslLabel = this.rowComment;
            if (dslLabel == null) break block1;
            DslLabel it = dslLabel;
            boolean bl = false;
            it.setVisible(isVisible);
        }
    }

    private final void doEnabled(boolean isEnabled) {
        block1: {
            Iterator<CellBaseImpl<?>> iterator = this.cells.iterator();
            while (iterator.hasNext()) {
                CellBaseImpl<?> cell;
                CellBaseImpl<?> cellBaseImpl = cell = iterator.next();
                if (cellBaseImpl == null) continue;
                cellBaseImpl.enabledFromParent(isEnabled);
            }
            DslLabel dslLabel = this.rowComment;
            if (dslLabel == null) break block1;
            DslLabel it = dslLabel;
            boolean bl = false;
            it.setEnabled(isEnabled);
        }
    }

    private final void registerRadioButton(CellImpl<? extends JRadioButton> cell, Object value) {
        ButtonsGroupImpl buttonsGroupImpl = this.dialogPanelConfig.getContext().getButtonsGroup();
        if (buttonsGroupImpl == null) {
            throw new UiDslException("Button group must be defined before using radio button", null, 2, null);
        }
        ButtonsGroupImpl buttonsGroup = buttonsGroupImpl;
        buttonsGroup.add(cell, value);
    }

    private final <T extends JComponent> CellImpl<T> cellImpl(T component2, JComponent viewComponent) {
        CellImpl<T> result2 = new CellImpl<T>(this.dialogPanelConfig, component2, this, viewComponent);
        this.cells.add(result2);
        UtilsKt.registerCreationStacktrace(component2);
        if (component2 instanceof JRadioButton) {
            this.registerRadioButton(result2, null);
        }
        return result2;
    }

    private static final Unit enabledIf$lambda$0(RowImpl this$0, boolean it) {
        this$0.enabled(it);
        return Unit.INSTANCE;
    }

    private static final Unit visibleIf$lambda$0(RowImpl this$0, boolean it) {
        this$0.visible(it);
        return Unit.INSTANCE;
    }

    private static final Unit checkBox$lambda$0(JBCheckBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setOpaque(false);
        return Unit.INSTANCE;
    }

    private static final Unit threeStateCheckBox$lambda$0(ThreeStateCheckBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setOpaque(false);
        return Unit.INSTANCE;
    }

    private static final Unit radioButton$lambda$0(JBRadioButton $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setOpaque(false);
        return Unit.INSTANCE;
    }

    private static final void button$lambda$0(Function1 $tmp0, ActionEvent p0) {
        $tmp0.invoke((Object)p0);
    }

    private static final Unit button$lambda$1(AnAction $action, Ref.ObjectRef $result, String $actionPlace, ActionEvent it) {
        CellImpl cellImpl;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($result.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"result");
            cellImpl = null;
        } else {
            cellImpl = (CellImpl)$result.element;
        }
        ActionUtil.invokeAction((AnAction)$action, (Component)((Component)cellImpl.getComponent()), (String)$actionPlace, null, null);
        return Unit.INSTANCE;
    }

    private static final void dropDownLink$lambda$0(Object it) {
    }

    private static final Unit textFieldWithBrowseButton$lambda$0(TextFieldWithBrowseButton $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setOpaque(false);
        $this$applyToComponent.getTextField().setOpaque(false);
        return Unit.INSTANCE;
    }

    private static final ValidationInfo intTextField$lambda$0(IntRange $range, ValidationInfoBuilder $this$validationOnInput, JBTextField it) {
        ValidationInfo validationInfo;
        Intrinsics.checkNotNullParameter((Object)$this$validationOnInput, (String)"$this$validationOnInput");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        Integer value = StringsKt.toIntOrNull((String)string);
        if (value == null) {
            String string2 = UIBundle.message((String)"please.enter.a.number", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            validationInfo = $this$validationOnInput.error(string2);
        } else if ($range != null && !$range.contains(value.intValue())) {
            Object[] objectArray = new Object[]{$range.getFirst(), $range.getLast()};
            String string3 = UIBundle.message((String)"please.enter.a.number.from.0.to.1", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            validationInfo = $this$validationOnInput.error(string3);
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    private static final Unit spinner$lambda$0(JBIntSpinner $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setOpaque(false);
        return Unit.INSTANCE;
    }

    private static final Unit spinner$lambda$1(JSpinner $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setOpaque(false);
        return Unit.INSTANCE;
    }

    private static final String comboBox$lambda$0(Object it) {
        return it.toString();
    }

    private static final String comboBox$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }
}

