/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dsl.listCellRenderer.impl;

import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.dsl.UiDslExceptionKt;
import com.intellij.ui.dsl.listCellRenderer.LcrInitParams;
import com.intellij.ui.dsl.listCellRenderer.LcrRow;
import com.intellij.ui.dsl.listCellRenderer.LcrTextSpeedSearchParams;
import com.intellij.ui.dsl.listCellRenderer.impl.LcrCellBaseImpl;
import com.intellij.ui.dsl.listCellRenderer.impl.LcrTextInitParamsImpl;
import com.intellij.ui.dsl.listCellRenderer.impl.PatchedSimpleColoredComponent;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B<\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ,\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00052\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u001b\u001a\u00020\u0005H\u0016J \u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lcom/intellij/ui/dsl/listCellRenderer/impl/LcrSimpleColoredTextImpl;", "Lcom/intellij/ui/dsl/listCellRenderer/impl/LcrCellBaseImpl;", "Lcom/intellij/ui/dsl/listCellRenderer/impl/LcrTextInitParamsImpl;", "initParams", "baselineAlign", "", "beforeGap", "Lcom/intellij/ui/dsl/listCellRenderer/LcrRow$Gap;", "text", "", "Lorg/jetbrains/annotations/Nls;", "selected", "rowForeground", "Ljava/awt/Color;", "<init>", "(Lcom/intellij/ui/dsl/listCellRenderer/impl/LcrTextInitParamsImpl;ZLcom/intellij/ui/dsl/listCellRenderer/LcrRow$Gap;Ljava/lang/String;ZLjava/awt/Color;)V", "type", "Lcom/intellij/ui/dsl/listCellRenderer/impl/LcrCellBaseImpl$Type;", "getType", "()Lcom/intellij/ui/dsl/listCellRenderer/impl/LcrCellBaseImpl$Type;", "apply", "", "component", "Ljavax/swing/JComponent;", "enabled", "list", "Ljavax/swing/JList;", "isSelected", "applyText", "speedSearchEnabledComponent", "Lcom/intellij/ui/SimpleColoredComponent;", "attributes", "Lcom/intellij/ui/SimpleTextAttributes;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class LcrSimpleColoredTextImpl
extends LcrCellBaseImpl<LcrTextInitParamsImpl> {
    @NotNull
    private final String text;
    private final boolean selected;
    @NotNull
    private final Color rowForeground;
    @NotNull
    private final LcrCellBaseImpl.Type type;

    public LcrSimpleColoredTextImpl(@NotNull LcrTextInitParamsImpl initParams, boolean baselineAlign, @NotNull LcrRow.Gap beforeGap, @NotNull String text2, boolean selected, @NotNull Color rowForeground) {
        Intrinsics.checkNotNullParameter((Object)((Object)initParams), (String)"initParams");
        Intrinsics.checkNotNullParameter((Object)beforeGap, (String)"beforeGap");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)rowForeground, (String)"rowForeground");
        super((LcrInitParams)initParams, baselineAlign, beforeGap, null);
        this.text = text2;
        this.selected = selected;
        this.rowForeground = rowForeground;
        this.type = LcrCellBaseImpl.Type.SIMPLE_COLORED_TEXT;
    }

    @Override
    @NotNull
    public LcrCellBaseImpl.Type getType() {
        return this.type;
    }

    @Override
    public void apply(@NotNull JComponent component2, boolean enabled2, @NotNull JList<?> list2, boolean isSelected) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        UiDslExceptionKt.checkTrue((boolean)this.getType().isInstance(component2));
        PatchedSimpleColoredComponent cfr_ignored_0 = (PatchedSimpleColoredComponent)((Object)component2);
        ((PatchedSimpleColoredComponent)((Object)component2)).clear();
        ((PatchedSimpleColoredComponent)((Object)component2)).setFont(((LcrTextInitParamsImpl)((Object)this.getInitParams())).getFont());
        ((PatchedSimpleColoredComponent)((Object)component2)).getAccessibleContext().setAccessibleName(((LcrTextInitParamsImpl)((Object)this.getInitParams())).getAccessibleName());
        ((PatchedSimpleColoredComponent)((Object)component2)).setRenderingHints(((LcrTextInitParamsImpl)((Object)this.getInitParams())).getRenderingHints());
        SimpleTextAttributes simpleTextAttributes = ((LcrTextInitParamsImpl)((Object)this.getInitParams())).getAttributes();
        if (simpleTextAttributes == null) {
            simpleTextAttributes = new SimpleTextAttributes(0, ((LcrTextInitParamsImpl)((Object)this.getInitParams())).getForeground());
        }
        SimpleTextAttributes baseAttributes = simpleTextAttributes;
        SimpleTextAttributes attributes = !enabled2 ? new SimpleTextAttributes(baseAttributes.getStyle(), UIUtil.getLabelDisabledForeground()) : (this.selected ? new SimpleTextAttributes(baseAttributes.getStyle(), this.rowForeground) : baseAttributes);
        this.applyText(list2, (SimpleColoredComponent)component2, attributes);
    }

    private final void applyText(JComponent speedSearchEnabledComponent, SimpleColoredComponent component2, SimpleTextAttributes attributes) {
        Iterable ranges;
        Iterable iterable;
        LcrTextSpeedSearchParams speedSearchField = ((LcrTextInitParamsImpl)((Object)this.getInitParams())).getSpeedSearchField();
        if (speedSearchField != null) {
            iterable = speedSearchField.getRanges();
            if (iterable == null) {
                SpeedSearchSupply speedSearchSupply = SpeedSearchSupply.getSupply((JComponent)speedSearchEnabledComponent);
                iterable = speedSearchSupply != null ? speedSearchSupply.matchingFragments(this.text) : null;
            }
        } else {
            iterable = null;
        }
        if ((ranges = iterable) == null) {
            component2.append(this.text, attributes);
        } else {
            SimpleTextAttributes highlighted = SimpleTextAttributes.merge((SimpleTextAttributes)attributes, (SimpleTextAttributes)new SimpleTextAttributes(64, null));
            SpeedSearchUtil.appendColoredFragments((SimpleColoredComponent)component2, (String)this.text, (Iterable)ranges, (SimpleTextAttributes)attributes, (SimpleTextAttributes)highlighted);
        }
    }
}

