/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.screenmenu;

import com.intellij.CommonBundle;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SimpleTimer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.ui.mac.MacMenuSettings;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.screenmenu.MenuItem;
import com.intellij.util.ArrayUtilRt;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Menu
extends MenuItem {
    private static final boolean USE_STUB = Boolean.getBoolean("jbScreenMenuBar.useStubItem");
    private static final int CLOSE_DELAY = Integer.getInteger("jbScreenMenuBar.closeDelay", 500);
    private static Boolean IS_ENABLED = null;
    private static Menu ourAppMenu = null;
    private final List<MenuItem> myItems = new ArrayList<MenuItem>();
    private final List<MenuItem> myBuffer = new ArrayList<MenuItem>();
    private Runnable myOnOpen;
    private Runnable myOnClose;
    private Component myComponent;
    private long myOpenTimeMs = 0L;
    private volatile boolean myIsOpened = false;
    long[] myCachedPeers;
    private static MethodHandle invokeAndWait;
    private static MethodHandle invokeLater;

    public Menu(String title2) {
        this.setTitle(title2);
    }

    public final boolean isAnyChildOpened() {
        for (MenuItem item : this.myItems) {
            if (!(item instanceof Menu) || !((Menu)item).myIsOpened) continue;
            return true;
        }
        return false;
    }

    public boolean isOpened() {
        return this.myIsOpened;
    }

    public long getOpenTimeMs() {
        return this.myOpenTimeMs;
    }

    private Menu() {
    }

    public static Menu getAppMenu() {
        if (ourAppMenu == null) {
            ourAppMenu = new Menu();
            long nsMenu = Menu.nativeGetAppMenu();
            Menu.ourAppMenu.nativePeer = ourAppMenu.nativeAttachMenu(nsMenu);
            Menu.ourAppMenu.isInHierarchy = true;
        }
        return ourAppMenu;
    }

    private static String removeMnemonic(@Nls String src) {
        if (src == null) {
            return "";
        }
        TextWithMnemonic txt = TextWithMnemonic.parse((String)src);
        return txt.getText();
    }

    public static void renameAppMenuItems() {
        ArrayList<Object> replace = new ArrayList<Object>(7);
        String bundleName = Menu.getBundleName();
        if (bundleName == null || bundleName.isEmpty()) {
            ApplicationNamesInfo names = ApplicationNamesInfo.getInstance();
            bundleName = names.getProductName();
        }
        replace.add("About.*");
        replace.add(Menu.removeMnemonic(ActionsBundle.message((String)"action.About.text", (Object[])new Object[0])) + " " + bundleName);
        replace.add("Check for Updates...");
        replace.add(Menu.removeMnemonic(ActionsBundle.message((String)"action.CheckForUpdate.text", (Object[])new Object[0])));
        String replacement = SystemInfo.isMacOSVentura ? Menu.removeMnemonic(CommonBundle.message((String)"action.settings.macOS.ventura", (Object[])new Object[0])) : Menu.removeMnemonic(CommonBundle.message((String)"action.settings.mac", (Object[])new Object[0]));
        replace.add("Preferences.*");
        replace.add(replacement);
        replace.add("Settings.*");
        replace.add(replacement);
        replace.add("Services");
        replace.add(Menu.removeMnemonic(CommonBundle.message((String)"action.appmenu.services", (Object[])new Object[0])));
        replace.add("Hide " + bundleName);
        replace.add(Menu.removeMnemonic(CommonBundle.message((String)"action.appmenu.hide_ide", (Object[])new Object[0]) + " " + bundleName));
        replace.add("Hide Others");
        replace.add(Menu.removeMnemonic(CommonBundle.message((String)"action.appmenu.hide_others", (Object[])new Object[0])));
        replace.add("Show All");
        replace.add(Menu.removeMnemonic(CommonBundle.message((String)"action.appmenu.show_all", (Object[])new Object[0])));
        replace.add("Quit.*");
        replace.add(Menu.removeMnemonic(CommonBundle.message((String)"action.appmenu.quit", (Object[])new Object[0]) + " " + bundleName));
        Menu.nativeRenameAppMenuItems(ArrayUtilRt.toStringArray(replace));
    }

    public void setOnOpen(@NotNull Component component2, @NotNull Runnable fillMenuProcedure) {
        if (component2 == null) {
            Menu.$$$reportNull$$$0(0);
        }
        if (fillMenuProcedure == null) {
            Menu.$$$reportNull$$$0(1);
        }
        this.myOnOpen = fillMenuProcedure;
        this.myComponent = component2;
    }

    public void setOnClose(Component component2, Runnable onClose) {
        this.myOnClose = onClose;
        this.myComponent = component2;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        @NonNls String propertyName = e.getPropertyName();
        if ("text".equals(propertyName) || "description".equals(propertyName)) {
            this.setTitle(this.presentation.getText());
        }
    }

    public void setTitle(String label2) {
        this.ensureNativePeer();
        if (label2 == null) {
            label2 = "";
        }
        this.myTitle = label2;
        this.nativeSetTitle(this.nativePeer, label2, this.isInHierarchy);
    }

    public int findIndexByTitle(String re) {
        if (re == null || re.isEmpty()) {
            return -1;
        }
        this.ensureNativePeer();
        return this.nativeFindIndexByTitle(this.nativePeer, re);
    }

    public synchronized MenuItem findItemByTitle(String re) {
        if (re == null || re.isEmpty()) {
            return null;
        }
        this.ensureNativePeer();
        long child = this.nativeFindItemByTitle(this.nativePeer, re);
        return child == 0L ? null : new MenuItem(child);
    }

    synchronized void disposeChildren(int delayMs) {
        if (delayMs <= 0) {
            for (MenuItem item : this.myItems) {
                item.dispose();
            }
        } else {
            ArrayList<MenuItem> copy = new ArrayList<MenuItem>(this.myItems);
            SimpleTimer.getInstance().setUp(() -> {
                for (MenuItem item : copy) {
                    item.dispose();
                }
            }, (long)delayMs);
        }
        this.myItems.clear();
    }

    @Override
    public synchronized void dispose() {
        this.disposeChildren(0);
        this.myCachedPeers = null;
        super.dispose();
    }

    public void beginFill() {
        for (MenuItem item : this.myBuffer) {
            if (item == null) continue;
            Disposer.dispose((Disposable)item);
        }
        this.myBuffer.clear();
    }

    @Nullable
    public MenuItem add(@Nullable MenuItem item) {
        this.myBuffer.add(item);
        return item;
    }

    public synchronized void endFill(boolean onAppKit) {
        this.disposeChildren(0);
        if (this.myBuffer.isEmpty()) {
            return;
        }
        this.myCachedPeers = new long[this.myBuffer.size()];
        for (int c = 0; c < this.myBuffer.size(); ++c) {
            MenuItem menuItem = this.myBuffer.get(c);
            if (menuItem != null) {
                menuItem.ensureNativePeer();
                this.myCachedPeers[c] = menuItem.nativePeer;
                this.myItems.add(menuItem);
                menuItem.isInHierarchy = true;
                continue;
            }
            this.myCachedPeers[c] = 0L;
        }
        this.myBuffer.clear();
        this.refillImpl(onAppKit);
    }

    synchronized void refillImpl(boolean onAppKit) {
        this.ensureNativePeer();
        if (this.myCachedPeers != null) {
            this.nativeRefill(this.nativePeer, this.myCachedPeers, onAppKit);
        }
    }

    public synchronized void endFill() {
        this.endFill(true);
    }

    public synchronized void add(MenuItem item, int position, boolean onAppKit) {
        if (position < 0) {
            return;
        }
        this.ensureNativePeer();
        item.ensureNativePeer();
        this.nativeInsertItem(this.nativePeer, item.nativePeer, position, onAppKit);
        this.myItems.add(item);
    }

    @Override
    synchronized void ensureNativePeer() {
        if (this.nativePeer == 0L) {
            this.nativePeer = this.nativeCreateMenu();
        }
    }

    public void menuNeedsUpdate() {
        this.myIsOpened = true;
        if (this.myOnOpen == null) {
            return;
        }
        this.myOpenTimeMs = System.currentTimeMillis();
        if (USE_STUB) {
            MenuItem stub = new MenuItem();
            this.myItems.add(stub);
            stub.isInHierarchy = true;
            this.ensureNativePeer();
            stub.ensureNativePeer();
            this.nativeAddItem(this.nativePeer, stub.nativePeer, false);
            ApplicationManager.getApplication().invokeLater(() -> {
                this.beginFill();
                this.myOnOpen.run();
                this.endFill(true);
            });
        } else {
            this.beginFill();
            Menu.invokeWithLWCToolkit(this.myOnOpen, this.myComponent, true);
            this.endFill(false);
        }
    }

    public void menuWillOpen() {
        if (!this.myIsOpened) {
            Menu.getLogger().debug("menuNeedsUpdate wasn't called for '" + this.myTitle + "', will do it now");
            this.menuNeedsUpdate();
        }
    }

    public void invokeMenuClosing() {
        this.myIsOpened = false;
        this.disposeChildren(CLOSE_DELAY);
        if (this.myOnClose != null) {
            Menu.invokeWithLWCToolkit(this.myOnClose, this.myComponent, false);
        }
    }

    private native long nativeCreateMenu();

    private native long nativeAttachMenu(long var1);

    private native long nativeFindItemByTitle(long var1, String var3);

    private native int nativeFindIndexByTitle(long var1, String var3);

    private native void nativeSetTitle(long var1, String var3, boolean var4);

    private native void nativeAddItem(long var1, long var3, boolean var5);

    private native void nativeInsertItem(long var1, long var3, int var5, boolean var6);

    native void nativeRefill(long var1, long[] var3, boolean var4);

    private static native void nativeInitClass();

    private static native long nativeGetAppMenu();

    private static native void nativeRenameAppMenuItems(String[] var0);

    public static boolean isJbScreenMenuEnabled() {
        if (IS_ENABLED != null) {
            return IS_ENABLED;
        }
        IS_ENABLED = false;
        if (!MacMenuSettings.isJbSystemMenu) {
            return false;
        }
        if (Boolean.getBoolean("apple.laf.useScreenMenuBar")) {
            Menu.getLogger().info("apple.laf.useScreenMenuBar==true, default screen menu implementation will be used");
            return false;
        }
        Path lib = PathManager.findBinFile((String)"libmacscreenmenu64.dylib");
        try {
            System.load(Objects.requireNonNull(lib).toString());
            Menu.nativeInitClass();
            Menu test = new Menu("test");
            test.ensureNativePeer();
            Disposer.dispose((Disposable)test);
        }
        catch (Throwable e) {
            Menu.getLogger().warn("can't load menu library: " + String.valueOf(lib) + ", exception: " + e.getMessage());
            return false;
        }
        IS_ENABLED = true;
        Menu.getLogger().info("use new ScreenMenuBar implementation");
        return true;
    }

    @Nullable
    static MethodHandle getToolkitInvokeMethod(boolean wait) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            if (wait) {
                if (invokeAndWait == null) {
                    invokeAndWait = lookup.findStatic(Menu.getToolkitClass(), "invokeAndWait", MethodType.methodType(Void.TYPE, Runnable.class, Component.class, Boolean.TYPE, Integer.TYPE));
                }
                return invokeAndWait;
            }
            if (invokeLater == null) {
                invokeLater = lookup.findStatic(Menu.getToolkitClass(), "invokeLater", MethodType.methodType(Void.TYPE, Runnable.class, Component.class));
            }
            return invokeLater;
        }
        catch (ClassNotFoundException e) {
            Menu.getLogger().warn("can't find sun.lwawt.macosx.LWCToolkit, screen menu won't be filled");
            return null;
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            Menu.getLogger().warn("can't find sun.lwawt.macosx.LWCToolkit method, screen menu won't be filled", (Throwable)e);
            return null;
        }
    }

    @NotNull
    private static Class<?> getToolkitClass() throws ClassNotFoundException {
        Class<?> clazz = Class.forName("sun.lwawt.macosx.LWCToolkit");
        if (clazz == null) {
            Menu.$$$reportNull$$$0(2);
        }
        return clazz;
    }

    private static void invokeWithLWCToolkit(Runnable r, Component invoker, boolean wait) {
        MethodHandle invokeMethod = Menu.getToolkitInvokeMethod(wait);
        if (invokeMethod == null) {
            return;
        }
        try {
            if (wait) {
                invokeMethod.invoke(r, invoker, true, -1);
            } else {
                invokeMethod.invoke(r, invoker);
            }
        }
        catch (Throwable e) {
            Menu.getLogger().warn("invokeWithLWCToolkit.invokeAndWait: " + String.valueOf(e));
        }
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(Menu.class);
        if (logger == null) {
            Menu.$$$reportNull$$$0(3);
        }
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getBundleName() {
        String bundleName;
        ID nativePool = Foundation.invoke((String)"NSAutoreleasePool", (String)"new", (Object[])new Object[0]);
        try {
            ID bundle = Foundation.invoke((String)"NSBundle", (String)"mainBundle", (Object[])new Object[0]);
            ID dict = Foundation.invoke((ID)bundle, (String)"infoDictionary", (Object[])new Object[0]);
            ID nsBundleName = Foundation.invoke((ID)dict, (String)"objectForKey:", (Object[])new Object[]{Foundation.nsString((String)"CFBundleName")});
            bundleName = Foundation.toStringViaUTF8((ID)nsBundleName);
        }
        finally {
            Foundation.invoke((ID)nativePool, (String)"release", (Object[])new Object[0]);
        }
        return bundleName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fillMenuProcedure";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/screenmenu/Menu";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/screenmenu/Menu";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolkitClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setOnOpen";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

