/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.plaf.beg;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalTabbedPaneUI;
import javax.swing.text.View;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class BegTabbedPaneUI
extends MetalTabbedPaneUI {
    private static final Color LIGHT = new Color(247, 243, 239);
    private static final Color DARK = new Color(189, 187, 182);
    private boolean myNoIconSpace = false;
    private boolean myPaintContentBorder = true;
    private FontMetrics myLayoutMetrics = null;

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        Object clientProperty = UIUtil.getTabbedPanePaintContentBorder((JComponent)c);
        if (clientProperty instanceof Boolean) {
            Boolean aBoolean = (Boolean)clientProperty;
            this.myPaintContentBorder = aBoolean;
        }
    }

    @Override
    protected Insets getContentBorderInsets(int tabPlacement) {
        if (tabPlacement == 1 && !this.myPaintContentBorder) {
            return JBUI.insetsTop((int)1);
        }
        if (tabPlacement == 3 && !this.myPaintContentBorder) {
            return JBUI.insetsBottom((int)1);
        }
        if (tabPlacement == 2 && !this.myPaintContentBorder) {
            return JBUI.insetsLeft((int)1);
        }
        if (tabPlacement == 4 && !this.myPaintContentBorder) {
            return JBUI.insetsRight((int)1);
        }
        return JBUI.insets((int)1);
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        g.setColor(this.darkShadow);
        switch (tabPlacement) {
            case 1: {
                if (isSelected) {
                    LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x, (double)(y + 1), (double)x, (double)(y + h - 1));
                    LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(x + 1), (double)y, (double)(x + w - 3), (double)y);
                    LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(x + w - 2), (double)(y + 1), (double)(x + w - 2), (double)(y + h - 1));
                    break;
                }
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x, (double)(y + 1), (double)x, (double)(y + h - 1));
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(x + 1), (double)y, (double)(x + w - 3), (double)y);
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(x + w - 2), (double)(y + 1), (double)(x + w - 2), (double)(y + h - 1));
                break;
            }
            case 2: {
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(x + 1), (double)(y + 1), (double)(x + w - 1), (double)(y + 1));
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x, (double)(y + 2), (double)x, (double)(y + h - 2));
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(x + 1), (double)(y + h - 1), (double)(x + w - 1), (double)(y + h - 1));
                break;
            }
            case 3: {
                if (isSelected) {
                    LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x, (double)y, (double)x, (double)(y + h - 2));
                    LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(x + 1), (double)(y + h - 1), (double)(x + w - 2), (double)(y + h - 1));
                    LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(x + w - 1), (double)y, (double)(x + w - 1), (double)(y + h - 2));
                    break;
                }
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x, (double)y, (double)x, (double)(y + h - 1));
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(x + 1), (double)(y + h - 1), (double)(x + w - 3), (double)(y + h - 1));
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(x + w - 2), (double)y, (double)(x + w - 2), (double)(y + h - 1));
                break;
            }
            case 4: {
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x, (double)(y + 1), (double)(x + w - 2), (double)(y + 1));
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(x + w - 1), (double)(y + 2), (double)(x + w - 1), (double)(y + h - 2));
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x, (double)(y + h - 1), (double)(x + w - 2), (double)(y + h - 1));
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown tabPlacement: " + tabPlacement);
            }
        }
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title2, Rectangle textRect, boolean isSelected) {
        if (isSelected) {
            font = font.isBold() ? font : font.deriveFont(1);
            metrics = metrics.getFont().isBold() ? metrics : g.getFontMetrics(font);
        } else {
            font = font.isPlain() ? font : font.deriveFont(0);
            metrics = metrics.getFont().isPlain() ? metrics : g.getFontMetrics(font);
        }
        g.setFont(font);
        if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
            g.setColor(this.tabPane.getForegroundAt(tabIndex));
            g.drawString(title2, textRect.x - (this.myNoIconSpace ? 5 : 0), textRect.y + metrics.getAscent());
        } else {
            g.setColor(this.tabPane.getBackgroundAt(tabIndex).brighter());
            g.drawString(title2, textRect.x, textRect.y + metrics.getAscent());
            g.setColor(this.tabPane.getBackgroundAt(tabIndex).darker());
            g.drawString(title2, textRect.x - (this.myNoIconSpace ? 6 : 1), textRect.y + metrics.getAscent() - 1);
        }
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (isSelected) {
            g.setColor(LIGHT);
        } else {
            g.setColor(DARK);
        }
        switch (tabPlacement) {
            case 2: {
                g.fillRect(x + 1, y + 2, w - 2, h - 3);
                break;
            }
            case 4: {
                g.fillRect(x, y + 2, w - 1, h - 3);
                break;
            }
            case 3: {
                g.fillRect(x + 1, y, w - 3, h - 1);
                break;
            }
            default: {
                g.fillRect(x + 1, y + 1, w - 2, h);
            }
        }
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (tabPlacement == 1 || this.myPaintContentBorder) {
            boolean leftToRight = BegTabbedPaneUI.isLeftToRight(this.tabPane);
            int right = x + w - 1;
            Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
            g.setColor(this.darkShadow);
            if (tabPlacement != 1 || selectedIndex < 0 || selRect.y + selRect.height + 1 < y || selRect.x < x || selRect.x > x + w) {
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x, (double)y, (double)(x + w - 1), (double)y);
            } else {
                boolean lastInRun = this.isLastInRun(selectedIndex);
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x, (double)y, (double)selRect.x, (double)y);
                if (selRect.x + selRect.width < right - 1) {
                    LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(selRect.x + selRect.width - 2), (double)y, (double)right, (double)y);
                } else {
                    LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(x + w - 2), (double)y, (double)(x + w - 2), (double)y);
                }
            }
        }
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (tabPlacement == 3 || this.myPaintContentBorder) {
            boolean leftToRight = BegTabbedPaneUI.isLeftToRight(this.tabPane);
            int bottom = y + h - 1;
            int right = x + w - 1;
            Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
            g.setColor(this.darkShadow);
            if (tabPlacement != 3 || selectedIndex < 0 || selRect.y - 1 > h || selRect.x < x || selRect.x > x + w) {
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x, (double)(y + h - 1), (double)(x + w - 1), (double)(y + h - 1));
            } else {
                boolean lastInRun = this.isLastInRun(selectedIndex);
                if (leftToRight || lastInRun) {
                    LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x, (double)bottom, (double)selRect.x, (double)bottom);
                } else {
                    LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x, (double)bottom, (double)(selRect.x - 1), (double)bottom);
                }
                if (selRect.x + selRect.width < x + w - 2) {
                    if (leftToRight && !lastInRun) {
                        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(selRect.x + selRect.width), (double)bottom, (double)right, (double)bottom);
                    } else {
                        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(selRect.x + selRect.width - 1), (double)bottom, (double)right, (double)bottom);
                    }
                }
            }
        }
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (tabPlacement == 2 || this.myPaintContentBorder) {
            Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
            g.setColor(this.darkShadow);
            if (tabPlacement != 2 || selectedIndex < 0 || selRect.x + selRect.width + 1 < x || selRect.y < y || selRect.y > y + h) {
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x, (double)y, (double)x, (double)(y + h - 2));
            } else {
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x, (double)y, (double)x, (double)(selRect.y + 1));
                if (selRect.y + selRect.height < y + h - 2) {
                    LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x, (double)(selRect.y + selRect.height + 1), (double)x, (double)(y + h + 2));
                }
            }
        }
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (tabPlacement == 4 || this.myPaintContentBorder) {
            Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
            g.setColor(this.darkShadow);
            if (tabPlacement != 4 || selectedIndex < 0 || selRect.x - 1 > w || selRect.y < y || selRect.y > y + h) {
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(x + w - 1), (double)y, (double)(x + w - 1), (double)(y + h - 1));
            } else {
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(x + w - 1), (double)y, (double)(x + w - 1), (double)selRect.y);
                if (selRect.y + selRect.height < y + h - 2) {
                    LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(x + w - 1), (double)(selRect.y + selRect.height), (double)(x + w - 1), (double)(y + h - 2));
                }
            }
        }
    }

    private boolean isLastInRun(int tabIndex) {
        int run2 = this.getRunForTab(this.tabPane.getTabCount(), tabIndex);
        int lastIndex = this.lastTabInRun(this.tabPane.getTabCount(), run2);
        return tabIndex == lastIndex;
    }

    static boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        return (int)((double)super.calculateTabHeight(tabPlacement, tabIndex, fontHeight) * 1.0);
    }

    @Override
    protected int calculateMaxTabHeight(int tabPlacement) {
        FontMetrics metrics = this.getFontMetrics();
        int tabCount = this.tabPane.getTabCount();
        int result2 = 0;
        int fontHeight = metrics.getHeight();
        for (int i2 = 0; i2 < tabCount; ++i2) {
            result2 = Math.max(this.calculateTabHeight(tabPlacement, i2, fontHeight), result2);
        }
        return result2;
    }

    public static ComponentUI createUI(JComponent c) {
        return new BegTabbedPaneUI();
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        Font font = metrics.getFont();
        FontMetrics plainMetrics = font.isPlain() ? metrics : this.tabPane.getFontMetrics(font.deriveFont(0));
        int widthPlain = super.calculateTabWidth(tabPlacement, tabIndex, plainMetrics);
        FontMetrics boldMetrics = font.isBold() ? metrics : this.tabPane.getFontMetrics(font.deriveFont(1));
        int widthBold = super.calculateTabWidth(tabPlacement, tabIndex, boldMetrics);
        int width = Math.max(widthPlain, widthBold);
        this.myLayoutMetrics = width == widthPlain ? plainMetrics : boldMetrics;
        return width;
    }

    @Override
    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, @NlsContexts.TabTitle String title2, Icon icon2, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        metrics = this.myLayoutMetrics != null ? this.myLayoutMetrics : metrics;
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.y = 0;
        textRect.x = 0;
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            this.tabPane.putClientProperty("html", v);
        }
        SwingUtilities.layoutCompoundLabel(this.tabPane, metrics, title2, icon2, 0, tabPlacement == 4 || tabPlacement == 2 ? 2 : 0, 0, 11, tabRect, iconRect, textRect, this.textIconGap);
        this.tabPane.putClientProperty("html", null);
        int xNudge = this.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
        int yNudge = this.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
        iconRect.x += xNudge;
        iconRect.y += yNudge;
        textRect.x += xNudge;
        textRect.y += yNudge;
    }

    public void setNoIconSpace(boolean noIconSpace) {
        this.myNoIconSpace = noIconSpace;
    }

    public void setPaintContentBorder(boolean paintContentBorder) {
        this.myPaintContentBorder = paintContentBorder;
    }

    @Override
    protected int calculateTabAreaHeight(int tabPlacement, int horizRunCount, int maxTabHeight) {
        for (int i2 = 0; i2 < this.tabPane.getTabCount(); ++i2) {
            Component component2 = this.tabPane.getComponentAt(i2);
            if (component2 == null) continue;
            return super.calculateTabAreaHeight(tabPlacement, horizRunCount, maxTabHeight);
        }
        return maxTabHeight + this.tabRunOverlay;
    }
}

