/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListPopupStepEx;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.SpeedSearchFilter;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.popup.ActionPopupOptions;
import com.intellij.ui.popup.ActionStepBuilder;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StatusText;
import java.awt.event.InputEvent;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionPopupStep
implements ListPopupStepEx<PopupFactoryImpl.ActionItem>,
MnemonicNavigationFilter<PopupFactoryImpl.ActionItem>,
SpeedSearchFilter<PopupFactoryImpl.ActionItem> {
    @NotNull
    private final List<PopupFactoryImpl.ActionItem> myItems;
    private final @NlsContexts.PopupTitle @Nullable String myTitle;
    @NotNull
    private final Supplier<? extends DataContext> myContext;
    @NotNull
    private final String myActionPlace;
    @NotNull
    private final ActionUiKind myUiKind;
    @NotNull
    private final PresentationFactory myPresentationFactory;
    private final ActionPopupOptions myOptions;
    private final int myDefaultOptionIndex;
    private Runnable myFinalRunnable;
    @NotNull
    private BiFunction<DataContext, AnAction, DataContext> mySubStepContextAdjuster;
    private @NlsContexts.PopupTitle @Nullable String myAdText;

    @Deprecated(forRemoval=true)
    public ActionPopupStep(@NotNull List<PopupFactoryImpl.ActionItem> items2, @NlsContexts.PopupTitle @Nullable String title2, @NotNull Supplier<? extends DataContext> context, @Nullable String actionPlace, boolean enableMnemonics, @Nullable Condition<? super AnAction> preselectCondition, boolean autoSelection, boolean showDisabledActions, @Nullable PresentationFactory presentationFactory) {
        if (items2 == null) {
            ActionPopupStep.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ActionPopupStep.$$$reportNull$$$0(1);
        }
        this(items2, title2, context, actionPlace == null ? "popup" : actionPlace, presentationFactory == null ? new PresentationFactory() : presentationFactory, ActionPopupOptions.forStep(showDisabledActions, enableMnemonics, autoSelection, preselectCondition));
    }

    public ActionPopupStep(@NotNull List<PopupFactoryImpl.ActionItem> items2, @NlsContexts.PopupTitle @Nullable String title2, @NotNull Supplier<? extends DataContext> context, @NotNull String actionPlace, @NotNull PresentationFactory presentationFactory, @NotNull ActionPopupOptions options2) {
        if (items2 == null) {
            ActionPopupStep.$$$reportNull$$$0(2);
        }
        if (context == null) {
            ActionPopupStep.$$$reportNull$$$0(3);
        }
        if (actionPlace == null) {
            ActionPopupStep.$$$reportNull$$$0(4);
        }
        if (presentationFactory == null) {
            ActionPopupStep.$$$reportNull$$$0(5);
        }
        if (options2 == null) {
            ActionPopupStep.$$$reportNull$$$0(6);
        }
        this(items2, title2, null, context, actionPlace, presentationFactory, options2);
    }

    @ApiStatus.Internal
    ActionPopupStep(@NotNull List<PopupFactoryImpl.ActionItem> items2, @NlsContexts.PopupTitle @Nullable String title2, @NlsContexts.PopupTitle @Nullable String adText, @NotNull Supplier<? extends DataContext> context, @NotNull String actionPlace, @NotNull PresentationFactory presentationFactory, @NotNull ActionPopupOptions options2) {
        if (items2 == null) {
            ActionPopupStep.$$$reportNull$$$0(7);
        }
        if (context == null) {
            ActionPopupStep.$$$reportNull$$$0(8);
        }
        if (actionPlace == null) {
            ActionPopupStep.$$$reportNull$$$0(9);
        }
        if (presentationFactory == null) {
            ActionPopupStep.$$$reportNull$$$0(10);
        }
        if (options2 == null) {
            ActionPopupStep.$$$reportNull$$$0(11);
        }
        this.mySubStepContextAdjuster = (c, a) -> c;
        this.myItems = items2;
        this.myTitle = title2;
        this.myAdText = adText;
        this.myContext = context;
        this.myActionPlace = ActionPopupStep.getPopupOrMainMenuPlace(actionPlace);
        this.myUiKind = "MainMenu".equals(this.myActionPlace) ? ActionUiKind.MAIN_MENU : ActionUiKind.POPUP;
        this.myPresentationFactory = presentationFactory;
        this.myOptions = options2;
        this.myDefaultOptionIndex = ActionPopupStep.getDefaultOptionIndexFromSelectCondition(options2.getPreselectCondition(), items2);
    }

    @NotNull
    public PresentationFactory getPresentationFactory() {
        PresentationFactory presentationFactory = this.myPresentationFactory;
        if (presentationFactory == null) {
            ActionPopupStep.$$$reportNull$$$0(12);
        }
        return presentationFactory;
    }

    @NotNull
    public String getActionPlace() {
        String string = this.myActionPlace;
        if (string == null) {
            ActionPopupStep.$$$reportNull$$$0(13);
        }
        return string;
    }

    public ActionPopupOptions getOptions() {
        return this.myOptions;
    }

    private static int getDefaultOptionIndexFromSelectCondition(@Nullable Condition<? super AnAction> preselectActionCondition, @NotNull List<PopupFactoryImpl.ActionItem> items2) {
        if (items2 == null) {
            ActionPopupStep.$$$reportNull$$$0(14);
        }
        int defaultOptionIndex = 0;
        if (preselectActionCondition != null) {
            for (int i2 = 0; i2 < items2.size(); ++i2) {
                AnAction action2 = items2.get(i2).getAction();
                if (!preselectActionCondition.value((Object)action2)) continue;
                defaultOptionIndex = i2;
                break;
            }
        }
        return defaultOptionIndex;
    }

    @NotNull
    public static ListPopupStep<PopupFactoryImpl.ActionItem> createActionsStep(@NlsContexts.PopupTitle @Nullable String title2, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext2, @NotNull String actionPlace, @NotNull PresentationFactory presentationFactory, @NotNull Supplier<? extends DataContext> contextSupplier, @NotNull ActionPopupOptions options2) {
        if (actionGroup == null) {
            ActionPopupStep.$$$reportNull$$$0(15);
        }
        if (dataContext2 == null) {
            ActionPopupStep.$$$reportNull$$$0(16);
        }
        if (actionPlace == null) {
            ActionPopupStep.$$$reportNull$$$0(17);
        }
        if (presentationFactory == null) {
            ActionPopupStep.$$$reportNull$$$0(18);
        }
        if (contextSupplier == null) {
            ActionPopupStep.$$$reportNull$$$0(19);
        }
        if (options2 == null) {
            ActionPopupStep.$$$reportNull$$$0(20);
        }
        List<PopupFactoryImpl.ActionItem> items2 = ActionPopupStep.createActionItems(actionGroup, dataContext2, actionPlace, presentationFactory, options2);
        Presentation groupPresentation = presentationFactory.getPresentation((AnAction)actionGroup);
        @Nls String adText = (String)groupPresentation.getClientProperty(ActionUtil.POPUP_AD_TEXT);
        ActionPopupOptions stepOptions = ActionPopupOptions.convertForStep(options2, items2);
        return new ActionPopupStep(items2, title2, adText, contextSupplier, actionPlace, presentationFactory, stepOptions);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static List<PopupFactoryImpl.ActionItem> createActionItems(@NotNull ActionGroup actionGroup, @NotNull DataContext dataContext2, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, @Nullable String actionPlace, @Nullable PresentationFactory presentationFactory) {
        if (actionGroup == null) {
            ActionPopupStep.$$$reportNull$$$0(21);
        }
        if (dataContext2 == null) {
            ActionPopupStep.$$$reportNull$$$0(22);
        }
        return ActionPopupStep.createActionItems(actionGroup, dataContext2, actionPlace == null ? "popup" : actionPlace, presentationFactory == null ? new PresentationFactory() : presentationFactory, ActionPopupOptions.create(showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, -1, false, null));
    }

    @NotNull
    public static List<PopupFactoryImpl.ActionItem> createActionItems(@NotNull ActionGroup actionGroup, @NotNull DataContext dataContext2, @NotNull String actionPlace, @NotNull PresentationFactory presentationFactory, @NotNull ActionPopupOptions options2) {
        if (actionGroup == null) {
            ActionPopupStep.$$$reportNull$$$0(23);
        }
        if (dataContext2 == null) {
            ActionPopupStep.$$$reportNull$$$0(24);
        }
        if (actionPlace == null) {
            ActionPopupStep.$$$reportNull$$$0(25);
        }
        if (presentationFactory == null) {
            ActionPopupStep.$$$reportNull$$$0(26);
        }
        if (options2 == null) {
            ActionPopupStep.$$$reportNull$$$0(27);
        }
        ActionUiKind.Popup uiKind = "MainMenu".equals(actionPlace) ? ActionUiKind.MAIN_MENU : ActionUiKind.POPUP;
        actionPlace = ActionPopupStep.getPopupOrMainMenuPlace(actionPlace);
        ActionStepBuilder builder = new ActionStepBuilder(dataContext2, options2.showNumbers(), options2.useAlphaAsNumbers(), options2.showDisabledActions(), options2.honorActionMnemonics(), actionPlace, (ActionUiKind)uiKind, presentationFactory);
        builder.buildGroup(actionGroup);
        List<PopupFactoryImpl.ActionItem> list2 = builder.getItems();
        if (list2 == null) {
            ActionPopupStep.$$$reportNull$$$0(28);
        }
        return list2;
    }

    @NotNull
    public List<PopupFactoryImpl.ActionItem> getValues() {
        List<PopupFactoryImpl.ActionItem> list2 = this.myItems;
        if (list2 == null) {
            ActionPopupStep.$$$reportNull$$$0(29);
        }
        return list2;
    }

    @NotNull
    public List<PopupFactoryImpl.ActionItem> getInlineItems(@NotNull PopupFactoryImpl.ActionItem value) {
        if (value == null) {
            ActionPopupStep.$$$reportNull$$$0(30);
        }
        List<PopupFactoryImpl.ActionItem> list2 = value.getInlineItems();
        if (list2 == null) {
            ActionPopupStep.$$$reportNull$$$0(31);
        }
        return list2;
    }

    public boolean isSelectable(PopupFactoryImpl.ActionItem value) {
        return value.isEnabled();
    }

    public int getMnemonicPos(PopupFactoryImpl.ActionItem value) {
        String text2 = this.getTextFor(value);
        return text2.indexOf(27);
    }

    @Nullable
    public String getMnemonicString(PopupFactoryImpl.ActionItem value) {
        if (value.digitMnemonicsEnabled()) {
            Character res = value.getMnemonicChar();
            return res != null ? res.toString() : null;
        }
        return super.getMnemonicString((Object)value);
    }

    public Icon getIconFor(PopupFactoryImpl.ActionItem aValue) {
        return aValue.getIcon(false);
    }

    public Icon getSelectedIconFor(PopupFactoryImpl.ActionItem value) {
        return value.getIcon(true);
    }

    @NotNull
    @NlsActions.ActionText
    public String getTextFor(PopupFactoryImpl.ActionItem value) {
        String string = value.getText();
        if (string == null) {
            ActionPopupStep.$$$reportNull$$$0(32);
        }
        return string;
    }

    @Nullable
    public String getTooltipTextFor(PopupFactoryImpl.ActionItem value) {
        return value.getTooltip();
    }

    public void setEmptyText(@NotNull StatusText emptyText) {
        if (emptyText == null) {
            ActionPopupStep.$$$reportNull$$$0(33);
        }
    }

    @Nullable
    public String getSecondaryTextFor(PopupFactoryImpl.ActionItem item) {
        return (String)item.getClientProperty(ActionUtil.SECONDARY_TEXT);
    }

    @Nullable
    public Icon getSecondaryIconFor( @NotNull PopupFactoryImpl.ActionItem item) {
        if (item == null) {
            ActionPopupStep.$$$reportNull$$$0(34);
        }
        return (Icon)item.getClientProperty(ActionUtil.SECONDARY_ICON);
    }

    public ListSeparator getSeparatorAbove(PopupFactoryImpl.ActionItem value) {
        return value.isPrependWithSeparator() ? new ListSeparator(value.getSeparatorText()) : null;
    }

    public int getDefaultOptionIndex() {
        return this.myDefaultOptionIndex;
    }

    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    @Nls
    @Nullable
    public String getAdText() {
        return this.myAdText;
    }

    @ApiStatus.Internal
    @NotNull
    public BiFunction<DataContext, AnAction, DataContext> getSubStepContextAdjuster() {
        BiFunction<DataContext, AnAction, DataContext> biFunction = this.mySubStepContextAdjuster;
        if (biFunction == null) {
            ActionPopupStep.$$$reportNull$$$0(35);
        }
        return biFunction;
    }

    @ApiStatus.Internal
    public void setSubStepContextAdjuster(@NotNull BiFunction<DataContext, AnAction, DataContext> subStepContextAdjuster) {
        if (subStepContextAdjuster == null) {
            ActionPopupStep.$$$reportNull$$$0(36);
        }
        this.mySubStepContextAdjuster = subStepContextAdjuster;
    }

    public PopupStep<?> onChosen(PopupFactoryImpl.ActionItem actionChoice, boolean finalChoice) {
        return this.onChosen(actionChoice, finalChoice, null);
    }

    @Nullable
    public PopupStep<?> onChosen(@NotNull PopupFactoryImpl.ActionItem item, boolean finalChoice, @Nullable InputEvent inputEvent) {
        if (item == null) {
            ActionPopupStep.$$$reportNull$$$0(37);
        }
        if (!item.isEnabled()) {
            return FINAL_CHOICE;
        }
        AnAction action2 = item.getAction();
        if (action2 instanceof ActionGroup) {
            ActionGroup subGroup = (ActionGroup)action2;
            if (!finalChoice || !item.isPerformGroup()) {
                DataContext dataContext2 = this.mySubStepContextAdjuster.apply(this.myContext.get(), action2);
                return ActionPopupStep.createActionsStep(null, subGroup, dataContext2, this.myActionPlace, this.myPresentationFactory, () -> dataContext2, ActionPopupOptions.convertForSubStep(this.myOptions));
            }
        }
        if (Utils.isKeepPopupOpen(item.getKeepPopupOnPerform(), inputEvent)) {
            this.performActionItem(item, inputEvent);
            return FINAL_CHOICE;
        }
        this.myFinalRunnable = () -> this.performActionItem(item, inputEvent);
        return FINAL_CHOICE;
    }

    public boolean isFinal(@NotNull PopupFactoryImpl.ActionItem item) {
        if (item == null) {
            ActionPopupStep.$$$reportNull$$$0(38);
        }
        if (!item.isEnabled()) {
            return true;
        }
        return !(item.getAction() instanceof ActionGroup) || item.isPerformGroup();
    }

    public void performActionItem(@NotNull PopupFactoryImpl.ActionItem item, @Nullable InputEvent inputEvent) {
        if (item == null) {
            ActionPopupStep.$$$reportNull$$$0(39);
        }
        AnAction action2 = item.getAction();
        AnActionEvent event = this.createAnActionEvent(item, inputEvent);
        event.setInjectedContext(action2.isInInjectedContext());
        ActionUtil.performAction((AnAction)action2, (AnActionEvent)event);
    }

    @NotNull
    public AnActionEvent createAnActionEvent(@NotNull PopupFactoryImpl.ActionItem item, @Nullable InputEvent inputEvent) {
        if (item == null) {
            ActionPopupStep.$$$reportNull$$$0(40);
        }
        DataContext dataContext2 = this.myContext.get();
        Presentation presentation2 = item.clonePresentation();
        AnActionEvent anActionEvent = AnActionEvent.createEvent((DataContext)dataContext2, (Presentation)presentation2, (String)this.myActionPlace, (ActionUiKind)this.myUiKind, (InputEvent)inputEvent);
        if (anActionEvent == null) {
            ActionPopupStep.$$$reportNull$$$0(41);
        }
        return anActionEvent;
    }

    public void updateStepItems(@NotNull JComponent component2) {
        if (component2 == null) {
            ActionPopupStep.$$$reportNull$$$0(42);
        }
        DataContext dataContext2 = this.myContext.get();
        List<PopupFactoryImpl.ActionItem> values = this.getValues();
        Utils.updateComponentActions(component2, ContainerUtil.map(values, PopupFactoryImpl.ActionItem::getAction), dataContext2, this.myActionPlace, this.myPresentationFactory, () -> {
            for (PopupFactoryImpl.ActionItem actionItem : values) {
                actionItem.updateFromPresentation(this.myPresentationFactory, this.myActionPlace);
            }
        });
    }

    public Runnable getFinalRunnable() {
        return this.myFinalRunnable;
    }

    public boolean hasSubstep(PopupFactoryImpl.ActionItem selectedValue) {
        return selectedValue != null && selectedValue.isEnabled() && selectedValue.getAction() instanceof ActionGroup && !selectedValue.isSubstepSuppressed();
    }

    public void canceled() {
    }

    public boolean isMnemonicsNavigationEnabled() {
        return this.myOptions.honorActionMnemonics();
    }

    public MnemonicNavigationFilter<PopupFactoryImpl.ActionItem> getMnemonicNavigationFilter() {
        return this;
    }

    public String getIndexedString(PopupFactoryImpl.ActionItem value) {
        return this.getTextFor(value);
    }

    public boolean isSpeedSearchEnabled() {
        return true;
    }

    public boolean isAutoSelectionEnabled() {
        return this.myOptions.autoSelectionEnabled();
    }

    public SpeedSearchFilter<PopupFactoryImpl.ActionItem> getSpeedSearchFilter() {
        return (SpeedSearchFilter)ObjectUtils.chooseNotNull(this.myOptions.getSpeedSearchFilter(), (Object)this);
    }

    @ApiStatus.Internal
    public void reorderItems(int from, int where, int preserveSeparatorAt) {
        if (this.myItems.get(from).isPrependWithSeparator() || this.myItems.get(where).isPrependWithSeparator()) {
            String fromText = this.myItems.get(from).getSeparatorText();
            String whereText = this.myItems.get(where).getSeparatorText();
            this.myItems.get(from).setSeparatorText(null);
            if (preserveSeparatorAt == from) {
                this.myItems.get(from + 1).setSeparatorText(fromText);
            }
            if (preserveSeparatorAt == where) {
                this.myItems.get(where).setSeparatorText(null);
                this.myItems.get(from).setSeparatorText(whereText);
            }
        }
        PopupFactoryImpl.ActionItem toMove = this.myItems.get(from);
        this.myItems.add(where, toMove);
        if (where < from) {
            ++from;
        }
        this.myItems.remove(from);
    }

    @NotNull
    private static String getPopupOrMainMenuPlace(@NotNull String place) {
        if (place == null) {
            ActionPopupStep.$$$reportNull$$$0(43);
        }
        boolean isOk = ActionPlaces.isPopupPlace((String)place) || "MainMenu".equals(place);
        String string = isOk ? place : ActionPlaces.getPopupPlace((String)place);
        if (string == null) {
            ActionPopupStep.$$$reportNull$$$0(44);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 13, 28, 29, 31, 32, 35, 41, 44 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 9: 
            case 17: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionPlace";
                break;
            }
            case 5: 
            case 10: 
            case 18: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationFactory";
                break;
            }
            case 6: 
            case 11: 
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 12: 
            case 13: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 35: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/popup/ActionPopupStep";
                break;
            }
            case 15: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 16: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextSupplier";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyText";
                break;
            }
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subStepContextAdjuster";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/popup/ActionPopupStep";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationFactory";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionPlace";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionItems";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlineItems";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFor";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubStepContextAdjuster";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnActionEvent";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getPopupOrMainMenuPlace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: 
            case 13: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 35: 
            case 41: 
            case 44: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultOptionIndexFromSelectCondition";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createActionsStep";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createActionItems";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getInlineItems";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setEmptyText";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getSecondaryIconFor";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "setSubStepContextAdjuster";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "onChosen";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isFinal";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "performActionItem";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createAnActionEvent";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "updateStepItems";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getPopupOrMainMenuPlace";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 13, 28, 29, 31, 32, 35, 41, 44 -> new IllegalStateException(string);
        };
    }
}

