/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.ui.GenericListComponentUpdater;
import com.intellij.openapi.ui.JBListUpdater;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.popup.util.PopupImplUtil;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import java.awt.Dimension;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PopupListAdapter<T>
implements PopupChooserBuilder.PopupComponentAdapter<T> {
    private final JList<T> myList;
    private final PopupChooserBuilder<T> myBuilder;
    private ListWithFilter<T> myListWithFilter;

    PopupListAdapter(PopupChooserBuilder<T> builder, JList<T> list2) {
        this.myBuilder = builder;
        this.myList = list2;
    }

    public JComponent getComponent() {
        return this.myList;
    }

    public void setRenderer(ListCellRenderer<? super T> renderer2) {
        this.myList.setCellRenderer(renderer2);
    }

    public void setItemChosenCallback(Consumer<? super T> callback) {
        this.myBuilder.setItemChosenCallback(() -> {
            T selectedValue = this.myList.getSelectedValue();
            if (selectedValue != null || !this.myList.isSelectionEmpty()) {
                callback.consume(selectedValue);
            }
        });
    }

    public void setItemsChosenCallback(Consumer<? super Set<T>> callback) {
        this.myBuilder.setItemChosenCallback(() -> {
            List<T> list2 = this.myList.getSelectedValuesList();
            callback.consume((Object)(list2 != null ? new HashSet<T>(list2) : Collections.emptySet()));
        });
    }

    public JScrollPane createScrollPane() {
        return this.myListWithFilter.getScrollPane();
    }

    public boolean hasOwnScrollPane() {
        return true;
    }

    @Nullable
    public Predicate<KeyEvent> getKeyEventHandler() {
        return InputEvent::isConsumed;
    }

    public JComponent buildFinalComponent() {
        this.myListWithFilter = (ListWithFilter)ListWithFilter.wrap(this.myList, (JScrollPane)((Object)new MyListWrapper(this.myList)), (Function)this.myBuilder.getItemsNamer(), (boolean)false, (boolean)this.myBuilder.isFilterAlwaysVisible(), (boolean)true);
        this.myListWithFilter.setAutoPackHeight(this.myBuilder.isAutoPackHeightOnFiltering());
        return this.myListWithFilter;
    }

    public void addMouseListener(MouseListener listener2) {
        this.myList.addMouseListener(listener2);
    }

    public void autoSelect() {
        JList<T> list2 = this.myList;
        if (list2.getSelectedIndex() == -1) {
            list2.setSelectedIndex(0);
        }
    }

    public GenericListComponentUpdater<T> getBackgroundUpdater() {
        return new JBListUpdater((JBList)this.myList);
    }

    public void setSelectedValue(T preselection, boolean shouldScroll) {
        this.myList.setSelectedValue(preselection, shouldScroll);
    }

    public void setItemSelectedCallback(Consumer<? super T> c) {
        this.myList.addListSelectionListener(e -> {
            T selectedValue = this.myList.getSelectedValue();
            c.consume(selectedValue);
        });
    }

    public void setSelectionMode(int selection) {
        this.myList.setSelectionMode(selection);
    }

    public boolean checkResetFilter() {
        return this.myListWithFilter.resetFilter();
    }

    public void setFixedRendererSize(@NotNull Dimension dimension) {
        if (dimension == null) {
            PopupListAdapter.$$$reportNull$$$0(0);
        }
        this.myList.setFixedCellWidth(dimension.width);
        this.myList.setFixedCellHeight(dimension.height);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dimension", "com/intellij/ui/popup/PopupListAdapter", "setFixedRendererSize"));
    }

    private final class MyListWrapper
    extends JBScrollPane
    implements UiDataProvider {
        private final JList<T> myList;

        private MyListWrapper(JList<T> list2) {
            super(-1);
            list2.setVisibleRowCount(PopupListAdapter.this.myBuilder.getVisibleRowCount());
            this.setViewportView(list2);
            if (PopupListAdapter.this.myBuilder.isAutoselectOnMouseMove()) {
                ListUtil.installAutoSelectOnMouseMove(list2);
            }
            ScrollingUtil.installActions(list2);
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.myList = list2;
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                MyListWrapper.$$$reportNull$$$0(0);
            }
            PopupImplUtil.uiSnapshotForList(this.myList, sink);
        }

        public void setBorder(Border border) {
            if (this.myList != null) {
                this.myList.setBorder(border);
            }
        }

        public void requestFocus() {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myList, true));
        }

        public synchronized void addMouseListener(MouseListener l) {
            this.myList.addMouseListener(l);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/ui/popup/PopupListAdapter$MyListWrapper", "uiDataSnapshot"));
        }
    }
}

