/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.jps.serialization;

import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.impl.ModulePathMacroManager;
import com.intellij.openapi.components.impl.ProjectPathMacroManager;
import com.intellij.openapi.components.impl.stores.ComponentStorageUtil;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.platform.workspace.jps.JpsProjectConfigLocation;
import com.intellij.platform.workspace.jps.bridge.impl.serialization.DefaultImlNormalizer;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentReader;
import com.intellij.platform.workspace.jps.serialization.impl.JpsProjectSerializersImplKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.reflect.KProperty0;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J&\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000f\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000bH\u0002J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000bH\u0002J$\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\t\u001a\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/workspaceModel/ide/impl/jps/serialization/CachingJpsFileContentReader;", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentReader;", "configLocation", "Lcom/intellij/platform/workspace/jps/JpsProjectConfigLocation;", "<init>", "(Lcom/intellij/platform/workspace/jps/JpsProjectConfigLocation;)V", "projectPathMacroManager", "Lcom/intellij/openapi/components/impl/ProjectPathMacroManager;", "kotlin.jvm.PlatformType", "fileContentCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "Lorg/jdom/Element;", "loadComponent", "fileUrl", "componentName", "customModuleFilePath", "getExpandMacroMap", "Lcom/intellij/openapi/components/ExpandMacroToPathMap;", "loadComponents", "getMacroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "loadStorageFile", "xmlFile", "Ljava/nio/file/Path;", "pathMacroManager", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class CachingJpsFileContentReader
implements JpsFileContentReader {
    @NotNull
    private final JpsProjectConfigLocation configLocation;
    private final ProjectPathMacroManager projectPathMacroManager;
    @NotNull
    private final ConcurrentHashMap<String, Map<String, Element>> fileContentCache;

    public CachingJpsFileContentReader(@NotNull JpsProjectConfigLocation configLocation) {
        Intrinsics.checkNotNullParameter((Object)configLocation, (String)"configLocation");
        this.configLocation = configLocation;
        this.projectPathMacroManager = ProjectPathMacroManager.createInstance(() -> CachingJpsFileContentReader.projectPathMacroManager$lambda$0((KProperty0)new PropertyReference0Impl(this.configLocation){

            public Object get() {
                return ((JpsProjectConfigLocation)this.receiver).getProjectFilePath();
            }
        }), () -> CachingJpsFileContentReader.projectPathMacroManager$lambda$1(this), null);
        this.fileContentCache = new ConcurrentHashMap();
    }

    @Nullable
    public Element loadComponent(@NotNull String fileUrl, @NotNull String componentName, @Nullable String customModuleFilePath) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        Map map2 = this.fileContentCache.computeIfAbsent(fileUrl + customModuleFilePath, arg_0 -> CachingJpsFileContentReader.loadComponent$lambda$1(arg_0 -> CachingJpsFileContentReader.loadComponent$lambda$0(this, fileUrl, customModuleFilePath, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"computeIfAbsent(...)");
        Map content2 = map2;
        return (Element)content2.get(componentName);
    }

    @NotNull
    public ExpandMacroToPathMap getExpandMacroMap(@NotNull String fileUrl) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        ExpandMacroToPathMap expandMacroToPathMap = this.getMacroManager(fileUrl, null).getExpandMacroMap();
        Intrinsics.checkNotNullExpressionValue((Object)expandMacroToPathMap, (String)"getExpandMacroMap(...)");
        return expandMacroToPathMap;
    }

    private final Map<String, Element> loadComponents(String fileUrl, String customModuleFilePath) {
        Map<String, Element> map2;
        PathMacroManager macroManager = this.getMacroManager(fileUrl, customModuleFilePath);
        Path file2 = Path.of(JpsPathUtil.urlToPath((String)fileUrl), new String[0]);
        if (Files.isRegularFile(file2, new LinkOption[0])) {
            Intrinsics.checkNotNull((Object)file2);
            map2 = this.loadStorageFile(file2, macroManager);
        } else {
            Map<String, Element> map3 = Map.of();
            map2 = map3;
            Intrinsics.checkNotNullExpressionValue(map3, (String)"of(...)");
        }
        return map2;
    }

    private final PathMacroManager getMacroManager(String fileUrl, String customModuleFilePath) {
        block3: {
            String path;
            block2: {
                path = JpsPathUtil.urlToPath((String)fileUrl);
                if (StringsKt.endsWith$default((String)fileUrl, (String)".iml", (boolean)false, (int)2, null)) break block2;
                Intrinsics.checkNotNull((Object)path);
                if (!JpsProjectSerializersImplKt.isExternalModuleFile((String)path)) break block3;
            }
            ModulePathMacroManager modulePathMacroManager = ModulePathMacroManager.createInstance(() -> CachingJpsFileContentReader.getMacroManager$lambda$0((KProperty0)new PropertyReference0Impl(this.configLocation){

                public Object get() {
                    return ((JpsProjectConfigLocation)this.receiver).getProjectFilePath();
                }
            }), () -> CachingJpsFileContentReader.getMacroManager$lambda$1(customModuleFilePath, path));
            Intrinsics.checkNotNullExpressionValue((Object)modulePathMacroManager, (String)"createInstance(...)");
            return (PathMacroManager)modulePathMacroManager;
        }
        ProjectPathMacroManager projectPathMacroManager2 = this.projectPathMacroManager;
        Intrinsics.checkNotNullExpressionValue((Object)projectPathMacroManager2, (String)"projectPathMacroManager");
        return (PathMacroManager)projectPathMacroManager2;
    }

    private final Map<String, Element> loadStorageFile(Path xmlFile, PathMacroManager pathMacroManager) {
        Element element = JDOMUtil.load((Path)xmlFile);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(...)");
        Element rootElement = element;
        if (StringsKt.endsWith$default((String)((Object)xmlFile).toString(), (String)".iml", (boolean)false, (int)2, null)) {
            DefaultImlNormalizer.INSTANCE.normalize(rootElement);
        }
        return ComponentStorageUtil.loadComponents((Element)rootElement, (PathMacroSubstitutor)((PathMacroSubstitutor)pathMacroManager));
    }

    private static final String projectPathMacroManager$lambda$0(KProperty0 $tmp0) {
        return (String)((Function0)$tmp0).invoke();
    }

    private static final String projectPathMacroManager$lambda$1(CachingJpsFileContentReader this$0) {
        return JpsPathUtil.urlToPath((String)this$0.configLocation.getBaseDirectoryUrlString());
    }

    private static final Map loadComponent$lambda$0(CachingJpsFileContentReader this$0, String $fileUrl, String $customModuleFilePath, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.loadComponents($fileUrl, $customModuleFilePath);
    }

    private static final Map loadComponent$lambda$1(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }

    private static final String getMacroManager$lambda$0(KProperty0 $tmp0) {
        return (String)((Function0)$tmp0).invoke();
    }

    private static final String getMacroManager$lambda$1(String $customModuleFilePath, String $path) {
        String string = $customModuleFilePath;
        if (string == null) {
            string = $path;
        }
        return string;
    }
}

