/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.xml.breadcrumbs.CrumbPresentation;
import com.intellij.xml.breadcrumbs.LazyTooltipCrumb;
import com.intellij.xml.breadcrumbs.NavigatableCrumb;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PsiCrumb
extends Crumb.Impl
implements NavigatableCrumb,
LazyTooltipCrumb {
    private final PsiAnchor anchor;
    private volatile BreadcrumbsProvider provider;
    private volatile @NlsContexts.Tooltip String tooltip;
    final CrumbPresentation presentation;

    PsiCrumb(@NotNull PsiElement element, @NotNull BreadcrumbsProvider provider, @Nullable CrumbPresentation presentation2) {
        if (element == null) {
            PsiCrumb.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            PsiCrumb.$$$reportNull$$$0(1);
        }
        super(provider.getElementIcon(element), provider.getElementInfo(element), null, provider.getContextActions(element));
        this.anchor = PsiAnchor.create((PsiElement)element);
        this.provider = provider;
        this.presentation = presentation2;
    }

    public String getTooltip() {
        if (this.needCalculateTooltip()) {
            PsiElement element = PsiCrumb.getElement((Crumb)this);
            this.tooltip = element == null ? null : this.provider.getElementTooltip(element);
            this.provider = null;
            if (element != null) {
                UIEventLogger.BreadcrumbShowTooltip.log(element.getProject(), (Object)element.getLanguage());
            }
        }
        return this.tooltip;
    }

    public boolean needCalculateTooltip() {
        return this.provider != null && this.tooltip == null;
    }

    public int getAnchorOffset() {
        PsiElement element = this.anchor.retrieve();
        return element != null ? element.getTextOffset() : -1;
    }

    @Nullable
    public TextRange getHighlightRange() {
        PsiElement element = this.anchor.retrieve();
        return element != null ? element.getTextRange() : null;
    }

    public void navigate(@NotNull Editor editor2, boolean withSelection) {
        int offset;
        if (editor2 == null) {
            PsiCrumb.$$$reportNull$$$0(2);
        }
        if ((offset = this.getAnchorOffset()) != -1) {
            PsiCrumb.moveEditorCaretTo((Editor)editor2, (int)offset);
        }
        PsiElement element = PsiCrumb.getElement((Crumb)this);
        if (withSelection) {
            TextRange range = this.getHighlightRange();
            PsiCrumb.select((Editor)editor2, (TextRange)range);
        }
        UIEventLogger.BreadcrumbNavigate.log(element != null ? element.getProject() : null, (Object)(element != null ? element.getLanguage() : null), (Object)withSelection);
    }

    @Contract(value="null -> null")
    static PsiElement getElement(Crumb crumb) {
        return crumb instanceof PsiCrumb ? ((PsiCrumb)crumb).anchor.retrieve() : null;
    }

    @Contract(value="null -> null", pure=true)
    static CrumbPresentation getPresentation(Crumb crumb) {
        return crumb instanceof PsiCrumb ? ((PsiCrumb)crumb).presentation : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xml/breadcrumbs/PsiCrumb";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "navigate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

