// Copyright 2000-2022 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package com.intellij.openapi.wm.ex;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.util.ui.StatusText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import javax.swing.*;
import javax.swing.border.EmptyBorder;
import java.util.List;

public interface ToolWindowEx extends ToolWindow {
  /**
   * @return type of internal decoration of tool window.
   * @throws IllegalStateException if tool window isn't installed.
   */
  @NotNull ToolWindowType getInternalType();

  void stretchWidth(int value);

  void stretchHeight(int value);

  default boolean canCloseContents() {
    return false;
  }

  /**
   * Returns the top-level decorator of the tool window. This decorator doesn't change when the tool window is split or unsplit.
   */
  @NotNull InternalDecorator getDecorator();

  /**
   * @deprecated Use {@link #setTitleActions(List)}
   */
  @Deprecated
  default void setTitleActions(@NotNull AnAction @NotNull ... actions) {
    setTitleActions(List.of(actions));
  }

  void setTabActions(@NotNull AnAction @NotNull ... actions);

  void setTabDoubleClickActions(@NotNull List<AnAction> actions);

  default @Nullable ToolWindowDecoration getDecoration() { return null; }

  final class Border extends EmptyBorder {
    public Border() {
      this(true, true, true, true);
    }

    public Border(boolean top, boolean left, boolean right, boolean bottom) {
      super(top ? 2 : 0, left ? 2 : 0, right ? 2 : 0, bottom ? 2 : 0);
    }
  }

  final class ToolWindowDecoration {
    private final ActionGroup myActionGroup;
    private final Icon myIcon;

    public ToolWindowDecoration(Icon icon, ActionGroup actionGroup) {
      myActionGroup = actionGroup;
      myIcon = icon;
    }

    public Icon getIcon() {
      return myIcon;
    }

    public ActionGroup getActionGroup() {
      return myActionGroup;
    }
  }

  default @Nullable StatusText getEmptyText() {
    return null;
  }

  default void updateContentUi() {}
}
