/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.ClientHintManager;
import com.intellij.codeInsight.hint.EditorHintListener;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.hint.PriorityQuestionAction;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.hint.ScrollAwareHint;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeTooltip;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ClientEditorManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.Gray;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.SlowOperations;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HintManagerImpl
extends HintManager {
    private static final Logger LOG = Logger.getInstance(HintManager.class);
    private final MyEditorManagerListener myEditorManagerListener = new MyEditorManagerListener();
    private static final Key<Integer> LAST_HINT_ON_EDITOR_Y_POSITION = Key.create((String)"hint.previous.editor.y.position");

    @ApiStatus.Internal
    public static int getPriority(QuestionAction action2) {
        return action2 instanceof PriorityQuestionAction ? ((PriorityQuestionAction)action2).getPriority() : 0;
    }

    public boolean canShowQuestionAction(QuestionAction action2) {
        return ClientHintManager.getCurrentInstance().canShowQuestionAction(action2);
    }

    public static boolean isActionToIgnore(AnAction action2) {
        ActionToIgnore actionToIgnore;
        return action2 instanceof ActionToIgnore && (actionToIgnore = (ActionToIgnore)action2).shouldBeIgnored();
    }

    public static HintManagerImpl getInstanceImpl() {
        return (HintManagerImpl)HintManager.getInstance();
    }

    public HintManagerImpl() {
        MyProjectManagerListener projectManagerListener2 = new MyProjectManagerListener();
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            projectManagerListener2.projectOpened(project2);
        }
        MessageBusConnection busConnection = ApplicationManager.getApplication().getMessageBus().connect();
        busConnection.subscribe(ProjectManager.TOPIC, (Object)projectManagerListener2);
    }

    public void setRequestFocusForNextHint(boolean requestFocus) {
        ClientHintManager.getCurrentInstance().setRequestFocusForNextHint(requestFocus);
    }

    public boolean performCurrentQuestionAction() {
        return ClientHintManager.getCurrentInstance().performCurrentQuestionAction();
    }

    public boolean hasShownHintsThatWillHideByOtherHint(boolean willShowTooltip) {
        return ClientHintManager.getCurrentInstance().hasShownHintsThatWillHideByOtherHint(willShowTooltip);
    }

    static void updateScrollableHintPosition(VisibleAreaEvent e, @NotNull LightweightHint hint, boolean hideIfOutOfEditor) {
        boolean okToUpdateBounds;
        Integer previousYPosition;
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(0);
        }
        if (hint.getComponent() instanceof ScrollAwareHint) {
            ((ScrollAwareHint)((Object)hint.getComponent())).editorScrolled();
        }
        if (!hint.isVisible()) {
            return;
        }
        Editor editor2 = e.getEditor();
        if (!editor2.getComponent().isShowing() || editor2.isOneLineMode()) {
            return;
        }
        Rectangle newRectangle = e.getOldRectangle();
        Rectangle oldRectangle = e.getNewRectangle();
        Point location = hint.getLocationOn(editor2.getContentComponent());
        Dimension size2 = hint.getSize();
        int xOffset = location.x - oldRectangle.x;
        int yOffset = location.y - oldRectangle.y;
        Point locationOnEditor = hint.getLocationOn(editor2.getComponent());
        if (oldRectangle.y == newRectangle.y && oldRectangle.height < newRectangle.height && (previousYPosition = (Integer)hint.getUserData(LAST_HINT_ON_EDITOR_Y_POSITION)) != null && previousYPosition > locationOnEditor.y) {
            yOffset += newRectangle.height - oldRectangle.height;
        }
        hint.putUserData(LAST_HINT_ON_EDITOR_Y_POSITION, locationOnEditor.y);
        location = new Point(newRectangle.x + xOffset, newRectangle.y + yOffset);
        Rectangle newBounds = new Rectangle(location.x, location.y, size2.width, size2.height);
        Rectangle newBoundsForIntersectionCheck = new Rectangle(location.x - 1, location.y - 1, size2.width + 2, size2.height + 2);
        boolean bl = okToUpdateBounds = hideIfOutOfEditor ? oldRectangle.contains(newBounds) : oldRectangle.intersects(newBoundsForIntersectionCheck);
        if (okToUpdateBounds || hint.vetoesHiding()) {
            hint.setLocation(new RelativePoint((Component)editor2.getContentComponent(), location));
        } else {
            hint.hide();
        }
    }

    public void showGutterHint(LightweightHint hint, Editor editor2, int lineNumber, int horizontalOffset, @HintManager.HideFlags int flags, int timeout, boolean reviveOnEditorChange, @NotNull HintHint hintInfo) {
        if (hintInfo == null) {
            HintManagerImpl.$$$reportNull$$$0(1);
        }
        HintManagerImpl.getClientManager(editor2).showGutterHint(hint, editor2, hintInfo, lineNumber, horizontalOffset, flags, timeout, reviveOnEditorChange, null);
    }

    public void showEditorHint(LightweightHint hint, Editor editor2, @HintManager.PositionFlags short constraint, @HintManager.HideFlags int flags, int timeout, boolean reviveOnEditorChange) {
        ThreadingAssertions.assertEventDispatchThread();
        editor2.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        editor2.getScrollingModel().runActionOnScrollingFinished(() -> {
            LogicalPosition pos = editor2.getCaretModel().getLogicalPosition();
            Point p = HintManagerImpl.getHintPosition(hint, editor2, pos, constraint);
            HintHint hintInfo = HintManagerImpl.createHintHint(editor2, p, hint, constraint);
            HintManagerImpl.getClientManager(editor2).showEditorHint(hint, editor2, hintInfo, p, flags, timeout, reviveOnEditorChange, null);
        });
    }

    public void showEditorHint(@NotNull LightweightHint hint, @NotNull Editor editor2, @NotNull Point p, @HintManager.HideFlags int flags, int timeout, boolean reviveOnEditorChange) {
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(3);
        }
        if (p == null) {
            HintManagerImpl.$$$reportNull$$$0(4);
        }
        this.showEditorHint(hint, editor2, p, flags, timeout, reviveOnEditorChange, (short)1);
    }

    public void showEditorHint(@NotNull LightweightHint hint, @NotNull Editor editor2, @NotNull Point p, @HintManager.HideFlags int flags, int timeout, boolean reviveOnEditorChange, @HintManager.PositionFlags short position) {
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(5);
        }
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(6);
        }
        if (p == null) {
            HintManagerImpl.$$$reportNull$$$0(7);
        }
        HintHint hintHint = HintManagerImpl.createHintHint(editor2, p, hint, position).setShowImmediately(true);
        this.showEditorHint(hint, editor2, p, flags, timeout, reviveOnEditorChange, hintHint);
    }

    public void showEditorHint(@NotNull LightweightHint hint, @NotNull Editor editor2, @NotNull Point p, @HintManager.HideFlags int flags, int timeout, boolean reviveOnEditorChange, @NotNull HintHint hintInfo) {
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(8);
        }
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(9);
        }
        if (p == null) {
            HintManagerImpl.$$$reportNull$$$0(10);
        }
        if (hintInfo == null) {
            HintManagerImpl.$$$reportNull$$$0(11);
        }
        HintManagerImpl.getClientManager(editor2).showEditorHint(hint, editor2, hintInfo, p, flags, timeout, reviveOnEditorChange, null);
    }

    public void showHint(@NotNull JComponent component2, @NotNull RelativePoint p, int flags, int timeout) {
        if (component2 == null) {
            HintManagerImpl.$$$reportNull$$$0(12);
        }
        if (p == null) {
            HintManagerImpl.$$$reportNull$$$0(13);
        }
        this.showHint(component2, p, flags, timeout, null);
    }

    public void showHint(@NotNull JComponent component2, @NotNull RelativePoint p, int flags, int timeout, @Nullable Runnable onHintHidden) {
        if (component2 == null) {
            HintManagerImpl.$$$reportNull$$$0(14);
        }
        if (p == null) {
            HintManagerImpl.$$$reportNull$$$0(15);
        }
        ClientHintManager.getCurrentInstance().showHint(component2, p, flags, timeout, onHintHidden);
    }

    @ApiStatus.Internal
    public static void doShowInGivenLocation(LightweightHint hint, Editor editor2, Point p, HintHint hintInfo, boolean updateSize) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        JComponent externalComponent = HintManagerImpl.getExternalComponent(editor2);
        p = HintManagerImpl.adjustHintPosition(p, updateSize, externalComponent, hint, hintInfo);
        if (hint.isShouldBeReopen()) {
            hint.hide(true);
        }
        if (hint.isVisible()) {
            if (updateSize) {
                hint.pack();
            }
            hint.updatePosition(hintInfo.getPreferredPosition());
            hint.updateLocation(p.x, p.y);
        } else {
            hint.show(externalComponent, p.x, p.y, editor2.getContentComponent(), hintInfo);
        }
        hint.putUserData(LAST_HINT_ON_EDITOR_Y_POSITION, hint.getLocationOn((JComponent)editor2.getComponent()).y);
    }

    @NotNull
    private static Point adjustHintPosition(Point p, boolean updateSize, JComponent externalComponent, LightweightHint hint, HintHint hintInfo) {
        Dimension size2;
        Dimension dimension = size2 = updateSize ? hint.getComponent().getPreferredSize() : hint.getComponent().getSize();
        if (LOG.isDebugEnabled()) {
            LOG.debug("START adjusting hint position " + String.valueOf(p) + " for a hint of size " + String.valueOf(size2) + " (using the " + (updateSize ? "preferred size" : "real size") + ")");
        }
        if (hint.isRealPopup() || hintInfo.isPopupForced()) {
            Point point = new Point(p);
            SwingUtilities.convertPointToScreen(point, externalComponent);
            if (LOG.isDebugEnabled()) {
                Rectangle componentBounds = new Rectangle(externalComponent.getLocationOnScreen(), externalComponent.getSize());
                LOG.debug("Location after converting to screen coordinates (for the external component with bounds " + String.valueOf(componentBounds) + "): " + String.valueOf(point));
            }
            Rectangle editorScreen = ScreenUtil.getScreenRectangle((int)point.x, (int)point.y);
            if (LOG.isDebugEnabled()) {
                LOG.debug("The screen rectangle for the original location is " + String.valueOf(editorScreen));
            }
            p = new Point(p);
            if (hintInfo.getPreferredPosition() == Balloon.Position.atLeft) {
                p.x -= size2.width;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Location after moving left to account for the balloon position" + String.valueOf(p));
                }
            }
            SwingUtilities.convertPointToScreen(p, externalComponent);
            if (LOG.isDebugEnabled()) {
                Rectangle componentBounds = new Rectangle(externalComponent.getLocationOnScreen(), externalComponent.getSize());
                LOG.debug("Location after converting to screen coordinates (for the external component with bounds " + String.valueOf(componentBounds) + "): " + String.valueOf(p));
            }
            Rectangle rectangle = new Rectangle(p, size2);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adjusting bounds to fit into the screen: " + String.valueOf(rectangle));
            }
            ScreenUtil.moveToFit((Rectangle)rectangle, (Rectangle)editorScreen, null);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adjusted bounds to fit into the screen: " + String.valueOf(rectangle));
            }
            p = rectangle.getLocation();
            SwingUtilities.convertPointFromScreen(p, externalComponent);
            if (LOG.isDebugEnabled()) {
                Rectangle componentBounds = new Rectangle(externalComponent.getLocationOnScreen(), externalComponent.getSize());
                LOG.debug("Location after converting from screen coordinates (for the external component with bounds " + String.valueOf(componentBounds) + "): " + String.valueOf(p));
            }
            if (hintInfo.getPreferredPosition() == Balloon.Position.atLeft) {
                p.x += size2.width;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Location after moving right to account for the balloon position" + String.valueOf(p));
                }
            }
        } else if (externalComponent.getWidth() < p.x + size2.width && !hintInfo.isAwtTooltip()) {
            p.x = Math.max(0, externalComponent.getWidth() - size2.width);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Location after trying to fit a non-AWT hint into [0, " + externalComponent.getWidth() + "]: " + String.valueOf(p));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("END adjusting hint position, the end result is " + String.valueOf(p));
        }
        Point point = p;
        if (point == null) {
            HintManagerImpl.$$$reportNull$$$0(16);
        }
        return point;
    }

    public static void updateLocation(LightweightHint hint, Editor editor2, Point p) {
        HintManagerImpl.doShowInGivenLocation(hint, editor2, p, HintManagerImpl.createHintHint(editor2, p, hint, (short)2), false);
    }

    public static void adjustEditorHintPosition(LightweightHint hint, Editor editor2, Point p, @HintManager.PositionFlags short constraint) {
        HintManagerImpl.doShowInGivenLocation(hint, editor2, p, HintManagerImpl.createHintHint(editor2, p, hint, constraint), true);
    }

    public void hideAllHints() {
        ClientHintManager.getCurrentInstance().hideAllHints();
    }

    public void cleanup() {
        ClientHintManager.getCurrentInstance().cleanup();
    }

    public Point getHintPosition(@NotNull LightweightHint hint, @NotNull Editor editor2, @HintManager.PositionFlags short constraint) {
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(17);
        }
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(18);
        }
        return ClientHintManager.getCurrentInstance().getHintPosition(hint, editor2, constraint);
    }

    static Point getHintPositionRelativeTo(@NotNull LightweightHint hint, @NotNull Editor editor2, @HintManager.PositionFlags short constraint, @NotNull Rectangle lookupBounds, LogicalPosition pos) {
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(19);
        }
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(20);
        }
        if (lookupBounds == null) {
            HintManagerImpl.$$$reportNull$$$0(21);
        }
        JComponent externalComponent = HintManagerImpl.getExternalComponent(editor2);
        IdeTooltip ideTooltip = hint.getCurrentIdeTooltip();
        if (ideTooltip != null) {
            Point point = ideTooltip.getPoint();
            return SwingUtilities.convertPoint(ideTooltip.getComponent(), point, externalComponent);
        }
        Dimension hintSize = hint.getComponent().getPreferredSize();
        int layeredPaneHeight = externalComponent.getHeight();
        switch (constraint) {
            case 3: {
                int y = lookupBounds.y;
                if (y < 0) {
                    y = 0;
                } else if (y + hintSize.height >= layeredPaneHeight) {
                    y = layeredPaneHeight - hintSize.height;
                }
                return new Point(lookupBounds.x - hintSize.width, y);
            }
            case 4: {
                int y = lookupBounds.y;
                if (y < 0) {
                    y = 0;
                } else if (y + hintSize.height >= layeredPaneHeight) {
                    y = layeredPaneHeight - hintSize.height;
                }
                return new Point(lookupBounds.x + lookupBounds.width, y);
            }
            case 1: {
                Point posAboveCaret = HintManagerImpl.getHintPosition(hint, editor2, pos, (short)1);
                return new Point(lookupBounds.x, Math.min(posAboveCaret.y, lookupBounds.y - hintSize.height));
            }
            case 2: {
                Point posUnderCaret = HintManagerImpl.getHintPosition(hint, editor2, pos, (short)2);
                return new Point(lookupBounds.x, Math.max(posUnderCaret.y, lookupBounds.y + lookupBounds.height));
            }
        }
        LOG.error("");
        return null;
    }

    public static Point getHintPosition(@NotNull LightweightHint hint, @NotNull Editor editor2, @NotNull RelativePoint point, @HintManager.PositionFlags short constraint) {
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(22);
        }
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(23);
        }
        if (point == null) {
            HintManagerImpl.$$$reportNull$$$0(24);
        }
        Point p = point.getPoint((Component)editor2.getContentComponent());
        return HintManagerImpl.getHintPosition(hint, editor2, p, p, constraint, Registry.is((String)"editor.balloonHints"));
    }

    public static Point getHintPosition(@NotNull LightweightHint hint, @NotNull Editor editor2, @NotNull LogicalPosition pos, @HintManager.PositionFlags short constraint) {
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(25);
        }
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(26);
        }
        if (pos == null) {
            HintManagerImpl.$$$reportNull$$$0(27);
        }
        VisualPosition visualPos = editor2.logicalToVisualPosition(pos);
        return HintManagerImpl.getHintPosition(hint, editor2, visualPos, visualPos, constraint);
    }

    public static Point getHintPosition(@NotNull LightweightHint hint, @NotNull Editor editor2, @NotNull VisualPosition pos, @HintManager.PositionFlags short constraint) {
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(28);
        }
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(29);
        }
        if (pos == null) {
            HintManagerImpl.$$$reportNull$$$0(30);
        }
        return HintManagerImpl.getHintPosition(hint, editor2, pos, pos, constraint);
    }

    private static Point getHintPosition(@NotNull LightweightHint hint, @NotNull Editor editor2, @NotNull VisualPosition pos1, @NotNull VisualPosition pos2, @HintManager.PositionFlags short constraint) {
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(31);
        }
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(32);
        }
        if (pos1 == null) {
            HintManagerImpl.$$$reportNull$$$0(33);
        }
        if (pos2 == null) {
            HintManagerImpl.$$$reportNull$$$0(34);
        }
        return HintManagerImpl.getHintPosition(hint, editor2, pos1, pos2, constraint, Registry.is((String)"editor.balloonHints"));
    }

    private static Point getHintPosition(@NotNull LightweightHint hint, @NotNull Editor editor2, @NotNull VisualPosition pos1, @NotNull VisualPosition pos2, @HintManager.PositionFlags short constraint, boolean showByBalloon) {
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(35);
        }
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(36);
        }
        if (pos1 == null) {
            HintManagerImpl.$$$reportNull$$$0(37);
        }
        if (pos2 == null) {
            HintManagerImpl.$$$reportNull$$$0(38);
        }
        return HintManagerImpl.getHintPosition(hint, editor2, editor2.visualPositionToXY(pos1), editor2.visualPositionToXY(pos2), constraint, showByBalloon);
    }

    private static Point getHintPosition(@NotNull LightweightHint hint, @NotNull Editor editor2, @NotNull Point point1, @NotNull Point point2, @HintManager.PositionFlags short constraint, boolean showByBalloon) {
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(39);
        }
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(40);
        }
        if (point1 == null) {
            HintManagerImpl.$$$reportNull$$$0(41);
        }
        if (point2 == null) {
            HintManagerImpl.$$$reportNull$$$0(42);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return new Point();
        }
        Point p = HintManagerImpl._getHintPosition(hint, editor2, point1, point2, constraint, showByBalloon);
        JComponent externalComponent = HintManagerImpl.getExternalComponent(editor2);
        Dimension hintSize = hint.getComponent().getPreferredSize();
        if (constraint == 1) {
            if (p.y < 0) {
                Point p1 = HintManagerImpl._getHintPosition(hint, editor2, point1, point2, (short)2, showByBalloon);
                if (p1.y + hintSize.height <= externalComponent.getSize().height) {
                    return p1;
                }
            }
        } else if (constraint == 2 && p.y + hintSize.height > externalComponent.getSize().height) {
            Point p1 = HintManagerImpl._getHintPosition(hint, editor2, point1, point2, (short)1, showByBalloon);
            if (p1.y >= 0) {
                return p1;
            }
        }
        return p;
    }

    @NotNull
    public static JComponent getExternalComponent(@NotNull Editor editor2) {
        JComponent externalComponent;
        JRootPane rootPane;
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(43);
        }
        if ((rootPane = (externalComponent = editor2.getComponent()).getRootPane()) == null) {
            JComponent jComponent = externalComponent;
            if (jComponent == null) {
                HintManagerImpl.$$$reportNull$$$0(44);
            }
            return jComponent;
        }
        JLayeredPane layeredPane2 = rootPane.getLayeredPane();
        JComponent jComponent = layeredPane2 != null ? layeredPane2 : rootPane;
        if (jComponent == null) {
            HintManagerImpl.$$$reportNull$$$0(45);
        }
        return jComponent;
    }

    private static Point _getHintPosition(@NotNull LightweightHint hint, @NotNull Editor editor2, @NotNull Point point1, @NotNull Point point2, @HintManager.PositionFlags short constraint, boolean showByBalloon) {
        Point p;
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(46);
        }
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(47);
        }
        if (point1 == null) {
            HintManagerImpl.$$$reportNull$$$0(48);
        }
        if (point2 == null) {
            HintManagerImpl.$$$reportNull$$$0(49);
        }
        Dimension hintSize = hint.getComponent().getPreferredSize();
        JComponent externalComponent = HintManagerImpl.getExternalComponent(editor2);
        JComponent internalComponent = editor2.getContentComponent();
        if (constraint == 5) {
            p = new Point(point2);
            if (!showByBalloon) {
                p.y += editor2.getLineHeight();
            }
        } else {
            p = new Point(point1);
            if (constraint == 2) {
                p.y += editor2.getLineHeight();
            }
        }
        Point location = SwingUtilities.convertPoint(internalComponent, p, externalComponent);
        if (constraint == 1 && !showByBalloon) {
            location.y -= hintSize.height;
            int diff = location.x + hintSize.width - externalComponent.getWidth();
            if (diff > 0) {
                location.x = Math.max(location.x - diff, 0);
            }
        }
        if (!(constraint != 3 && constraint != 4 || showByBalloon)) {
            location.y -= hintSize.height / 2;
            if (constraint == 3) {
                location.x -= hintSize.width;
            }
        }
        return location;
    }

    public void showErrorHint(@NotNull Editor editor2, @NlsContexts.HintText @NotNull String text2) {
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(50);
        }
        if (text2 == null) {
            HintManagerImpl.$$$reportNull$$$0(51);
        }
        this.showErrorHint(editor2, text2, (short)1);
    }

    public void showErrorHint(@NotNull Editor editor2, @NlsContexts.HintText @NotNull String text2, short position) {
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(52);
        }
        if (text2 == null) {
            HintManagerImpl.$$$reportNull$$$0(53);
        }
        JComponent label2 = HintUtil.createErrorLabel(text2);
        LightweightHint hint = new LightweightHint(label2);
        Point p = HintManagerImpl.getClientManager(editor2).getHintPosition(hint, editor2, position);
        int flags = 42;
        this.showEditorHint(hint, editor2, p, flags, 0, false);
    }

    public void showInformationHint(@NotNull Editor editor2, @NotNull String text2, @HintManager.PositionFlags short position) {
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(54);
        }
        if (text2 == null) {
            HintManagerImpl.$$$reportNull$$$0(55);
        }
        this.showInformationHint(editor2, text2, null, position);
    }

    public void showInformationHint(@NotNull Editor editor2, @NotNull String text2, @Nullable HyperlinkListener listener2) {
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(56);
        }
        if (text2 == null) {
            HintManagerImpl.$$$reportNull$$$0(57);
        }
        this.showInformationHint(editor2, text2, listener2, (short)1);
    }

    private void showInformationHint(@NotNull Editor editor2, @NlsContexts.HintText @NotNull String text2, @Nullable HyperlinkListener listener2, @HintManager.PositionFlags short position) {
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(58);
        }
        if (text2 == null) {
            HintManagerImpl.$$$reportNull$$$0(59);
        }
        JComponent label2 = HintUtil.createInformationLabel(text2, listener2, null, null);
        this.showInformationHint(editor2, label2, position, null);
    }

    public void showInformationHint(@NotNull Editor editor2, @NotNull JComponent component2) {
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(60);
        }
        if (component2 == null) {
            HintManagerImpl.$$$reportNull$$$0(61);
        }
        this.showInformationHint(editor2, component2, null);
    }

    public void showInformationHint(@NotNull Editor editor2, @NotNull JComponent component2, @Nullable Runnable onHintHidden) {
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(62);
        }
        if (component2 == null) {
            HintManagerImpl.$$$reportNull$$$0(63);
        }
        this.showInformationHint(editor2, component2, (short)1, onHintHidden);
    }

    public void showInformationHint(@NotNull Editor editor2, @NotNull JComponent component2, @HintManager.PositionFlags short position, @Nullable Runnable onHintHidden) {
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(64);
        }
        if (component2 == null) {
            HintManagerImpl.$$$reportNull$$$0(65);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        LightweightHint hint = new LightweightHint(component2);
        Point p = HintManagerImpl.getClientManager(editor2).getHintPosition(hint, editor2, position);
        int flags = 42;
        AccessibleContextUtil.setName((Component)hint.getComponent(), (String)IdeBundle.message((String)"information.hint.accessible.context.name", (Object[])new Object[0]));
        if (onHintHidden != null) {
            AtomicBoolean called = new AtomicBoolean();
            hint.addHintListener(event -> {
                if (called.compareAndSet(false, true)) {
                    onHintHidden.run();
                }
            });
        }
        this.showEditorHint(hint, editor2, p, flags, 0, false);
    }

    public void showSuccessHint(@NotNull Editor editor2, @NotNull String text2, short position) {
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(66);
        }
        if (text2 == null) {
            HintManagerImpl.$$$reportNull$$$0(67);
        }
        this.showSuccessHint(editor2, text2, position, null);
    }

    public void showSuccessHint(@NotNull Editor editor2, @NotNull String text2, @Nullable HyperlinkListener listener2) {
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(68);
        }
        if (text2 == null) {
            HintManagerImpl.$$$reportNull$$$0(69);
        }
        this.showSuccessHint(editor2, text2, (short)1, listener2);
    }

    private void showSuccessHint(@NotNull Editor editor2, @NlsContexts.HintText @NotNull String text2, @HintManager.PositionFlags short position, @Nullable HyperlinkListener listener2) {
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(70);
        }
        if (text2 == null) {
            HintManagerImpl.$$$reportNull$$$0(71);
        }
        LightweightHint hint = new LightweightHint(HintUtil.createSuccessLabel(text2, listener2));
        Point p = HintManagerImpl.getClientManager(editor2).getHintPosition(hint, editor2, position);
        int flags = 42;
        this.showEditorHint(hint, editor2, p, flags, 0, false);
    }

    @NotNull
    private static ClientHintManager getClientManager(@NotNull Editor editor2) {
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(72);
        }
        AccessToken ignored = ClientId.withClientId((ClientId)ClientEditorManager.Companion.getClientId(editor2));
        ClientHintManager clientHintManager = ClientHintManager.getCurrentInstance();
        ClientHintManager clientHintManager2 = clientHintManager;
        if (clientHintManager2 == null) {
            HintManagerImpl.$$$reportNull$$$0(73);
        }
        return clientHintManager2;
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
    }

    public void showErrorHint(@NotNull Editor editor2, @NlsContexts.HintText @NotNull String hintText, int offset1, int offset2, short constraint, int flags, int timeout) {
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(74);
        }
        if (hintText == null) {
            HintManagerImpl.$$$reportNull$$$0(75);
        }
        JComponent label2 = HintUtil.createErrorLabel(hintText);
        LightweightHint hint = new LightweightHint(label2);
        VisualPosition pos1 = editor2.offsetToVisualPosition(offset1);
        VisualPosition pos2 = editor2.offsetToVisualPosition(offset2);
        Point p = HintManagerImpl.getHintPosition(hint, editor2, pos1, pos2, constraint);
        this.showEditorHint(hint, editor2, p, flags, timeout, false);
    }

    public void showQuestionHint(@NotNull Editor editor2, @NotNull String hintText, int offset1, int offset2, @NotNull QuestionAction action2) {
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(76);
        }
        if (hintText == null) {
            HintManagerImpl.$$$reportNull$$$0(77);
        }
        if (action2 == null) {
            HintManagerImpl.$$$reportNull$$$0(78);
        }
        JComponent label2 = HintUtil.createQuestionLabel(hintText);
        LightweightHint hint = new LightweightHint(label2);
        this.showQuestionHint(editor2, offset1, offset2, hint, action2, (short)1);
    }

    public void showQuestionHint(@NotNull Editor editor2, int offset1, int offset2, @NotNull LightweightHint hint, @NotNull QuestionAction action2, @HintManager.PositionFlags short constraint) {
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(79);
        }
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(80);
        }
        if (action2 == null) {
            HintManagerImpl.$$$reportNull$$$0(81);
        }
        VisualPosition pos1 = editor2.offsetToVisualPosition(offset1);
        VisualPosition pos2 = editor2.offsetToVisualPosition(offset2);
        Point p = HintManagerImpl.getHintPosition(hint, editor2, pos1, pos2, constraint);
        this.showQuestionHint(editor2, p, offset1, offset2, hint, action2, constraint);
    }

    private static void showQuestionHint(@NotNull Editor editor2, @NotNull Point p, int offset1, int offset2, @NotNull LightweightHint hint, int flags, @NotNull QuestionAction action2, @HintManager.PositionFlags short constraint) {
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(82);
        }
        if (p == null) {
            HintManagerImpl.$$$reportNull$$$0(83);
        }
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(84);
        }
        if (action2 == null) {
            HintManagerImpl.$$$reportNull$$$0(85);
        }
        HintManagerImpl.getClientManager(editor2).showQuestionHint(editor2, p, offset1, offset2, hint, flags, action2, constraint);
    }

    public void showQuestionHint(@NotNull Editor editor2, @NotNull Point p, int offset1, int offset2, @NotNull LightweightHint hint, @NotNull QuestionAction action2, @HintManager.PositionFlags short constraint) {
        HintUtil.HintLabel label2;
        JEditorPane pane2;
        JComponent jComponent;
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(86);
        }
        if (p == null) {
            HintManagerImpl.$$$reportNull$$$0(87);
        }
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(88);
        }
        if (action2 == null) {
            HintManagerImpl.$$$reportNull$$$0(89);
        }
        if (ExperimentalUI.isNewUI() && (jComponent = hint.getComponent()) instanceof HintUtil.HintLabel && (pane2 = (label2 = (HintUtil.HintLabel)jComponent).getPane()) != null) {
            pane2.addHyperlinkListener(e -> {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && "action".equals(e.getDescription()) && hint.isVisible()) {
                    boolean execute2;
                    try (AccessToken ignore = SlowOperations.startSection((String)"action.perform");){
                        execute2 = action2.execute();
                    }
                    if (execute2) {
                        hint.hide();
                    }
                }
            });
        }
        int flags = 714;
        HintManagerImpl.showQuestionHint(editor2, p, offset1, offset2, hint, flags, action2, constraint);
    }

    public static HintHint createHintHint(Editor editor2, Point p, LightweightHint hint, @HintManager.PositionFlags short constraint) {
        return HintManagerImpl.createHintHint(editor2, p, hint, constraint, false);
    }

    public static HintHint createHintHint(Editor editor2, Point p, LightweightHint hint, @HintManager.PositionFlags short constraint, boolean createInEditorComponent) {
        JRootPane rootPane = editor2.getComponent().getRootPane();
        if (rootPane == null) {
            return new HintHint(editor2, p);
        }
        JLayeredPane lp = rootPane.getLayeredPane();
        HintHint hintInfo = new HintHint(editor2, SwingUtilities.convertPoint(lp, p, editor2.getContentComponent()));
        boolean showByBalloon = Registry.is((String)"editor.balloonHints");
        if (showByBalloon) {
            if (!createInEditorComponent) {
                hintInfo = new HintHint(lp, p);
            }
            hintInfo.setAwtTooltip(true).setHighlighterType(true);
        }
        hintInfo.initStyleFrom(hint.getComponent());
        if (showByBalloon) {
            if (!hintInfo.isBorderColorSet()) {
                hintInfo.setBorderColor((Color)new JBColor(Color.gray, (Color)Gray._140));
            }
            hintInfo.setFont(hintInfo.getTextFont().deriveFont(0));
            hintInfo.setCalloutShift((int)((double)editor2.getLineHeight() * 0.1));
        }
        hintInfo.setPreferredPosition(Balloon.Position.above);
        if (constraint == 2 || constraint == 5) {
            hintInfo.setPreferredPosition(Balloon.Position.below);
        } else if (constraint == 4) {
            hintInfo.setPreferredPosition(Balloon.Position.atRight);
        } else if (constraint == 3) {
            hintInfo.setPreferredPosition(Balloon.Position.atLeft);
        }
        if (hint.isAwtTooltip()) {
            hintInfo.setAwtTooltip(true);
        }
        hintInfo.setPositionChangeShift(0, editor2.getLineHeight());
        return hintInfo;
    }

    boolean isEscapeHandlerEnabled() {
        return ClientHintManager.getCurrentInstance().isEscapeHandlerEnabled();
    }

    public boolean hideHints(int mask, boolean onlyOne, boolean editorChanged) {
        return ClientHintManager.getCurrentInstance().hideHints(mask, onlyOne, editorChanged);
    }

    public static EditorHintListener getPublisher() {
        return EditorHintListenerHolder.ourEditorHintPublisher;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16, 44, 45, 73 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintInfo";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 18: 
            case 20: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 36: 
            case 40: 
            case 43: 
            case 47: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 74: 
            case 76: 
            case 79: 
            case 82: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 83: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 12: 
            case 14: 
            case 61: 
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 16: 
            case 44: 
            case 45: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/hint/HintManagerImpl";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupBounds";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos1";
                break;
            }
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos2";
                break;
            }
            case 41: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point1";
                break;
            }
            case 42: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point2";
                break;
            }
            case 51: 
            case 53: 
            case 55: 
            case 57: 
            case 59: 
            case 67: 
            case 69: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 75: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintText";
                break;
            }
            case 78: 
            case 81: 
            case 85: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/hint/HintManagerImpl";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustHintPosition";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalComponent";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getClientManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateScrollableHintPosition";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "showGutterHint";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showEditorHint";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
            case 16: 
            case 44: 
            case 45: 
            case 73: {
                break;
            }
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getHintPosition";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getHintPositionRelativeTo";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getExternalComponent";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "_getHintPosition";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "showErrorHint";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "showInformationHint";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "showSuccessHint";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getClientManager";
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "showQuestionHint";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16, 44, 45, 73 -> new IllegalStateException(string);
        };
    }

    public static interface ActionToIgnore {
        @ApiStatus.Internal
        default public boolean shouldBeIgnored() {
            return true;
        }
    }

    private final class MyEditorManagerListener
    implements FileEditorManagerListener {
        private MyEditorManagerListener() {
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            if (event == null) {
                MyEditorManagerListener.$$$reportNull$$$0(0);
            }
            HintManagerImpl.this.hideHints(0, false, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/hint/HintManagerImpl$MyEditorManagerListener", "selectionChanged"));
        }
    }

    private final class MyProjectManagerListener
    implements ProjectManagerListener {
        private MyProjectManagerListener() {
        }

        public void projectOpened(@NotNull Project project2) {
            if (project2 == null) {
                MyProjectManagerListener.$$$reportNull$$$0(0);
            }
            project2.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)HintManagerImpl.this.myEditorManagerListener);
        }

        public void projectClosed(@NotNull Project project2) {
            if (project2 == null) {
                MyProjectManagerListener.$$$reportNull$$$0(1);
            }
            ThreadingAssertions.assertEventDispatchThread();
            TooltipController.getInstance().cancelTooltips();
            ApplicationManager.getApplication().invokeLater(() -> HintManagerImpl.this.hideHints(0, false, false));
            for (ClientHintManager instance : ClientHintManager.getAllInstances()) {
                instance.onProjectClosed(project2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/intellij/codeInsight/hint/HintManagerImpl$MyProjectManagerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectOpened";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectClosed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class EditorHintListenerHolder {
        static final EditorHintListener ourEditorHintPublisher = (EditorHintListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(EditorHintListener.TOPIC);

        private EditorHintListenerHolder() {
        }
    }

    record HintInfo(LightweightHint hint, @HintManager.HideFlags int flags, boolean reviveOnEditorChange) {
    }
}

