/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.util.containers.ContainerUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public abstract class AbstractMessage {
    private final Date myDate = Calendar.getInstance().getTime();
    private boolean myIsRead;
    private Runnable myOnReadCallback;
    private boolean myIsSubmitting;
    private SubmittedReportInfo mySubmissionInfo;
    private String myAdditionalInfo;
    private String myAppInfo;

    @NotNull
    public abstract Throwable getThrowable();

    @NotNull
    public abstract String getThrowableText();

    @Nullable
    public abstract String getMessage();

    @NotNull
    public @Unmodifiable List<Attachment> getAllAttachments() {
        List<Attachment> list2 = List.of();
        if (list2 == null) {
            AbstractMessage.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @NotNull
    public @Unmodifiable List<Attachment> getIncludedAttachments() {
        List list2 = ContainerUtil.filter(this.getAllAttachments(), Attachment::isIncluded);
        if (list2 == null) {
            AbstractMessage.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @NotNull
    public Date getDate() {
        Date date = this.myDate;
        if (date == null) {
            AbstractMessage.$$$reportNull$$$0(2);
        }
        return date;
    }

    public boolean isRead() {
        return this.myIsRead;
    }

    public void setRead(boolean isRead) {
        this.myIsRead = isRead;
        if (isRead && this.myOnReadCallback != null) {
            this.myOnReadCallback.run();
            this.myOnReadCallback = null;
        }
    }

    public void setOnReadCallback(Runnable callback) {
        this.myOnReadCallback = callback;
    }

    public boolean isSubmitting() {
        return this.myIsSubmitting;
    }

    public void setSubmitting(boolean isSubmitting) {
        this.myIsSubmitting = isSubmitting;
    }

    public SubmittedReportInfo getSubmissionInfo() {
        return this.mySubmissionInfo;
    }

    public void setSubmitted(SubmittedReportInfo info) {
        this.myIsSubmitting = false;
        this.mySubmissionInfo = info;
    }

    public boolean isSubmitted() {
        return this.mySubmissionInfo != null && (this.mySubmissionInfo.getStatus() == SubmittedReportInfo.SubmissionStatus.NEW_ISSUE || this.mySubmissionInfo.getStatus() == SubmittedReportInfo.SubmissionStatus.DUPLICATE);
    }

    public String getAdditionalInfo() {
        return this.myAdditionalInfo;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.myAdditionalInfo = additionalInfo;
    }

    @Nullable
    protected String getAppInfo() {
        return this.myAppInfo;
    }

    protected void setAppInfo(String appInfo) {
        this.myAppInfo = appInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/diagnostic/AbstractMessage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAttachments";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedAttachments";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDate";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

