/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.DisablePluginsDialog;
import com.intellij.diagnostic.PluginStartupCostEntry;
import com.intellij.diagnostic.StartUpPerformanceService;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.ListTableModel;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\u0013\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0014\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0014J\b\u0010 \u001a\u00020\u0019H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\bH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u0013X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006$"}, d2={"Lcom/intellij/diagnostic/PluginStartupCostDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "pluginsToDisable", "", "", "getPluginsToDisable", "()Ljava/util/Set;", "tableModel", "Lcom/intellij/util/ui/ListTableModel;", "Lcom/intellij/diagnostic/PluginStartupCostEntry;", "getTableModel", "()Lcom/intellij/util/ui/ListTableModel;", "setTableModel", "(Lcom/intellij/util/ui/ListTableModel;)V", "table", "Lcom/intellij/ui/table/TableView;", "getTable", "()Lcom/intellij/ui/table/TableView;", "setTable", "(Lcom/intellij/ui/table/TableView;)V", "createCenterPanel", "Ljavax/swing/JComponent;", "createLeftSideActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "doOKAction", "", "getPreferredFocusedComponent", "getInitialSize", "Ljava/awt/Dimension;", "getDimensionServiceKey", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nAnalyzePluginStartupPerformanceAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyzePluginStartupPerformanceAction.kt\ncom/intellij/diagnostic/PluginStartupCostDialog\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n136#2,9:138\n216#2:147\n217#2:149\n145#2:150\n1#3:148\n1#3:162\n1068#4:151\n1617#4,9:152\n1869#4:161\n1870#4:163\n1626#4:164\n*S KotlinDebug\n*F\n+ 1 AnalyzePluginStartupPerformanceAction.kt\ncom/intellij/diagnostic/PluginStartupCostDialog\n*L\n58#1:138,9\n58#1:147\n58#1:149\n58#1:150\n58#1:148\n127#1:162\n82#1:151\n127#1:152,9\n127#1:161\n127#1:163\n127#1:164\n*E\n"})
final class PluginStartupCostDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final Set<String> pluginsToDisable;
    public ListTableModel<PluginStartupCostEntry> tableModel;
    public TableView<PluginStartupCostEntry> table;

    public PluginStartupCostDialog(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(project2);
        this.project = project2;
        this.pluginsToDisable = new LinkedHashSet();
        this.setTitle(IdeBundle.message((String)"analyze.plugin.title", (Object[])new Object[0]));
        this.init();
    }

    @NotNull
    public final Set<String> getPluginsToDisable() {
        return this.pluginsToDisable;
    }

    @NotNull
    public final ListTableModel<PluginStartupCostEntry> getTableModel() {
        ListTableModel<PluginStartupCostEntry> listTableModel = this.tableModel;
        if (listTableModel != null) {
            return listTableModel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"tableModel");
        return null;
    }

    public final void setTableModel(@NotNull ListTableModel<PluginStartupCostEntry> listTableModel) {
        Intrinsics.checkNotNullParameter(listTableModel, (String)"<set-?>");
        this.tableModel = listTableModel;
    }

    @NotNull
    public final TableView<PluginStartupCostEntry> getTable() {
        TableView<PluginStartupCostEntry> tableView = this.table;
        if (tableView != null) {
            return tableView;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"table");
        return null;
    }

    public final void setTable(@NotNull TableView<PluginStartupCostEntry> tableView) {
        Intrinsics.checkNotNullParameter(tableView, (String)"<set-?>");
        this.table = tableView;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected JComponent createCenterPanel() {
        void $this$createCenterPanel_u24lambda_u242;
        ColumnInfo[] columnInfoArray;
        ColumnInfo[] columnInfoArray2;
        String $this$mapNotNullTo$iv$iv;
        Map pluginCostMap;
        Map $this$mapNotNull$iv = pluginCostMap = StartUpPerformanceService.Companion.getInstance().getPluginCostMap();
        boolean $i$f$mapNotNull = false;
        Map map2 = $this$mapNotNull$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        ColumnInfo[] $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            PluginStartupCostEntry pluginStartupCostEntry;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            String pluginId = (String)entry.getKey();
            Object2LongMap costMap = (Object2LongMap)entry.getValue();
            if (!ApplicationManager.getApplication().isInternal() && ApplicationInfo.getInstance().isEssentialPlugin(pluginId)) {
                pluginStartupCostEntry = null;
            } else {
                Object object = PluginManagerCore.getPlugin((PluginId)PluginId.Companion.getId(pluginId));
                if (object == null || (object = object.getName()) == null) {
                    pluginStartupCostEntry = null;
                } else {
                    LongIterator iterator2;
                    Object name2 = object;
                    long totalCost = 0L;
                    Intrinsics.checkNotNullExpressionValue((Object)((LongCollection)costMap.values()).iterator(), (String)"iterator(...)");
                    while (iterator2.hasNext()) {
                        totalCost += iterator2.nextLong();
                    }
                    Set set = costMap.keySet();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
                    List ids = CollectionsKt.toMutableList((Collection)set);
                    CollectionsKt.sort((List)ids);
                    StringBuilder costDetails = new StringBuilder();
                    for (String id2 : ids) {
                        costDetails.append(id2).append(": ").append(TimeUnit.NANOSECONDS.toMillis(costMap.getLong((Object)id2)));
                        costDetails.append('\n');
                    }
                    String string = costDetails.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    pluginStartupCostEntry = new PluginStartupCostEntry(pluginId, (String)name2, totalCost, string);
                }
            }
            if (pluginStartupCostEntry == null) continue;
            PluginStartupCostEntry it$iv$iv = pluginStartupCostEntry;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending22 = false;
        List tableData = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PluginStartupCostEntry it = (PluginStartupCostEntry)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getCost());
                it = (PluginStartupCostEntry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getCost()));
            }
        });
        String $i$f$sortedByDescending22 = IdeBundle.message((String)"column.name.plugin", (Object[])new Object[0]);
        ColumnInfo<PluginStartupCostEntry, String> pluginColumn2 = new ColumnInfo<PluginStartupCostEntry, String>(this, $i$f$sortedByDescending22){
            final /* synthetic */ PluginStartupCostDialog this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public String valueOf(PluginStartupCostEntry item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return item.getPluginName() + (this.this$0.getPluginsToDisable().contains(item.getPluginId()) ? " (will be disabled)" : "");
            }
        };
        $this$mapNotNullTo$iv$iv = IdeBundle.message((String)"column.name.startup.time.ms", (Object[])new Object[0]);
        ColumnInfo<PluginStartupCostEntry, Integer> costColumn2 = new ColumnInfo<PluginStartupCostEntry, Integer>($this$mapNotNullTo$iv$iv){

            public Integer valueOf(PluginStartupCostEntry item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return (int)TimeUnit.NANOSECONDS.toMillis(item.getCost());
            }
        };
        destination$iv$iv = IdeBundle.message((String)"column.name.cost.details", (Object[])new Object[0]);
        ColumnInfo<PluginStartupCostEntry, String> costDetailsColumn2 = new ColumnInfo<PluginStartupCostEntry, String>((String)destination$iv$iv){

            public String valueOf(PluginStartupCostEntry item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return item.getCostDetails();
            }
        };
        if (ApplicationManager.getApplication().isInternal()) {
            columnInfoArray2 = new TableView[]{pluginColumn2, costColumn2, costDetailsColumn2};
            columnInfoArray = columnInfoArray2;
        } else {
            columnInfoArray2 = new ColumnInfo[]{pluginColumn2, costColumn2};
            columnInfoArray = columnInfoArray2;
        }
        ColumnInfo[] columns = columnInfoArray;
        this.setTableModel((ListTableModel<PluginStartupCostEntry>)new ListTableModel(columns, tableData));
        $this$forEach$iv$iv$iv = columnInfoArray2 = new TableView(this.getTableModel());
        PluginStartupCostDialog pluginStartupCostDialog = this;
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u242.setShowColumns(true);
        pluginStartupCostDialog.setTable((TableView<PluginStartupCostEntry>)columnInfoArray2);
        return (JComponent)new JBScrollPane((Component)this.getTable());
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        Action[] actionArray = IdeBundle.message((String)"button.disable.selected.plugins", (Object[])new Object[0]);
        AbstractAction disableAction2 = new AbstractAction(this, (String)actionArray){
            final /* synthetic */ PluginStartupCostDialog this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(ActionEvent e) {
                for (PluginStartupCostEntry costEntry : this.this$0.getTable().getSelectedObjects()) {
                    this.this$0.getPluginsToDisable().add(costEntry.getPluginId());
                }
                this.this$0.getTableModel().fireTableDataChanged();
            }
        };
        actionArray = new Action[]{disableAction2};
        return actionArray;
    }

    /*
     * WARNING - void declaration
     */
    protected void doOKAction() {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        super.doOKAction();
        Iterable iterable = this.pluginsToDisable;
        Project project2 = this.project;
        boolean $i$f$mapNotNull = false;
        void var3_4 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            IdeaPluginDescriptor it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (PluginManagerCore.getPlugin((PluginId)PluginId.Companion.getId(it)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        DisablePluginsDialog.confirmDisablePlugins$intellij_platform_ide_impl(project2, (List)destination$iv$iv);
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.getTable();
    }

    @NotNull
    public Dimension getInitialSize() {
        return (Dimension)new JBDimension(800, 600);
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "AnalyzePluginStartupPerformanceAction.PluginStartupCostDialog";
    }
}

