/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Deprecated(message="Internal component, and already outdated at that", level=DeprecationLevel.ERROR)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001b\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R&\u0010\u0013\u001a\u00020\u00032\b\b\u0001\u0010\u0012\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lcom/intellij/diagnostic/PrivacyNoticeComponent;", "Ljavax/swing/JPanel;", "label", "", "expandedLabel", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "iconLabel", "Ljavax/swing/JLabel;", "titleLabel", "privacyPolicyPane", "Ljavax/swing/JEditorPane;", "expanded", "", "getExpanded", "()Z", "setExpanded", "(Z)V", "text", "privacyPolicy", "getPrivacyPolicy", "()Ljava/lang/String;", "setPrivacyPolicy", "(Ljava/lang/String;)V", "useInHeader", "", "component", "Ljavax/swing/JComponent;", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class PrivacyNoticeComponent
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String label;
    @NotNull
    private final String expandedLabel;
    @NotNull
    private final JLabel iconLabel;
    @NotNull
    private final JLabel titleLabel;
    @NotNull
    private final JEditorPane privacyPolicyPane;
    private boolean expanded;

    public PrivacyNoticeComponent(@NlsContexts.Label @NotNull String label2, @NlsContexts.Label @NotNull String expandedLabel) {
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        Intrinsics.checkNotNullParameter((Object)expandedLabel, (String)"expandedLabel");
        super(new GridBagLayout());
        this.label = label2;
        this.expandedLabel = expandedLabel;
        this.iconLabel = new JLabel();
        this.titleLabel = new JLabel();
        this.privacyPolicyPane = new JEditorPane();
        this.expanded = true;
        this.setBackground(PrivacyNoticeComponent.Companion.backgroundColor());
        JPanel iconLabelPanel = new JPanel(new BorderLayout());
        this.useInHeader(iconLabelPanel);
        iconLabelPanel.add((Component)this.iconLabel, "West");
        JPanel mySeparatorPanel = new JPanel();
        this.useInHeader(mySeparatorPanel);
        mySeparatorPanel.setPreferredSize(new Dimension(6, 1));
        this.useInHeader(this.titleLabel);
        this.titleLabel.setForeground(PrivacyNoticeComponent.Companion.titleColor());
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont((float)(this.titleLabel.getFont().getSize() - 1)));
        this.privacyPolicyPane.setEditable(false);
        this.privacyPolicyPane.setFocusable(false);
        this.privacyPolicyPane.setBackground(PrivacyNoticeComponent.Companion.backgroundColor());
        this.privacyPolicyPane.setForeground(PrivacyNoticeComponent.Companion.noticeColor());
        this.privacyPolicyPane.setFont(this.privacyPolicyPane.getFont().deriveFont((float)(this.privacyPolicyPane.getFont().getSize() - (SystemInfo.isWindows ? 2 : 1))));
        this.privacyPolicyPane.setEditorKit(HTMLEditorKitBuilder.Companion.simple());
        this.privacyPolicyPane.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)6, (int)6));
        this.privacyPolicyPane.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        this.add((Component)mySeparatorPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 3, (Insets)JBInsets.emptyInsets(), 0, 0));
        this.add((Component)iconLabelPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBInsets.emptyInsets(), 0, 0));
        this.add((Component)this.titleLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, (Insets)JBInsets.emptyInsets(), 0, 0));
        this.add((Component)this.privacyPolicyPane, new GridBagConstraints(2, 1, 1, 1, 0.0, 1.0, 17, 2, (Insets)JBInsets.emptyInsets(), 0, 0));
        this.setExpanded(true);
    }

    public final boolean getExpanded() {
        return this.expanded;
    }

    public final void setExpanded(boolean expanded) {
        this.expanded = expanded;
        if (expanded) {
            this.titleLabel.setText(this.expandedLabel);
            this.iconLabel.setIcon(AllIcons.General.ArrowDown);
            this.privacyPolicyPane.setVisible(true);
        } else {
            this.titleLabel.setText(this.label);
            this.iconLabel.setIcon(AllIcons.General.ArrowRight);
            this.privacyPolicyPane.setVisible(false);
        }
    }

    @NotNull
    public final String getPrivacyPolicy() {
        String string = this.privacyPolicyPane.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    public final void setPrivacyPolicy(@Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.privacyPolicyPane.setText(text2);
    }

    private final void useInHeader(JComponent component2) {
        component2.setBorder((Border)JBUI.Borders.empty((int)6, (int)0));
        component2.setBackground(PrivacyNoticeComponent.Companion.backgroundColor());
        component2.setCursor(Cursor.getPredefinedCursor(12));
        component2.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ PrivacyNoticeComponent this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseReleased(MouseEvent e) {
                this.this$0.setExpanded(!this.this$0.getExpanded());
            }
        });
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0002J\r\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0002J\r\u0010\b\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/diagnostic/PrivacyNoticeComponent$Companion;", "", "<init>", "()V", "titleColor", "Ljava/awt/Color;", "Lorg/jetbrains/annotations/NotNull;", "noticeColor", "backgroundColor", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final Color titleColor() {
            Color color = UIUtil.getLabelForeground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getLabelForeground(...)");
            return color;
        }

        private final Color noticeColor() {
            Color color = UIUtil.getContextHelpForeground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getContextHelpForeground(...)");
            return color;
        }

        private final Color backgroundColor() {
            Color color = ColorUtil.hackBrightness((Color)JBUI.CurrentTheme.CustomFrameDecorations.paneBackground(), (int)1, (float)0.952381f);
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"hackBrightness(...)");
            return color;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

