/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.openapi.util.text.StringUtil;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class RecoveredThrowable
extends Throwable {
    private final String myFullMessage;
    private final String myStacktrace;

    private RecoveredThrowable(String fullMessage, String stacktrace) {
        this.myFullMessage = fullMessage;
        this.myStacktrace = stacktrace;
    }

    @Override
    public String getMessage() {
        return this.myFullMessage;
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        s.print(this.myStacktrace);
    }

    @Override
    public void printStackTrace(PrintStream s) {
        s.print(this.myStacktrace);
    }

    @NotNull
    public static Throwable fromString(@NotNull String stacktrace) {
        String line;
        if (stacktrace == null) {
            RecoveredThrowable.$$$reportNull$$$0(0);
        }
        if (stacktrace.isBlank()) {
            throw new IllegalArgumentException("stacktrace is empty");
        }
        String[] lines = StringUtil.splitByLines((String)stacktrace);
        RecoveredThrowable result2 = new RecoveredThrowable(lines[0], stacktrace);
        ArrayList<StackTraceElement> stack = new ArrayList<StackTraceElement>(lines.length - 1);
        for (int i2 = 1; i2 < lines.length && (line = lines[i2].trim()).startsWith("at "); ++i2) {
            stack.add(RecoveredThrowable.parseStackTraceLine(line.substring(3).trim()));
        }
        result2.setStackTrace(stack.toArray(new StackTraceElement[0]));
        RecoveredThrowable recoveredThrowable = result2;
        if (recoveredThrowable == null) {
            RecoveredThrowable.$$$reportNull$$$0(1);
        }
        return recoveredThrowable;
    }

    private static StackTraceElement parseStackTraceLine(String line) {
        int methodStart;
        int nameStart;
        String className = null;
        String methodName = null;
        String sourceFile = null;
        int lineNumber = 0;
        int sourceStart = line.lastIndexOf(40);
        if (sourceStart > 0) {
            int sourceEnd = line.endsWith(")") ? line.length() - 1 : line.length();
            String source = line.substring(sourceStart + 1, sourceEnd);
            if (source.equalsIgnoreCase("Native Method")) {
                lineNumber = -2;
            } else if (!source.equalsIgnoreCase("Unknown Source")) {
                int separator = source.lastIndexOf(58);
                if (separator < 0) {
                    sourceFile = source;
                } else {
                    sourceFile = source.substring(0, separator);
                    try {
                        lineNumber = Integer.parseInt(source.substring(separator + 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            line = line.substring(0, sourceStart);
        }
        if ((nameStart = line.lastIndexOf(47)) > 0) {
            line = line.substring(nameStart + 1);
        }
        if ((methodStart = line.lastIndexOf(46)) < 0) {
            className = line;
            methodName = "<empty>";
        } else {
            className = line.substring(0, methodStart);
            methodName = line.substring(methodStart + 1);
        }
        StackTraceElement element = new StackTraceElement(className, methodName, sourceFile, lineNumber);
        return element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stacktrace";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/RecoveredThrowable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/RecoveredThrowable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "fromString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

