/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.util.messages.Topic;
import java.awt.AWTEvent;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
@ApiStatus.Internal
public interface RunnablesListener {
    @Topic.AppLevel
    public static final Topic<RunnablesListener> TOPIC = new Topic(RunnablesListener.class, Topic.BroadcastDirection.TO_DIRECT_CHILDREN, true);
    public static final SimpleDateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    public static final DecimalFormat DEFAULT_DURATION_FORMAT = new DecimalFormat("0.00");

    default public void eventsProcessed(@NotNull Class<? extends AWTEvent> eventClass, @NotNull Collection<InvocationDescription> descriptions) {
        if (eventClass == null) {
            RunnablesListener.$$$reportNull$$$0(0);
        }
        if (descriptions == null) {
            RunnablesListener.$$$reportNull$$$0(1);
        }
    }

    default public void runnablesProcessed(@NotNull Collection<InvocationDescription> invocations, @NotNull Collection<InvocationInfo> infos, @NotNull Collection<WrapperDescription> wrappers) {
        if (invocations == null) {
            RunnablesListener.$$$reportNull$$$0(2);
        }
        if (infos == null) {
            RunnablesListener.$$$reportNull$$$0(3);
        }
        if (wrappers == null) {
            RunnablesListener.$$$reportNull$$$0(4);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invocations";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrappers";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diagnostic/RunnablesListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "eventsProcessed";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "runnablesProcessed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class WrapperDescription
    implements Comparable<WrapperDescription> {
        @NotNull
        private final String myFQN;
        private final int myUsagesCount;

        @NotNull
        static WrapperDescription computeNext(@NotNull String fqn, @Nullable WrapperDescription description) {
            if (fqn == null) {
                WrapperDescription.$$$reportNull$$$0(0);
            }
            return new WrapperDescription(fqn, description != null ? description.myUsagesCount : 0);
        }

        private WrapperDescription(@NotNull String fqn, int count) {
            if (fqn == null) {
                WrapperDescription.$$$reportNull$$$0(1);
            }
            this.myFQN = fqn;
            this.myUsagesCount = 1 + count;
        }

        @NotNull
        public String getFQN() {
            String string = this.myFQN;
            if (string == null) {
                WrapperDescription.$$$reportNull$$$0(2);
            }
            return string;
        }

        public int getUsagesCount() {
            return this.myUsagesCount;
        }

        @Override
        public int compareTo(@NotNull WrapperDescription description) {
            if (description == null) {
                WrapperDescription.$$$reportNull$$$0(3);
            }
            return Integer.compare(description.myUsagesCount, this.myUsagesCount);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WrapperDescription description = (WrapperDescription)o;
            return this.myUsagesCount == description.myUsagesCount && this.myFQN.equals(description.myFQN);
        }

        public int hashCode() {
            return Objects.hash(this.myFQN, this.myUsagesCount);
        }

        @NotNull
        public String toString() {
            String string = "WrapperDescription{FQN='" + this.myFQN + "', usagesCount=" + this.myUsagesCount + "}";
            if (string == null) {
                WrapperDescription.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqn";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diagnostic/RunnablesListener$WrapperDescription";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diagnostic/RunnablesListener$WrapperDescription";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFQN";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "computeNext";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4 -> new IllegalStateException(string);
            };
        }
    }

    public static final class InvocationInfo
    implements Comparable<InvocationInfo> {
        @NotNull
        private final String myFQN;
        private final int myCount;
        private final long myDuration;

        /*
         * WARNING - void declaration
         */
        @NotNull
        static InvocationInfo computeNext(@NotNull String fqn, long duration2, @Nullable InvocationInfo invocationInfo) {
            void info;
            if (fqn == null) {
                InvocationInfo.$$$reportNull$$$0(0);
            }
            return new InvocationInfo(fqn, info != null ? info.myCount : 0, (info != null ? info.myDuration : 0L) + duration2);
        }

        private InvocationInfo(@NotNull String fqn, int count, long duration2) {
            if (fqn == null) {
                InvocationInfo.$$$reportNull$$$0(1);
            }
            this.myFQN = fqn;
            this.myCount = 1 + count;
            this.myDuration = duration2;
        }

        @NotNull
        public String getFQN() {
            String string = this.myFQN;
            if (string == null) {
                InvocationInfo.$$$reportNull$$$0(2);
            }
            return string;
        }

        public int getCount() {
            return this.myCount;
        }

        public double getAverageDuration() {
            return (double)this.myDuration / (double)this.myCount;
        }

        @Override
        public int compareTo(@NotNull InvocationInfo info) {
            int result2;
            if (info == null) {
                InvocationInfo.$$$reportNull$$$0(3);
            }
            return (result2 = Integer.compare(info.myCount, this.myCount)) != 0 ? result2 : Double.compare(info.myDuration, this.myDuration);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InvocationInfo info = (InvocationInfo)o;
            return this.myCount == info.myCount && this.myDuration == info.myDuration && this.myFQN.equals(info.myFQN);
        }

        public int hashCode() {
            return Objects.hash(this.myFQN, this.myCount, this.myDuration);
        }

        @NotNull
        public String toString() {
            String string = "InvocationsInfo{FQN='" + this.myFQN + "', count=" + this.myCount + ", averageDuration=" + DEFAULT_DURATION_FORMAT.format(this.getAverageDuration()) + " ms}";
            if (string == null) {
                InvocationInfo.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqn";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diagnostic/RunnablesListener$InvocationInfo";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diagnostic/RunnablesListener$InvocationInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFQN";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "computeNext";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4 -> new IllegalStateException(string);
            };
        }
    }

    public static final class InvocationDescription
    implements Comparable<InvocationDescription> {
        @NotNull
        private final String myProcessId;
        private final long myStartedAt;
        private final long myFinishedAt;

        /*
         * WARNING - void declaration
         */
        InvocationDescription(@NotNull String processId, long startedAt, long l) {
            void finishedAt;
            if (processId == null) {
                InvocationDescription.$$$reportNull$$$0(0);
            }
            this.myProcessId = processId;
            this.myStartedAt = startedAt;
            this.myFinishedAt = finishedAt;
        }

        @NotNull
        public String getProcessId() {
            String string = this.myProcessId;
            if (string == null) {
                InvocationDescription.$$$reportNull$$$0(1);
            }
            return string;
        }

        public long getStartedAt() {
            return this.myStartedAt;
        }

        @NotNull
        public Date getStartDateTime() {
            return new Date(this.getStartedAt());
        }

        public long getFinishedAt() {
            return this.myFinishedAt;
        }

        public long getDuration() {
            return this.myFinishedAt - this.myStartedAt;
        }

        @Override
        public int compareTo(@NotNull InvocationDescription description) {
            int result2;
            if (description == null) {
                InvocationDescription.$$$reportNull$$$0(2);
            }
            return (result2 = Long.compare(this.myStartedAt, description.myStartedAt)) != 0 ? result2 : Long.compare(this.myFinishedAt, description.myFinishedAt);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InvocationDescription description = (InvocationDescription)o;
            return this.myStartedAt == description.myStartedAt && this.myFinishedAt == description.myFinishedAt && this.myProcessId.equals(description.myProcessId);
        }

        public int hashCode() {
            return Objects.hash(this.myProcessId, this.myStartedAt, this.myFinishedAt);
        }

        @NotNull
        public String toString() {
            String string = "InvocationDescription{processId='" + this.myProcessId + "', duration=" + DEFAULT_DURATION_FORMAT.format(this.getDuration()) + " ms}";
            if (string == null) {
                InvocationDescription.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processId";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diagnostic/RunnablesListener$InvocationDescription";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diagnostic/RunnablesListener$InvocationDescription";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProcessId";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3 -> new IllegalStateException(string);
            };
        }
    }
}

