/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.opentelemetry;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.LowMemoryWatcherManager;
import com.intellij.platform.diagnostic.telemetry.PlatformScopesKt;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import io.opentelemetry.api.metrics.DoubleGauge;
import io.opentelemetry.api.metrics.LongGauge;
import io.opentelemetry.api.metrics.Meter;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\n"}, d2={"Lcom/intellij/diagnostic/opentelemetry/LowMemoryToOTelReporter;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ReportingService", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nLowMemoryToOTelReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LowMemoryToOTelReporter.kt\ncom/intellij/diagnostic/opentelemetry/LowMemoryToOTelReporter\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,48:1\n70#2,6:49\n*S KotlinDebug\n*F\n+ 1 LowMemoryToOTelReporter.kt\ncom/intellij/diagnostic/opentelemetry/LowMemoryToOTelReporter\n*L\n25#1:49,6\n*E\n"})
public final class LowMemoryToOTelReporter
implements ProjectActivity {
    @Nullable
    public Object execute(@NotNull Project project2, @NotNull Continuation<? super Unit> $completion) {
        boolean $i$f$serviceAsync = false;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        ComponentManager $this$serviceAsync$iv$iv = (ComponentManager)application;
        boolean $i$f$serviceAsync2 = false;
        Object object = ((ComponentManagerEx)$this$serviceAsync$iv$iv).getServiceAsync(ReportingService.class, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Service(value={Service.Level.APP})
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/diagnostic/opentelemetry/LowMemoryToOTelReporter$ReportingService;", "Lcom/intellij/openapi/util/LowMemoryWatcherManager$Listener;", "<init>", "()V", "gcLoadGauge", "Lio/opentelemetry/api/metrics/DoubleGauge;", "gcOverloaded", "Lio/opentelemetry/api/metrics/LongGauge;", "memoryStatus", "", "event", "Lcom/intellij/openapi/util/LowMemoryWatcherManager$LowMemoryEvent;", "intellij.platform.ide.impl"})
    private static final class ReportingService
    implements LowMemoryWatcherManager.Listener {
        @NotNull
        private final DoubleGauge gcLoadGauge;
        @NotNull
        private final LongGauge gcOverloaded;

        public ReportingService() {
            Meter otelMeter = TelemetryManager.Companion.getMeter(PlatformScopesKt.PlatformMetrics);
            DoubleGauge doubleGauge = otelMeter.gaugeBuilder("LowMemory.gcLoad").build();
            Intrinsics.checkNotNullExpressionValue((Object)doubleGauge, (String)"build(...)");
            this.gcLoadGauge = doubleGauge;
            LongGauge longGauge = otelMeter.gaugeBuilder("LowMemory.gcOverloaded").ofLongs().build();
            Intrinsics.checkNotNullExpressionValue((Object)longGauge, (String)"build(...)");
            this.gcOverloaded = longGauge;
            ScheduledExecutorService scheduledExecutorService = AppExecutorUtil.getAppScheduledExecutorService();
            Intrinsics.checkNotNull((Object)scheduledExecutorService, (String)"null cannot be cast to non-null type com.intellij.util.concurrency.AppScheduledExecutorService");
            ((AppScheduledExecutorService)scheduledExecutorService).getLowMemoryWatcherManager().addListener((LowMemoryWatcherManager.Listener)this);
        }

        public void memoryStatus(@NotNull LowMemoryWatcherManager.LowMemoryEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.gcLoadGauge.set(event.gcLoadScore);
            this.gcOverloaded.set(event.gcOverloaded ? 1L : 0L);
        }
    }
}

