/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ijent.nio;

import com.intellij.execution.ijent.nio.IjentEphemeralRootAwareFileSystemProvider;
import com.intellij.execution.ijent.nio.IjentEphemeralRootAwarePath;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.core.nio.fs.DelegatingFileSystem;
import com.intellij.platform.ijent.community.impl.nio.IjentNioPath;
import com.intellij.util.text.StringKt;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0004\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000f\u001a\u00020\u0005H\u0014J\u0010\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J)\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u000e2\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0017\"\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u0002H\u0016J\u0012\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0011H\u0016J\b\u0010#\u001a\u00020\bH\u0016J\b\u0010$\u001a\u00020\bH\u0016J\b\u0010%\u001a\u00020\u000eH\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000e0'H\u0016J\u0010\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020\u000eH\u0002J\u0010\u0010*\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/execution/ijent/nio/IjentEphemeralRootAwareFileSystem;", "Lcom/intellij/platform/core/nio/fs/DelegatingFileSystem;", "Lcom/intellij/execution/ijent/nio/IjentEphemeralRootAwareFileSystemProvider;", "rootAwareFileSystemProvider", "ijentFs", "Ljava/nio/file/FileSystem;", "originalFs", "useRootDirectoriesFromOriginalFs", "", "<init>", "(Lcom/intellij/execution/ijent/nio/IjentEphemeralRootAwareFileSystemProvider;Ljava/nio/file/FileSystem;Ljava/nio/file/FileSystem;Z)V", "root", "Ljava/nio/file/Path;", "invariantSeparatorRootPathString", "", "getDelegate", "getRootDirectories", "", "close", "", "getPath", "first", "more", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/nio/file/Path;", "provider", "getPathMatcher", "Ljava/nio/file/PathMatcher;", "syntaxAndPattern", "getUserPrincipalLookupService", "Ljava/nio/file/attribute/UserPrincipalLookupService;", "newWatchService", "Ljava/nio/file/WatchService;", "getFileStores", "Ljava/nio/file/FileStore;", "isOpen", "isReadOnly", "getSeparator", "supportedFileAttributeViews", "", "isPathUnderRoot", "path", "relativizeToRoot", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nIjentEphemeralRootAwareFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IjentEphemeralRootAwareFileSystem.kt\ncom/intellij/execution/ijent/nio/IjentEphemeralRootAwareFileSystem\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,370:1\n10468#2:371\n10890#2,5:372\n774#3:377\n865#3,2:378\n1563#3:382\n1634#3,3:383\n37#4,2:380\n37#4,2:386\n*S KotlinDebug\n*F\n+ 1 IjentEphemeralRootAwareFileSystem.kt\ncom/intellij/execution/ijent/nio/IjentEphemeralRootAwareFileSystem\n*L\n328#1:371\n328#1:372,5\n328#1:377\n328#1:378,2\n335#1:382\n335#1:383,3\n328#1:380,2\n335#1:386,2\n*E\n"})
public final class IjentEphemeralRootAwareFileSystem
extends DelegatingFileSystem<IjentEphemeralRootAwareFileSystemProvider> {
    @NotNull
    private final IjentEphemeralRootAwareFileSystemProvider rootAwareFileSystemProvider;
    @NotNull
    private final FileSystem ijentFs;
    @NotNull
    private final FileSystem originalFs;
    private final boolean useRootDirectoriesFromOriginalFs;
    @NotNull
    private final Path root;
    @NotNull
    private final String invariantSeparatorRootPathString;

    public IjentEphemeralRootAwareFileSystem(@NotNull IjentEphemeralRootAwareFileSystemProvider rootAwareFileSystemProvider, @NotNull FileSystem ijentFs, @NotNull FileSystem originalFs, boolean useRootDirectoriesFromOriginalFs) {
        Intrinsics.checkNotNullParameter((Object)((Object)rootAwareFileSystemProvider), (String)"rootAwareFileSystemProvider");
        Intrinsics.checkNotNullParameter((Object)ijentFs, (String)"ijentFs");
        Intrinsics.checkNotNullParameter((Object)originalFs, (String)"originalFs");
        this.rootAwareFileSystemProvider = rootAwareFileSystemProvider;
        this.ijentFs = ijentFs;
        this.originalFs = originalFs;
        this.useRootDirectoriesFromOriginalFs = useRootDirectoriesFromOriginalFs;
        this.root = this.rootAwareFileSystemProvider.getRoot();
        this.invariantSeparatorRootPathString = StringsKt.removeSuffix((String)PathsKt.getInvariantSeparatorsPathString((Path)this.root), (CharSequence)"/");
    }

    @NotNull
    protected FileSystem getDelegate() {
        return this.ijentFs;
    }

    @NotNull
    public Iterable<Path> getRootDirectories() {
        Iterable iterable;
        if (this.useRootDirectoriesFromOriginalFs) {
            Iterable iterable2 = this.originalFs.getRootDirectories();
            iterable = iterable2;
            Intrinsics.checkNotNullExpressionValue(iterable2, (String)"getRootDirectories(...)");
        } else {
            Path path = Paths.get(((Object)this.root).toString(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            iterable = CollectionsKt.listOf((Object)path);
        }
        return iterable;
    }

    public void close() {
        this.ijentFs.close();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Path getPath(@NotNull String first, String ... more) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)more, (String)"more");
        if (this.isPathUnderRoot(first)) {
            void $this$toTypedArray$iv2;
            void $this$filterTo$iv$iv;
            Collection $this$filter$iv;
            void $this$flatMapTo$iv$iv;
            Object $this$flatMap$iv = more;
            boolean $i$f$flatMap = false;
            String[] stringArray = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            int n = ((void)$this$flatMapTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void element$iv$iv;
                void it = element$iv$iv = $this$flatMapTo$iv$iv[j];
                boolean bl = false;
                CharSequence charSequence = (CharSequence)it;
                String[] stringArray2 = new String[1];
                Intrinsics.checkNotNullExpressionValue((Object)this.root.getFileSystem().getSeparator(), (String)"getSeparator(...)");
                Iterable list$iv$iv = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String p0 = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = ((CharSequence)p0).length() > 0;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv2;
            String[] parts = thisCollection$iv.toArray(new String[0]);
            Path path = this.ijentFs.getPath(this.relativizeToRoot(first), Arrays.copyOf(parts, parts.length));
            Intrinsics.checkNotNull((Object)path, (String)"null cannot be cast to non-null type com.intellij.platform.ijent.community.impl.nio.IjentNioPath");
            IjentNioPath ijentNioPath = (IjentNioPath)path;
            return new IjentEphemeralRootAwarePath(this, this.root, ijentNioPath);
        }
        FileSystem fileSystem = this.getDelegate(first);
        Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"getDelegate(...)");
        FileSystem delegateFs = fileSystem;
        String string = this.originalFs.getSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSeparator(...)");
        String string2 = delegateFs.getSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSeparator(...)");
        String first2 = StringsKt.replace$default((String)first, (String)string, (String)string2, (boolean)false, (int)4, null);
        Iterable $this$map$iv = ArraysKt.toList((Object[])more);
        boolean $i$f$map = false;
        Iterable $i$f$filterTo = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String bl = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            String string3 = this.originalFs.getSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getSeparator(...)");
            String string4 = delegateFs.getSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getSeparator(...)");
            collection.add(StringsKt.replace$default((String)it, (String)string3, (String)string4, (boolean)false, (int)4, null));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] more2 = thisCollection$iv.toArray(new String[0]);
        Path path = super.getPath(first2, Arrays.copyOf(more2, more2.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        return path;
    }

    @NotNull
    public IjentEphemeralRootAwareFileSystemProvider provider() {
        return this.rootAwareFileSystemProvider;
    }

    @NotNull
    public PathMatcher getPathMatcher(@Nullable String syntaxAndPattern) {
        PathMatcher pathMatcher = this.originalFs.getPathMatcher(syntaxAndPattern);
        Intrinsics.checkNotNullExpressionValue((Object)pathMatcher, (String)"getPathMatcher(...)");
        return pathMatcher;
    }

    @NotNull
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        UserPrincipalLookupService userPrincipalLookupService = this.originalFs.getUserPrincipalLookupService();
        Intrinsics.checkNotNullExpressionValue((Object)userPrincipalLookupService, (String)"getUserPrincipalLookupService(...)");
        return userPrincipalLookupService;
    }

    @NotNull
    public WatchService newWatchService() {
        WatchService watchService = this.originalFs.newWatchService();
        Intrinsics.checkNotNullExpressionValue((Object)watchService, (String)"newWatchService(...)");
        return watchService;
    }

    @NotNull
    public Iterable<FileStore> getFileStores() {
        Iterable<FileStore> iterable = this.originalFs.getFileStores();
        Intrinsics.checkNotNullExpressionValue(iterable, (String)"getFileStores(...)");
        Iterable<FileStore> iterable2 = this.ijentFs.getFileStores();
        Intrinsics.checkNotNullExpressionValue(iterable2, (String)"getFileStores(...)");
        return CollectionsKt.plus(iterable, iterable2);
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    @NotNull
    public String getSeparator() {
        String string = this.originalFs.getSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSeparator(...)");
        return string;
    }

    @NotNull
    public Set<String> supportedFileAttributeViews() {
        Set set;
        Set $this$supportedFileAttributeViews_u24lambda_u240 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        Set<String> set2 = this.originalFs.supportedFileAttributeViews();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"supportedFileAttributeViews(...)");
        $this$supportedFileAttributeViews_u24lambda_u240.addAll((Collection)set2);
        Set<String> set3 = this.ijentFs.supportedFileAttributeViews();
        Intrinsics.checkNotNullExpressionValue(set3, (String)"supportedFileAttributeViews(...)");
        $this$supportedFileAttributeViews_u24lambda_u240.addAll((Collection)set3);
        return SetsKt.build((Set)set);
    }

    private final boolean isPathUnderRoot(String path) {
        String string = FileUtil.toSystemIndependentName((String)path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        return StringsKt.startsWith$default((String)string, (String)this.invariantSeparatorRootPathString, (boolean)false, (int)2, null);
    }

    private final String relativizeToRoot(String path) {
        String string = FileUtil.toSystemIndependentName((String)path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        String string2 = StringKt.nullize$default((String)StringsKt.removePrefix((String)string, (CharSequence)this.invariantSeparatorRootPathString), (boolean)false, (int)1, null);
        if (string2 == null) {
            string2 = "/";
        }
        return string2;
    }
}

