/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ijent.nio;

import com.intellij.execution.ijent.nio.IjentEphemeralRootAwareFileSystem;
import com.intellij.execution.ijent.nio.IjentEphemeralRootAwareFileSystemKt;
import com.intellij.execution.ijent.nio.IjentEphemeralRootAwarePath;
import com.intellij.execution.ijent.nio.IjentNioPosixFileAttributesWithDosAdapterKt;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.platform.core.nio.fs.DelegatingFileSystemProvider;
import com.intellij.platform.core.nio.fs.RoutingAwareFileSystemProvider;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.utils.EelPathUtils;
import com.intellij.platform.ijent.community.impl.nio.IjentNioPath;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016JA\u0010\u0016\u001a\u0002H\u0017\"\b\b\u0000\u0010\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00052\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001b2\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u001d\"\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fJ5\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u00052\u0016\u0010\u001c\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010$0\u001d\"\u0004\u0018\u00010$H\u0016\u00a2\u0006\u0002\u0010%J5\u0010&\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u00052\u0016\u0010\u001c\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010$0\u001d\"\u0004\u0018\u00010$H\u0016\u00a2\u0006\u0002\u0010%J\u001c\u0010'\u001a\u00020\u00072\b\u0010(\u001a\u0004\u0018\u00010\u00052\b\u0010)\u001a\u0004\u0018\u00010\u0005H\u0014J\u0014\u0010*\u001a\u0004\u0018\u00010\u00052\b\u0010+\u001a\u0004\u0018\u00010\u0005H\u0014J\u0018\u0010,\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0005H\u0016J\u0014\u0010-\u001a\u0004\u0018\u00010\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u0014J\u0010\u0010.\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/execution/ijent/nio/IjentEphemeralRootAwareFileSystemProvider;", "Lcom/intellij/platform/core/nio/fs/DelegatingFileSystemProvider;", "Lcom/intellij/execution/ijent/nio/IjentEphemeralRootAwareFileSystem;", "Lcom/intellij/platform/core/nio/fs/RoutingAwareFileSystemProvider;", "root", "Ljava/nio/file/Path;", "ijentFsProvider", "Ljava/nio/file/spi/FileSystemProvider;", "originalFsProvider", "useRootDirectoriesFromOriginalFs", "", "<init>", "(Ljava/nio/file/Path;Ljava/nio/file/spi/FileSystemProvider;Ljava/nio/file/spi/FileSystemProvider;Z)V", "getRoot", "()Ljava/nio/file/Path;", "originalFs", "Ljava/nio/file/FileSystem;", "kotlin.jvm.PlatformType", "wrapDelegateFileSystem", "delegateFs", "getScheme", "", "readAttributes", "A", "Ljava/nio/file/attribute/BasicFileAttributes;", "path", "type", "Ljava/lang/Class;", "options", "", "Ljava/nio/file/LinkOption;", "(Ljava/nio/file/Path;Ljava/lang/Class;[Ljava/nio/file/LinkOption;)Ljava/nio/file/attribute/BasicFileAttributes;", "copy", "", "source", "target", "Ljava/nio/file/CopyOption;", "(Ljava/nio/file/Path;Ljava/nio/file/Path;[Ljava/nio/file/CopyOption;)V", "move", "getDelegate", "path1", "path2", "wrapDelegatePath", "delegatePath", "isSameFile", "toDelegatePath", "canHandleRouting", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class IjentEphemeralRootAwareFileSystemProvider
extends DelegatingFileSystemProvider<IjentEphemeralRootAwareFileSystemProvider, IjentEphemeralRootAwareFileSystem>
implements RoutingAwareFileSystemProvider {
    @NotNull
    private final Path root;
    @NotNull
    private final FileSystemProvider ijentFsProvider;
    @NotNull
    private final FileSystemProvider originalFsProvider;
    private final boolean useRootDirectoriesFromOriginalFs;
    private final FileSystem originalFs;

    public IjentEphemeralRootAwareFileSystemProvider(@NotNull Path root, @NotNull FileSystemProvider ijentFsProvider, @NotNull FileSystemProvider originalFsProvider, boolean useRootDirectoriesFromOriginalFs) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)ijentFsProvider, (String)"ijentFsProvider");
        Intrinsics.checkNotNullParameter((Object)originalFsProvider, (String)"originalFsProvider");
        this.root = root;
        this.ijentFsProvider = ijentFsProvider;
        this.originalFsProvider = originalFsProvider;
        this.useRootDirectoriesFromOriginalFs = useRootDirectoriesFromOriginalFs;
        this.originalFs = this.originalFsProvider.getFileSystem(new URI("file:/"));
    }

    @NotNull
    public final Path getRoot() {
        return this.root;
    }

    @NotNull
    public IjentEphemeralRootAwareFileSystem wrapDelegateFileSystem(@NotNull FileSystem delegateFs) {
        Intrinsics.checkNotNullParameter((Object)delegateFs, (String)"delegateFs");
        FileSystem fileSystem = this.originalFs;
        Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"originalFs");
        return new IjentEphemeralRootAwareFileSystem(this, delegateFs, fileSystem, this.useRootDirectoriesFromOriginalFs);
    }

    @Nullable
    public String getScheme() {
        return this.originalFsProvider.getScheme();
    }

    @NotNull
    public <A extends BasicFileAttributes> A readAttributes(@NotNull Path path, @NotNull Class<A> type, LinkOption ... options2) {
        BasicFileAttributes basicFileAttributes;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        if (SystemInfo.isWindows) {
            basicFileAttributes = IjentNioPosixFileAttributesWithDosAdapterKt.readAttributesUsingDosAttributesAdapter(this.ijentFsProvider, path, IjentEphemeralRootAwareFileSystemKt.access$toIjentPath(path), type, Arrays.copyOf(options2, options2.length));
        } else {
            BasicFileAttributes basicFileAttributes2 = super.readAttributes(path, type, Arrays.copyOf(options2, options2.length));
            basicFileAttributes = basicFileAttributes2;
            Intrinsics.checkNotNullExpressionValue((Object)basicFileAttributes2, (String)"readAttributes(...)");
        }
        return (A)basicFileAttributes;
    }

    public void copy(@NotNull Path source, @NotNull Path target, CopyOption ... options2) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        if (Intrinsics.areEqual((Object)EelProviderUtil.getEelDescriptor((Path)source), (Object)EelProviderUtil.getEelDescriptor((Path)target))) {
            super.copy(source, target, Arrays.copyOf(options2, options2.length));
        } else {
            EelPathUtils.INSTANCE.walkingTransfer(IjentEphemeralRootAwareFileSystemKt.access$toOriginalPath(source), IjentEphemeralRootAwareFileSystemKt.access$toOriginalPath(target), false, ArraysKt.contains((Object[])options2, (Object)StandardCopyOption.COPY_ATTRIBUTES));
        }
    }

    public void move(@NotNull Path source, @NotNull Path target, CopyOption ... options2) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        if (Intrinsics.areEqual((Object)EelProviderUtil.getEelDescriptor((Path)source), (Object)EelProviderUtil.getEelDescriptor((Path)target))) {
            super.move(source, target, Arrays.copyOf(options2, options2.length));
        } else {
            EelPathUtils.INSTANCE.walkingTransfer(IjentEphemeralRootAwareFileSystemKt.access$toOriginalPath(source), IjentEphemeralRootAwareFileSystemKt.access$toOriginalPath(target), true, ArraysKt.contains((Object[])options2, (Object)StandardCopyOption.COPY_ATTRIBUTES));
        }
    }

    @NotNull
    protected FileSystemProvider getDelegate(@Nullable Path path1, @Nullable Path path2) {
        return this.ijentFsProvider;
    }

    @Nullable
    protected Path wrapDelegatePath(@Nullable Path delegatePath) {
        if (delegatePath == null) {
            return null;
        }
        if (delegatePath instanceof IjentNioPath) {
            return new IjentEphemeralRootAwarePath(this.wrapDelegateFileSystem((FileSystem)((IjentNioPath)delegatePath).getFileSystem()), this.root, (IjentNioPath)delegatePath);
        }
        return delegatePath;
    }

    public boolean isSameFile(@NotNull Path path, @NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path2");
        if (!(path instanceof IjentEphemeralRootAwarePath)) {
            if (!(path2 instanceof IjentEphemeralRootAwarePath)) {
                throw new ProviderMismatchException("Neither " + path + " (" + Reflection.getOrCreateKotlinClass(path.getClass()) + ") nor " + path2 + " (" + Reflection.getOrCreateKotlinClass(path2.getClass()) + ") are " + IjentEphemeralRootAwarePath.class.getName());
            }
            return this.isSameFile(path2, path);
        }
        if (!(path2 instanceof IjentEphemeralRootAwarePath)) {
            return Intrinsics.areEqual((Object)((IjentEphemeralRootAwarePath)path).getActualPath().getFileSystem().provider(), (Object)path2.getFileSystem().provider()) ? Files.isSameFile(((IjentEphemeralRootAwarePath)path).getActualPath(), path2) : false;
        }
        if (Intrinsics.areEqual((Object)((IjentEphemeralRootAwarePath)path).getActualPath(), (Object)((IjentEphemeralRootAwarePath)path).getOriginalPath()) && Intrinsics.areEqual((Object)((IjentEphemeralRootAwarePath)path2).getActualPath(), (Object)((IjentEphemeralRootAwarePath)path2).getOriginalPath())) {
            return Files.isSameFile((Path)IjentEphemeralRootAwareFileSystemKt.access$toIjentPath(path), (Path)IjentEphemeralRootAwareFileSystemKt.access$toIjentPath(path2));
        }
        if (Intrinsics.areEqual((Object)((IjentEphemeralRootAwarePath)path).getActualPath().getFileSystem().provider(), (Object)((IjentEphemeralRootAwarePath)path2).getActualPath().getFileSystem().provider())) {
            return Files.isSameFile(((IjentEphemeralRootAwarePath)path).getActualPath(), ((IjentEphemeralRootAwarePath)path2).getActualPath());
        }
        return false;
    }

    @Nullable
    protected Path toDelegatePath(@Nullable Path path) {
        if (path instanceof IjentEphemeralRootAwarePath) {
            if (!(this.root == ((IjentEphemeralRootAwarePath)path).getRootPath())) {
                throw new IllegalStateException("Check failed.");
            }
            return (Path)((IjentEphemeralRootAwarePath)path).getOriginalPath();
        }
        return path;
    }

    public boolean canHandleRouting(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return true;
    }
}

