/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.execution.filters.CompositeInputFilter;
import com.intellij.execution.filters.ConsoleDependentFilterProvider;
import com.intellij.execution.filters.ConsoleDependentInputFilterProvider;
import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.ConsoleFilterProviderEx;
import com.intellij.execution.filters.ConsoleInputFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.InputFilter;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.UISettingsUtils;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.StringTokenizer;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConsoleViewUtil {
    public static final Key<Boolean> EDITOR_IS_CONSOLE_HISTORY_VIEW = Key.create((String)"EDITOR_IS_CONSOLE_HISTORY_VIEW");
    private static final Key<Boolean> REPLACE_ACTION_ENABLED = Key.create((String)"REPLACE_ACTION_ENABLED");
    private static final Logger LOG = Logger.getInstance(ConsoleViewUtil.class);

    @NotNull
    public static EditorEx setupConsoleEditor(@Nullable Project project2, boolean foldingOutlineShown, boolean lineMarkerAreaShown) {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document document2 = ((EditorFactoryImpl)editorFactory).createDocument(true);
        UndoUtil.disableUndoFor((Document)document2);
        EditorEx editor2 = (EditorEx)editorFactory.createViewer(document2, project2, EditorKind.CONSOLE);
        ConsoleViewUtil.setupConsoleEditor(editor2, foldingOutlineShown, lineMarkerAreaShown);
        EditorEx editorEx = editor2;
        if (editorEx == null) {
            ConsoleViewUtil.$$$reportNull$$$0(0);
        }
        return editorEx;
    }

    public static void setupConsoleEditor(@NotNull EditorEx editor2, boolean foldingOutlineShown, boolean lineMarkerAreaShown) {
        if (editor2 == null) {
            ConsoleViewUtil.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().runWriteIntentReadAction(() -> {
            EditorSettings editorSettings = editor2.getSettings();
            editorSettings.setLineMarkerAreaShown(lineMarkerAreaShown);
            editorSettings.setIndentGuidesShown(false);
            editorSettings.setLineNumbersShown(false);
            editorSettings.setFoldingOutlineShown(foldingOutlineShown);
            editorSettings.setAdditionalPageAtBottom(false);
            editorSettings.setAdditionalColumnsCount(0);
            editorSettings.setAdditionalLinesCount(0);
            editorSettings.setRightMarginShown(false);
            editorSettings.setCaretRowShown(false);
            editorSettings.setShowingSpecialChars(false);
            editor2.getGutterComponentEx().setPaintBackground(false);
            EditorColorsScheme scheme = ConsoleViewUtil.updateConsoleColorScheme(editor2.getColorsScheme(), editor2);
            scheme.setEditorFontSize(UISettingsUtils.getInstance().getScaledConsoleFontSize());
            editor2.setColorsScheme(scheme);
            editor2.setHighlighter((EditorHighlighter)new NullEditorHighlighter());
            return null;
        });
    }

    public static void setupLanguageConsoleEditor(@NotNull EditorEx editor2) {
        if (editor2 == null) {
            ConsoleViewUtil.$$$reportNull$$$0(2);
        }
        ConsoleViewUtil.setupConsoleEditor(editor2, false, false);
        editor2.getContentComponent().setFocusCycleRoot(false);
        editor2.setBorder(null);
        EditorSettings editorSettings = editor2.getSettings();
        editorSettings.setAdditionalLinesCount(1);
        editorSettings.setAdditionalColumnsCount(1);
    }

    @NotNull
    public static EditorColorsScheme updateConsoleColorScheme(@NotNull EditorColorsScheme scheme, EditorEx editor2) {
        if (scheme == null) {
            ConsoleViewUtil.$$$reportNull$$$0(3);
        }
        EditorColorsScheme editorColorsScheme = editor2.createBoundColorSchemeDelegate(ConsoleViewUtil.updateConsoleColorScheme(scheme));
        if (editorColorsScheme == null) {
            ConsoleViewUtil.$$$reportNull$$$0(4);
        }
        return editorColorsScheme;
    }

    @NotNull
    public static DelegateColorScheme updateConsoleColorScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            ConsoleViewUtil.$$$reportNull$$$0(5);
        }
        return new DelegateColorScheme(scheme){

            @Override
            @NotNull
            public Color getDefaultBackground() {
                Color color = this.getColor(ConsoleViewContentType.CONSOLE_BACKGROUND_KEY);
                Color color2 = color == null ? super.getDefaultBackground() : color;
                if (color2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return color2;
            }

            @Override
            @NotNull
            public FontPreferences getFontPreferences() {
                FontPreferences fontPreferences = this.getConsoleFontPreferences();
                if (fontPreferences == null) {
                    1.$$$reportNull$$$0(1);
                }
                return fontPreferences;
            }

            @Override
            public int getEditorFontSize() {
                return this.getConsoleFontSize();
            }

            @Override
            public float getEditorFontSize2D() {
                return this.getConsoleFontSize2D();
            }

            @Override
            public String getEditorFontName() {
                return this.getConsoleFontName();
            }

            @Override
            public float getLineSpacing() {
                return this.getConsoleLineSpacing();
            }

            @Override
            @NotNull
            public Font getFont(EditorFontType key) {
                Font font = super.getFont(EditorFontType.getConsoleType((EditorFontType)key));
                if (font == null) {
                    1.$$$reportNull$$$0(2);
                }
                return font;
            }

            @Override
            public void setEditorFontSize(int fontSize) {
                this.setConsoleFontSize(fontSize);
            }

            @Override
            public void setEditorFontSize(float fontSize) {
                this.setConsoleFontSize(fontSize);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/execution/impl/ConsoleViewUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDefaultBackground";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFontPreferences";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFont";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    public static boolean isConsoleViewEditor(@NotNull Editor editor2) {
        if (editor2 == null) {
            ConsoleViewUtil.$$$reportNull$$$0(6);
        }
        return editor2.getEditorKind() == EditorKind.CONSOLE;
    }

    public static boolean isReplaceActionEnabledForConsoleViewEditor(@NotNull Editor editor2) {
        if (editor2 == null) {
            ConsoleViewUtil.$$$reportNull$$$0(7);
        }
        return editor2.getUserData(REPLACE_ACTION_ENABLED) == Boolean.TRUE;
    }

    public static void enableReplaceActionForConsoleViewEditor(@NotNull Editor editor2) {
        if (editor2 == null) {
            ConsoleViewUtil.$$$reportNull$$$0(8);
        }
        editor2.putUserData(REPLACE_ACTION_ENABLED, (Object)true);
    }

    public static void printWithHighlighting(@NotNull ConsoleView console, @NotNull String text2, @NotNull SyntaxHighlighter highlighter) {
        if (console == null) {
            ConsoleViewUtil.$$$reportNull$$$0(9);
        }
        if (text2 == null) {
            ConsoleViewUtil.$$$reportNull$$$0(10);
        }
        if (highlighter == null) {
            ConsoleViewUtil.$$$reportNull$$$0(11);
        }
        ConsoleViewUtil.printWithHighlighting(console, text2, highlighter, null);
    }

    public static void printWithHighlighting(@NotNull ConsoleView console, @NotNull String text2, @NotNull SyntaxHighlighter highlighter, Runnable doOnNewLine) {
        if (console == null) {
            ConsoleViewUtil.$$$reportNull$$$0(12);
        }
        if (text2 == null) {
            ConsoleViewUtil.$$$reportNull$$$0(13);
        }
        if (highlighter == null) {
            ConsoleViewUtil.$$$reportNull$$$0(14);
        }
        ConsoleViewUtil.printWithHighlighting((? super String token, ? super ConsoleViewContentType contentType) -> console.print(token, contentType), text2, highlighter, doOnNewLine);
    }

    public static void printWithHighlighting(@NotNull BiConsumer<? super String, ? super ConsoleViewContentType> tokenSink, @NotNull String text2, @NotNull SyntaxHighlighter highlighter, Runnable doOnNewLine) {
        IElementType tokenType;
        if (tokenSink == null) {
            ConsoleViewUtil.$$$reportNull$$$0(15);
        }
        if (text2 == null) {
            ConsoleViewUtil.$$$reportNull$$$0(16);
        }
        if (highlighter == null) {
            ConsoleViewUtil.$$$reportNull$$$0(17);
        }
        Lexer lexer = highlighter.getHighlightingLexer();
        lexer.start((CharSequence)text2, 0, text2.length(), 0);
        while ((tokenType = lexer.getTokenType()) != null) {
            ConsoleViewContentType contentType = ConsoleViewUtil.getContentTypeForToken(tokenType, highlighter);
            StringTokenizer eolTokenizer = new StringTokenizer(lexer.getTokenText(), "\n", true);
            while (eolTokenizer.hasMoreTokens()) {
                String tok = eolTokenizer.nextToken();
                tokenSink.accept(tok, (ConsoleViewContentType)contentType);
                if (doOnNewLine == null || !"\n".equals(tok)) continue;
                doOnNewLine.run();
            }
            lexer.advance();
        }
    }

    @NotNull
    public static ConsoleViewContentType getContentTypeForToken(@NotNull IElementType tokenType, @NotNull SyntaxHighlighter highlighter) {
        TextAttributesKey[] keys;
        if (tokenType == null) {
            ConsoleViewUtil.$$$reportNull$$$0(18);
        }
        if (highlighter == null) {
            ConsoleViewUtil.$$$reportNull$$$0(19);
        }
        if ((keys = highlighter.getTokenHighlights(tokenType)).length == 0) {
            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
            if (consoleViewContentType == null) {
                ConsoleViewUtil.$$$reportNull$$$0(20);
            }
            return consoleViewContentType;
        }
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.getConsoleViewType(ColorCache.getInstance().getKey(List.of(keys)));
        if (consoleViewContentType == null) {
            ConsoleViewUtil.$$$reportNull$$$0(21);
        }
        return consoleViewContentType;
    }

    public static void printAsFileType(@NotNull ConsoleView console, @NotNull String text2, @NotNull FileType fileType2) {
        SyntaxHighlighter highlighter;
        if (console == null) {
            ConsoleViewUtil.$$$reportNull$$$0(22);
        }
        if (text2 == null) {
            ConsoleViewUtil.$$$reportNull$$$0(23);
        }
        if (fileType2 == null) {
            ConsoleViewUtil.$$$reportNull$$$0(24);
        }
        if ((highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)fileType2, null, null)) != null) {
            ConsoleViewUtil.printWithHighlighting(console, text2, highlighter);
        } else {
            console.print(text2, ConsoleViewContentType.NORMAL_OUTPUT);
        }
    }

    public static Filter[] computeConsoleFilters(@NotNull ConsoleFilterProvider provider, @NotNull Project project2, @Nullable ConsoleView consoleView, @NotNull GlobalSearchScope searchScope) {
        if (provider == null) {
            ConsoleViewUtil.$$$reportNull$$$0(25);
        }
        if (project2 == null) {
            ConsoleViewUtil.$$$reportNull$$$0(26);
        }
        if (searchScope == null) {
            ConsoleViewUtil.$$$reportNull$$$0(27);
        }
        if (consoleView != null && provider instanceof ConsoleDependentFilterProvider) {
            return ((ConsoleDependentFilterProvider)provider).getDefaultFilters(consoleView, project2, searchScope);
        }
        if (provider instanceof ConsoleFilterProviderEx) {
            return ((ConsoleFilterProviderEx)provider).getDefaultFilters(project2, searchScope);
        }
        return provider.getDefaultFilters(project2);
    }

    @NotNull
    public static List<Filter> computeConsoleFilters(@NotNull Project project2, @Nullable ConsoleView consoleView, @NotNull GlobalSearchScope searchScope) {
        if (project2 == null) {
            ConsoleViewUtil.$$$reportNull$$$0(28);
        }
        if (searchScope == null) {
            ConsoleViewUtil.$$$reportNull$$$0(29);
        }
        ArrayList<Filter> result2 = new ArrayList<Filter>();
        for (ConsoleFilterProvider eachProvider : (ConsoleFilterProvider[])ConsoleFilterProvider.FILTER_PROVIDERS.getExtensions()) {
            try {
                Collections.addAll(result2, ConsoleViewUtil.computeConsoleFilters(eachProvider, project2, consoleView, searchScope));
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)PluginException.createByClass((String)("An exception occurred when trying to get console filters, this provider will be unavailable: " + String.valueOf(eachProvider)), (Throwable)e, (Class)eachProvider.getClass()));
            }
        }
        ArrayList<Filter> arrayList = result2;
        if (arrayList == null) {
            ConsoleViewUtil.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    @NotNull
    public static InputFilter computeInputFilter(@NotNull ConsoleView consoleView, @NotNull Project project2, @NotNull GlobalSearchScope searchScope) {
        List inputFilters;
        if (consoleView == null) {
            ConsoleViewUtil.$$$reportNull$$$0(31);
        }
        if (project2 == null) {
            ConsoleViewUtil.$$$reportNull$$$0(32);
        }
        if (searchScope == null) {
            ConsoleViewUtil.$$$reportNull$$$0(33);
        }
        if ((inputFilters = ConsoleInputFilterProvider.INPUT_FILTER_PROVIDERS.getExtensionList()).isEmpty()) {
            InputFilter inputFilter = (text2, contentType) -> null;
            if (inputFilter == null) {
                ConsoleViewUtil.$$$reportNull$$$0(34);
            }
            return inputFilter;
        }
        ArrayList<InputFilter> allFilters = new ArrayList<InputFilter>();
        for (ConsoleInputFilterProvider eachProvider : inputFilters) {
            if (eachProvider instanceof ConsoleDependentInputFilterProvider) {
                allFilters.addAll(((ConsoleDependentInputFilterProvider)eachProvider).getDefaultFilters(consoleView, project2, searchScope));
                continue;
            }
            allFilters.addAll(Arrays.asList(eachProvider.getDefaultFilters(project2)));
        }
        return new CompositeInputFilter(project2, allFilters);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 22, 23, 24, 25, 26, 27, 28, 29, 31, 32, 33 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/ConsoleViewUtil";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 9: 
            case 12: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: 
            case 14: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenSink";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 26: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 27: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "setupConsoleEditor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/ConsoleViewUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "updateConsoleColorScheme";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentTypeForToken";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "computeConsoleFilters";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "computeInputFilter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setupConsoleEditor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setupLanguageConsoleEditor";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateConsoleColorScheme";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isConsoleViewEditor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isReplaceActionEnabledForConsoleViewEditor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "enableReplaceActionForConsoleViewEditor";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "printWithHighlighting";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getContentTypeForToken";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "printAsFileType";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "computeConsoleFilters";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "computeInputFilter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 22, 23, 24, 25, 26, 27, 28, 29, 31, 32, 33 -> new IllegalArgumentException(string);
        };
    }

    @Service
    private static final class ColorCache {
        private static ColorCache instance;
        private final Map<Key<?>, List<TextAttributesKey>> textAttributeKeys = new ConcurrentHashMap();
        private final Map<Key<?>, TextAttributes> mergedTextAttributes = new ConcurrentHashMap();
        private final Map<List<TextAttributesKey>, Key<?>> keys = new ConcurrentHashMap();

        @NotNull
        public static ColorCache getInstance() {
            ColorCache result2 = instance;
            if (result2 == null) {
                instance = result2 = (ColorCache)ApplicationManager.getApplication().getService(ColorCache.class);
            }
            ColorCache colorCache = result2;
            if (colorCache == null) {
                ColorCache.$$$reportNull$$$0(0);
            }
            return colorCache;
        }

        private ColorCache() {
            ApplicationManager.getApplication().getMessageBus().simpleConnect().subscribe(LafManagerListener.TOPIC, (Object)new LafManagerListener(){

                public void lookAndFeelChanged(@NotNull LafManager source) {
                    if (source == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    mergedTextAttributes.clear();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/execution/impl/ConsoleViewUtil$ColorCache$1", "lookAndFeelChanged"));
                }
            });
        }

        private Key<?> getKey(List<TextAttributesKey> keyList) {
            return this.keys.computeIfAbsent(keyList, keys -> {
                StringBuilder keyName = new StringBuilder("ConsoleViewUtil_");
                for (TextAttributesKey key : keys) {
                    keyName.append("_").append(key.getExternalName());
                }
                final Key newKey = new Key(keyName.toString());
                this.textAttributeKeys.put((Key<?>)newKey, (List<TextAttributesKey>)keys);
                ConsoleViewContentType.registerNewConsoleViewType((Key)newKey, (ConsoleViewContentType)new ConsoleViewContentType(keyName.toString(), new TextAttributes()){

                    public TextAttributes getAttributes() {
                        return mergedTextAttributes.computeIfAbsent(newKey, contentKey -> {
                            EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
                            TextAttributes result2 = scheme.getAttributes(HighlighterColors.TEXT);
                            for (TextAttributesKey key : textAttributeKeys.get(contentKey)) {
                                TextAttributes attributes = scheme.getAttributes(key);
                                if (attributes == null) continue;
                                result2 = TextAttributes.merge((TextAttributes)result2, (TextAttributes)attributes);
                            }
                            return result2;
                        });
                    }
                });
                return newKey;
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/ConsoleViewUtil$ColorCache", "getInstance"));
        }
    }

    private static final class NullEditorHighlighter
    extends EmptyEditorHighlighter {
        private static final TextAttributes NULL_ATTRIBUTES = new TextAttributes();

        NullEditorHighlighter() {
            super(NULL_ATTRIBUTES);
        }

        public void setColorScheme(@NotNull EditorColorsScheme scheme) {
            if (scheme == null) {
                NullEditorHighlighter.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/execution/impl/ConsoleViewUtil$NullEditorHighlighter", "setColorScheme"));
        }
    }
}

