/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a4\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0007\u001a,\u0010\u0004\u001a\u0004\u0018\u00010\u0001*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u001c\u0010\u0012\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0001H\u0002\u001a2\u0010\u0014\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"prefixText", "", "PATTERN", "Lkotlin/text/Regex;", "executeInShellAndGetCommandOnlyStdout", "Lcom/intellij/execution/process/ProcessOutput;", "Lcom/intellij/execution/wsl/WSLDistribution;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "options", "Lcom/intellij/execution/wsl/WSLCommandLineOptions;", "timeout", "", "processHandlerCustomizer", "Ljava/util/function/Consumer;", "Lcom/intellij/execution/process/ProcessHandler;", "expectOneLineStdout", "", "expectOneLineOutput", "stdout", "executeOnWsl", "intellij.platform.ide.impl"})
@JvmName(name="WslExecution")
@ApiStatus.Internal
public final class WslExecution {
    @NotNull
    private static final String prefixText = "intellij: executing command...";
    @NotNull
    private static final Regex PATTERN = new Regex("intellij: executing command...\r?\n");

    @JvmOverloads
    @NotNull
    public static final ProcessOutput executeInShellAndGetCommandOnlyStdout(@NotNull WSLDistribution $this$executeInShellAndGetCommandOnlyStdout, @NotNull GeneralCommandLine commandLine, @NotNull WSLCommandLineOptions options2, int timeout, @NotNull Consumer<ProcessHandler> processHandlerCustomizer) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)$this$executeInShellAndGetCommandOnlyStdout, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        Intrinsics.checkNotNullParameter(processHandlerCustomizer, (String)"processHandlerCustomizer");
        if (!options2.isExecuteCommandInShell()) {
            throw new AssertionError((Object)"Execution in shell is expected");
        }
        options2.addInitCommand("echo " + CommandLineUtil.posixQuote((String)prefixText));
        if (options2.isExecuteCommandInInteractiveShell()) {
            Map map2 = commandLine.getEnvironment();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getEnvironment(...)");
            Map map3 = map2;
            String string = "DISABLE_AUTO_UPDATE";
            String string2 = "true";
            map3.put(string, string2);
            options2.setPassEnvVarsUsingInterop(true);
        }
        ProcessOutput output = WslExecution.executeOnWsl($this$executeInShellAndGetCommandOnlyStdout, commandLine, options2, timeout, processHandlerCustomizer);
        String string = output.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        String stdout = string;
        MatchResult match = Regex.find$default((Regex)PATTERN, (CharSequence)stdout, (int)0, (int)2, null);
        if (match == null) {
            Application application = ApplicationManager.getApplication();
            if (application == null || application.isInternal() || application.isUnitTestMode()) {
                WSLUtil.LOG.error("Cannot find 'intellij: executing command...' in stdout: " + output + ", command: " + commandLine.getCommandLineString());
            } else if (WSLUtil.LOG.isDebugEnabled()) {
                WSLUtil.LOG.debug("Cannot find 'intellij: executing command...' in stdout: " + output + ", command: " + commandLine.getCommandLineString());
            } else {
                WSLUtil.LOG.info("Cannot find 'intellij: executing command...' in stdout");
            }
            return output;
        }
        String string3 = stdout.substring(match.getRange().getLast() + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        return new ProcessOutput(string3, output.getStderr(), output.getExitCode(), output.isTimeout(), output.isCancelled());
    }

    public static /* synthetic */ ProcessOutput executeInShellAndGetCommandOnlyStdout$default(WSLDistribution wSLDistribution, GeneralCommandLine generalCommandLine, WSLCommandLineOptions wSLCommandLineOptions, int n, Consumer consumer, int n2, Object object) throws ExecutionException {
        if ((n2 & 8) != 0) {
            consumer = WslExecution::executeInShellAndGetCommandOnlyStdout$lambda$0;
        }
        return WslExecution.executeInShellAndGetCommandOnlyStdout(wSLDistribution, generalCommandLine, wSLCommandLineOptions, n, consumer);
    }

    @Nullable
    public static final String executeInShellAndGetCommandOnlyStdout(@NotNull WSLDistribution $this$executeInShellAndGetCommandOnlyStdout, @NotNull GeneralCommandLine commandLine, @NotNull WSLCommandLineOptions options2, int timeout, boolean expectOneLineStdout) {
        Intrinsics.checkNotNullParameter((Object)$this$executeInShellAndGetCommandOnlyStdout, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        try {
            ProcessOutput output = WslExecution.executeInShellAndGetCommandOnlyStdout$default($this$executeInShellAndGetCommandOnlyStdout, commandLine, options2, timeout, null, 8, null);
            String string = output.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
            String stdout = string;
            if (!output.isTimeout() && output.getExitCode() == 0) {
                return expectOneLineStdout ? WslExecution.expectOneLineOutput($this$executeInShellAndGetCommandOnlyStdout, commandLine, stdout) : stdout;
            }
            WSLUtil.LOG.info("Failed to execute " + commandLine + " for " + $this$executeInShellAndGetCommandOnlyStdout.getMsId() + ": exitCode=" + output.getExitCode() + ", timeout=" + output.isTimeout() + ", stdout=" + stdout + ", stderr=" + output.getStderr());
        }
        catch (ExecutionException e) {
            WSLUtil.LOG.info("Failed to execute " + commandLine + " for " + $this$executeInShellAndGetCommandOnlyStdout.getMsId(), (Throwable)e);
        }
        return null;
    }

    private static final String expectOneLineOutput(WSLDistribution $this$expectOneLineOutput, GeneralCommandLine commandLine, String stdout) {
        String string = StringUtil.convertLineSeparators((String)stdout, (String)LineSeparator.LF.getSeparatorString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertLineSeparators(...)");
        String converted = string;
        List list2 = StringUtil.split((String)converted, (String)LineSeparator.LF.getSeparatorString(), (boolean)true, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"split(...)");
        List lines = list2;
        if (lines.size() != 1) {
            WSLUtil.LOG.info("One line stdout expected: " + $this$expectOneLineOutput.getMsId() + ", command=" + commandLine + ", stdout=" + stdout + ", lines=" + lines.size());
        }
        String string2 = StringUtil.notNullize((String)((String)ContainerUtil.getFirstItem((List)lines)), (String)stdout);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"notNullize(...)");
        return string2;
    }

    private static final ProcessOutput executeOnWsl(WSLDistribution $this$executeOnWsl, GeneralCommandLine commandLine, WSLCommandLineOptions options2, int timeout, Consumer<ProcessHandler> processHandlerCustomizer) throws ExecutionException {
        $this$executeOnWsl.patchCommandLine(commandLine, null, options2);
        CapturingProcessHandler processHandler = new CapturingProcessHandler(commandLine);
        processHandlerCustomizer.accept((ProcessHandler)processHandler);
        ProcessOutput processOutput = processHandler.runProcess(timeout);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcess(...)");
        return processOutput;
    }

    @JvmOverloads
    @NotNull
    public static final ProcessOutput executeInShellAndGetCommandOnlyStdout(@NotNull WSLDistribution $this$executeInShellAndGetCommandOnlyStdout, @NotNull GeneralCommandLine commandLine, @NotNull WSLCommandLineOptions options2, int timeout) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)$this$executeInShellAndGetCommandOnlyStdout, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        return WslExecution.executeInShellAndGetCommandOnlyStdout$default($this$executeInShellAndGetCommandOnlyStdout, commandLine, options2, timeout, null, 8, null);
    }

    private static final void executeInShellAndGetCommandOnlyStdout$lambda$0(ProcessHandler it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }
}

